/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.newhismodel;

import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.hr.hbp.business.application.impl.common.HRLongValueParseService;
import kd.hr.hbp.business.domain.repository.HisLineTimeDao;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.util.newhismodel.HisShowFormHandler;

public class HisChooseChangeStylePlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final String VERSION_ENTRY = "versionentry";
    private static final String VERSION_ENTRY_ID = "entryid";
    private static final String CHANGE_STYLE = "radiogroupfield";
    private static final String STYLE_NEW_VERSION = "1";
    private static final String STYLE_MODIFY_TEMP_VERSION = "2";
    private static final String OP_CONFIRM = "confirm";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entry = (EntryGrid)this.getView().getControl(VERSION_ENTRY);
        entry.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject event) {
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam("entityId");
        Long boId = HRLongValueParseService.getInstance().getLongValueFromMap(this.getView().getFormShowParameter().getCustomParams(), "boid");
        DynamicObjectCollection tempVersions = HisLineTimeDao.getInstance().queryAllTempVersions(entityId, (Object)boId);
        DynamicObjectCollection versionEntry = this.getModel().getDataEntity().getDynamicObjectCollection(VERSION_ENTRY);
        int createRowCount = tempVersions.size() - versionEntry.getRowCount();
        if (createRowCount > 0) {
            this.getModel().batchCreateNewEntryRow(VERSION_ENTRY, createRowCount);
        }
        for (int i = 0; i < tempVersions.size(); ++i) {
            this.getModel().setValue(VERSION_ENTRY_ID, ((DynamicObject)tempVersions.get(i)).get("id"), i);
            this.getModel().setValue("number", ((DynamicObject)tempVersions.get(i)).get("number"), i);
            this.getModel().setValue("name", ((DynamicObject)tempVersions.get(i)).get("name"), i);
            this.getModel().setValue("modifier", ((DynamicObject)tempVersions.get(i)).get("modifier"), i);
            this.getModel().setValue("modifytime", ((DynamicObject)tempVersions.get(i)).get("modifytime"), i);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String key = args.getProperty().getName();
        if (HRStringUtils.equals((String)CHANGE_STYLE, (String)key)) {
            String style = (String)args.getChangeSet()[0].getNewValue();
            if (HRStringUtils.equals((String)style, (String)STYLE_NEW_VERSION)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{VERSION_ENTRY});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{VERSION_ENTRY});
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        int rowIndex = event.getRowIndex();
        long pkId = (Long)this.getModel().getValue(VERSION_ENTRY_ID, rowIndex);
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam("entityId");
        HisShowFormHandler.getInstance().openHisDataEditByViewWindow(this.getView(), entityId, pkId);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)OP_CONFIRM)) {
            String changeStyle = (String)this.getModel().getValue(CHANGE_STYLE);
            if (HRStringUtils.equals((String)changeStyle, (String)STYLE_NEW_VERSION)) {
                this.getView().returnDataToParent((Object)STYLE_NEW_VERSION);
            } else {
                EntryGrid entry = (EntryGrid)this.getView().getControl(VERSION_ENTRY);
                int[] selectedRows = entry.getEntryState().getSelectedRows();
                if (selectedRows.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"HisChooseChangeStylePlugin_01", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                HashMap map = Maps.newHashMapWithExpectedSize((int)2);
                map.put(CHANGE_STYLE, STYLE_MODIFY_TEMP_VERSION);
                int focusRowIndex = this.getModel().getEntryCurrentRowIndex(VERSION_ENTRY);
                map.put("tempVersionId", this.getModel().getValue(VERSION_ENTRY_ID, focusRowIndex));
                this.getView().returnDataToParent((Object)map);
            }
        }
    }
}

