/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.newhismodel;

import java.text.ParseException;
import java.util.Date;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.filter.SortType;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.ListColumn;
import kd.bos.list.events.CreateListColumnsListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.constants.newhismodel.EventOperateEnums;
import kd.hr.hbp.common.constants.newhismodel.HisDisableOperateConstants;
import kd.hr.hbp.common.constants.newhismodel.HisFieldNameConstants;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.util.newhismodel.HisModelListCommonTool;

public class HisConfirmDisableFoldListPlugin
extends AbstractBasePlugIn
implements HisFieldNameConstants,
HisDisableOperateConstants,
CreateListColumnsListener,
SetFilterListener {
    private static final Log LOGGER = LogFactory.getLog(HisConfirmDisableFoldListPlugin.class);

    public void initialize() {
        super.initialize();
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentView == null) {
            return;
        }
        String hisFormId = parentView.getPageCache().get("hisFormId");
        BillList billList = (BillList)this.getControl("billlistap");
        billList.setBillFormId(hisFormId);
        billList.addCreateListColumnsListener((CreateListColumnsListener)this);
        billList.addSetFilterListener((SetFilterListener)this);
    }

    public void setFilter(SetFilterEvent event) {
        String id = (String)this.getView().getFormShowParameter().getCustomParam("pkId");
        event.getQFilters().add(new QFilter("boid", "=", (Object)Long.parseLong(id)));
        event.getQFilters().add(new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0')));
        event.getQFilters().add(new QFilter("datastatus", "=", (Object)EventOperateEnums.CHANGE_BEFORE_STATUS_TOBEEFFECT.getValue()));
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        String disableDateStr = (String)parentView.getFormShowParameter().getCustomParam("hisDisableDate");
        Date disableDate = new Date();
        if (HRStringUtils.isNotEmpty((String)disableDateStr)) {
            try {
                disableDate = HRDateTimeUtils.parseDate((String)disableDateStr);
            }
            catch (ParseException ex) {
                LOGGER.error((Throwable)ex);
            }
        }
        event.getQFilters().add(new QFilter("bsed", ">=", (Object)disableDate));
    }

    public void createListColumns(BeforeCreateListColumnsArgs args) {
        ListColumn colNumber = HisModelListCommonTool.createListColumn("number", ResManager.loadKDString((String)"\u7f16\u7801", (String)"HisConfirmDisableFoldListPlugin_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), (Container)this.getView().getControl("listgridviewap"));
        args.addListColumn((IListColumn)colNumber);
        ListColumn colName = HisModelListCommonTool.createListColumn("name", ResManager.loadKDString((String)"\u540d\u79f0", (String)"HisConfirmDisableFoldListPlugin_2", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), (Container)this.getView().getControl("listgridviewap"));
        args.addListColumn((IListColumn)colName);
        ListColumn colBsed = HisModelListCommonTool.createListColumn("bsed", ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f", (String)"HisConfirmDisableFoldListPlugin_3", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), (Container)this.getView().getControl("listgridviewap"));
        colBsed.setOrder(SortType.ASC.name());
        args.addListColumn((IListColumn)colBsed);
        ListColumn colBsled = HisModelListCommonTool.createListColumn("bsled", ResManager.loadKDString((String)"\u5931\u6548\u65e5\u671f", (String)"HisConfirmDisableFoldListPlugin_4", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), (Container)this.getView().getControl("listgridviewap"));
        args.addListColumn((IListColumn)colBsled);
        ListColumn colDataStatus = HisModelListCommonTool.createListColumn("datastatus", ResManager.loadKDString((String)"\u7248\u672c\u72b6\u6001", (String)"HisConfirmDisableFoldListPlugin_5", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), (Container)this.getView().getControl("listgridviewap"));
        args.addListColumn((IListColumn)colDataStatus);
        ListColumn colModifier = HisModelListCommonTool.createListColumn("modifier", ResManager.loadKDString((String)"\u64cd\u4f5c\u4eba", (String)"HisConfirmDisableFoldListPlugin_6", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), (Container)this.getView().getControl("listgridviewap"));
        args.addListColumn((IListColumn)colModifier);
    }
}

