/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.newhismodel;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.ListColumn;
import kd.bos.list.events.CreateListColumnsListener;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.constants.newhismodel.HisDisableOperateConstants;
import kd.hr.hbp.common.constants.newhismodel.HisFieldNameConstants;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.util.newhismodel.HisModelListCommonTool;

@ExcludeFromJacocoGeneratedReport
public class HisConfirmDisablePlugin
extends AbstractBasePlugIn
implements HisFieldNameConstants,
HisDisableOperateConstants,
CreateListColumnsListener,
SetFilterListener {
    public void initialize() {
        super.initialize();
        String hisFormId = (String)this.getView().getFormShowParameter().getCustomParam("hisFormId");
        BillList billList = (BillList)this.getControl("billlistap");
        billList.setBillFormId(hisFormId);
        billList.addCreateListColumnsListener((CreateListColumnsListener)this);
        billList.addSetFilterListener((SetFilterListener)this);
    }

    public void setFilter(SetFilterEvent event) {
        List notConfirmIds = (List)this.getView().getFormShowParameter().getCustomParam("notConfirmIds");
        event.getQFilters().add(new QFilter("iscurrentversion", "=", (Object)Character.valueOf('1')));
        event.getQFilters().add(new QFilter("id", "in", (Object)notConfirmIds));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String disableDate = (String)this.getView().getFormShowParameter().getCustomParam("hisDisableDate");
        if (HRStringUtils.isNotEmpty((String)disableDate)) {
            this.getView().getPageCache().put("hisDisableDate", disableDate);
        }
        String hisFormId = (String)this.getView().getFormShowParameter().getCustomParam("hisFormId");
        this.getView().getPageCache().put("hisFormId", hisFormId);
        Map hisEntityEventMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSHismodelService", (String)"getHisEntityEventBo", (Object[])new Object[]{hisFormId});
        String setDisableDate = (String)hisEntityEventMap.get("setdisabledate");
        if (!HRStringUtils.equals((String)setDisableDate, (String)"true")) {
            Label label = (Label)this.getView().getControl("labelap");
            label.setText(ResManager.loadKDString((String)"\u786e\u5b9a\u7981\u7528\u4ee5\u4e0b\u6570\u636e\u540e\uff0c\u5728\u5f53\u524d\u65e5\u671f\u540e\u751f\u6548\u7684\u201c\u5f85\u751f\u6548\u201d\u7248\u672c\u5c06\u88ab\u7f6e\u4e3a\u201c\u5df2\u5220\u9664\u201d\u72b6\u6001\uff08\u8bf7\u70b9\u51fb\u201c\u5c55\u5f00\u201d\u6309\u94ae\uff0c\u67e5\u770b\u201c\u5f85\u751f\u6548\u201d\u7248\u672c\uff09\u3002", (String)"HisConfirmDisablePlugin_14", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
        }
    }

    public void createListColumns(BeforeCreateListColumnsArgs args) {
        List businessCols = (List)this.getView().getFormShowParameter().getCustomParam("showListColumns");
        if (businessCols != null) {
            businessCols.forEach(map -> {
                ListColumn newCol = HisModelListCommonTool.createListColumn((String)map.get("key"), (String)map.get("caption"), (Container)this.getView().getControl("listgridviewap"));
                args.addListColumn((IListColumn)newCol);
            });
        } else {
            ListColumn colNumber = HisModelListCommonTool.createListColumn("number", ResManager.loadKDString((String)"\u7f16\u7801", (String)"HisConfirmDisablePlugin_9", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), (Container)this.getView().getControl("listgridviewap"));
            args.addListColumn((IListColumn)colNumber);
            ListColumn colName = HisModelListCommonTool.createListColumn("name", ResManager.loadKDString((String)"\u540d\u79f0", (String)"HisConfirmDisablePlugin_10", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), (Container)this.getView().getControl("listgridviewap"));
            args.addListColumn((IListColumn)colName);
            ListColumn colStatus = HisModelListCommonTool.createListColumn("status", ResManager.loadKDString((String)"\u6570\u636e\u72b6\u6001", (String)"HisConfirmDisablePlugin_11", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), (Container)this.getView().getControl("listgridviewap"));
            args.addListColumn((IListColumn)colStatus);
            ListColumn colEnable = HisModelListCommonTool.createListColumn("enable", ResManager.loadKDString((String)"\u4f7f\u7528\u72b6\u6001", (String)"HisConfirmDisablePlugin_12", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), (Container)this.getView().getControl("listgridviewap"));
            args.addListColumn((IListColumn)colEnable);
            ListColumn colModifier = HisModelListCommonTool.createListColumn("modifier", ResManager.loadKDString((String)"\u64cd\u4f5c\u4eba", (String)"HisConfirmDisablePlugin_13", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), (Container)this.getView().getControl("listgridviewap"));
            args.addListColumn((IListColumn)colModifier);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"close")) {
            this.close();
            return;
        }
        if (!HRStringUtils.equals((String)operateKey, (String)"his_disable")) {
            return;
        }
        BillList billList = (BillList)this.getControl("billlistap");
        op.setEntityId(billList.getBillFormId());
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"HisConfirmDisablePlugin_4", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        String disableDate = this.getView().getPageCache().get("hisDisableDate");
        if (HRStringUtils.isNotEmpty((String)disableDate)) {
            op.getOption().setVariableValue("hisDisableDate", disableDate);
        }
        op.getOption().setVariableValue("selectRowPks", SerializationUtils.toJsonString((Object)selectedRows.getPrimaryKeyValues()));
        op.getOption().setVariableValue("billFormId", billList.getBillFormId());
        if (billList.getCurrentListAllRowCollection().size() != selectedRows.size()) {
            op.getOption().setVariableValue("isshowmessage", "false");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (!HRStringUtils.equals((String)"his_disable", (String)operateKey)) {
            return;
        }
        if (!args.getOperationResult().isSuccess()) {
            this.getView().showErrorNotification(args.getOperationResult().getMessage());
            return;
        }
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection allRows = billList.getCurrentListAllRowCollection();
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (allRows.size() == selectedRows.size()) {
            this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId()).getPageCache().put("hisDisableResult", "1");
            return;
        }
        Set selectIds = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
        List<ListSelectedRow> notDealRows = allRows.stream().filter(row -> !selectIds.contains(row.getPrimaryKeyValue())).collect(Collectors.toList());
        HashMap pkNumbers = Maps.newHashMapWithExpectedSize((int)notDealRows.size());
        ArrayList msgList = Lists.newArrayListWithExpectedSize((int)notDealRows.size());
        String msg = ResManager.loadKDString((String)"\u4e0d\u6267\u884c\u7981\u7528\u64cd\u4f5c\u3002", (String)"HisConfirmDisablePlugin_7", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]);
        notDealRows.forEach(row -> {
            pkNumbers.put(row.getPrimaryKeyValue().toString(), row.getNumber());
            msgList.add(row.getNumber() + ":" + msg);
        });
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_operationresult");
        showParameter.setCustomParam("pkNumbers", (Object)pkNumbers);
        showParameter.setCustomParam("hasMore", (Object)(notDealRows.size() > 5 ? 1 : 0));
        showParameter.setCustomParam("operateName", (Object)op.getOperateName());
        showParameter.setCustomParam("title", (Object)String.format(ResManager.loadKDString((String)"\u5171%1$s\u6761\u5355\u636e\uff0c\u7981\u7528\u6210\u529f%2$s\u6761\uff0c\u4e0d\u5904\u7406%3$s\u6761", (String)"HisConfirmDisablePlugin_8", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), allRows.size(), selectedRows.size(), notDealRows.size()));
        showParameter.setCustomParam("errorMsg", (Object)msgList);
        showParameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
        showParameter.setShowTitle(false);
        this.getView().showForm(showParameter);
    }

    private void close() {
        ConfirmCallBackListener confirmListener = new ConfirmCallBackListener("closeDisable", (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u4e0d\u518d\u6267\u884c\u7981\u7528\u64cd\u4f5c\u5417\uff1f", (String)"HisConfirmDisablePlugin_5", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmListener);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String actionId = event.getCallBackId();
        if (actionId.equals("closeDisable") && event.getResult() == MessageBoxResult.Yes) {
            this.getView().close();
        }
    }
}

