/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.newhismodel;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.FieldProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.constants.newhismodel.HisLineTimeTplConstants;
import kd.hr.hbp.common.util.HRStringUtils;

public class HisF7FoldFormEdit
extends AbstractBasePlugIn
implements HisLineTimeTplConstants {
    private static final String KEY_ENTRY_ENTITY = "entryentity";

    public void loadCustomControlMetas(LoadCustomControlMetasArgs event) {
        super.loadCustomControlMetas(event);
        EntryAp entryAp = this.createDynamicEntryAp(((FormShowParameter)event.getSource()).getParentPageId());
        HashMap<String, String> mapEntry = new HashMap<String, String>();
        mapEntry.put("id", KEY_ENTRY_ENTITY);
        mapEntry.put("columns", (String)entryAp.createControl().get("columns"));
        event.getItems().add(mapEntry);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentView == null) {
            return;
        }
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("LoadCustomControlMetasSample", exp.getMessage()), new Object[0]);
        }
        this.registDynamicProps(newMainType, parentView.getPageId());
        e.setNewEntityType(newMainType);
    }

    public void createNewData(BizDataEventArgs e) {
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentView == null) {
            return;
        }
        DynamicObject dataEntity = new DynamicObject((DynamicObjectType)this.getModel().getDataEntityType());
        DynamicObjectCollection rows = dataEntity.getDynamicObjectCollection(KEY_ENTRY_ENTITY);
        DynamicObject newRow = new DynamicObject(rows.getDynamicObjectType());
        rows.add((Object)newRow);
        e.setDataEntity((Object)dataEntity);
    }

    public void beforeBindData(EventObject e) {
        EntryAp dynamicEntryAp = this.createDynamicEntryAp(this.getView().getFormShowParameter().getParentPageId());
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(KEY_ENTRY_ENTITY);
        List fieldEdits = ((Container)dynamicEntryAp.buildRuntimeControl()).getItems();
        for (Control fieldEdit : fieldEdits) {
            fieldEdit.setView(this.getView());
            entryGrid.getItems().add(fieldEdit);
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        String fieldKey = e.getKey();
        if (HRStringUtils.equals((String)fieldKey, (String)KEY_ENTRY_ENTITY)) {
            return;
        }
        FieldEdit fieldEdit = new FieldEdit();
        fieldEdit.setKey(fieldKey);
        fieldEdit.setEntryKey(fieldKey);
        fieldEdit.setView(this.getView());
        e.setControl((Control)fieldEdit);
    }

    private EntryAp createDynamicEntryAp(String parentPageId) {
        EntryAp entryAp = new EntryAp();
        entryAp.setKey(KEY_ENTRY_ENTITY);
        List<Map<String, Object>> columnList = this.getParentAllColumn(parentPageId);
        columnList.forEach(column -> {
            String key = (String)column.get("fieldName");
            if (HRStringUtils.isEmpty((String)key)) {
                return;
            }
            EntryFieldAp fieldAp = new EntryFieldAp();
            fieldAp.setId(key);
            fieldAp.setKey(key);
            fieldAp.setName(new LocaleString((String)column.get("caption")));
            fieldAp.setFireUpdEvt(false);
            TextField field = new TextField();
            field.setId(key);
            field.setKey(key);
            fieldAp.setField((Field)field);
            entryAp.getItems().add(fieldAp);
        });
        return entryAp;
    }

    private void registDynamicProps(MainEntityType newMainType, String parentPageId) {
        EntryType entryType = (EntryType)newMainType.getAllEntities().get(KEY_ENTRY_ENTITY);
        List<Map<String, Object>> listColumns = this.getParentAllColumn(parentPageId);
        listColumns.forEach(column -> {
            String key = (String)column.get("fieldName");
            if (HRStringUtils.isEmpty((String)key)) {
                return;
            }
            FieldProp fieldProp = new FieldProp();
            fieldProp.setName(key);
            fieldProp.setDisplayName(new LocaleString((String)column.get("caption")));
            fieldProp.setDbIgnore(true);
            fieldProp.setAlias("");
            entryType.registerSimpleProperty((DynamicSimpleProperty)fieldProp);
        });
    }

    private List<Map<String, Object>> getParentAllColumn(String parentPageId) {
        IHRAppCache appCache = HRAppCache.get((String)"hbp");
        return (List)appCache.get("his_list_columns" + parentPageId, List.class);
    }
}

