/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.newhismodel;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.filter.SortType;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.ListColumn;
import kd.bos.list.ListOperationColumn;
import kd.bos.list.ListShowParameter;
import kd.hr.hbp.business.application.impl.common.HRLongValueParseService;
import kd.hr.hbp.business.domain.util.HisModelEditAuditTool;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.newhismodel.HisLineTimeTplListPlugin;
import kd.hr.hbp.formplugin.web.util.newhismodel.HisModelEditBtnGenTool;
import kd.hr.hbp.formplugin.web.util.newhismodel.HisModelEditBuTool;
import kd.hr.hbp.formplugin.web.util.newhismodel.HisModelListCommonTool;

public class HisLineTimeTplListPluginTest
extends HisLineTimeTplListPlugin {
    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        if (!this.isLookup()) {
            this.createListColumn(args);
            String option = (String)this.getView().getFormShowParameter().getCustomParam("option");
            if (!HRStringUtils.equals((String)option, (String)"showhisversion")) {
                args.getListColumns().removeIf(column -> "changedescription".equals(column.getListFieldKey()));
            }
        }
    }

    private boolean isLookup() {
        boolean isLookup = false;
        if (this.getView().getFormShowParameter() instanceof ListShowParameter) {
            ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
            isLookup = listShowParameter.isLookUp();
        }
        return isLookup;
    }

    private void createListColumn(BeforeCreateListColumnsArgs args) {
        ListColumn versionSource;
        String option = (String)this.getView().getFormShowParameter().getCustomParam("option");
        List columnList = args.getListColumns();
        boolean needAudit = HisModelEditAuditTool.getNeedAuditForBillList((IFormView)this.getView());
        if (!HRStringUtils.equals((String)option, (String)"showhisversion")) {
            if (!needAudit) {
                args.getListColumns().removeIf(column -> HRStringUtils.equals((String)column.getListFieldKey(), (String)"ismodify"));
            }
            return;
        }
        Set<String> keySet = Stream.of("hisversion", "versionsource", "datastatus", "bsed", "bsled", "changebsed", "firstbsed", "ismodify", "modifier", "modifier.name", "modifytime", "status", "issyspreset").collect(Collectors.toSet());
        this.removeExistListColumn(keySet, columnList);
        ListColumn colDataStatus = HisModelListCommonTool.createListColumn("datastatus", ResManager.loadKDString((String)"\u7248\u672c\u72b6\u6001", (String)"HisLineTimeTplListPlugin_0", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
        columnList.add(colDataStatus);
        ListColumn colBsed = HisModelListCommonTool.createListColumn("bsed", ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f", (String)"HisLineTimeTplListPlugin_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
        colBsed.setOrder(SortType.DESC.name());
        columnList.add(colBsed);
        ListColumn colBsled = HisModelListCommonTool.createListColumn("bsled", ResManager.loadKDString((String)"\u5931\u6548\u65e5\u671f", (String)"HisLineTimeTplListPlugin_2", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
        columnList.add(colBsled);
        String billFormId = ((IListView)this.getView()).getListModel().getDataEntityType().getName();
        Long boId = HRLongValueParseService.getInstance().getLongValueFromMap(this.getView().getFormShowParameter().getCustomParams(), "boid");
        if (boId != null) {
            if (HisModelEditBuTool.exitsOriginSyncData(billFormId, boId)) {
                versionSource = HisModelListCommonTool.createListColumn("versionsource", ResManager.loadKDString((String)"\u7248\u672c\u6765\u6e90", (String)"HisLineTimeTplListPlugin_18", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
                columnList.add(versionSource);
            }
        } else {
            versionSource = HisModelListCommonTool.createListColumn("versionsource", ResManager.loadKDString((String)"\u7248\u672c\u6765\u6e90", (String)"HisLineTimeTplListPlugin_18", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
            columnList.add(versionSource);
        }
        ListColumn colModifier = HisModelListCommonTool.createListColumn("modifier.name", ResManager.loadKDString((String)"\u64cd\u4f5c\u4eba", (String)"HisLineTimeTplListPlugin_14", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
        colModifier.setColumnFilter(true);
        columnList.add(colModifier);
        ListColumn colModifyTime = HisModelListCommonTool.createListColumn("modifytime", ResManager.loadKDString((String)"\u64cd\u4f5c\u65f6\u95f4", (String)"HisLineTimeTplListPlugin_15", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
        colModifyTime.setOrder(SortType.DESC.name());
        columnList.add(colModifyTime);
        ListColumn colVersion = HisModelListCommonTool.createListColumn("hisversion", ResManager.loadKDString((String)"\u7248\u672c\u53f7", (String)"HisLineTimeTplListPlugin_16", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
        columnList.add(0, colVersion);
        ListColumn planBSED = HisModelListCommonTool.createListColumn("changebsed", "Plan effect date");
        columnList.add(planBSED);
        ListOperationColumn operationColumn = this.createOperationColumn(needAudit);
        columnList.add(operationColumn);
        HisModelEditBtnGenTool.createBillListHisBtnBar(this.getView(), needAudit);
        Map hisEntityEventMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSHismodelService", (String)"getHisEntityEventBo", (Object[])new Object[]{billFormId});
        if (hisEntityEventMap.isEmpty()) {
            this.getPageCache().put("openrevise", "1");
        } else if (!HRStringUtils.equals((String)((String)hisEntityEventMap.get("openrevise")), (String)"0")) {
            this.getPageCache().put("openrevise", "1");
        }
    }

    private void removeExistListColumn(Set<String> keySet, List<IListColumn> columnList) {
        columnList.forEach(column -> column.setOrder(SortType.NotOrder.name()));
        columnList.removeIf(col -> keySet.contains(col.getListFieldKey()) || col instanceof ListOperationColumn);
    }

    private ListOperationColumn createOperationColumn(boolean needAudit) {
        ListOperationColumn column = new ListOperationColumn();
        ArrayList items = Lists.newArrayListWithCapacity((int)16);
        OperationColItem modifyItem = new OperationColItem();
        modifyItem.setOperationName(new LocaleString(ResManager.loadKDString((String)"\u4fee\u6539", (String)"HisLineTimeTplListPlugin_6", (String)"hrmp-hbp-formplugin", (Object[])new Object[0])));
        modifyItem.setOperationKey("his_modify");
        modifyItem.setVisible(false);
        items.add(modifyItem);
        OperationColItem copyItem = new OperationColItem();
        copyItem.setOperationName(new LocaleString(ResManager.loadKDString((String)"\u590d\u5236", (String)"HisLineTimeTplListPlugin_7", (String)"hrmp-hbp-formplugin", (Object[])new Object[0])));
        copyItem.setOperationKey("his_copy");
        copyItem.setVisible(false);
        items.add(copyItem);
        OperationColItem changeBedItem = new OperationColItem();
        changeBedItem.setOperationName(new LocaleString(ResManager.loadKDString((String)"\u53d8\u66f4\u751f\u6548\u65e5\u671f", (String)"HisLineTimeTplListPlugin_8", (String)"hrmp-hbp-formplugin", (Object[])new Object[0])));
        changeBedItem.setOperationKey("changebed");
        changeBedItem.setVisible(false);
        items.add(changeBedItem);
        OperationColItem cancelChangeItem = new OperationColItem();
        cancelChangeItem.setOperationName(new LocaleString(ResManager.loadKDString((String)"\u53d6\u6d88\u53d8\u66f4", (String)"HisLineTimeTplListPlugin_9", (String)"hrmp-hbp-formplugin", (Object[])new Object[0])));
        cancelChangeItem.setOperationKey("cancelchange");
        cancelChangeItem.setVisible(false);
        items.add(cancelChangeItem);
        OperationColItem reviseItem = new OperationColItem();
        reviseItem.setOperationName(new LocaleString(ResManager.loadKDString((String)"\u4fee\u8ba2", (String)"HisLineTimeTplListPlugin_17", (String)"hrmp-hbp-formplugin", (Object[])new Object[0])));
        reviseItem.setOperationKey("revise");
        reviseItem.setVisible(false);
        items.add(reviseItem);
        if (needAudit) {
            OperationColItem confirmChangeItem = new OperationColItem();
            confirmChangeItem.setOperationName(new LocaleString(ResManager.loadKDString((String)"\u786e\u8ba4\u53d8\u66f4", (String)"HisLineTimeTplListPlugin_10", (String)"hrmp-hbp-formplugin", (Object[])new Object[0])));
            confirmChangeItem.setOperationKey("confirmchange");
            confirmChangeItem.setVisible(false);
            items.add(confirmChangeItem);
        }
        column.setOperationColItems((List)items);
        column.setVisible(63);
        column.setName(new LocaleString(ResManager.loadKDString((String)"\u64cd\u4f5c", (String)"HisLineTimeTplListPlugin_11", (String)"hrmp-hbp-formplugin", (Object[])new Object[0])));
        column.setCaption(new LocaleString(ResManager.loadKDString((String)"\u64cd\u4f5c", (String)"HisLineTimeTplListPlugin_11", (String)"hrmp-hbp-formplugin", (Object[])new Object[0])));
        column.setKey("listoperatecol");
        column.setSeq(2);
        return column;
    }
}

