/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.newhismodel;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.control.Label;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.util.HRBaseDataConfigUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.util.newhismodel.HisShowFormHandler;
import kd.hr.hbp.formplugin.web.util.newhismodel.HisTreeTplTool;

public class HisLineTimeTreeOpTipsPlugin
extends AbstractFormPlugin {
    private static final String CONTROL_TIPS = "tips";
    private static final String CONTROL_TREE = "treeviewap";
    private static final String CONTROL_ENABLE_CHECKBOX = "enablecheckbox";
    private static final String BTN_SAVE = "btnsave";
    private static final String BTN_CONFIRM_CHANGE = "btnok";
    private static final String OP_CONFIRM_CHANGE = "confirmchange";
    private boolean needAudit = false;
    private static final Log LOGGER = LogFactory.getLog(HisLineTimeTreeOpTipsPlugin.class);

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        TreeView tv1 = (TreeView)this.getView().getControl(CONTROL_TREE);
        tv1.addTreeNodeClickListener(this.getTreeNodeClickListener());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (CONTROL_ENABLE_CHECKBOX.equals(e.getProperty().getName())) {
            if (Boolean.TRUE.equals(e.getChangeSet()[0].getNewValue())) {
                this.getView().setEnable(Boolean.TRUE, new String[]{BTN_SAVE, BTN_CONFIRM_CHANGE});
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{BTN_SAVE, BTN_CONFIRM_CHANGE});
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String tips = (String)this.getView().getFormShowParameter().getCustomParam(CONTROL_TIPS);
        Label label = (Label)this.getView().getControl(CONTROL_TIPS);
        label.setText(tips);
        String treeNodeStr = (String)this.getView().getFormShowParameter().getCustomParam("treeNodes");
        List treeNodes = (List)SerializationUtils.fromJsonString((String)treeNodeStr, List.class);
        this.constructTreeView(treeNodes);
        this.needAudit = HRBaseDataConfigUtil.getAudit((String)((String)this.getView().getFormShowParameter().getCustomParam("entityId")));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setEnable(Boolean.FALSE, new String[]{CONTROL_ENABLE_CHECKBOX, BTN_SAVE, BTN_CONFIRM_CHANGE});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (!HRStringUtils.equals((String)operateKey, (String)"save") && !HRStringUtils.equals((String)operateKey, (String)OP_CONFIRM_CHANGE)) {
            return;
        }
        long userId = RequestContext.get().getCurrUserId();
        String appId = this.getView().getFormShowParameter().getAppId();
        String entityName = this.getView().getEntityId();
        String permItemId = HRStringUtils.equals((String)operateKey, (String)"save") ? "4715a0df000000ac" : (this.needAudit ? "47162f66000000ac" : "4715a0df000000ac");
        boolean hasPermission = PermissionServiceHelper.checkPermission((Long)userId, (String)appId, (String)entityName, (String)permItemId);
        if (!hasPermission) {
            String caption = FormMetadataCache.getFormConfig((String)entityName).getCaption().getLocaleValue();
            if (HRStringUtils.equals((String)operateKey, (String)"save")) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u65e0\u201c%s\u201d\u7684\u201c\u4fee\u6539\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"HisLineTimeTreeOpTipsPlugin_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), caption));
            } else {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u65e0\u201c%s\u201d\u7684\u201c\u786e\u8ba4\u53d8\u66f4\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"HisLineTimeTreeOpTipsPlugin_2", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), caption));
            }
            args.setCancel(true);
        } else {
            this.getView().returnDataToParent((Object)operateKey);
            this.getView().close();
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        if (HRStringUtils.equals((String)"hisDataChange", (String)event.getActionId())) {
            String entityId = (String)this.getView().getFormShowParameter().getCustomParam("entityId");
            String parentLongNumber = (String)this.getView().getFormShowParameter().getCustomParam("parentLongNumber");
            Date effStartDate = null;
            Date effEndDate = null;
            try {
                String effEndDateStr;
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                String effStartDateStr = (String)this.getView().getFormShowParameter().getCustomParam("bsed");
                if (effStartDateStr != null) {
                    effStartDate = format.parse(effStartDateStr);
                }
                if ((effEndDateStr = (String)this.getView().getFormShowParameter().getCustomParam("bsled")) != null) {
                    effEndDate = format.parse(effEndDateStr);
                }
            }
            catch (ParseException ex) {
                LOGGER.error((Throwable)ex);
            }
            List<Map<String, Object>> result = HisTreeTplTool.validateTreeSaveOrConfirmChange(entityId, null, effStartDate, effEndDate, parentLongNumber, null);
            if (result == null) {
                this.getView().setEnable(Boolean.TRUE, new String[]{CONTROL_ENABLE_CHECKBOX});
            }
        }
    }

    private void constructTreeView(List<Map<String, Object>> treeNodes) {
        TreeView tv = (TreeView)this.getView().getControl(CONTROL_TREE);
        Map<String, Object> rootMap = treeNodes.get(0);
        String rootId = String.valueOf(rootMap.get("id"));
        TreeNode rootNode = new TreeNode(null, rootId, String.valueOf(rootMap.get("name")), true);
        rootNode.setIsOpened(true);
        tv.addNode(rootNode);
        this.getPageCache().put(tv.getKey(), SerializationUtils.toJsonString((Object)rootNode));
        if (treeNodes.size() == 1) {
            return;
        }
        TreeNode parentNode = rootNode;
        for (int i = 1; i < treeNodes.size(); ++i) {
            Map<String, Object> nodeMap = treeNodes.get(i);
            String nodeId = String.valueOf(nodeMap.get("id"));
            boolean isParent = i != treeNodes.size() - 1;
            TreeNode node = new TreeNode(parentNode.getId(), nodeId, String.valueOf(nodeMap.get("name")), isParent);
            node.setIsOpened(true);
            parentNode.addChild(node);
            parentNode = node;
        }
    }

    private TreeNodeClickListener getTreeNodeClickListener() {
        final HisLineTimeTreeOpTipsPlugin plugin = this;
        return new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                Object nodeId = evt.getNodeId();
                String entityId = (String)HisLineTimeTreeOpTipsPlugin.this.getView().getFormShowParameter().getCustomParam("entityId");
                HisShowFormHandler.getInstance().openHisDataChangeByModal(HisLineTimeTreeOpTipsPlugin.this.getView(), entityId, Long.parseLong((String)nodeId), (IFormPlugin)plugin);
            }
        };
    }
}

