/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.newhismodel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.property.GroupProp;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.TemplateTreePlugin;
import kd.bos.list.IListView;
import kd.bos.mvc.list.ListView;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.utils.DbTypeConverter;
import kd.hr.hbp.common.constants.HRBaseConstants;
import kd.hr.hbp.common.constants.newhismodel.HisFieldNameConstants;
import kd.hr.hbp.common.util.HRStringUtils;

public class HisModelTreePlugin
extends TemplateTreePlugin
implements HRBaseConstants,
HisFieldNameConstants {
    public void beforeItemClick(BeforeItemClickEvent evt) {
        if (Objects.isNull(this.getTreeListView()) || Objects.isNull(this.getTreeModel())) {
            return;
        }
        if (evt.getItemKey().equals("tbldel")) {
            super.beforeItemClick(evt);
            IPageCache pageCache = this.getPageCache();
            pageCache.put("istbldel", "true");
            return;
        }
        GroupProp prop = this.getTreeModel().getGroupProp();
        if (prop instanceof ParentBasedataProp) {
            ListSelectedRowCollection listSelectedRowCollection;
            String propName = prop.getName();
            String entityName = prop.getEntityType().getName();
            String numberName = prop.getNumberProp();
            String listCaption = this.getView().getFormShowParameter().getCaption();
            if ((evt.getItemKey().equals("tbldisable") || evt.getItemKey().equals("tbldel")) && (listSelectedRowCollection = ((IListView)this.getView()).getSelectedRows()) != null && !listSelectedRowCollection.isEmpty()) {
                ORM orm = ORM.create();
                String selectField = "id," + prop.getEntityType().getNameProperty() + "," + propName + ".enable," + propName + "." + numberName + ",longnumber,enable";
                Object[] ids = new Object[listSelectedRowCollection.size()];
                Object[] numbers = new Object[listSelectedRowCollection.size()];
                for (int i = 0; i < listSelectedRowCollection.size(); ++i) {
                    ids[i] = listSelectedRowCollection.get(i).getPrimaryKeyValue();
                    numbers[i] = listSelectedRowCollection.get(i).getNumber();
                }
                QFilter q = new QFilter("id", "in", (Object)ids);
                QFilter[] filters = new QFilter[]{q};
                DynamicObjectCollection dynamicObjectCollection = orm.query(prop.getBaseEntityId(), selectField, filters);
                Object[] longNumbers = new Object[dynamicObjectCollection.size()];
                int needProcessData = 0;
                for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
                    DynamicObject doj = (DynamicObject)dynamicObjectCollection.get(i);
                    if ("0".equals(doj.get("enable")) && evt.getItemKey().equals("tbldisable")) continue;
                    ++needProcessData;
                    longNumbers[i] = doj.get("longnumber");
                }
                if (needProcessData > 0) {
                    QFilter baseQfilter = new QFilter("longnumber", "like", (Object)(longNumbers[0] + ((ParentBasedataProp)prop).getLongNumberDLM() + "%"));
                    QFilter versionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
                    for (int i = 1; i < longNumbers.length; ++i) {
                        QFilter tempQfilter = new QFilter("longnumber", "like", (Object)(longNumbers[i] + ((ParentBasedataProp)prop).getLongNumberDLM() + "%"));
                        baseQfilter.or(tempQfilter);
                    }
                    if (orm.exists(entityName, new QFilter[]{baseQfilter, versionFilter})) {
                        evt.setCancel(true);
                        if (evt.getItemKey().equals("tbldisable")) {
                            this.getView().showConfirm(ResManager.loadKDString((String)"\u7981\u7528\u63d0\u793a", (String)"StandardTreeListPlugin_8", (String)"bos-form-core", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"%1$s%2$s\u6709\u4e0b\u7ea7%3$s\uff0c\u6b64\u6b21\u7981\u7528\u5c06\u7981\u7528\u57fa\u7840\u8d44\u6599\u6240\u6709\u4e0b\u7ea7\u57fa\u7840\u8d44\u6599,\u662f\u5426\u7ee7\u7eed\uff1f", (String)"StandardTreeListPlugin_9", (String)"bos-form-core", (Object[])new Object[0]), listCaption, Arrays.toString(numbers), listCaption), MessageBoxOptions.YesNo, null, new ConfirmCallBackListener("disablebyall", (IFormPlugin)this));
                        } else if (evt.getItemKey().equals("tbldel")) {
                            this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u63d0\u793a", (String)"StandardTreeListPlugin_10", (String)"bos-form-core", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"%1$s%2$s\u6709\u4e0b\u7ea7%3$s\uff0c\u6b64\u6b21\u5220\u9664\u5c06\u5220\u9664\u57fa\u7840\u8d44\u6599\u6240\u6709\u4e0b\u7ea7\u57fa\u7840\u8d44\u6599,\u662f\u5426\u7ee7\u7eed\uff1f", (String)"StandardTreeListPlugin_11", (String)"bos-form-core", (Object[])new Object[0]), listCaption, Arrays.toString(numbers), listCaption), MessageBoxOptions.YesNo, null, new ConfirmCallBackListener("delbyall", (IFormPlugin)this));
                        }
                    }
                }
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    public void refreshNode(RefreshNodeEvent event) {
        String groupEntityNum;
        super.refreshNode(event);
        String entityNum = ((ListView)this.getView()).getBillFormId();
        if (EntityMetadataCache.getDataEntityType((String)entityNum).getAllFields().containsKey("group") && !EntityMetadataCache.getDataEntityType((String)(groupEntityNum = ((GroupProp)EntityMetadataCache.getDataEntityType((String)entityNum).getAllFields().get("group")).getEntityType().getName())).getAllFields().containsKey("iscurrentversion")) {
            return;
        }
        TreeListModel treeListModel = (TreeListModel)event.getSource();
        treeListModel.getTreeFilter().add(new QFilter("iscurrentversion", "=", (Object)"1"));
    }

    public DynamicObjectCollection getChildrenDynamicObject(BeforeDoOperationEventArgs args, BasedataEntityType entityType) {
        IPageCache pageCache = this.getPageCache();
        if (HRStringUtils.equals((String)pageCache.get("istbldel"), (String)"true")) {
            pageCache.remove("istbldel");
            return super.getChildrenDynamicObject(args, entityType);
        }
        ListSelectedRowCollection listSelectedRowCollection = args.getListSelectedData();
        Object[] ids = new Object[listSelectedRowCollection.size()];
        for (int i = 0; i < listSelectedRowCollection.size(); ++i) {
            ids[i] = listSelectedRowCollection.get(i).getPrimaryKeyValue();
        }
        return this.getChildrenDynamicObject(ids, entityType);
    }

    private DynamicObjectCollection getChildrenDynamicObject(Object[] ids, BasedataEntityType entityType) {
        ORM orm = ORM.create();
        String number = entityType.getNumberProperty();
        if (entityType.getProperty("longnumber") == null) {
            return null;
        }
        String entityName = entityType.getName();
        String selectFields = "id,longnumber,parent.longnumber," + number + ",enable";
        String orderBy = "longnumber desc";
        int dbType = entityType.getPrimaryKey().getDbType();
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = DbTypeConverter.safeConvert((int)dbType, (Object)ids[i]);
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", (Object)ids)};
        DynamicObjectCollection collection = orm.query(entityName, selectFields, filters, orderBy);
        ArrayList<String> list = new ArrayList<String>();
        for (DynamicObject object : collection) {
            if (object.getString("longnumber") == null || "".equals(object.getString("longnumber").trim())) continue;
            list.add(object.getString("longnumber"));
        }
        selectFields = "id,longnumber,parent.longnumber," + number + ",enable";
        ParentBasedataProp parentProp = null;
        DataEntityPropertyCollection props = entityType.getProperties();
        for (IDataEntityProperty prop : props) {
            if (!(prop.getParent() instanceof MainEntityType) || !(prop instanceof ParentBasedataProp)) continue;
            parentProp = (ParentBasedataProp)prop;
            break;
        }
        String longNumberDLM = ".";
        if (parentProp != null) {
            longNumberDLM = parentProp.getLongNumberDLM();
        }
        QFilter baseQfilter = new QFilter("id", "in", (Object)ids);
        QFilter versionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        if (ids.length > 1000) {
            return collection;
        }
        for (String s : list) {
            baseQfilter.or(new QFilter("longnumber", "like", (Object)(s + longNumberDLM + "%")));
        }
        return list.isEmpty() ? collection : orm.query(entityName, selectFields, new QFilter[]{baseQfilter, versionFilter}, orderBy);
    }

    private boolean isHisLine() {
        String formId = ((IListView)this.getView()).getBillFormId();
        return EntityMetadataCache.getDataEntityType((String)formId).getProperties().containsKey((Object)"bsed");
    }
}

