/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.newhismodel;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.filter.SortType;
import kd.bos.entity.list.column.TextColumnDesc;
import kd.bos.entity.property.ComboProp;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.ListColumn;
import kd.bos.list.ListOperationColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.list.column.ListOperationColumnDesc;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.IListPlugin;
import kd.bos.mvc.form.FormView;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.hr.hbp.business.application.impl.common.HRLongValueParseService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisReviseValidateService;
import kd.hr.hbp.business.domain.util.HisModelEditAuditTool;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.business.util.HRBaseDataConfigUtil;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.constants.HRBaseConstants;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.constants.newhismodel.EventOperateEnums;
import kd.hr.hbp.common.constants.newhismodel.HisFieldNameConstants;
import kd.hr.hbp.common.constants.newhismodel.HisSysConstants;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.hbp.formplugin.web.util.newhismodel.HisModelEditBtnGenTool;
import kd.hr.hbp.formplugin.web.util.newhismodel.HisModelEditBuTool;
import kd.hr.hbp.formplugin.web.util.newhismodel.HisShowFormHandler;

public class HisNonLineTimeTplListPlugin
extends HRDataBaseList
implements HRBaseConstants,
HisFieldNameConstants,
HisSysConstants,
IListPlugin {
    private static final String HISVERSION_DESC = "hisversion desc";

    public void packageData(PackageDataEvent event) {
        String dataStatus;
        String hisInfoList;
        TextColumnDesc col;
        String key;
        super.packageData(event);
        if (event.getSource() instanceof TextColumnDesc && HRStringUtils.equals((String)"hisversion", (String)(key = (col = (TextColumnDesc)event.getSource()).getKey())) && HRStringUtils.equals((String)"Z0001", (String)event.getFormatValue().toString())) {
            event.setFormatValue((Object)"");
        }
        if (!HRStringUtils.equals((String)(hisInfoList = (String)this.getView().getFormShowParameter().getCustomParam("hisinfolist")), (String)"hisinfolist")) {
            return;
        }
        if (!(event.getSource() instanceof ListOperationColumnDesc)) {
            return;
        }
        List operationColItems = (List)event.getFormatValue();
        if (event.getRowData().containsProperty("datastatus") && !HRStringUtils.equals((String)(dataStatus = event.getRowData().getString("datastatus")), (String)EventOperateEnums.CHANGE_BEFORE_STATUS_TEMP.getValue())) {
            for (OperationColItem opItem : operationColItems) {
                if (!"revise".equals(opItem.getOperationKey())) continue;
                opItem.setVisible(true);
            }
        }
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        QFilter isCurrentFilter;
        super.setFilter(setFilterEvent);
        String hisInfoList = (String)this.getView().getFormShowParameter().getCustomParam("hisinfolist");
        List qFilters = setFilterEvent.getQFilters();
        if (HRStringUtils.isEmpty((String)hisInfoList)) {
            isCurrentFilter = new QFilter("iscurrentversion", "=", (Object)"1");
            QFilter dataStatusFilter = new QFilter("datastatus", "!=", (Object)EnumHisDataVersionStatus.DISCARDED.getStatus());
            qFilters.add(isCurrentFilter);
            qFilters.add(dataStatusFilter);
        }
        if (HRStringUtils.equals((String)hisInfoList, (String)"hisinfolist")) {
            isCurrentFilter = new QFilter("iscurrentversion", "=", (Object)"0");
            QFilter isReviseFilter = new QFilter("datastatus", "!=", (Object)EnumHisDataVersionStatus.REVISED.getStatus());
            qFilters.add(isCurrentFilter);
            qFilters.add(isReviseFilter);
            qFilters.removeIf(filter -> Objects.nonNull(filter) && HRStringUtils.equals((String)filter.getProperty(), (String)"ctrlstrategy"));
            setFilterEvent.setOrderBy(HISVERSION_DESC);
        }
        if (this.getView().getFormShowParameter() instanceof ListShowParameter && ((ListShowParameter)this.getView().getFormShowParameter()).isLookUp()) {
            BillList billList = (BillList)setFilterEvent.getSource();
            Map fields = billList.getEntityType().getFields();
            if (fields.containsKey("status")) {
                QFilter statusFilter = new QFilter("status", "=", (Object)"C");
                qFilters.add(statusFilter);
            }
            QFilter dataStatusQfilter = new QFilter("datastatus", "=", (Object)"1");
            qFilters.add(dataStatusQfilter);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        Set fields;
        super.billListHyperLinkClick(args);
        ListView view = (ListView)this.getView();
        String hisInfoList = (String)view.getFormShowParameter().getCustomParam("hisinfolist");
        if (!HRStringUtils.equals((String)hisInfoList, (String)"hisinfolist")) {
            return;
        }
        Long boid = HRLongValueParseService.getInstance().getLongValueFromMap(view.getFormShowParameter().getCustomParams(), "boid");
        String notShowFields = (String)this.getView().getFormShowParameter().getCustomParam("notOpenDefaultHyperLink");
        if (HRStringUtils.isNotEmpty((String)notShowFields) && (notShowFields.contains(",") ? (fields = Arrays.stream(notShowFields.split(",")).collect(Collectors.toSet())).contains(args.getFieldName()) : HRStringUtils.equals((String)args.getFieldName(), (String)notShowFields))) {
            return;
        }
        args.setCancel(true);
        ListShowParameter parameter = (ListShowParameter)view.getFormShowParameter();
        BillShowParameter showParameter = this.newBillShowParameter(parameter.getBillFormId());
        showParameter.setFormId(parameter.getBillFormId());
        showParameter.setPkId(this.getFocusRowPkId());
        String billStatus = view.getCurrentSelectedRowInfo().getBillStatus();
        showParameter.setStatus(OperationStatus.EDIT);
        if (HRStringUtils.equals((String)billStatus, (String)"C")) {
            showParameter.setBillStatus(BillOperationStatus.AUDIT);
        } else {
            showParameter.setBillStatus(BillOperationStatus.EDIT);
        }
        HRPageCache pageCache = new HRPageCache(view.getPageCache());
        Map customParamMap = (Map)pageCache.get("customParamMap", Map.class);
        if (customParamMap != null) {
            showParameter.getCustomParams().putAll(customParamMap);
        }
        showParameter.setCustomParam("fromPage", (Object)"fromHisAction");
        showParameter.setCustomParam("fromHisPageToEdit", (Object)"fromHisAction");
        showParameter.setCustomParam("boid", (Object)boid);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "refreshHisList"));
        view.showForm((FormShowParameter)showParameter);
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        IFormView view = this.getView();
        String hisInfoList = (String)view.getFormShowParameter().getCustomParam("hisinfolist");
        boolean needAudit = HisModelEditAuditTool.getNeedAuditForBillList((IFormView)view);
        List listColumns = args.getListColumns();
        Iterator iterator = listColumns.iterator();
        if (HRStringUtils.isEmpty((String)hisInfoList)) {
            while (iterator.hasNext()) {
                String listFieldKey = ((IListColumn)iterator.next()).getListFieldKey();
                if (HRStringUtils.equals((String)listFieldKey, (String)"datastatus") || HRStringUtils.equals((String)listFieldKey, (String)"changedescription")) {
                    iterator.remove();
                }
                if (!HRStringUtils.equals((String)listFieldKey, (String)"ismodify") || needAudit) continue;
                iterator.remove();
            }
        } else if (HRStringUtils.equals((String)hisInfoList, (String)"hisinfolist")) {
            ListColumn colModifier;
            HisModelEditBtnGenTool.createNonHisListBtnBar(view, needAudit);
            Long boid = HRLongValueParseService.getInstance().getLongValueFromMap(this.getView().getFormShowParameter().getCustomParams(), "boid");
            ListShowParameter parameter = (ListShowParameter)this.getView().getFormShowParameter();
            String billFormId = parameter.getBillFormId();
            boolean isExistVersionSource = HisModelEditBuTool.exitsOriginSyncData(billFormId, boid);
            while (iterator.hasNext()) {
                String listFieldKey = ((IListColumn)iterator.next()).getListFieldKey();
                if (!HRStringUtils.equals((String)listFieldKey, (String)"ismodify") && !HRStringUtils.equals((String)listFieldKey, (String)"status")) continue;
                iterator.remove();
            }
            Set keySet = Stream.of("modifier", "modifier.name", "modifytime", "issyspreset").collect(Collectors.toSet());
            listColumns.forEach(column -> column.setOrder(SortType.NotOrder.name()));
            listColumns.removeIf(col -> keySet.contains(col.getListFieldKey()) || col instanceof ListOperationColumn);
            if (isExistVersionSource) {
                colModifier = this.createListColumn("versionsource", ResManager.loadKDString((String)"\u7248\u672c\u6765\u6e90", (String)"HisLineTimeTplListPlugin_18", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
                listColumns.add(colModifier);
            }
            colModifier = this.createListColumn("modifier.name", ResManager.loadKDString((String)"\u64cd\u4f5c\u4eba", (String)"HisLineTimeTplListPlugin_14", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
            colModifier.setColumnFilter(true);
            listColumns.add(colModifier);
            ListColumn colModifyTime = this.createListColumn("modifytime", ResManager.loadKDString((String)"\u64cd\u4f5c\u65f6\u95f4", (String)"HisLineTimeTplListPlugin_15", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
            listColumns.add(colModifyTime);
            ListOperationColumn operationColumn = this.createOperationColumn();
            if (operationColumn != null) {
                listColumns.add(operationColumn);
            }
            ListColumn colVersion = this.createListColumn("hisversion", ResManager.loadKDString((String)"\u7248\u672c\u53f7", (String)"HisLineTimeTplListPlugin_16", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
            listColumns.add(0, colVersion);
        }
    }

    private ListOperationColumn createOperationColumn() {
        Map hisEntityEventMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSHismodelService", (String)"getHisEntityEventBo", (Object[])new Object[]{((IListView)this.getView()).getListModel().getDataEntityType().getName()});
        this.getView().getPageCache().put("openrevise", "1");
        if (hisEntityEventMap.isEmpty()) {
            this.getPageCache().put("openrevise", "1");
        } else if (!HRStringUtils.equals((String)((String)hisEntityEventMap.get("openrevise")), (String)"0")) {
            this.getPageCache().put("openrevise", "1");
        } else {
            return null;
        }
        ListOperationColumn column = new ListOperationColumn();
        ArrayList items = Lists.newArrayListWithCapacity((int)16);
        OperationColItem reviseItem = new OperationColItem();
        reviseItem.setOperationName(new LocaleString(ResManager.loadKDString((String)"\u4fee\u8ba2", (String)"HisLineTimeTplListPlugin_17", (String)"hrmp-hbp-formplugin", (Object[])new Object[0])));
        reviseItem.setOperationKey("revise");
        reviseItem.setVisible(false);
        items.add(reviseItem);
        column.setOperationColItems((List)items);
        column.setVisible(63);
        column.setName(new LocaleString(ResManager.loadKDString((String)"\u64cd\u4f5c", (String)"HisLineTimeTplListPlugin_11", (String)"hrmp-hbp-formplugin", (Object[])new Object[0])));
        column.setCaption(new LocaleString(ResManager.loadKDString((String)"\u64cd\u4f5c", (String)"HisLineTimeTplListPlugin_11", (String)"hrmp-hbp-formplugin", (Object[])new Object[0])));
        column.setKey("listoperatecol");
        column.setSeq(2);
        return column;
    }

    private ListColumn createListColumn(String key, String caption) {
        ListColumn col = new ListColumn();
        col.setKey(key);
        col.setCaption(new LocaleString(caption));
        col.setListFieldKey(key);
        col.setFieldName(key);
        col.setSeq(1);
        col.setVisible(63);
        return col;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView view = this.getView();
        String hisInfoList = (String)view.getFormShowParameter().getCustomParam("hisinfolist");
        if (HRStringUtils.equals((String)hisInfoList, (String)"hisinfolist")) {
            view.setVisible(Boolean.FALSE, new String[]{"schemefilterview", "cardview"});
            view.setVisible(Boolean.TRUE, new String[]{"tbl_auditconfirmchange", "tbl_deletehis"});
            IClientViewProxy viewProxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
            viewProxy.removeInvokeControlMethod("filtercontainerap", "loadSchemeList");
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"tbl_confirmchange", "tbl_auditconfirmchange", "tbl_deletehis"});
            Map status = HRBaseDataConfigUtil.getStatus((String)((ListView)view).getBillFormId());
            boolean needAudit = (Boolean)status.get("auditcheck");
            String enableStatus = (String)status.get("enablestatus");
            view.setVisible(Boolean.valueOf(needAudit && HRStringUtils.equals((String)enableStatus, (String)"10")), new String[]{"tblunaudit"});
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        String hisInfoList = (String)this.getView().getFormShowParameter().getCustomParam("hisinfolist");
        if (HRStringUtils.equals((String)hisInfoList, (String)"hisinfolist")) {
            args.getCommonFilterColumns().clear();
            this.addFilterColumn(args);
            if (Objects.nonNull(this.getPageCache().get("customfilter"))) {
                this.getPageCache().remove("customfilter");
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"revise") && !args.isCancel()) {
            String billFormId = ((ListView)this.getView()).getBillFormId();
            boolean orgValidate = HisReviseValidateService.getInstance().reviseOrgValidate(this.getView(), this.getFocusRowPkId(), billFormId);
            if (!orgValidate) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u4fee\u8ba2\u975e\u672c\u7ec4\u7ec7\u521b\u5efa\u7684\u6570\u636e\u3002", (String)"HisLineTimeTplFormEdit_10", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            HisShowFormHandler.getInstance().newNoTimeLineRevisePage((FormView)((ListView)this.getView()), this.getFocusRowPkId(), (IFormPlugin)this, this.getModel());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "deletehis": 
            case "audithisconfirmchange": {
                ListView listView = (ListView)this.getView();
                listView.clearSelection();
                listView.refresh();
                break;
            }
            case "versionchangecompare": {
                if (!args.getOperationResult().isSuccess()) {
                    return;
                }
                Set<Object> selectedRowIds = this.getSelectedRows().stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
                HisShowFormHandler.getInstance().showVersionChangeCompareList((ListView)this.getView(), selectedRowIds);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if (HRStringUtils.equals((String)actionId, (String)"refreshHisList")) {
            ListView listView = (ListView)this.getView();
            listView.refresh();
        }
    }

    private void addFilterColumn(FilterContainerInitArgs args) {
        boolean needAudit = HisModelEditAuditTool.getNeedAuditForBillList((IFormView)this.getView());
        String billFormId = ((ListView)this.getView()).getListModel().getDataEntityType().getName();
        List valueMapItemList = ((ComboProp)EntityMetadataCache.getDataEntityType((String)billFormId).getFields().get("datastatus")).getComboItems();
        valueMapItemList.removeIf(item -> EnumHisDataVersionStatus.REVISED.getStatus().equals(item.getValue()));
        if (!needAudit) {
            valueMapItemList.removeIf(item -> EnumHisDataVersionStatus.TEMP.getStatus().equals(item.getValue()));
        } else {
            valueMapItemList.removeIf(item -> EnumHisDataVersionStatus.TEMP.getStatus().equals(item.getValue()));
            ValueMapItem valueMapItem = new ValueMapItem();
            valueMapItem.setName(new LocaleString(ResManager.loadKDString((String)"\u6682\u5b58", (String)"HisNonLineTimeTplListPlugin_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0])));
            valueMapItem.setValue(EnumHisDataVersionStatus.TEMP.getStatus());
            valueMapItemList.add(0, valueMapItem);
        }
        CommonFilterColumn dataStatusColumn = new CommonFilterColumn();
        dataStatusColumn.setKey("datastatus");
        dataStatusColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u7248\u672c\u72b6\u6001", (String)"HisNonLineTimeTplListPlugin_0", (String)"hrmp-hbp-formplugin", (Object[])new Object[0])));
        dataStatusColumn.setFieldName("datastatus");
        dataStatusColumn.setType("text");
        List<ComboItem> combos = this.buildComboItems(needAudit);
        dataStatusColumn.setComboItems(combos);
        dataStatusColumn.setMulti(true);
        args.addFilterColumn((FilterColumn)dataStatusColumn);
    }

    private List<ComboItem> buildComboItems(boolean needAudit) {
        ArrayList combos = Lists.newArrayListWithExpectedSize((int)16);
        if (needAudit) {
            ComboItem temp = new ComboItem();
            temp.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6682\u5b58", (String)"HisNonLineTimeTplListPlugin_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0])));
            temp.setValue(EnumHisDataVersionStatus.TEMP.getStatus());
            combos.add(temp);
        }
        ComboItem deleted = new ComboItem();
        deleted.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5df2\u5220\u9664", (String)"HisNonLineTimeTplListPlugin_3", (String)"hrmp-hbp-formplugin", (Object[])new Object[0])));
        deleted.setValue(EnumHisDataVersionStatus.DELETED.getStatus());
        combos.add(deleted);
        ComboItem effecting = new ComboItem();
        effecting.setCaption(new LocaleString(ResManager.loadKDString((String)"\u751f\u6548\u4e2d", (String)"HisNonLineTimeTplListPlugin_2", (String)"hrmp-hbp-formplugin", (Object[])new Object[0])));
        effecting.setValue(EnumHisDataVersionStatus.EFFECTING.getStatus());
        combos.add(effecting);
        ComboItem discarded = new ComboItem();
        discarded.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5df2\u5e9f\u5f03", (String)"HisNonLineTimeTplListPlugin_4", (String)"hrmp-hbp-formplugin", (Object[])new Object[0])));
        discarded.setValue(EnumHisDataVersionStatus.DISCARDED.getStatus());
        combos.add(discarded);
        return combos;
    }

    public BillShowParameter newBillShowParameter(String entityId) {
        Boolean isBaseDataCtrl = BaseDataServiceHelper.checkBaseDataCtrl((String)entityId);
        if (isBaseDataCtrl.booleanValue()) {
            return new BillShowParameter();
        }
        return new BaseShowParameter();
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        e.getParameter().setCustomParam("disable_control_title", (Object)"true");
    }
}

