/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.newhismodel;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.IListView;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.util.StringUtils;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisEffDateCommonService;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;

@ExcludeFromJacocoGeneratedReport
public class HisSetDisableDatePlugin
extends AbstractBasePlugIn {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String entityNumber = this.getEntityNumber();
        Date disableDate = HisEffDateCommonService.getInstance().getNowMaskDate(entityNumber);
        this.getModel().setValue("disabledate", (Object)disableDate);
        this.updateMask(entityNumber);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object showTips = this.getView().getFormShowParameter().getCustomParam("showTips");
        if (showTips instanceof Boolean && !((Boolean)showTips).booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tips"});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"confirm")) {
            this.getView().returnDataToParent(this.getModel().getValue("disabledate"));
        }
    }

    private void updateMask(String entityNumber) {
        if (StringUtils.isEmpty((Object)entityNumber)) {
            return;
        }
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        if (formMeta == null) {
            return;
        }
        for (ControlAp control : formMeta.getItems()) {
            if (!(control instanceof FieldAp) || !control.getKey().equals("bsed")) continue;
            String mask = ((FieldAp)control).getMask();
            String formatString = ((FieldAp)control).getDisplayFormatString();
            HashMap<String, String> maskMap = new HashMap<String, String>(2);
            maskMap.put("mask", mask);
            maskMap.put("df", formatString);
            HashMap<String, HashMap<String, String>> itemMap = new HashMap<String, HashMap<String, String>>(1);
            itemMap.put("item", maskMap);
            this.getView().updateControlMetadata("disabledate", itemMap);
        }
    }

    private String getEntityNumber() {
        IFormView formView = this.getView().getParentView();
        String entityNumber = formView instanceof IListView ? ((IListView)formView).getListModel().getDataEntityType().getName() : formView.getModel().getDataEntityType().getName();
        return entityNumber;
    }
}

