/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.newhismodel;

import com.alibaba.fastjson.JSON;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.calc.api.HisVersionCalcApiParam;
import kd.hr.hbp.business.domain.model.newhismodel.calc.api.HisVersionCalcApiResult;
import kd.hr.hbp.business.domain.service.impl.newhismodel.calc.EnumVersionDataChangeType;
import kd.hr.hbp.common.api.HrApiResponse;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;

public class HisTestCalcHisVersionDemoEdit
extends HRDataBaseEdit {
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (operateKey.equals("save") || operateKey.equals("confirmchange")) {
            HisVersionCalcApiParam hisVersionReviseParamBo = new HisVersionCalcApiParam();
            hisVersionReviseParamBo.setValidateContinuity(true);
            hisVersionReviseParamBo.setDynamicObject(this.getModel().getDataEntity());
            HrApiResponse hisVersionCalcApiResultHrApiResponse = HisModelController.getInstance().hisVersionSaveCalc(hisVersionReviseParamBo);
            HisVersionCalcApiResult hisVersionCalcApiResult = (HisVersionCalcApiResult)hisVersionCalcApiResultHrApiResponse.getData();
            if (hisVersionCalcApiResult == null) {
                this.getView().showTipNotification(hisVersionCalcApiResultHrApiResponse.getErrorMessage());
                return;
            }
            Map mapList = hisVersionCalcApiResult.getHisVersionCalcData();
            List newList = (List)mapList.get(EnumVersionDataChangeType.NEW.getType());
            List updateList = (List)mapList.get(EnumVersionDataChangeType.UPDATE.getType());
            List deleteList = (List)mapList.get(EnumVersionDataChangeType.DELETE.getType());
            HashMap<String, String> map = new HashMap<String, String>(16);
            map.put(EnumVersionDataChangeType.NEW.getType(), this.listToString(newList));
            map.put(EnumVersionDataChangeType.UPDATE.getType(), this.listToString(updateList));
            map.put(EnumVersionDataChangeType.DELETE.getType(), this.listToString(deleteList));
            this.getView().showTipNotification(JSON.toJSONString(map));
        }
    }

    private String listToString(List<DynamicObject> dynamicObjects) {
        if (CollectionUtils.isEmpty(dynamicObjects)) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        for (DynamicObject dynamicObject : dynamicObjects) {
            Date startDate = dynamicObject.getDate("bsed");
            Date endDate = dynamicObject.getDate("bsled");
            String hisVersion = dynamicObject.getString("hisversion");
            sb.append(" version: ");
            sb.append(hisVersion);
            sb.append(";");
            if (dynamicObject.getDynamicObjectType().getProperties().containsKey((Object)"description")) {
                String description = dynamicObject.getString("description");
                sb.append(" description: ");
                sb.append(description);
                sb.append(";");
            }
            String dataStatus = dynamicObject.getString("datastatus");
            sb.append(" data status : ");
            if (dataStatus != null) {
                switch (dataStatus) {
                    case "-3": {
                        sb.append("temp");
                        break;
                    }
                    case "-2": {
                        sb.append("deleted");
                        break;
                    }
                    case "0": {
                        sb.append("to be effect");
                        break;
                    }
                    case "1": {
                        sb.append("effecting");
                        break;
                    }
                    case "2": {
                        sb.append("invalid");
                        break;
                    }
                }
                sb.append(";");
            }
            sb.append(" start date : ");
            if (startDate != null) {
                sb.append(HRDateTimeUtils.format((Date)startDate, (String)"yyyy-MM-dd"));
                sb.append(";");
            }
            sb.append(" end date: ");
            if (endDate != null) {
                sb.append(HRDateTimeUtils.format((Date)endDate, (String)"yyyy-MM-dd"));
                sb.append(";");
            }
            sb.append("  ");
        }
        return sb.toString();
    }
}

