/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.newhismodel;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.SortType;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.list.column.TextColumnDesc;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.ListColumn;
import kd.bos.list.events.CreateListColumnsListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.FieldControlRuleDto;
import kd.bos.permission.api.FieldControlRules;
import kd.hr.hbp.business.application.impl.common.HRLongValueParseService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.constants.newhismodel.EventOperateEnums;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.util.newhismodel.HisModelListCommonTool;

public class HisVersionComparePlugin
extends AbstractFormPlugin
implements CreateListColumnsListener,
SetFilterListener {
    private static final Log LOGGER = LogFactory.getLog(HisVersionComparePlugin.class);
    private static final String SELECTED_FIRST_ID = "selectedFirstId";
    private static final String SELECTED_TWICE_ID = "selectedTwiceId";
    private String hisFormId = null;
    private Long boId = null;
    private List<FieldControlRuleDto> fieldControlRuleDtos = null;
    private String mainOrg = null;

    public void initialize() {
        super.initialize();
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentView == null) {
            return;
        }
        this.hisFormId = parentView.getPageCache().get("formId");
        this.boId = Long.parseLong(parentView.getPageCache().get("boid"));
        BillList billList = (BillList)this.getControl("billlistap");
        billList.setBillFormId(this.hisFormId);
        billList.addCreateListColumnsListener((CreateListColumnsListener)this);
        billList.addSetFilterListener((SetFilterListener)this);
        billList.addPackageDataListener(this::packageData);
        String appNum = EntityMetadataCache.getDataEntityType((String)this.hisFormId).getAppId();
        String appId = EntityMetadataCache.getAppInfo((String)appNum).getId();
        FieldControlRules fieldControlRules = (FieldControlRules)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSDataPermissionService", (String)"getFieldControlRules", (Object[])new Object[]{RequestContext.get().getCurrUserId(), appId, this.hisFormId, Collections.emptyMap()});
        this.fieldControlRuleDtos = fieldControlRules.getFieldControlRuleDtos();
        this.mainOrg = EntityMetadataCache.getDataEntityType((String)this.hisFormId).getMainOrg();
        LOGGER.info("HisVersionComparePlugin_init appNum: {}, appId: {}, fieldControlRules: {}", new Object[]{appNum, appId, fieldControlRules});
    }

    public void setFilter(SetFilterEvent event) {
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        String selectedIds = parentView.getPageCache().get("selectedIds");
        List ObjectIds = (List)SerializationUtils.fromJsonString((String)selectedIds, List.class);
        List ids = HRLongValueParseService.getInstance().parseLongForList(ObjectIds);
        if (this.getPageCache().get(SELECTED_FIRST_ID) == null) {
            if (ids.size() == 1) {
                this.getPageCache().put(SELECTED_FIRST_ID, ((Long)ids.get(0)).toString());
            } else if (ids.size() == 2) {
                this.getPageCache().put(SELECTED_FIRST_ID, ((Long)ids.get(0)).toString());
                this.getPageCache().put(SELECTED_TWICE_ID, ((Long)ids.get(1)).toString());
            } else if (ids.size() > 2) {
                HRBaseServiceHelper helper = new HRBaseServiceHelper(this.hisFormId);
                DynamicObjectCollection versions = helper.queryOriginalCollection("id", new QFilter[]{new QFilter("id", "in", (Object)ids)}, "hisversion desc");
                DynamicObject firstDy = (DynamicObject)versions.get(0);
                this.getPageCache().put(SELECTED_FIRST_ID, firstDy.getString("id"));
                DynamicObject secondDy = (DynamicObject)versions.get(1);
                this.getPageCache().put(SELECTED_TWICE_ID, secondDy.getString("id"));
            }
        }
        String selectedFirstId = this.getPageCache().get(SELECTED_FIRST_ID);
        String selectedTwiceId = this.getPageCache().get(SELECTED_TWICE_ID);
        if (HRStringUtils.isEmpty((String)selectedFirstId) && HRStringUtils.isEmpty((String)selectedTwiceId)) {
            event.getQFilters().add(new QFilter("id", "!=", (Object)"id", true));
        } else if (HRStringUtils.isEmpty((String)selectedTwiceId)) {
            event.getQFilters().add(new QFilter("id", "=", (Object)Long.parseLong(selectedFirstId)));
        } else {
            event.getQFilters().add(new QFilter("id", "in", (Object)new Object[]{Long.parseLong(selectedFirstId), Long.parseLong(selectedTwiceId)}));
            event.setOrderBy("hisversion desc");
        }
    }

    public void createListColumns(BeforeCreateListColumnsArgs args) {
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        String showListColumnForVersionCompare = parentView.getPageCache().get("showListColumnForVersionCompare");
        if (HRStringUtils.isNotEmpty((String)showListColumnForVersionCompare)) {
            String sameValueFieldNums;
            List colMapList = (List)SerializationUtils.fromJsonString((String)showListColumnForVersionCompare, List.class);
            if (((Boolean)this.getModel().getValue("checkboxfield")).booleanValue() && HRStringUtils.isNotEmpty((String)(sameValueFieldNums = this.getView().getPageCache().get("sameValueFieldNums")))) {
                Set sameValueFieldNumSet = (Set)SerializationUtils.fromJsonString((String)sameValueFieldNums, Set.class);
                colMapList.removeIf(map -> sameValueFieldNumSet.contains(map.get("colflag")));
            }
            args.getListColumns().clear();
            ListColumn boIdCol = HisModelListCommonTool.createListColumn("boid", ResManager.loadKDString((String)"\u4e1a\u52a1ID", (String)"HisVersionComparePlugin_0", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), (Container)this.getView().getControl("listgridviewap"));
            boIdCol.setOrder(SortType.ASC.name());
            boIdCol.setVisible(0);
            args.addListColumn((IListColumn)boIdCol);
            Map<String, String> colMap = this.sortFields(colMapList);
            colMap.forEach((fieldKey, fieldName) -> {
                ListColumn newCol = HisModelListCommonTool.createListColumn(fieldKey, fieldName, (Container)this.getView().getControl("listgridviewap"));
                args.addListColumn((IListColumn)newCol);
            });
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void packageData(PackageDataEvent event) {
        TextColumnDesc col;
        String key;
        ColumnDesc columnDesc = (ColumnDesc)event.getSource();
        if (columnDesc == null || columnDesc.getFieldProp() == null) {
            return;
        }
        String fieldNum = columnDesc.getFieldProp().getName();
        if (!this.isHisLine() && event.getSource() instanceof TextColumnDesc && HRStringUtils.equals((String)"hisversion", (String)(key = (col = (TextColumnDesc)event.getSource()).getKey())) && HRStringUtils.equals((String)"Z0001", (String)event.getFormatValue().toString())) {
            event.setFormatValue((Object)"");
        }
        for (FieldControlRuleDto rule : this.fieldControlRuleDtos) {
            if (HRStringUtils.isNotEmpty((String)this.mainOrg)) {
                long createOrg = 0L;
                Object createOrgObj = event.getRowData().get(this.mainOrg);
                if (createOrgObj instanceof DynamicObject) {
                    createOrg = ((DynamicObject)createOrgObj).getLong("id");
                } else if (createOrgObj instanceof Long) {
                    createOrg = (Long)createOrgObj;
                }
                HashSet orgs = Sets.newHashSetWithExpectedSize((int)16);
                Long mainOrgId = rule.getMainOrgId();
                orgs.add(mainOrgId);
                if (rule.getIncludeSubOrg()) {
                    orgs.addAll(rule.getSubOrgId());
                }
                if (!orgs.contains(createOrg)) {
                    LOGGER.info("HisVersionComparePlugin_init_packageData orgs: {}, createOrg: {}", (Object)orgs, (Object)createOrg);
                    continue;
                }
            }
            Set canNotReadFields = rule.getFieldControlRule().getCanNotReadFields();
            LOGGER.info("HisVersionComparePlugin_init_packageData canNotReadFields: {}", (Object)canNotReadFields);
            if (!canNotReadFields.contains(fieldNum)) continue;
            event.setFormatValue((Object)"******");
            break;
        }
    }

    private Map<String, String> sortFields(List<Map<String, Object>> colMapList) {
        LinkedHashMap sortColMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
        AbstractMap colMap = Maps.newTreeMap();
        for (Map<String, Object> map : colMapList) {
            colMap.put((String)map.get("colflag"), (String)map.get("colname"));
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)this.hisFormId);
        Map allEntities = dataEntityType.getAllEntities();
        LinkedHashMap entryNotSortColMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
        for (Map.Entry entityTypeEntry : allEntities.entrySet()) {
            if (!(entityTypeEntry.getValue() instanceof EntryType)) continue;
            Map fields = ((EntityType)entityTypeEntry.getValue()).getFields();
            colMap.forEach((key, name) -> {
                if (fields.containsKey(key)) {
                    entryNotSortColMap.put(key, name);
                }
            });
        }
        for (Map.Entry entry2 : colMap.entrySet()) {
            String baseDataFieldKey;
            String fieldKey = (String)entry2.getKey();
            if (!fieldKey.contains(".") || !entryNotSortColMap.containsKey(baseDataFieldKey = fieldKey.split("\\.")[0])) continue;
            entryNotSortColMap.put(fieldKey, entry2.getValue());
        }
        colMap.entrySet().removeIf(entry -> entryNotSortColMap.containsKey(entry.getKey()));
        LinkedHashMap newNotSortColMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
        newNotSortColMap.putAll(colMap);
        newNotSortColMap.putAll(entryNotSortColMap);
        colMap = newNotSortColMap;
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        String showListHisColumnForVersionCompare = parentView.getPageCache().get("showListHisColumnForVersionCompare");
        if (HRStringUtils.isNotEmpty((String)showListHisColumnForVersionCompare)) {
            String sameValueFieldNums;
            Map<String, String> hisColMap = (Map<String, String>)SerializationUtils.fromJsonString((String)showListHisColumnForVersionCompare, Map.class);
            if (((Boolean)this.getModel().getValue("checkboxfield")).booleanValue() && HRStringUtils.isNotEmpty((String)(sameValueFieldNums = this.getView().getPageCache().get("sameValueFieldNums")))) {
                Set sameValueFieldNumSet = (Set)SerializationUtils.fromJsonString((String)sameValueFieldNums, Set.class);
                hisColMap.entrySet().removeIf(entry -> sameValueFieldNumSet.contains(entry.getKey()));
            }
            AbstractMap finalNotSortColMap = colMap;
            hisColMap.entrySet().removeIf(entry -> !finalNotSortColMap.containsKey(entry.getKey()));
            Map<String, String> finalHisColMap = hisColMap = this.sortHisColMap(hisColMap);
            colMap.entrySet().removeIf(entry -> {
                if (((String)entry.getKey()).contains(".")) {
                    return finalHisColMap.containsKey(((String)entry.getKey()).split("\\.")[0]);
                }
                return finalHisColMap.containsKey(entry.getKey());
            });
            for (Map.Entry<String, String> entry3 : hisColMap.entrySet()) {
                if (HRStringUtils.equals((String)entry3.getKey(), (String)"changedescription")) {
                    sortColMap.putAll(colMap);
                }
                String key2 = entry3.getKey();
                boolean isPut = false;
                for (Map.Entry colMapEntry : colMap.entrySet()) {
                    if (!key2.contains(".")) continue;
                    if (((String)colMapEntry.getKey()).contains(".") && HRStringUtils.equals((String)key2.split("\\.")[0], (String)((String)colMapEntry.getKey()).split("\\.")[0])) {
                        sortColMap.put(colMapEntry.getKey(), colMapEntry.getValue());
                        isPut = true;
                        continue;
                    }
                    if (!HRStringUtils.equals((String)key2.split("\\.")[0], (String)((String)colMapEntry.getKey()))) continue;
                    sortColMap.put(colMapEntry.getKey(), colMapEntry.getValue());
                    isPut = true;
                }
                if (isPut) continue;
                sortColMap.put(entry3.getKey(), entry3.getValue());
            }
            if (!sortColMap.containsKey("changedescription")) {
                sortColMap.putAll(colMap);
            }
            return sortColMap;
        }
        return colMap;
    }

    @ExcludeFromJacocoGeneratedReport
    private Map<String, String> sortHisColMap(Map<String, String> hisColMap) {
        LinkedHashMap newHisColMap = Maps.newLinkedHashMapWithExpectedSize((int)hisColMap.size());
        ArrayList baseDataNums = Lists.newArrayListWithCapacity((int)10);
        hisColMap.forEach((key, name) -> {
            String baseDataKey;
            if (key.contains(".") && !baseDataNums.contains(baseDataKey = key.split("\\.")[0])) {
                baseDataNums.add(baseDataKey);
            }
        });
        if (baseDataNums.isEmpty()) {
            return hisColMap;
        }
        for (String string : baseDataNums) {
            boolean findBaseData = false;
            for (Map.Entry<String, String> entry : hisColMap.entrySet()) {
                if (entry.getKey().contains(".")) {
                    String fieldKey = entry.getKey().split("\\.")[0];
                    if (!HRStringUtils.equals((String)fieldKey, (String)string)) continue;
                    findBaseData = true;
                    newHisColMap.put(entry.getKey(), entry.getValue());
                    continue;
                }
                if (findBaseData || newHisColMap.containsKey(entry.getKey())) continue;
                newHisColMap.put(entry.getKey(), entry.getValue());
            }
        }
        for (Map.Entry entry : hisColMap.entrySet()) {
            if (newHisColMap.containsKey(entry.getKey())) continue;
            newHisColMap.put(entry.getKey(), entry.getValue());
        }
        return newHisColMap;
    }

    public void propertyChanged(PropertyChangedArgs args) {
        if (HRStringUtils.equals((String)args.getProperty().getName(), (String)"checkboxfield")) {
            BillList billList = (BillList)this.getControl("billlistap");
            billList.refresh();
            this.getView().updateView();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.createComboItems();
        String selectedFirstId = this.getPageCache().get(SELECTED_FIRST_ID);
        String selectedTwiceId = this.getPageCache().get(SELECTED_TWICE_ID);
        if (HRStringUtils.isEmpty((String)selectedFirstId) || HRStringUtils.isEmpty((String)selectedTwiceId)) {
            return;
        }
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        String showListColumnForVersionCompare = parentView.getPageCache().get("showListColumnForVersionCompare");
        String hisFormId = parentView.getPageCache().get("formId");
        if (HRStringUtils.isNotEmpty((String)showListColumnForVersionCompare)) {
            List colMapList = (List)SerializationUtils.fromJsonString((String)showListColumnForVersionCompare, List.class);
            ArrayList fieldNums = Lists.newArrayListWithCapacity((int)10);
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)hisFormId);
            DataEntityPropertyCollection properties = dataEntityType.getProperties();
            Map allEntities = dataEntityType.getAllEntities();
            for (Map.Entry entityTypeEntry : allEntities.entrySet()) {
                if (entityTypeEntry.getValue() instanceof EntryType) continue;
                properties = ((EntityType)entityTypeEntry.getValue()).getProperties();
                break;
            }
            for (Map colMap : colMapList) {
                String fieldKey = (String)colMap.get("colflag");
                if (HRStringUtils.equals((String)fieldKey, (String)"fseq") || HRStringUtils.equals((String)fieldKey, (String)"index") || HRStringUtils.equals((String)fieldKey, (String)"listoperatecol")) continue;
                if (fieldKey.contains(".") && properties.containsKey((Object)fieldKey.split("\\.")[0])) {
                    fieldNums.add(fieldKey);
                    continue;
                }
                if (!properties.containsKey((Object)fieldKey)) continue;
                fieldNums.add(fieldKey);
            }
            HRBaseServiceHelper helper = new HRBaseServiceHelper(hisFormId);
            DynamicObject[] dys = helper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", (Object)new Long[]{Long.parseLong(selectedFirstId), Long.parseLong(selectedTwiceId)})});
            DynamicObject selectedFirstDy = dys[0];
            DynamicObject selectedTwiceDy = dys[1];
            HashSet sameValueFieldNums = Sets.newHashSetWithExpectedSize((int)16);
            for (String fieldNum : fieldNums) {
                if (this.isDifferentCompareFieldVal(selectedFirstDy.get(fieldNum), selectedTwiceDy.get(fieldNum))) {
                    this.setListUnitStyle(fieldNum);
                    continue;
                }
                sameValueFieldNums.add(fieldNum);
            }
            if (!sameValueFieldNums.isEmpty()) {
                this.getView().getPageCache().put("sameValueFieldNums", SerializationUtils.toJsonString((Object)sameValueFieldNums));
            }
        }
    }

    public void customEvent(CustomEventArgs args) {
        String selectedVersionStr = args.getEventArgs();
        if (HRStringUtils.isEmpty((String)selectedVersionStr)) {
            return;
        }
        if (HRStringUtils.isEmpty((String)selectedVersionStr)) {
            return;
        }
        String[] split = selectedVersionStr.split(",");
        List ids = Arrays.stream(split).filter(HRStringUtils::isNotEmpty).collect(Collectors.toList());
        if (ids.size() != 2) {
            return;
        }
        this.getPageCache().put(SELECTED_FIRST_ID, (String)ids.get(0));
        this.getPageCache().put(SELECTED_TWICE_ID, (String)ids.get(1));
        BillList billList = (BillList)this.getControl("billlistap");
        billList.refresh();
        this.getView().updateView();
    }

    @ExcludeFromJacocoGeneratedReport
    private boolean isDifferentCompareFieldVal(Object firstVal, Object secondVal) {
        if (firstVal == null && secondVal == null) {
            return false;
        }
        if (firstVal == null || secondVal == null) {
            return true;
        }
        boolean result = false;
        if (firstVal instanceof DynamicObject) {
            result = !Objects.equals(((DynamicObject)firstVal).get("id"), ((DynamicObject)secondVal).get("id"));
        } else {
            if (firstVal instanceof MulBasedataDynamicObjectCollection) {
                Set secondIds;
                Set firstIds = ((MulBasedataDynamicObjectCollection)firstVal).stream().map(data -> data.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toSet());
                return !firstIds.containsAll(secondIds = ((MulBasedataDynamicObjectCollection)secondVal).stream().map(data -> data.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toSet())) || firstIds.size() != secondIds.size();
            }
            result = firstVal instanceof Date ? ((Date)firstVal).getTime() != ((Date)secondVal).getTime() : (firstVal instanceof OrmLocaleValue ? !HRStringUtils.equals((String)((OrmLocaleValue)firstVal).getLocaleValue(), (String)((OrmLocaleValue)secondVal).getLocaleValue()) : !Objects.equals(firstVal, secondVal));
        }
        return result;
    }

    private void createComboItems() {
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        String selectedIds = parentView.getPageCache().get("selectedIds");
        List ids = Lists.newArrayListWithCapacity((int)10);
        if (HRStringUtils.isNotEmpty((String)selectedIds)) {
            ids = (List)SerializationUtils.fromJsonString((String)selectedIds, List.class);
        }
        HashMap customData = Maps.newHashMapWithExpectedSize((int)2);
        ArrayList dropDownList = Lists.newArrayListWithCapacity((int)10);
        ArrayList selectedValue = Lists.newArrayListWithCapacity((int)10);
        Set dataStatusSet = Stream.of(EventOperateEnums.CHANGE_BEFORE_STATUS_TEMP.getValue(), EventOperateEnums.CHANGE_BEFORE_STATUS_TOBEEFFECT.getValue(), EventOperateEnums.CHANGE_BEFORE_STATUS_EFFECTING.getValue(), EventOperateEnums.CHANGE_BEFORE_STATUS_INVALIDED.getValue(), EventOperateEnums.CHANGE_BEFORE_STATUS_DELETED.getValue()).collect(Collectors.toSet());
        HRBaseServiceHelper helper = new HRBaseServiceHelper(this.hisFormId);
        String selectedProps = "id, hisversion";
        if (this.isHisLine()) {
            selectedProps = "id, hisversion, bsed";
        }
        DynamicObjectCollection versions = helper.queryOriginalCollection(selectedProps, new QFilter[]{new QFilter("boid", "=", (Object)this.boId), new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0')), new QFilter("datastatus", "in", dataStatusSet)}, "hisversion desc");
        for (DynamicObject version : versions) {
            String hisVersion = version.getString("hisversion");
            if (this.isHisLine()) {
                if (HRStringUtils.isEmpty((String)hisVersion)) {
                    Date date = version.getDate("bsed");
                    hisVersion = date == null ? ResManager.loadKDString((String)"\u6682\u5b58\u7248\u672c", (String)"HisVersionComparePlugin_2", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]) : String.format(ResManager.loadKDString((String)"\u6682\u5b58\u7248\u672c%s", (String)"HisVersionComparePlugin_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), HRDateTimeUtils.getUserSettingFormat().format(date));
                }
            } else if (hisVersion.startsWith("Z")) {
                hisVersion = ResManager.loadKDString((String)"\u6682\u5b58\u7248\u672c", (String)"HisVersionComparePlugin_2", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]);
            }
            HashMap dropDownItem = Maps.newHashMapWithExpectedSize((int)2);
            dropDownItem.put("key", version.getString("id"));
            dropDownItem.put("value", hisVersion);
            dropDownList.add(dropDownItem);
            if (ids.size() > 2 || !ids.contains(version.getLong("id"))) continue;
            selectedValue.add(dropDownItem);
        }
        customData.put("dropDownList", dropDownList);
        customData.put("selectedValue", selectedValue);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.setEntryProperty("customcontrolap", "data", (Object)customData);
    }

    private boolean isHisLine() {
        IDataEntityProperty effStartDatePro = (IDataEntityProperty)EntityMetadataCache.getDataEntityType((String)this.hisFormId).getProperties().get((Object)"bsed");
        return effStartDatePro != null;
    }

    private void setListUnitStyle(String fieldKey) {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection currentListAllRowCollection = billList.getCurrentListAllRowCollection();
        ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>(currentListAllRowCollection.size());
        for (int i = 0; i < currentListAllRowCollection.size(); ++i) {
            CellStyle cellStyle = new CellStyle();
            cellStyle.setFieldKey(fieldKey);
            cellStyle.setRow(i);
            cellStyle.setForeColor("#FF991C");
            cellStyles.add(cellStyle);
        }
        billList.setCellStyle(cellStyles);
    }
}

