/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.newhismodel.bd;

import com.google.common.collect.Maps;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.bdctrl.BdCtrlStrtgyUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.hr.hbp.business.domain.repository.HisCommonEntityRepository;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisCommonService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.constants.newhismodel.EnumEntityTpl;
import kd.hr.hbp.common.constants.newhismodel.HisLineTimeTplConstants;
import kd.hr.hbp.common.constants.newhismodel.HisSysConstants;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hbp.formplugin.web.util.newhismodel.HisModelEditBtnGenTool;
import kd.hr.hbp.formplugin.web.util.newhismodel.HisNewDataPageFieldsHandler;

public class HisBaseDataFormPlugin
extends HRDataBaseEdit
implements HisLineTimeTplConstants,
HisSysConstants {
    private static final Log LOGGER = LogFactory.getLog(HisBaseDataFormPlugin.class);
    private static final String CREATEORG = "createorg";
    private static final String USEORGID = "useorgId";
    private static final String ISPERSONALIZEDATA = "isPersonalizeData";
    private final Set<String> hisLineOpKeys = Stream.of("confirmchange", "confirmchangenoaudit").collect(Collectors.toSet());
    private final Set<String> hisNoneLineOpKeys = Stream.of("changesave", "auditconfirmchange").collect(Collectors.toSet());
    private final String SHARE_MAP = "mapShare";
    private final String UPDATE_MAP = "mapUpdate";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String fromPage = (String)this.getView().getFormShowParameter().getCustomParam("fromPage");
        Boolean isPersonalizeData = (Boolean)this.getView().getFormShowParameter().getCustomParam(ISPERSONALIZEDATA);
        if (isPersonalizeData != null && isPersonalizeData.booleanValue() && !HRStringUtils.equals((String)"fromHisAction", (String)fromPage) && !"revise".equals(fromPage)) {
            HisModelEditBtnGenTool.createBdBillEditSaveBtn(this.getView());
        }
        this.handlePersonalChangeForm();
    }

    @ExcludeFromJacocoGeneratedReport
    public void propertyChanged(PropertyChangedArgs args) {
        if (!this.isHisLine()) {
            return;
        }
        String propKey = args.getProperty().getName();
        String action = (String)this.getView().getFormShowParameter().getCustomParam("his_action");
        if (!HRStringUtils.equals((String)propKey, (String)"bsed") || !HRStringUtils.equals((String)action, (String)"open_insert_data_page") && !HRStringUtils.equals((String)action, (String)"open_copy_his_data_page") && !HRStringUtils.equals((String)action, (String)"open_insert_new_data_page")) {
            return;
        }
        String isPersonalizeSaveData = (String)this.getView().getFormShowParameter().getCustomParam("isPersonalizeSaveData");
        if (!HRStringUtils.equals((String)isPersonalizeSaveData, (String)"true")) {
            return;
        }
        HRPageCache pageCache = new HRPageCache(this.getPageCache());
        Map updateMap = (Map)pageCache.get("mapUpdate", Map.class);
        Date newStartDate = (Date)args.getChangeSet()[0].getNewValue();
        if (newStartDate == null) {
            return;
        }
        HisNewDataPageFieldsHandler.getInstance().handlePersonalizedFieldsForChangeBsed(this.getModel(), this.getView(), newStartDate, updateMap);
    }

    private void handlePersonalChangeForm() {
        if (this.isHisLine()) {
            String fromPage;
            String action;
            Object id = this.getModel().getValue("id");
            Object masterId = this.getModel().getValue("masterid");
            if ((Long)this.getModel().getValue("boid") == 0L) {
                return;
            }
            HashMap mapShare = Maps.newHashMapWithExpectedSize((int)16);
            HashMap mapUpdate = Maps.newHashMapWithExpectedSize((int)16);
            Long masterCurrentDyOrgId = this.getMasterCurrentDyOrgId();
            BdCtrlStrtgyUtils.getShareInfoFromBdCtrlStrtgy((String)this.getModel().getDataEntityType().getName(), (Long)masterCurrentDyOrgId, (Map)mapShare, (Map)mapUpdate);
            this.getPageCache().put("mapShare", SerializationUtils.toJsonString((Object)mapShare));
            this.getPageCache().put("mapUpdate", SerializationUtils.toJsonString((Object)mapUpdate));
            if (!(Objects.equals(id, 0) || Objects.equals(masterId, 0) || Objects.equals(id, masterId))) {
                HRPageCache pageCache = new HRPageCache(this.getPageCache());
                HashMap<String, String> customParamMap = (HashMap<String, String>)pageCache.get("customParamMap", Map.class);
                if (customParamMap == null) {
                    customParamMap = new HashMap<String, String>(16);
                }
                customParamMap.put("isPersonalizeSaveData", "true");
                pageCache.put("customParamMap", customParamMap);
            }
            if (this.isHisLineVersionChangePage(action = (String)this.getView().getFormShowParameter().getCustomParam("his_action"), fromPage = (String)this.getView().getFormShowParameter().getCustomParam("fromPage"))) {
                this.handlePersonalizeDataChangePage();
            } else if (HRStringUtils.equals((String)action, (String)"open_insert_new_data_page")) {
                Object isPersonalizeSaveData = this.getView().getFormShowParameter().getCustomParam("isPersonalizeSaveData");
                if (!HRStringUtils.equals((String)((String)isPersonalizeSaveData), (String)"true")) {
                    return;
                }
                if (!mapShare.isEmpty() || !mapUpdate.isEmpty()) {
                    HisNewDataPageFieldsHandler.getInstance().handlePersonalizedFields(this.getModel(), this.getView(), mapShare, mapUpdate);
                }
            }
        } else {
            String fromPage = (String)this.getView().getFormShowParameter().getCustomParam("fromPage");
            Object isChangeFromNonLineParam = this.getView().getFormShowParameter().getCustomParam("isChange");
            if (Objects.nonNull(isChangeFromNonLineParam) && ((Boolean)isChangeFromNonLineParam).booleanValue()) {
                this.handlePersonalizeDataChangePage();
            } else if ("revise".equals(fromPage)) {
                this.handlePersonalizeDataChangePage();
            }
        }
    }

    private boolean isHisLineVersionChangePage(String action, String fromPage) {
        return HRStringUtils.equals((String)action, (String)"open_data_page") || HRStringUtils.equals((String)action, (String)"modify_data_page") || HRStringUtils.equals((String)action, (String)"open_insert_data_page") || HRStringUtils.equals((String)action, (String)"open_copy_his_data_page") || HRStringUtils.equals((String)fromPage, (String)"revise");
    }

    @ExcludeFromJacocoGeneratedReport
    private void handlePersonalizeDataChangePage() {
        Object isPersonalizeSaveData = this.getView().getFormShowParameter().getCustomParam("isPersonalizeSaveData");
        if (isPersonalizeSaveData instanceof String) {
            if (!HRStringUtils.equals((String)((String)isPersonalizeSaveData), (String)"true")) {
                return;
            }
        } else if (isPersonalizeSaveData instanceof Boolean) {
            if (!((Boolean)isPersonalizeSaveData).booleanValue()) {
                return;
            }
        } else {
            return;
        }
        String billFormId = this.getModel().getDataEntityType().getName();
        Long masterCurrentDyOrgId = this.getMasterCurrentDyOrgId();
        BdCtrlStrtgyUtils.setVisibleByBdCtrlStrtgy((String)billFormId, (Long)masterCurrentDyOrgId, (IFormView)this.getView(), (OperationStatus)OperationStatus.EDIT);
        this.getView().setEnable(Boolean.TRUE, new String[]{"bsed", "bsled", "changedescription"});
        this.getModel().setDataChanged(false);
    }

    private Long getMasterCurrentDyOrgId() {
        String billFormId = this.getModel().getDataEntityType().getName();
        String masteridPropName = BaseDataServiceHelper.getMasterIdPropName((String)billFormId);
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(billFormId);
        Long boid = (Long)this.getModel().getValue("boid");
        DynamicObject personalCurDy = HisCommonEntityRepository.getAllFieldsDy((HRBaseServiceHelper)hrBaseServiceHelper, (long)boid);
        DynamicObject originalData = BusinessDataServiceHelper.loadSingleFromCache((Object)personalCurDy.getLong(masteridPropName), (String)billFormId);
        if (originalData != null && originalData.getDynamicObject("createOrg") != null) {
            DynamicObject org = originalData.getDynamicObject("createOrg");
            return org.getLong("id");
        }
        return 0L;
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String operationKey = evt.getOperationKey().toLowerCase();
        String useOrgID = (String)this.getView().getFormShowParameter().getCustomParam(USEORGID);
        DynamicObject createorg = (DynamicObject)this.getModel().getValue(CREATEORG);
        if (null == createorg) {
            return;
        }
        if (null == useOrgID && null != this.getView().getModel().getValue("useOrg")) {
            useOrgID = ((DynamicObject)this.getView().getModel().getValue("useOrg")).getPkValue().toString();
        }
        String createorgId = String.valueOf(createorg.getPkValue());
        if (HRStringUtils.equals((String)operationKey, (String)"showhisversion") || HRStringUtils.equals((String)operationKey, (String)"hisinfo")) {
            this.setParams(useOrgID, createorgId);
            return;
        }
        if (HRStringUtils.equals((String)"revise", (String)operationKey) && !createorgId.equals(useOrgID)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u4fee\u8ba2\u975e\u672c\u7ec4\u7ec7\u521b\u5efa\u7684\u6570\u636e\u3002", (String)"HisBaseDataFormPlugin_4", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
        if (this.isHisLine()) {
            switch (operationKey) {
                case "his_disable": {
                    if (createorgId.equals(useOrgID)) break;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4e0d\u662f\u57fa\u7840\u6570\u636e\u7684\u521b\u5efa\u7ec4\u7ec7\uff0c\u7981\u7528\u5931\u8d25\u3002", (String)"HisBaseDataFormPlugin_0", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    break;
                }
                case "insertdata_his": {
                    if (createorgId.equals(useOrgID)) break;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u53d8\u66f4\u975e\u672c\u7ec4\u7ec7\u521b\u5efa\u7684\u6570\u636e\u3002", (String)"HisBaseDataFormPlugin_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    break;
                }
            }
        } else if (HRStringUtils.equals((String)"change", (String)operationKey) && !createorgId.equals(useOrgID)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u53d8\u66f4\u975e\u672c\u7ec4\u7ec7\u521b\u5efa\u7684\u6570\u636e\u3002", (String)"HisBaseDataFormPlugin_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    private boolean isHisLine() {
        String entityType = HisCommonService.getInstance().entityInhRelation(this.getModel().getDataEntityType().getName());
        return EnumEntityTpl.LINETIMESEQ_TPL.getNumber().equals(entityType);
    }

    private void setParams(String useOrgID, String createorgId) {
        HRPageCache pageCache = new HRPageCache(this.getPageCache());
        Map customParamMap = (Map)pageCache.get("customParamMap", Map.class);
        if (customParamMap == null) {
            customParamMap = Maps.newHashMapWithExpectedSize((int)16);
        }
        Object isPersonalizeData = this.getView().getFormShowParameter().getCustomParam(ISPERSONALIZEDATA);
        customParamMap.put(USEORGID, useOrgID);
        customParamMap.put(CREATEORG, createorgId);
        customParamMap.put(ISPERSONALIZEDATA, isPersonalizeData);
        pageCache.put("customParamMap", (Object)customParamMap);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String createorgId;
        FormOperate operate = (FormOperate)args.getSource();
        Object isPersonalizeData = this.getView().getFormShowParameter().getCustomParam(ISPERSONALIZEDATA);
        if (this.isHisLine()) {
            if (HRStringUtils.equals((String)operate.getOperateKey(), (String)"save")) {
                this.setOpParam(operate, isPersonalizeData);
                return;
            }
            if (!this.hisLineOpKeys.contains(operate.getOperateKey())) {
                return;
            }
            DynamicObject createorg = (DynamicObject)this.getModel().getValue(CREATEORG);
            if (createorg != null) {
                String createorgId2 = String.valueOf(createorg.getPkValue());
                operate.getOption().setVariableValue(CREATEORG, createorgId2);
            }
        } else if (!this.hisNoneLineOpKeys.contains(operate.getOperateKey())) {
            return;
        }
        this.restoreBitIndexOnCopyOperation();
        String useOrgID = (String)this.getView().getFormShowParameter().getCustomParam(USEORGID);
        DynamicObject createorg = (DynamicObject)this.getModel().getValue(CREATEORG);
        if (null == useOrgID && null != this.getModel().getValue("useOrg")) {
            useOrgID = ((DynamicObject)this.getModel().getValue("useOrg")).getPkValue().toString();
        }
        if (null != createorg && HRStringUtils.isNotEmpty((String)useOrgID) && !(createorgId = String.valueOf(createorg.getPkValue())).equals(useOrgID)) {
            if (HRStringUtils.equals((String)operate.getOperateKey(), (String)"changesave")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u4fee\u8ba2\u975e\u672c\u7ec4\u7ec7\u521b\u5efa\u7684\u6570\u636e\u3002", (String)"HisBaseDataFormPlugin_2", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
                args.cancel = true;
                args.setCancelMessage(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u4fee\u8ba2\u975e\u672c\u7ec4\u7ec7\u521b\u5efa\u7684\u6570\u636e\u3002", (String)"HisBaseDataFormPlugin_2", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u53d8\u66f4\u975e\u672c\u7ec4\u7ec7\u521b\u5efa\u7684\u6570\u636e\u3002", (String)"HisBaseDataFormPlugin_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
            args.cancel = true;
            args.setCancelMessage(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u53d8\u66f4\u975e\u672c\u7ec4\u7ec7\u521b\u5efa\u7684\u6570\u636e\u3002", (String)"HisBaseDataFormPlugin_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
            return;
        }
        operate.getOption().setVariableValue("useOrgID", useOrgID);
        this.setOpParam(operate, isPersonalizeData);
        super.beforeDoOperation(args);
    }

    private void setOpParam(FormOperate operate, Object isPersonalizeData) {
        Boolean isCurrentVersion = (Boolean)this.getModel().getValue("iscurrentversion");
        String fromPage = (String)this.getView().getFormShowParameter().getCustomParam("fromPage");
        if (isCurrentVersion == Boolean.TRUE && null != isPersonalizeData && ((Boolean)isPersonalizeData).booleanValue() && !"revise".equals(fromPage)) {
            operate.getOption().setVariableValue(ISPERSONALIZEDATA, "1");
        } else {
            operate.getOption().setVariableValue(ISPERSONALIZEDATA, "0");
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void restoreBitIndexOnCopyOperation() {
        Object param = this.getView().getFormShowParameter().getCustomParam("iscopy");
        boolean isCopy = false;
        if (param instanceof Boolean) {
            isCopy = (Boolean)param;
        }
        IPageCache pageCache = this.getPageCache();
        String wasSave = pageCache.get("bd_was_save");
        if (isCopy && !Boolean.parseBoolean(wasSave)) {
            pageCache.put("bd_was_save", Boolean.TRUE.toString());
            this.getModel().setValue("bitindex", null);
            this.getModel().setValue("sourcedata", null);
            this.getModel().setValue("srcindex", null);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        Object isPersonalizeData;
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("save".equals(operateKey) && args.getOperationResult().isSuccess() && Objects.nonNull(isPersonalizeData = this.getView().getFormShowParameter().getCustomParam(ISPERSONALIZEDATA)) && ((Boolean)isPersonalizeData).booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save"});
        }
    }
}

