/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.newhismodel.impt;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.form.operate.webapi.AbstractOperateWebApi;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportEntityMapping;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisCommonService;
import kd.hr.hbp.business.domain.util.HisModelEditAuditTool;
import kd.hr.hbp.business.domain.util.HisModelImportUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.constants.newhismodel.EnumEntityTpl;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class HisBatchImportPlugin
extends BatchImportPlugin {
    protected static final Log log = LogFactory.getLog(HisBatchImportPlugin.class);
    private static final String enableOldKey = "enable".concat("_old");
    private static final String statusOldKey = "status".concat("_old");

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        String keyFields = (String)this.ctx.getOption().get("KeyFields");
        String importType = (String)this.ctx.getOption().get("importtype");
        if (HRStringUtils.isNotEmpty((String)keyFields) && !HRStringUtils.equals((String)importType, (String)"new") && Arrays.stream(keyFields.split(",")).noneMatch(keyField -> HRStringUtils.equals((String)"id", (String)keyField))) {
            this.ctx.addOption("KeyFields", (Object)(keyFields + ",id,"));
        }
        long startTime = System.currentTimeMillis();
        super.beforeSave(billdatas, logger);
        log.info("hisImport_bosValidate, time: {}, dataCount: {}", (Object)(System.currentTimeMillis() - startTime), (Object)billdatas.size());
        startTime = System.currentTimeMillis();
        this.validHisBillFormData(billdatas, logger);
        log.info("hisImport_validHisBillFormData, time: {}, dataCount: {}", (Object)(System.currentTimeMillis() - startTime), (Object)billdatas.size());
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        String opNum;
        String importType = (String)this.ctx.getOption().get("importtype");
        Boolean needAudit = (Boolean)this.ctx.getOption().get("needAudit");
        if (needAudit == null) {
            needAudit = this.getEntityNeedAudit();
            this.ctx.addOption("needAudit", (Object)needAudit);
        }
        HashMap idIndexMap = Maps.newHashMapWithExpectedSize((int)rowdatas.size());
        int i = 0;
        for (ImportBillData importBillData : rowdatas) {
            idIndexMap.put(importBillData.getData().get((Object)"id"), i++);
        }
        HashMap importDataMap = Maps.newHashMapWithExpectedSize((int)16);
        if (importType.equals("overridenew")) {
            this.signPersonalFlagForData(rowdatas);
            for (ImportBillData temp : rowdatas) {
                Boolean isNewData = (Boolean)temp.getData().remove((Object)"newDataForHis");
                opNum = isNewData != null && isNewData != false ? "save" : this.getDataOpNumForOverride(temp);
                List bills = importDataMap.getOrDefault(opNum, Lists.newArrayListWithCapacity((int)10));
                bills.add(temp.getData());
                importDataMap.putIfAbsent(opNum, bills);
            }
        } else if (importType.equals("override")) {
            this.signPersonalFlagForData(rowdatas);
            for (ImportBillData temp : rowdatas) {
                opNum = this.getDataOpNumForOverride(temp);
                List bills = importDataMap.getOrDefault(opNum, Lists.newArrayListWithCapacity((int)10));
                bills.add(temp.getData());
                importDataMap.putIfAbsent(opNum, bills);
            }
        } else {
            ArrayList arrayList = Lists.newArrayListWithCapacity((int)10);
            for (ImportBillData temp : rowdatas) {
                arrayList.add(temp.getData());
            }
            importDataMap.put("save", arrayList);
        }
        HashSet hashSet = Sets.newHashSetWithExpectedSize((int)16);
        hashSet.addAll(this.getColIds(rowdatas));
        hashSet.add("id");
        ApiResult firstBatchResult = null;
        ApiResult secondBatchResult = null;
        List saveBatch = (List)importDataMap.get("save");
        if (saveBatch != null && !saveBatch.isEmpty()) {
            boolean isLastBatch = importDataMap.size() == 1;
            firstBatchResult = this.invokeBatch("save", saveBatch, hashSet, idIndexMap, isLastBatch);
        }
        importDataMap.remove("save");
        for (Map.Entry importDataEntry : importDataMap.entrySet()) {
            List confirmChangeBatch = (List)importDataEntry.getValue();
            if (confirmChangeBatch == null || confirmChangeBatch.isEmpty()) continue;
            secondBatchResult = this.invokeBatch((String)importDataEntry.getKey(), confirmChangeBatch, hashSet, idIndexMap, true);
        }
        return this.addTogetherApiResult(firstBatchResult, secondBatchResult);
    }

    private ApiResult invokeBatch(String operateKey, List<Map<String, Object>> batchData, Set<String> colIds, Map<Object, Integer> idIndexMap, boolean isLastBatch) {
        long startTime = System.currentTimeMillis();
        this.ctx.addOption("callOperationNumber", (Object)operateKey);
        ApiResult batchResult = this.executeOp(batchData, colIds);
        this.resetErrorMsgIndex(batchResult, idIndexMap);
        log.info("hisImport_executeOp, time: {}, dataCount: {}", (Object)(System.currentTimeMillis() - startTime), (Object)batchData.size());
        this.clearHisImportCache(isLastBatch);
        return batchResult;
    }

    private void resetErrorMsgIndex(ApiResult result, Map<Object, Integer> idIndexMap) {
        if (result == null) {
            return;
        }
        List dataList = (List)result.getData();
        if (dataList == null) {
            return;
        }
        for (Map map : dataList) {
            Integer index;
            List errorInfos;
            if (map == null || (errorInfos = (List)map.get("data")) == null || errorInfos.isEmpty() || (index = (Integer)map.get("dindex")) == null) continue;
            for (OperateErrorInfo errorInfo : errorInfos) {
                Integer index2 = idIndexMap.get(errorInfo.getPkValue());
                if (index2 == null) continue;
                index = index2;
                errorInfo.setRowIndex(index.intValue());
                errorInfo.setDataEntityIndex(index.intValue());
            }
            map.put("dindex", index);
        }
    }

    private String getDataOpNumForOverride(ImportBillData rowData) {
        String entityType = HisCommonService.getInstance().entityInhRelation(this.ctx.getBillFormId());
        Boolean needAudit = (Boolean)this.ctx.getOption().get("needAudit");
        String isPersonal = (String)rowData.getData().remove((Object)"isPersonal");
        if (HRStringUtils.equals((String)isPersonal, (String)"1")) {
            rowData.getData().remove((Object)enableOldKey);
            return "save";
        }
        String enable = rowData.getData().getString(enableOldKey);
        if (HRStringUtils.equals((String)enable, (String)"10")) {
            return "save";
        }
        if (EnumEntityTpl.NONLINETIMESEQ_TPL.getNumber().equals(entityType)) {
            return needAudit != false ? "save" : "confirmchange";
        }
        return needAudit != false ? "save" : "confirmchangenoaudit";
    }

    private void signPersonalFlagForData(List<ImportBillData> rowdatas) {
        String isBdBaseDataKey;
        IHRAppCache cache = HRAppCache.get((String)"hbp");
        String isBdBaseData = (String)cache.get(isBdBaseDataKey = String.format("HisImportIsBdBaseData_%s_%s", this.getBillFormId(), HisModelImportUtil.getImportCacheKeySuffix()), String.class);
        if (HRStringUtils.isEmpty((String)isBdBaseData)) {
            Boolean isBaseDataCtrl = BaseDataServiceHelper.checkBaseDataCtrl((String)this.getBillFormId());
            isBdBaseData = isBaseDataCtrl != false ? "1" : "0";
            cache.put(isBdBaseDataKey, (Object)isBdBaseData);
        }
        if (HRStringUtils.equals((String)isBdBaseData, (String)"0")) {
            return;
        }
        HashSet pkIdSet = new HashSet(16);
        String entityNumber = rowdatas.get(0).getEntityMapping().getEntityType().getName();
        rowdatas.forEach(rowdata -> {
            JSONObject data = rowdata.getData();
            Long pkId = data.getLong("id");
            pkIdSet.add(pkId);
        });
        String selectFields = "id,number,createorg";
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(entityNumber);
        QFilter filter = new QFilter("id", "in", pkIdSet);
        DynamicObject[] dynamicObjects = hrBaseServiceHelper.query(selectFields, new QFilter[]{filter});
        Map idToDyMaps = Arrays.stream(dynamicObjects).filter(dy -> !HRObjectUtils.isEmpty((Object)dy)).collect(Collectors.toMap(dy -> dy.getLong("id"), Function.identity()));
        rowdatas.forEach(rowdata -> {
            JSONObject data = rowdata.getData();
            Long pkId = data.getLong("id");
            DynamicObject dynamicObject = (DynamicObject)idToDyMaps.get(pkId);
            if (!HRObjectUtils.isEmpty((Object)dynamicObject)) {
                String createorg;
                Map createorgMaps = (Map)data.get((Object)"createorg");
                String importprop = (String)createorgMaps.get("importprop");
                String originalCreateorg = dynamicObject.getDynamicObject("createorg").getString(importprop);
                if (!HRStringUtils.equals((String)originalCreateorg, (String)(createorg = (String)createorgMaps.get(importprop)))) {
                    rowdata.getData().put("isPersonal", (Object)"1");
                }
            }
        });
    }

    private ApiResult addTogetherApiResult(ApiResult one, ApiResult two) {
        if (one == null) {
            return two;
        }
        if (two == null) {
            return one;
        }
        ApiResult finalResult = new ApiResult();
        finalResult.setSuccess(one.getSuccess() && two.getSuccess());
        if (HRStringUtils.equals((String)"fail", (String)one.getErrorCode()) || HRStringUtils.equals((String)"fail", (String)two.getErrorCode())) {
            finalResult.setErrorCode("fail");
        }
        List oneDataMaps = (List)one.getData();
        List twoDataMaps = (List)two.getData();
        ArrayList allData = Lists.newArrayListWithCapacity((int)(oneDataMaps.size() + twoDataMaps.size()));
        allData.addAll(oneDataMaps);
        allData.addAll(twoDataMaps);
        finalResult.setData((Object)allData);
        return finalResult;
    }

    private ApiResult executeOp(List<Map<String, Object>> bills, Set<String> colIds) {
        if (bills.isEmpty()) {
            return null;
        }
        String billFormId = this.getBillFormId();
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)billFormId);
        IDataEntityProperty statusProp = mainType.findProperty(((BasedataEntityType)mainType).getBillStatus());
        for (Map<String, Object> bill : bills) {
            boolean nonEnabling;
            String enableOld = MapUtils.getString(bill, (Object)enableOldKey);
            String statusOld = MapUtils.getString(bill, (Object)statusOldKey);
            boolean isAudited = StringUtils.equals((CharSequence)statusOld, (CharSequence)"C");
            boolean bl = nonEnabling = !StringUtils.equals((CharSequence)enableOld, (CharSequence)"10");
            if (statusProp == null) continue;
            if (isAudited && nonEnabling) {
                ((BillStatusProp)statusProp).setDefValue((Object)"C");
                continue;
            }
            ((BillStatusProp)statusProp).setDefValue((Object)"A");
        }
        JSONObject dataPack = new JSONObject();
        dataPack.put("datas", bills);
        dataPack.put("appid", (Object)this.ctx.getCheckRightAppId());
        this.ctx.addOption("appid", (Object)this.ctx.getCheckRightAppId());
        dataPack.put("option", (Object)this.ctx.getOption());
        dataPack.put("formShowParameterAppId", (Object)this.ctx.getFormShowParameterAppId());
        dataPack.put("colIds", colIds);
        dataPack.put("forcedsubmit", (Object)this.getImportSaveOpNum());
        AbstractOperateWebApi webApi = this.getSaveWebApi();
        webApi.initialize(this.getBillFormId(), (Map)dataPack);
        IHRAppCache cache = HRAppCache.get((String)"hbp");
        Object importLogId = this.ctx.getLogId();
        String importLogIdCacheKey = String.format("HisImportLogId_%s_%s", this.getBillFormId(), RequestContext.get().getCurrUserId());
        cache.put(importLogIdCacheKey, importLogId);
        return webApi.execute();
    }

    protected String getImportSaveOpNum() {
        String opNum = (String)this.ctx.getOption().get("callOperationNumber");
        if (HRStringUtils.isEmpty((String)opNum)) {
            opNum = "save";
        }
        return opNum;
    }

    private Boolean getEntityNeedAudit() {
        IHRAppCache cache = HRAppCache.get((String)"hbp");
        String cacheKey = String.format("HisImportNeedAudit_%s_%s", this.getBillFormId(), HisModelImportUtil.getImportCacheKeySuffix());
        Boolean needAudit = (Boolean)cache.get(cacheKey, Boolean.class);
        if (needAudit == null) {
            needAudit = HisModelEditAuditTool.getNeedAuditForOp((IDataEntityType)EntityMetadataCache.getDataEntityType((String)this.ctx.getBillFormId()));
            cache.put(cacheKey, (Object)needAudit);
        }
        return needAudit;
    }

    private void clearHisImportCache(boolean isLastBatch) {
        IHRAppCache cache = HRAppCache.get((String)"hbp");
        String url = this.ctx.getAllUrls().toArray(new String[0])[0];
        if (this.ctx.isResolveComplete(url) && this.ctx.getDataQueue(url).isEmpty() && isLastBatch) {
            String entityId = this.getBillFormId();
            String importCacheKeySuffix = HisModelImportUtil.getImportCacheKeySuffix();
            String cacheKey = String.format("HRHisModelImport_%s_%s_UpdateType", entityId, RequestContext.get().getCurrUserId());
            cache.remove(cacheKey);
            String importLogIdCacheKey = String.format("HisImportLogId_%s_%s", entityId, importCacheKeySuffix);
            cache.remove(importLogIdCacheKey);
            String lastHisImportLogKey = String.format("HismodelImportLogId_%s_%s", entityId, importCacheKeySuffix);
            cache.remove(lastHisImportLogKey);
            String eventIdKey = String.format("HismodelEventId_%s_%s", entityId, importCacheKeySuffix);
            cache.remove(eventIdKey);
            String needAuditKey = String.format("HisImportNeedAudit_%s_%s", entityId, importCacheKeySuffix);
            cache.remove(needAuditKey);
            String isBdBaseData = String.format("HisImportIsBdBaseData_%s_%s", entityId, importCacheKeySuffix);
            cache.remove(isBdBaseData);
        }
    }

    private Set<String> getColIds(List<ImportBillData> rowdatas) {
        return rowdatas != null && rowdatas.size() > 0 ? rowdatas.get(0).getEntityMapping().getCols().keySet() : new HashSet<String>(0);
    }

    private void validHisBillFormData(List<ImportBillData> billdatas, ImportLogger logger) {
        if (billdatas.isEmpty()) {
            return;
        }
        String importType = (String)this.ctx.getOption().get("importtype");
        if (!HRStringUtils.equals((String)importType, (String)"new")) {
            this.validImportDataExist(billdatas, importType, logger);
        }
    }

    private void validImportDataExist(List<ImportBillData> billdatas, String importType, ImportLogger logger) {
        String keyFieldString = (String)this.ctx.getOption().get("KeyFields");
        List<String> keyFields = Arrays.stream(keyFieldString.split(",")).filter(keyField -> HRStringUtils.isNotEmpty((String)keyField) && !"id".equals(keyField)).distinct().collect(Collectors.toList());
        ArrayList conditionForSearch = Lists.newArrayListWithCapacity((int)16);
        HashMap conditionMap = Maps.newHashMapWithExpectedSize((int)16);
        String selectProp = this.buildConditionMap(billdatas, keyFields, conditionMap, conditionForSearch);
        this.handleNullForConditionMap(conditionMap);
        QFilter qFilter = this.buildQueryQFilter(conditionMap);
        Map<String, List<Map<String, Object>>> searchResultMap = this.queryObjFromDB(selectProp, qFilter, keyFields);
        Iterator<ImportBillData> it = billdatas.iterator();
        int index = 0;
        ArrayList<ImportBillData> notFoundIdDatas = new ArrayList<ImportBillData>(10);
        while (it.hasNext()) {
            ImportBillData billdata = it.next();
            Map conditionForSearchMap = (Map)conditionForSearch.get(index);
            String conditionForSearchStr = JSON.toJSONString((Object)conditionForSearchMap);
            if (HRStringUtils.equals((String)importType, (String)"override") && !searchResultMap.containsKey(conditionForSearchStr)) {
                logger.log(Integer.valueOf(billdata.getStartIndex()), this.buildErrorMsgForNotFound(billdata, conditionForSearchMap));
                logger.fail();
                it.remove();
            } else {
                List<Map<String, Object>> fieldValList = searchResultMap.get(conditionForSearchStr);
                if (fieldValList != null) {
                    if (fieldValList.size() == 1) {
                        billdata.getData().put("id", fieldValList.get(0).get("id"));
                        billdata.getData().put(enableOldKey, fieldValList.get(0).get("enable"));
                        billdata.getData().put(statusOldKey, fieldValList.get(0).get("status"));
                    } else {
                        List<Object> ids = fieldValList.stream().map(map -> map.get("id")).collect(Collectors.toList());
                        logger.log(Integer.valueOf(billdata.getStartIndex()), this.buildErrorMsgForFindALot(ids));
                        logger.fail();
                        it.remove();
                    }
                } else {
                    notFoundIdDatas.add(billdata);
                }
            }
            ++index;
        }
        if (HRStringUtils.equals((String)importType, (String)"overridenew") && notFoundIdDatas.size() > 0) {
            long[] ids = ID.genLongIds((int)notFoundIdDatas.size());
            for (int i = 0; i < notFoundIdDatas.size(); ++i) {
                ImportBillData billData = (ImportBillData)notFoundIdDatas.get(i);
                billData.getData().put("id", (Object)ids[i]);
                billData.getData().put("newDataForHis", (Object)Boolean.TRUE);
            }
        }
    }

    private void handleNullForConditionMap(Map<String, List<Object>> conditionMap) {
        HashSet removeKeys = Sets.newHashSetWithExpectedSize((int)16);
        for (String key : conditionMap.keySet()) {
            if (key.contains(".") || !conditionMap.keySet().stream().anyMatch(num -> num.contains(".") && HRStringUtils.equals((String)key, (String)num.substring(0, num.indexOf(46))))) continue;
            removeKeys.add(key);
        }
        removeKeys.forEach(conditionMap::remove);
    }

    private Object getPropertyVal(Map<String, Object> data, String field) {
        BillEntityType entityType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)this.getBillFormId());
        DynamicProperty property = entityType.getProperty(field);
        Object propertyVal = data.get(field);
        Optional<Object> defaultPropertyVal = this.tryGetDefaultPropertyValIfNotFindPropertyVal(propertyVal, property);
        if (defaultPropertyVal.isPresent()) {
            return defaultPropertyVal.get();
        }
        if (propertyVal == null) {
            return propertyVal;
        }
        Optional<Object> formatPropertyVal = this.tryGetFormatPropertyVal(propertyVal, property, field);
        return formatPropertyVal.isPresent() ? formatPropertyVal.get() : propertyVal;
    }

    private Optional<Object> tryGetFormatPropertyVal(Object propertyVal, DynamicProperty property, String field) {
        if (property instanceof MuliLangTextProp) {
            if (propertyVal instanceof Map) {
                return Optional.ofNullable(LocaleString.fromMap((Map)((Map)propertyVal)).toString());
            }
            return Optional.ofNullable(propertyVal.toString());
        }
        return this.getDateOrTimePropValue(propertyVal, property, field);
    }

    private Optional<Object> getDateOrTimePropValue(Object propertyVal, DynamicProperty property, String field) {
        if (property instanceof DateTimeProp && !(propertyVal instanceof Date)) {
            try {
                return Optional.of(((DateTimeProp)property).getDateFormat().parse(propertyVal.toString()));
            }
            catch (ParseException var5) {
                throw new RuntimeException("ParseException", var5);
            }
        }
        if (property instanceof TimeProp) {
            return Optional.of(TimeProp.timeToSecond((Object)propertyVal.toString(), (String)field));
        }
        return property instanceof DecimalProp && propertyVal instanceof String ? Optional.of(new BigDecimal(new BigDecimal((String)propertyVal).stripTrailingZeros().toPlainString())) : Optional.empty();
    }

    private Optional<Object> tryGetDefaultPropertyValIfNotFindPropertyVal(Object propertyVal, DynamicProperty property) {
        if (property == null) {
            return Optional.empty();
        }
        if (propertyVal == null && property instanceof BasedataProp) {
            BasedataProp basedataProp = (BasedataProp)property;
            PKFieldProp basedatePk = (PKFieldProp)basedataProp.getDynamicComplexPropertyType().getPrimaryKey();
            return Optional.ofNullable(basedatePk.getDefaultValue());
        }
        if (propertyVal != null && property instanceof BasedataProp) {
            Map basedataMap = (Map)propertyVal;
            String dataType = this.getBasedataPropertyForQFilter(basedataMap);
            return Optional.ofNullable(basedataMap.get(dataType));
        }
        return propertyVal == null ? Optional.ofNullable(property.getDefaultValue()) : Optional.empty();
    }

    private String buildConditionMap(List<ImportBillData> billdatas, List<String> keyFields, Map<String, List<Object>> conditionMap, List<Map<String, Object>> conditionForSearch) {
        ArrayList newKeyFields = Lists.newArrayListWithCapacity((int)16);
        StringBuilder selectProps = new StringBuilder();
        for (ImportBillData billdata : billdatas) {
            JSONObject data = billdata.getData();
            TreeMap conditionForSearchMap = Maps.newTreeMap();
            for (String keyField : keyFields) {
                Object val = this.getPropertyVal((Map<String, Object>)data, keyField);
                keyField = this.tryRebuildFieldForQFilter((Map<String, Object>)data, keyField);
                List valSet = conditionMap.getOrDefault(keyField, new ArrayList(billdatas.size()));
                valSet.add(val);
                conditionMap.put(keyField, valSet);
                conditionForSearchMap.put(keyField, val);
                if (newKeyFields.contains(keyField)) continue;
                newKeyFields.add(keyField);
            }
            conditionForSearch.add(conditionForSearchMap);
        }
        keyFields.clear();
        keyFields.addAll(newKeyFields);
        HashSet removeKeys = Sets.newHashSetWithExpectedSize((int)16);
        for (String key : newKeyFields) {
            if (key.contains(".") || !newKeyFields.stream().anyMatch(num -> num.contains(".") && HRStringUtils.equals((String)key, (String)num.substring(0, num.indexOf(46))))) continue;
            removeKeys.add(key);
        }
        newKeyFields.removeAll(removeKeys);
        keyFields.removeAll(removeKeys);
        Collections.sort(keyFields);
        Collections.sort(newKeyFields);
        for (String keyField : newKeyFields) {
            selectProps.append(keyField).append(',');
        }
        return selectProps.substring(0, selectProps.length() - 1);
    }

    private QFilter buildQueryQFilter(Map<String, List<Object>> conditionMap) {
        QFilter filter = null;
        for (Map.Entry<String, List<Object>> conditionEntry : conditionMap.entrySet()) {
            String fieldKey = conditionEntry.getKey();
            List<Object> fieldValues = conditionEntry.getValue();
            if (filter == null) {
                filter = new QFilter(fieldKey, "in", fieldValues);
                continue;
            }
            filter.and(fieldKey, "in", fieldValues);
        }
        return filter;
    }

    private String buildErrorMsgForFindALot(List<Object> ids) {
        StringBuilder sb = new StringBuilder();
        ids.forEach(id -> sb.append(id).append(", "));
        return String.format(ResManager.loadKDString((String)"\u5b58\u5728\u591a\u6761\u6ee1\u8db3\u8986\u76d6\u6761\u4ef6\u7684\u6570\u636e\uff1a%s", (String)"HisBatchImportPlugin_04", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), sb.substring(0, sb.length() - 2));
    }

    private String buildErrorMsgForNotFound(ImportBillData billData, Map<String, Object> conditionForSearchMap) {
        StringBuilder conditionMsg = new StringBuilder();
        for (Map.Entry<String, Object> entry : conditionForSearchMap.entrySet()) {
            String field;
            String tipField = field = entry.getKey();
            if (field.contains(".")) {
                String[] fieldArr = field.split("\\.");
                tipField = fieldArr[0];
            }
            Object tipValue = this.tryRebuildValueForQFilter((Map<String, Object>)billData.getData(), field);
            ImportEntityMapping.ColInfo colInfo = (ImportEntityMapping.ColInfo)billData.getEntityMapping().getCols().get(tipField);
            if (colInfo == null) {
                return ResManager.loadKDString((String)"\u6839\u636e\u6570\u636e\u66ff\u6362\u89c4\u5219\u7684\u552f\u4e00\u503c\uff0c\u5339\u914d\u4e0d\u5230\u6570\u636e\uff0c\u53ef\u80fd\u662f\u6a21\u677f\u4e2d\u6ca1\u6709\u8be5\u5b57\u6bb5\uff0c\u8bf7\u68c0\u67e5\u5bfc\u5165\u6587\u4ef6\u6216\u6570\u636e\u66ff\u6362\u89c4\u5219\u7684\u552f\u4e00\u503c\u3002", (String)"HisBatchImportPlugin_03", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]);
            }
            String colDisplayName = ((ImportEntityMapping.ColInfo)billData.getEntityMapping().getCols().get(tipField)).getDisplayName();
            conditionMsg.append(colDisplayName).append('=').append(tipValue).append(',');
        }
        return String.format(ResManager.loadKDString((String)"\u6570\u636e\u66f4\u65b0\u5931\u8d25\uff0c\u7cfb\u7edf\u627e\u4e0d\u5230\u201c%s\u201d\u7684\u6570\u636e\u884c\u3002", (String)"HisBatchImportPlugin_02", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), conditionMsg.substring(0, conditionMsg.length() - 1));
    }

    public void customFilter(String selectProp, DynamicObjectCollection dataCol) {
    }

    private Map<String, List<Map<String, Object>>> queryObjFromDB(String selectProp, QFilter filter, List<String> keyFields) {
        QFilter isCurrentQFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('1'));
        HRBaseServiceHelper helper = new HRBaseServiceHelper(this.ctx.getBillFormId());
        DataEntityPropertyCollection properties = EntityMetadataCache.getDataEntityType((String)this.getBillFormId()).getProperties();
        boolean hasStatus = HisModelImportUtil.hasStatus((DataEntityPropertyCollection)properties);
        boolean hasEnable = HisModelImportUtil.hasEnable((DataEntityPropertyCollection)properties);
        String extSelectField = "id,";
        if (hasEnable && !selectProp.contains("enable")) {
            extSelectField = extSelectField + "enable,";
        }
        if (hasStatus && !selectProp.contains("status")) {
            extSelectField = extSelectField + "status,";
        }
        DynamicObjectCollection dataCol = helper.queryOriginalCollection(extSelectField + selectProp, new QFilter[]{filter, isCurrentQFilter});
        this.customFilter(selectProp, dataCol);
        HashMap searchResultMap = Maps.newHashMapWithExpectedSize((int)16);
        dataCol.forEach(data -> {
            LinkedHashMap conditionForSearchMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
            for (String keyField : keyFields) {
                conditionForSearchMap.put(keyField, data.get(keyField));
            }
            String searchKey = JSON.toJSONString((Object)conditionForSearchMap);
            List fieldValList = searchResultMap.computeIfAbsent(searchKey, key -> new ArrayList(10));
            HashMap fieldValMap = Maps.newHashMapWithExpectedSize((int)16);
            fieldValMap.put("id", data.get("id"));
            if (hasEnable) {
                fieldValMap.put("enable", data.get("enable"));
            }
            if (hasStatus) {
                fieldValMap.put("status", data.get("status"));
            }
            fieldValList.add(fieldValMap);
        });
        return searchResultMap;
    }

    private Object tryRebuildValueForQFilter(Map<String, Object> data, String field) {
        String[] fieldArr = field.split("\\.");
        if (fieldArr.length > 1) {
            String dataType = fieldArr[1];
            String fieldSuffix = fieldArr[0];
            Map propertyVal = (Map)data.get(fieldSuffix);
            return propertyVal.get(dataType);
        }
        return data.get(field);
    }

    private String tryRebuildFieldForQFilter(Map<String, Object> data, String field) {
        BillEntityType entityType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)this.ctx.getBillFormId());
        DynamicProperty property = entityType.getProperty(field);
        Object propertyVal = data.get(field);
        if (propertyVal != null && property instanceof BasedataProp) {
            String dataType = this.getBasedataPropertyForQFilter((Map)propertyVal);
            field = field + "." + dataType;
        }
        return field;
    }

    private String getBasedataPropertyForQFilter(Map<String, Object> basedataMap) {
        if (basedataMap.containsKey("id")) {
            return "id";
        }
        String importProp = (String)basedataMap.get("importprop");
        if (importProp == null) {
            return basedataMap.containsKey("number") ? "number" : "name";
        }
        return importProp;
    }
}

