/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.newhismodel.impt;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.BasedataItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisCommonService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumEntityTpl;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.model.hismodel.HisBaseDataItem;
import kd.hr.hbp.common.util.HRStringUtils;

public class HisImportFilterF7DataHandler {
    private static final Log logger = LogFactory.getLog(HisImportFilterF7DataHandler.class);

    public boolean validateHisF7Reference(String entityNum, Map<HisBaseDataItem, Object> baseDataMap, Map<HisBaseDataItem, Object> bdBaseDataMap, Map.Entry<BasedataItem, Object> baseDataEntry, Map<String, Boolean> inhRelationMap, Map<String, Boolean> isBdBaseDataMap, Map<String, Boolean> baseDataSelDataMap, Date effDate, StringBuilder error) {
        String fieldKey;
        BasedataItem baseDataItem = baseDataEntry.getKey();
        Object id = baseDataEntry.getValue();
        String baseDataEntityNum = baseDataItem.getEntityNumber();
        if (HRStringUtils.equals((String)baseDataEntityNum, (String)(fieldKey = baseDataItem.getFieldKey()))) {
            return true;
        }
        if (this.isNotInheritHisModel(baseDataEntityNum, inhRelationMap)) {
            return true;
        }
        boolean result = false;
        HisBaseDataItem hisBaseDataItem = new HisBaseDataItem(baseDataItem, effDate);
        boolean isBdBaseData = isBdBaseDataMap.get(baseDataItem.getFieldKey()) == null ? false : isBdBaseDataMap.get(baseDataItem.getFieldKey());
        Object cacheId = null;
        cacheId = isBdBaseData ? bdBaseDataMap.get(hisBaseDataItem) : baseDataMap.get(hisBaseDataItem);
        if (cacheId != null) {
            if (Objects.equals(cacheId, 0L)) {
                this.buildErrorMsg(error, entityNum, baseDataItem);
            } else {
                if (isBdBaseData) {
                    baseDataEntry.setValue(cacheId);
                }
                result = true;
            }
        } else {
            boolean exist = this.queryBaseDataExist(baseDataEntityNum, baseDataEntry, isBdBaseDataMap, baseDataSelDataMap, effDate);
            if (exist) {
                if (isBdBaseData) {
                    bdBaseDataMap.put(hisBaseDataItem, baseDataEntry.getValue());
                } else {
                    baseDataMap.put(hisBaseDataItem, id);
                }
                result = true;
            } else {
                this.buildErrorMsg(error, entityNum, baseDataItem);
                baseDataMap.put(hisBaseDataItem, 0L);
            }
        }
        return result;
    }

    public void filterHisF7ReferenceData(Map<HisBaseDataItem, Object> baseDataMap, Map<BasedataItem, List<Object>> searchResult, Map<String, Boolean> bdBaseDataMap, Map<String, Boolean> baseDataSelDataMap, Map<String, Boolean> inhRelationMap, Map<BasedataItem, List<Object>> baseDataIdMap, Date effDate) {
        searchResult.forEach((item, ids) -> {
            String entityId = item.getEntityNumber();
            if (this.isNotInheritHisModel(entityId, inhRelationMap)) {
                return;
            }
            HisBaseDataItem hisBaseDataItem = new HisBaseDataItem(item, effDate);
            Object cacheId = baseDataMap.get(hisBaseDataItem);
            if (cacheId != null) {
                ids.clear();
                if (Objects.equals(cacheId, 0L)) return;
                ids.add(cacheId);
                return;
            } else {
                List copyIds;
                QFilter idQFilter = new QFilter("id", "in", ids);
                if (ids.size() == 1 && (copyIds = (List)baseDataIdMap.get(item)) != null) {
                    idQFilter = new QFilter("id", "in", (Object)copyIds);
                }
                Long id = null;
                Boolean isSelDataF7 = (Boolean)baseDataSelDataMap.get(item.getFieldKey());
                Boolean isBdBaseData = (Boolean)bdBaseDataMap.get(item.getFieldKey());
                if (isSelDataF7 == null || isSelDataF7.booleanValue()) {
                    if (isBdBaseData != null && isBdBaseData.booleanValue()) {
                        id = this.filterBdDataForCurrent(entityId, effDate, idQFilter);
                    } else {
                        QFilter dataStatusFilter;
                        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityId);
                        QFilter versionFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('1'));
                        DynamicObjectCollection dys = helper.queryOriginalCollection("id", new QFilter[]{idQFilter, versionFilter, dataStatusFilter = new QFilter("datastatus", "in", Stream.of(EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()).collect(Collectors.toSet()))});
                        if (dys.size() > 0) {
                            if (dys.size() != 1) return;
                            id = ((DynamicObject)dys.get(0)).getLong("id");
                        }
                    }
                } else if (isBdBaseData != null && isBdBaseData.booleanValue()) {
                    idQFilter = new QFilter("boid", "in", ids);
                    id = this.filterBdDataForVersion(entityId, effDate, idQFilter);
                } else {
                    QFilter dataStatusFilter;
                    QFilter effDateFilter;
                    QFilter versionFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0'));
                    DynamicObject dy = BusinessDataServiceHelper.loadSingleFromCache((String)entityId, (String)"id", (QFilter[])new QFilter[]{idQFilter, versionFilter, effDateFilter = new QFilter("bsed", "<=", (Object)effDate).and(new QFilter("bsled", ">=", (Object)effDate)), dataStatusFilter = new QFilter("datastatus", "in", Stream.of(EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()).collect(Collectors.toSet()))});
                    if (dy != null) {
                        id = dy.getLong("id");
                    }
                }
                ids.clear();
                if (id != null) {
                    ids.add(id);
                    baseDataMap.put(hisBaseDataItem, id);
                    return;
                } else {
                    baseDataMap.put(hisBaseDataItem, 0L);
                }
            }
        });
    }

    private Long filterBdDataForCurrent(String entityId, Date effDate, QFilter idQFilter) {
        QFilter versionFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('1'));
        QFilter dateQFilter = new QFilter("id", "=", (Object)"masterid", true).or(new QFilter("firstbsed", "<=", (Object)effDate));
        DynamicObject currentDy = BusinessDataServiceHelper.loadSingleFromCache((String)entityId, (String)"id, masterid, firstbsed", (QFilter[])new QFilter[]{idQFilter, versionFilter, dateQFilter});
        if (currentDy == null) {
            return null;
        }
        return currentDy.getLong("id");
    }

    private Long filterBdDataForVersion(String entityId, Date effDate, QFilter idQFilter) {
        QFilter versionFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0'));
        QFilter effDateFilter = new QFilter("bsed", "<=", (Object)effDate).and(new QFilter("bsled", ">=", (Object)effDate));
        QFilter dataStatusFilter = new QFilter("datastatus", "in", Stream.of(EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()).collect(Collectors.toSet()));
        DynamicObject dy = BusinessDataServiceHelper.loadSingleFromCache((String)entityId, (String)"id", (QFilter[])new QFilter[]{idQFilter, versionFilter, effDateFilter, dataStatusFilter});
        if (dy == null) {
            return null;
        }
        return dy.getLong("id");
    }

    private boolean isNotInheritHisModel(String entityKey, Map<String, Boolean> inhRelationMap) {
        Boolean isHisEntity = inhRelationMap.get(entityKey);
        if (isHisEntity == null) {
            String entityType = HisCommonService.getInstance().entityInhRelation(entityKey);
            isHisEntity = EnumEntityTpl.LINETIMESEQ_TPL.getNumber().equals(entityType) || EnumEntityTpl.NONLINETIMESEQ_TPL.getNumber().equals(entityType);
            inhRelationMap.put(entityKey, isHisEntity);
        }
        return isHisEntity == false;
    }

    private boolean queryBaseDataExist(String entityNum, Map.Entry<BasedataItem, Object> baseDataEntry, Map<String, Boolean> isBdBaseDataMap, Map<String, Boolean> baseDataSelDataMap, Date effDate) {
        BasedataItem baseDataItem = baseDataEntry.getKey();
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityNum);
        QFilter qFilter = new QFilter("id", "=", baseDataEntry.getValue());
        Boolean isSelData = baseDataSelDataMap.get(baseDataItem.getFieldKey());
        Boolean isBdBaseData = isBdBaseDataMap.get(baseDataItem.getFieldKey());
        Long id = null;
        if (isSelData == null || isSelData.booleanValue()) {
            if (isBdBaseData != null && isBdBaseData.booleanValue()) {
                id = this.filterBdDataForCurrent(entityNum, effDate, qFilter);
                return id != null;
            }
            QFilter isCurrentQFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('1'));
            return helper.isExists(new QFilter[]{qFilter, isCurrentQFilter});
        }
        if (isBdBaseData != null && isBdBaseData.booleanValue()) {
            QFilter boIdQFilter = new QFilter("boid", "=", baseDataEntry.getValue());
            id = this.filterBdDataForVersion(entityNum, effDate, boIdQFilter);
            if (id != null) {
                baseDataEntry.setValue(id);
                return true;
            }
            return false;
        }
        QFilter isCurrentQFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0'));
        QFilter dataStatusFilter = new QFilter("datastatus", "in", Stream.of(EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()).collect(Collectors.toSet()));
        QFilter effDateFilter = new QFilter("bsed", "<=", (Object)effDate).and(new QFilter("bsled", ">=", (Object)effDate));
        return helper.isExists(new QFilter[]{qFilter, isCurrentQFilter, dataStatusFilter, effDateFilter});
    }

    private void buildErrorMsg(StringBuilder error, String entityNum, BasedataItem basedataItem) {
        String baseDataEntityNum = basedataItem.getEntityNumber();
        String fieldKey = basedataItem.getFieldKey();
        String searchKey = basedataItem.getSearchKey();
        String searchValue = basedataItem.getSearchValue();
        Long orgId = basedataItem.getOrgId();
        IDataEntityProperty fieldProp = null;
        String suffixMsg = "";
        for (EntityType entityType : EntityMetadataCache.getDataEntityType((String)entityNum).getAllEntities().values()) {
            fieldProp = (IDataEntityProperty)entityType.getFields().get(fieldKey);
            if (fieldProp == null) continue;
            if (entityType instanceof SubEntryType) {
                suffixMsg = ResManager.loadKDString((String)"\u5b50\u5206\u5f55", (String)"HisImportFilterF7DataHandler_03", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]);
                break;
            }
            if (!(entityType instanceof EntryType)) break;
            suffixMsg = ResManager.loadKDString((String)"\u5206\u5f55", (String)"HisImportFilterF7DataHandler_04", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]);
            break;
        }
        if (fieldProp == null) {
            error.append(String.format(ResManager.loadKDString((String)"\u5b9e\u4f53%1$s\u7684%2$s\u5b57\u6bb5\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"HisImportFilterF7DataHandler_02", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), entityNum, fieldKey));
            return;
        }
        String importPropName = fieldProp.getDisplayName().getLocaleValue();
        String searchName = EntityMetadataCache.getDataEntityType((String)baseDataEntityNum).getProperty(searchKey).getDisplayName().getLocaleValue();
        String errorMsg = ResManager.loadKDString((String)"%1$s\u201c%2$s\u201d\u4e0b\u201c%3$s=%4$s\u201d\u5bfc\u5165\u4e0d\u6210\u529f\u3002\u53ef\u80fd\u7684\u539f\u56e0\u662f\uff1a1\u3001%5$s\u4e0d\u6b63\u786e\uff1b2\u3001\u4e0d\u7b26\u5408\u57fa\u7840\u8d44\u6599\u5b57\u6bb5\u67e5\u8be2\u6761\u4ef6\uff1b3\u3001\u8be5\u57fa\u7840\u8d44\u6599\u5728\u4f7f\u7528\u7ec4\u7ec7\u201c\u5185\u7801=%6$s\u201d\u6216\u8005\u5176\u4e0b\u7ea7\u7ec4\u7ec7\u4e2d\u4e0d\u5b58\u5728\u6216\u6ca1\u6709\u4f7f\u7528\u6743\u9650", (String)"HisImportFilterF7DataHandler_01", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]);
        error.append(String.format(errorMsg, suffixMsg, importPropName, searchName, searchValue, searchName, orgId));
    }
}

