/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.newhismodel.mobile;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractMobListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.constants.newhismodel.HisFieldNameConstants;
import kd.hr.hbp.common.constants.newhismodel.HisLineTimeTplConstants;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.util.newhismodel.HisLineF7FilterHandler;

public class HisLineMobileListPlugin
extends AbstractMobListPlugin
implements HisLineTimeTplConstants,
HisFieldNameConstants {
    private static final Log logger = LogFactory.getLog(HisLineMobileListPlugin.class);

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        if (this.isLookup()) {
            String isPageStart = this.getPageCache().get("isPageStart");
            if (isPageStart == null) {
                this.getPageCache().put("isPageStart", "1");
            } else {
                this.getPageCache().put("isPageStart", "0");
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        if (!this.isLookup()) {
            QFilter qFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('1'));
            e.getQFilters().add(qFilter);
            return;
        }
        ListShowParameter listParameter = (ListShowParameter)this.getView().getFormShowParameter();
        this.initParams(listParameter, e);
    }

    private void initParams(ListShowParameter listParameter, SetFilterEvent event) {
        HisLineF7FilterHandler handler;
        List qFilters = event.getQFilters();
        BillList billList = (BillList)event.getSource();
        Map fields = billList.getEntityType().getFields();
        if (fields.containsKey("enable")) {
            Object isShowDisableData = listParameter.getCustomParam("isShowDisableData");
            if (this.isPageStart() && ((Boolean)Optional.ofNullable(isShowDisableData).orElse(false)).booleanValue()) {
                Optional<QFilter> enableQFilter = qFilters.stream().filter(qFilter -> qFilter != null && "enable".equals(qFilter.getProperty())).findAny();
                enableQFilter.ifPresent(qFilter -> qFilter.or(new QFilter("enable", "=", (Object)"0")));
            }
        }
        if ((handler = HisLineF7FilterHandler.getInstance()).isBusinessF7(this.getView())) {
            handler.addBusinessF7QFilters(listParameter, qFilters);
        }
    }

    private boolean isLookup() {
        boolean isLookup = false;
        if (this.getView().getFormShowParameter() instanceof ListShowParameter) {
            ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
            isLookup = listShowParameter.isLookUp();
        }
        return isLookup;
    }

    private boolean isPageStart() {
        String isPageStart = this.getPageCache().get("isPageStart");
        return HRStringUtils.equals((String)isPageStart, (String)"1");
    }
}

