/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.newhismodel.pluginservice;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.RefProp;
import kd.bos.ext.hr.entity.property.HisModelBasedataProp;
import kd.bos.ext.hr.metadata.field.HisModelBasedataField;
import kd.bos.filter.CommonBaseDataFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.filter.CommonBaseDataFilterColumnAp;
import kd.bos.metadata.filter.CommonFilterColumnAp;
import kd.bos.metadata.filter.SchemeBaseDataFilterColumnAp;
import kd.bos.metadata.form.BillFormAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.application.impl.common.HRLongValueParseService;
import kd.hr.hbp.business.domain.model.newhismodel.hisbdfilter.EnumHisF7SearchType;
import kd.hr.hbp.business.domain.model.newhismodel.hisbdfilter.HisEntityF7SearchTypeBo;
import kd.hr.hbp.business.domain.model.newhismodel.hisbdfilter.HisFieldF7SearchTypeBo;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisCommonService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.hisversion.HisVersionReviseService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.HRBaseConstants;
import kd.hr.hbp.common.constants.newhismodel.EnumEntityTpl;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.constants.newhismodel.EventOperateEnums;
import kd.hr.hbp.common.constants.newhismodel.HisFieldNameConstants;
import kd.hr.hbp.common.constants.newhismodel.HisLineTimeTplConstants;
import kd.hr.hbp.common.constants.newhismodel.HisSysConstants;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.newhismodel.pluginservice.HisFilterConfigParseFactory;
import kd.hr.hbp.formplugin.web.newhismodel.pluginservice.IHisFilterConfigParseService;
import kd.hr.hbp.formplugin.web.util.newhismodel.HisModelListCommonTool;

public class HisCommonFilterService
implements HRBaseConstants,
HisSysConstants,
HisLineTimeTplConstants,
HisFieldNameConstants {
    private static final Log LOGGER = LogFactory.getLog(HisCommonFilterService.class);
    private final String POINT = ".";
    private final String ID_CACHE_SUFFIX = "_selectedIds";
    public static final String FILTER_GRID_CACHE_SUFFIX = "_fromFilterGridView";
    public static final String FROM_FILTER_GRID_VIEW = "fromFilterGridView";
    public static final String SCHEME_CACHE_SUFFIX = "_fromSchemeFilterView";
    public static final String FROM_SCHEME_FILTER_VIEW = "fromSchemeFilterView";
    private final String IS_SCHEME_FILTER = "isSchemeFilter";
    public static final String SEARCH_TYPE_BO = "searchTypeBo";
    private static volatile HisCommonFilterService hisCommonFilterService = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HisCommonFilterService getInstance() {
        if (hisCommonFilterService != null) return hisCommonFilterService;
        Class<HisVersionReviseService> clazz = HisVersionReviseService.class;
        synchronized (HisVersionReviseService.class) {
            if (hisCommonFilterService != null) return hisCommonFilterService;
            hisCommonFilterService = new HisCommonFilterService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return hisCommonFilterService;
        }
    }

    public void initialize(IFormView view, IPageCache pageCache) {
        if (HRStringUtils.isEmpty((String)pageCache.get(SEARCH_TYPE_BO)) && view.getFormShowParameter() instanceof ListShowParameter) {
            ListShowParameter listShowParameter = (ListShowParameter)view.getFormShowParameter();
            if (listShowParameter.isLookUp()) {
                return;
            }
            long begin = System.currentTimeMillis();
            String entityNumber = ((ListView)view).getListModel() == null ? ((ListView)view).getBillFormId() : ((ListView)view).getListModel().getDataEntityType().getName();
            HisEntityF7SearchTypeBo hisEntityF7SearchTypeBo = new HisEntityF7SearchTypeBo();
            hisEntityF7SearchTypeBo.setEntityNumber(entityNumber);
            boolean isMultiSelect = this.isMultiSelect(entityNumber);
            String entityId = MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Form);
            hisEntityF7SearchTypeBo.setEntityId(entityId);
            String type = isMultiSelect ? "multiEntity" : "commonEntity";
            pageCache.put("isMultiSelect", isMultiSelect ? "1" : "0");
            hisEntityF7SearchTypeBo.setMultiEntity(isMultiSelect);
            IHisFilterConfigParseService hisFilterConfigParseService = HisFilterConfigParseFactory.getInstance().getFilterConfigInstance(type);
            if (hisFilterConfigParseService == null) {
                return;
            }
            hisFilterConfigParseService.getFilterConfig(entityNumber, hisEntityF7SearchTypeBo);
            pageCache.put(SEARCH_TYPE_BO, SerializationUtils.toJsonString((Object)hisEntityF7SearchTypeBo));
            long end = System.currentTimeMillis();
            LOGGER.info("HisCommonFilterService.initialize excute time :" + (end - begin));
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args, IFormView view) {
        if (!this.isLookup((IListView)view)) {
            List commonFilterColumns = args.getCommonFilterColumns();
            this.modifyFilterColumn(commonFilterColumns);
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args, IFormView view) {
        String fieldName;
        if (this.isLookup((IListView)view)) {
            return;
        }
        String refEntityId = null;
        ArrayList<Long> valueList = new ArrayList<Long>();
        String isSchemeFilter = "0";
        Map filterValues = args.getFilterValues();
        if (filterValues.containsKey("schemefilter")) {
            isSchemeFilter = "1";
        }
        view.getPageCache().put("isSchemeFilter", isSchemeFilter);
        String key = view.getPageCache().get(SEARCH_TYPE_BO);
        if (HRStringUtils.isEmpty((String)key)) {
            return;
        }
        HisEntityF7SearchTypeBo hisEntityF7SearchTypeBo = (HisEntityF7SearchTypeBo)SerializationUtils.fromJsonString((String)key, HisEntityF7SearchTypeBo.class);
        if (hisEntityF7SearchTypeBo == null) {
            return;
        }
        List boList = hisEntityF7SearchTypeBo.getHisFieldF7SearchTypeBoList();
        if (boList == null || boList.size() < 1) {
            return;
        }
        List hisVersionFieldList = boList.stream().filter(HisFieldF7SearchTypeBo::isHisVersionField).map(HisFieldF7SearchTypeBo::getFullFieldName).distinct().collect(Collectors.toList());
        Map currentCommonFilter = args.getCurrentCommonFilter();
        if (currentCommonFilter == null) {
            return;
        }
        List fieldNames = (List)currentCommonFilter.get("FieldName");
        if (fieldNames != null && fieldNames.size() > 0) {
            fieldName = (String)fieldNames.get(0);
            if (fieldName.contains(".")) {
                fieldName = fieldName.substring(0, fieldName.lastIndexOf("."));
            }
        } else {
            return;
        }
        if (!hisVersionFieldList.contains(fieldName)) {
            return;
        }
        List values = (List)currentCommonFilter.get("Value");
        if (values != null && values.size() > 0) {
            for (Object value : values) {
                if (!HRStringUtils.isNotEmpty((String)((String)value))) continue;
                valueList.add(Long.valueOf((String)value));
            }
        }
        view.getPageCache().remove(fieldName + "_selectedIds");
        if (valueList.size() < 1) {
            return;
        }
        view.getPageCache().put(fieldName + "_selectedIds", SerializationUtils.toJsonString(valueList));
        String filterStyleCacheKey = isSchemeFilter.equals("0") ? fieldName + FILTER_GRID_CACHE_SUFFIX : fieldName + SCHEME_CACHE_SUFFIX;
        String filterStyle = view.getPageCache().get(filterStyleCacheKey);
        if (HRStringUtils.isEmpty((String)filterStyle)) {
            if (HRStringUtils.equals((String)isSchemeFilter, (String)"0")) {
                filterStyle = HisCommonFilterService.getInstance().getFilterStyleFromMetaData(fieldName, view.getPageCache());
            } else if (HRStringUtils.equals((String)isSchemeFilter, (String)"1")) {
                return;
            }
        }
        if (HRStringUtils.equals((String)filterStyle, (String)"1")) {
            return;
        }
        for (HisFieldF7SearchTypeBo bo : boList) {
            if (!HRStringUtils.equals((String)bo.getFullFieldName(), (String)fieldName)) continue;
            refEntityId = bo.getRefEntity();
            break;
        }
        if (HRStringUtils.isEmpty(refEntityId)) {
            return;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(refEntityId);
        QFilter qFilter = new QFilter("id", "in", valueList);
        DynamicObject[] dys = serviceHelper.queryOriginalArray("boid", qFilter.toArray());
        if (dys == null || dys.length < 1) {
            return;
        }
        List boidList = Arrays.stream(dys).map(dy -> dy.get("boid")).collect(Collectors.toList());
        QFilter boidFilter = new QFilter("id", "in", boidList);
        DynamicObject[] boidDys = serviceHelper.queryOriginalArray("boid , sourcevid", boidFilter.toArray());
        List finalBoidDys = Arrays.stream(boidDys).filter(dy -> valueList.contains(dy.get("sourcevid"))).collect(Collectors.toList());
        boidList = finalBoidDys.stream().map(dy -> dy.get("boid")).collect(Collectors.toList());
        List sourceVids = finalBoidDys.stream().map(dy -> dy.get("sourcevid")).collect(Collectors.toList());
        valueList.addAll(boidList);
        valueList.removeAll(sourceVids);
        List newValueList = valueList.stream().map(String::valueOf).collect(Collectors.toList());
        newValueList = newValueList.stream().distinct().collect(Collectors.toList());
        currentCommonFilter.put("Value", newValueList);
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent evt, IPageCache pageCache) {
        Map customParams = evt.getCustomParams();
        String refPropKey = evt.getRefPropKey();
        String fullFieldName = evt.getFieldName();
        String fieldName = fullFieldName.substring(0, fullFieldName.lastIndexOf("."));
        String refEntityId = evt.getRefEntityId();
        Object[] selectedIds = evt.getSelectedIds();
        boolean isHisVersionField = this.isHisVersionField(fieldName, customParams, pageCache);
        if (!isHisVersionField) {
            return;
        }
        if (HRStringUtils.equals((String)refPropKey, (String)"id")) {
            evt.getCustomParams().put(FROM_FILTER_GRID_VIEW, "1");
            String filterStyleInCache = pageCache.get(fieldName + FILTER_GRID_CACHE_SUFFIX);
            String filterStyle = HRStringUtils.isNotEmpty((String)filterStyleInCache) ? filterStyleInCache : this.getFilterStyleFromMetaData(fieldName, pageCache);
            List customQFilters = evt.getCustomQFilters();
            this.setFilterByStyle(filterStyle, customQFilters);
            if (selectedIds != null && selectedIds.length > 0 && HRStringUtils.equals((String)filterStyle, (String)"2")) {
                Object[] newSelectedIds = this.transVersionId(selectedIds, refEntityId, pageCache, fieldName);
                evt.setSelectedIds(newSelectedIds);
            }
            pageCache.put(fieldName + FILTER_GRID_CACHE_SUFFIX, filterStyle);
        } else {
            boolean isCurrentVersion;
            Object id;
            QFilter qFilter;
            HRBaseServiceHelper serviceHelper;
            DynamicObject dy;
            customParams.put(FROM_SCHEME_FILTER_VIEW, "1");
            String filterStyle = selectedIds != null && selectedIds.length > 0 ? ((dy = (serviceHelper = new HRBaseServiceHelper(refEntityId)).queryOriginalOne("iscurrentversion", (qFilter = (id = selectedIds[0]) instanceof Long ? new QFilter("id", "=", id) : new QFilter("id", "=", (Object)Long.parseLong((String)id))).toArray())) == null ? this.getFilterStyleFromMetaData(fieldName, pageCache) : ((isCurrentVersion = dy.getBoolean("iscurrentversion")) ? "1" : "2")) : this.getFilterStyleFromMetaData(fieldName, pageCache);
            pageCache.put(fieldName + SCHEME_CACHE_SUFFIX, filterStyle);
        }
        customParams.put("fieldName", fieldName);
        customParams.put("refEntityId", refEntityId);
    }

    public void setFilter(SetFilterEvent e, IFormView view, IPageCache pageCache) {
        String entityNumber;
        if (!this.isLookup((IListView)view)) {
            List qFilters = e.getQFilters();
            String key = pageCache.get(SEARCH_TYPE_BO);
            if (HRStringUtils.isEmpty((String)key)) {
                LOGGER.error("HisCommonFilterService.setFilter execute error : this.getPageCache().get(SEARCH_TYPE_BO) is empty");
                return;
            }
            HisEntityF7SearchTypeBo entityF7SearchTypeBo = (HisEntityF7SearchTypeBo)SerializationUtils.fromJsonString((String)key, HisEntityF7SearchTypeBo.class);
            if (entityF7SearchTypeBo == null) {
                LOGGER.error("HisCommonFilterService.setFilter execute error : entityF7SearchTypeBo is empty");
                return;
            }
            List<QFilter> transQFilters = this.transQFilters(qFilters, entityF7SearchTypeBo, pageCache);
            if (transQFilters != null && transQFilters.size() > 0) {
                qFilters.clear();
                qFilters.addAll(transQFilters);
            }
        }
        if (!HRStringUtils.isEmpty((String)(entityNumber = ((ListView)view).getListModel() == null ? ((ListView)view).getBillFormId() : ((ListView)view).getListModel().getDataEntityType().getName()))) {
            String type = HisCommonService.getInstance().entityInhRelation(entityNumber);
            if (EnumEntityTpl.LINETIMESEQ_TPL.getNumber().equals(type)) {
                HisModelListCommonTool.changeHisListBdQFilter2(entityNumber, e.getQFilters());
            }
        }
    }

    private void modifyFilterColumn(List<FilterColumn> commonFilterColumns) {
        for (FilterColumn column : commonFilterColumns) {
            List<ComboItem> comboItems;
            Set<Object> ids;
            if (!(column instanceof CommonBaseDataFilterColumn)) continue;
            String entity = column.getFilterField().getRefEntityId();
            String inhRelation = HisCommonService.getInstance().entityInhRelation(entity);
            if (!inhRelation.equals(EnumEntityTpl.LINETIMESEQ_TPL.getNumber()) || CollectionUtils.isEmpty(ids = ((CommonBaseDataFilterColumn)column).getComboItems().stream().map(ComboItem::getValue).collect(Collectors.toSet())) || (comboItems = this.sortComboItems(entity, ids)) == null) continue;
            ((CommonBaseDataFilterColumn)column).setComboItems(comboItems);
        }
    }

    private List<ComboItem> sortComboItems(String entity, Set<Object> ids) {
        HashSet idSet = Sets.newHashSetWithExpectedSize((int)16);
        for (Object objId : ids) {
            if (objId == null) continue;
            Long id = HRLongValueParseService.getInstance().parseLong(objId);
            idSet.add(id);
        }
        if (CollectionUtils.isEmpty((Collection)idSet)) {
            return null;
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entity);
        QFilter qFilter = new QFilter("id", "in", (Object)idSet);
        DynamicObject[] dys = helper.queryOriginalArray("id,name,datastatus", qFilter.toArray());
        List toBeEffectList = Arrays.stream(dys).filter(dy -> HRStringUtils.equals((String)dy.getString("datastatus"), (String)"0")).collect(Collectors.toList());
        if (toBeEffectList.size() < 1) {
            return null;
        }
        List effectList = Arrays.stream(dys).filter(dy -> HRStringUtils.equals((String)dy.getString("datastatus"), (String)"1")).collect(Collectors.toList());
        effectList.addAll(toBeEffectList);
        ArrayList combos = Lists.newArrayListWithExpectedSize((int)16);
        for (DynamicObject dy2 : effectList) {
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(dy2.getString("name")));
            comboItem.setValue(dy2.getString("id"));
            combos.add(comboItem);
        }
        return combos;
    }

    private boolean isLookup(IListView view) {
        boolean isLookup = false;
        if (view.getFormShowParameter() instanceof ListShowParameter) {
            ListShowParameter listShowParameter = (ListShowParameter)view.getFormShowParameter();
            isLookup = listShowParameter.isLookUp();
        }
        return isLookup;
    }

    private Object[] transVersionId(Object[] selectedIds, String refEntityId, IPageCache pageCache, String fieldName) {
        String selectedIdsStr = pageCache.get(fieldName + "_selectedIds");
        if (HRStringUtils.isEmpty((String)selectedIdsStr)) {
            LOGGER.error("HisCommonFilterService.tranSelectedId execute error : pageCache.get({}_selectedIds) is empty", (Object)fieldName);
            return selectedIds;
        }
        ArrayList selectedIdList = (ArrayList)SerializationUtils.fromJsonString((String)selectedIdsStr, List.class);
        ArrayList<Object> newSelectedList = new ArrayList<Object>(selectedIdList.size());
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(refEntityId);
        QFilter qFilter = new QFilter("id", "in", (Object)selectedIdList);
        DynamicObject[] dys = serviceHelper.queryOriginalArray("id,sourcevid,iscurrentversion", qFilter.toArray());
        if (dys == null || dys.length < 1) {
            return selectedIds;
        }
        for (DynamicObject dy : dys) {
            if (dy.getBoolean("iscurrentversion")) {
                newSelectedList.add(dy.get("sourcevid"));
                continue;
            }
            newSelectedList.add(dy.get("id"));
        }
        return newSelectedList.toArray();
    }

    private boolean isHisVersionField(String fieldName, Map<String, Object> customParams, IPageCache pageCache) {
        String key = pageCache.get(SEARCH_TYPE_BO);
        if (HRStringUtils.isEmpty((String)key)) {
            LOGGER.error("HisCommonFilterService.isHisVersionField execute error : this.getPageCache().get(SEARCH_TYPE_BO) is empty");
            return false;
        }
        HisEntityF7SearchTypeBo hisEntityF7SearchTypeBo = (HisEntityF7SearchTypeBo)SerializationUtils.fromJsonString((String)key, HisEntityF7SearchTypeBo.class);
        if (hisEntityF7SearchTypeBo == null) {
            return false;
        }
        List boList = hisEntityF7SearchTypeBo.getHisFieldF7SearchTypeBoList();
        if (boList == null || boList.size() < 1) {
            return false;
        }
        for (HisFieldF7SearchTypeBo fieldF7SearchTypeBo : boList) {
            String entryFieldName;
            if (fieldF7SearchTypeBo.isEntryField() && HRStringUtils.equals((String)(entryFieldName = fieldF7SearchTypeBo.getFullFieldName().replace(fieldF7SearchTypeBo.getEntryNumber() + ".", "")), (String)fieldName) && fieldF7SearchTypeBo.isHisVersionField()) {
                customParams.put("isHisVersionField", "1");
                return true;
            }
            if (!HRStringUtils.equals((String)fieldF7SearchTypeBo.getFullFieldName(), (String)fieldName) || !fieldF7SearchTypeBo.isHisVersionField()) continue;
            customParams.put("isHisVersionField", "1");
            return true;
        }
        return false;
    }

    private String getFilterStyleFromMetaData(String fieldName, IPageCache pageCache) {
        String key = pageCache.get(SEARCH_TYPE_BO);
        if (HRStringUtils.isEmpty((String)key)) {
            return "1";
        }
        if (HRStringUtils.isEmpty((String)fieldName)) {
            return "1";
        }
        HisEntityF7SearchTypeBo hisEntityF7SearchTypeBo = (HisEntityF7SearchTypeBo)SerializationUtils.fromJsonString((String)key, HisEntityF7SearchTypeBo.class);
        if (hisEntityF7SearchTypeBo == null) {
            return "1";
        }
        List boList = hisEntityF7SearchTypeBo.getHisFieldF7SearchTypeBoList();
        if (boList == null) {
            return "1";
        }
        for (HisFieldF7SearchTypeBo fieldF7SearchTypeBo : boList) {
            String entryFieldName;
            if (fieldF7SearchTypeBo.isEntryField() && HRStringUtils.equals((String)(entryFieldName = fieldF7SearchTypeBo.getFullFieldName().replace(fieldF7SearchTypeBo.getEntryNumber() + ".", "")), (String)fieldName)) {
                return HRStringUtils.equals((String)fieldF7SearchTypeBo.getSearchType(), (String)EnumHisF7SearchType.BY_BO.getType()) ? "1" : "2";
            }
            if (!HRStringUtils.equals((String)fieldF7SearchTypeBo.getFullFieldName(), (String)fieldName)) continue;
            return HRStringUtils.equals((String)fieldF7SearchTypeBo.getSearchType(), (String)EnumHisF7SearchType.BY_BO.getType()) ? "1" : "2";
        }
        return "1";
    }

    private void setFilterByStyle(String filterStyle, List<QFilter> customQFilters) {
        if (HRStringUtils.equals((String)filterStyle, (String)"1")) {
            QFilter currentVersionFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('1'));
            customQFilters.add(currentVersionFilter);
            QFilter dataStatusFilter = new QFilter("datastatus", "in", Stream.of(EventOperateEnums.CHANGE_BEFORE_STATUS_EFFECTING.getValue(), EventOperateEnums.CHANGE_BEFORE_STATUS_TOBEEFFECT.getValue()).collect(Collectors.toSet()));
            customQFilters.add(dataStatusFilter);
        } else {
            QFilter currentVersionFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0'));
            customQFilters.add(currentVersionFilter);
            QFilter dataStatusFilter = new QFilter("datastatus", "in", Stream.of(EnumHisDataVersionStatus.DELETED.getStatus(), EnumHisDataVersionStatus.DISCARDED.getStatus(), EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus(), EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()).collect(Collectors.toSet()));
            customQFilters.add(dataStatusFilter);
        }
    }

    private List<QFilter> transQFilters(List<QFilter> originalQFilters, HisEntityF7SearchTypeBo entityF7SearchTypeBo, IPageCache pageCache) {
        List searchTypeBoList = entityF7SearchTypeBo.getHisFieldF7SearchTypeBoList();
        if (searchTypeBoList == null || searchTypeBoList.size() < 1) {
            return null;
        }
        List<HisFieldF7SearchTypeBo> hisFieldF7SearchTypeBos = searchTypeBoList.stream().filter(HisFieldF7SearchTypeBo::isHisVersionField).collect(Collectors.toList());
        if (hisFieldF7SearchTypeBos.size() < 1) {
            return null;
        }
        ArrayList<QFilter> hisQFilters = new ArrayList<QFilter>(originalQFilters.size());
        for (QFilter filter : originalQFilters) {
            QFilter hisQFilter;
            if (filter == null || (hisQFilter = this.transQFilter(filter, hisFieldF7SearchTypeBos, pageCache)) == null) continue;
            LOGGER.info("HisCommonFilterService.transQFilter excute result : hisQFilter = {}", (Object)hisQFilter.toString());
            hisQFilters.add(hisQFilter);
        }
        return hisQFilters;
    }

    private QFilter transQFilter(QFilter filter, List<HisFieldF7SearchTypeBo> hisFieldF7SearchTypeBoList, IPageCache pageCache) {
        String propertySuffix;
        String property = filter.getProperty();
        String string = propertySuffix = property.contains(".") ? property.substring(property.lastIndexOf(".") + 1) : null;
        if (HRStringUtils.isNotEmpty((String)property) && !HRStringUtils.equals((String)propertySuffix, (String)"id")) {
            return filter;
        }
        for (HisFieldF7SearchTypeBo searchTypeBo : hisFieldF7SearchTypeBoList) {
            String propertyName;
            String fieldName = searchTypeBo.getFieldName();
            String fieldSearchType = searchTypeBo.getSearchType();
            String refEntity = searchTypeBo.getRefEntity();
            String fullFieldName = searchTypeBo.getFullFieldName();
            String string2 = propertyName = property.contains(".") ? property.substring(0, property.lastIndexOf(".")) : property;
            if (!HRStringUtils.equalsIgnoreCase((String)propertyName, (String)fullFieldName)) continue;
            String filterStyle = this.getfilterStyle(fieldSearchType, pageCache, fullFieldName, filter, refEntity);
            return this.transToHisQFilter(filterStyle, property, refEntity, filter, pageCache, fullFieldName, fieldName);
        }
        return filter;
    }

    private QFilter transToHisQFilter(String filterStyle, String property, String refEntity, QFilter filter, IPageCache pageCache, String fullFieldName, String fieldName) {
        String isSchemeFilter = pageCache.get("isSchemeFilter");
        LOGGER.info("HisCommonFilterService.transToHisQFilter methodParamters : isSchemeFilter = {} , fullFieldName = {} , fieldName = {} , property = {} , refEntity = {} , filter = {} , idListStr = {} , filterStyle = {}", new Object[]{isSchemeFilter, fullFieldName, fieldName, property, refEntity, filter.toString(), pageCache.get(fullFieldName + "_selectedIds"), filterStyle});
        if (HRStringUtils.isNotEmpty((String)isSchemeFilter) && HRStringUtils.equals((String)isSchemeFilter, (String)"1")) {
            if (filterStyle.equals(EnumHisF7SearchType.BY_VERSION.getType())) {
                return filter;
            }
            List value = (List)filter.getValue();
            return this.transToBoQfilter(value, property, refEntity, filter);
        }
        String idListStr = pageCache.get(fullFieldName + "_selectedIds");
        if (HRStringUtils.isEmpty((String)idListStr)) {
            LOGGER.error("HisCommonFilterService.transQFilter execute error : pageCache.get({}_selectedIds) is empty", (Object)fieldName);
            return filter;
        }
        List idList = (List)SerializationUtils.fromJsonString((String)idListStr, List.class);
        List<Long> transIdList = this.transId(filterStyle, idList, refEntity);
        if (filterStyle.equals(EnumHisF7SearchType.BY_VERSION.getType())) {
            filter.__setCP("in");
            filter.__setValue(transIdList);
            return filter;
        }
        return this.transToBoQfilter(idList, property, refEntity, filter);
    }

    private QFilter transToBoQfilter(List<Long> transIdList, String property, String refEntity, QFilter filter) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(refEntity);
        String selectProperty = property.substring(property.lastIndexOf(".") + 1);
        QFilter selectPropertyFilter = new QFilter(selectProperty, "in", transIdList);
        DynamicObject[] dys = serviceHelper.queryOriginalArray("boid", selectPropertyFilter.toArray());
        if (dys == null || dys.length < 1) {
            return filter;
        }
        Set boidSet = Arrays.stream(dys).map(dy -> dy.getLong("boid")).collect(Collectors.toSet());
        QFilter boFilter = new QFilter(property.replace("." + selectProperty, ".boid"), "in", boidSet).and(property.replace("." + selectProperty, ".datastatus"), "!=", (Object)EnumHisDataVersionStatus.REVISED.getStatus());
        List filterNests = filter.getNests(true);
        for (QFilter.QFilterNest filterNest : filterNests) {
            if (filterNest.isAnd()) {
                boFilter.and(filterNest.getFilter());
                continue;
            }
            boFilter.or(filterNest.getFilter());
        }
        return boFilter;
    }

    private List<Long> transId(String searchType, List<Long> idList, String refEntity) {
        List curVersionDys;
        if (HRStringUtils.equals((String)searchType, (String)EnumHisF7SearchType.BY_BO.getType())) {
            return idList;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(refEntity);
        QFilter qFilter = new QFilter("id", "in", idList);
        DynamicObject[] dys = serviceHelper.queryOriginalArray("id , iscurrentversion , sourcevid", qFilter.toArray());
        if (dys == null || dys.length < 1) {
            LOGGER.error("HisCommonFilterService.transId execute error : dys is empty");
            return idList;
        }
        idList.clear();
        List currentDys = Arrays.stream(dys).filter(dy -> dy.getBoolean("iscurrentversion")).collect(Collectors.toList());
        if (currentDys.size() > 0) {
            List sourceVids = currentDys.stream().map(dy -> dy.getLong("sourcevid")).collect(Collectors.toList());
            idList.addAll(sourceVids);
        }
        if ((curVersionDys = Arrays.stream(dys).filter(dy -> !dy.getBoolean("iscurrentversion")).collect(Collectors.toList())).size() > 0) {
            List curVersionIds = curVersionDys.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
            idList.addAll(curVersionIds);
        }
        return idList.stream().distinct().collect(Collectors.toList());
    }

    private String getfilterStyle(String fieldSearchType, IPageCache pageCache, String fieldName, QFilter filter, String refEntity) {
        ArrayList value;
        String filterStyle = null;
        String isSchemeFilter = pageCache.get("isSchemeFilter");
        if (HRStringUtils.isNotEmpty((String)isSchemeFilter)) {
            String filterStyleCacheKey = isSchemeFilter.equals("0") ? fieldName + FILTER_GRID_CACHE_SUFFIX : fieldName + SCHEME_CACHE_SUFFIX;
            filterStyle = pageCache.get(filterStyleCacheKey);
        }
        if (HRStringUtils.isNotEmpty(filterStyle)) {
            return HRStringUtils.equals(filterStyle, (String)"1") ? EnumHisF7SearchType.BY_BO.getType() : EnumHisF7SearchType.BY_VERSION.getType();
        }
        if (HRStringUtils.equals((String)isSchemeFilter, (String)"1") && (value = (ArrayList)filter.getValue()) != null && value.size() > 0) {
            HRBaseServiceHelper helper = new HRBaseServiceHelper(refEntity);
            QFilter qFilter = new QFilter("id", "=", value.get(0));
            DynamicObject dy = helper.queryOriginalOne("iscurrentversion", qFilter.toArray());
            return dy.getBoolean("iscurrentversion") ? EnumHisF7SearchType.BY_BO.getType() : EnumHisF7SearchType.BY_VERSION.getType();
        }
        if (HRStringUtils.isNotEmpty((String)fieldSearchType)) {
            return fieldSearchType;
        }
        return EnumHisF7SearchType.BY_BO.getType();
    }

    private boolean isMultiSelect(String entityNumber) {
        return EntityMetadataCache.getDataEntityType((String)entityNumber) instanceof QueryEntityType;
    }

    public List<HisFieldF7SearchTypeBo> buildEntitySearchBos(String entityNumber, HisEntityF7SearchTypeBo entityF7SearchTypeBo) {
        Set<String> listFilterFieldNames = this.getListMeta(entityF7SearchTypeBo.getEntityId());
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        DataEntityPropertyCollection propertyCollection = mainEntityType.getProperties();
        Map allEntities = mainEntityType.getAllEntities();
        ArrayList<HisFieldF7SearchTypeBo> fieldF7SearchTypeBos = new ArrayList<HisFieldF7SearchTypeBo>(propertyCollection.size());
        this.buildFieldSearchBos(propertyCollection, fieldF7SearchTypeBos, false, "", entityF7SearchTypeBo, entityNumber, listFilterFieldNames);
        for (Map.Entry entry : allEntities.entrySet()) {
            String entryNumber = (String)entry.getKey();
            EntityType entityType = (EntityType)entry.getValue();
            if (!(entityType instanceof EntryType)) continue;
            this.buildFieldSearchBos(entityType.getProperties(), fieldF7SearchTypeBos, true, entryNumber, entityF7SearchTypeBo, entityNumber, listFilterFieldNames);
        }
        if (CollectionUtils.isEmpty(fieldF7SearchTypeBos)) {
            return null;
        }
        Map<String, String> boMap = fieldF7SearchTypeBos.stream().collect(Collectors.toMap(HisFieldF7SearchTypeBo::getFieldName, HisFieldF7SearchTypeBo::getFullFieldName, (oldData, newData) -> oldData));
        EntityMetadata entitymeta = this.getRuntimeMetaData(entityF7SearchTypeBo.getEntityId());
        List entityItems = entitymeta.getItems();
        for (EntityItem entityItem : entityItems) {
            List refProps;
            BasedataField basedataField;
            if (!(entityItem instanceof BasedataField) || !listFilterFieldNames.contains((basedataField = (BasedataField)entityItem).getKey()) || (refProps = basedataField.getRefProps()) == null || refProps.size() < 1) continue;
            String fieldName = basedataField.getKey();
            String fullFieldName = boMap.get(fieldName);
            EntityMetadata nlMetaData = ((BasedataField)entityItem).getRefBaseEntityMeta();
            for (RefProp refProp : refProps) {
                String name = refProp.getName();
                if (!name.contains(".")) continue;
                String nlFieldNumber = name.split("\\.")[0];
                this.buildNlFieldSearchBos(nlMetaData, nlFieldNumber, fullFieldName, fieldF7SearchTypeBos, entityF7SearchTypeBo, entityNumber);
            }
        }
        return fieldF7SearchTypeBos;
    }

    private EntityMetadata getRuntimeMetaData(String entityId) {
        long l1 = System.currentTimeMillis();
        EntityMetadata metadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        long l2 = System.currentTimeMillis();
        LOGGER.info("HisCommonFilterService.getRuntimeMetaData excute time " + (l2 - l1));
        return metadata;
    }

    private Set<String> getListMeta(String entityId) {
        HashSet<String> listFilterFieldNames = new HashSet<String>(16);
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Form);
        FormMetadata listMeta = ((BillFormAp)formMetadata.getRootAp()).getListMeta();
        List items = listMeta.getItems();
        for (ControlAp item : items) {
            String[] split;
            if (item instanceof CommonBaseDataFilterColumnAp) {
                split = ((CommonFilterColumnAp)item).getFieldName().split("\\.");
                listFilterFieldNames.add(split[0]);
            }
            if (!(item instanceof SchemeBaseDataFilterColumnAp)) continue;
            split = ((SchemeBaseDataFilterColumnAp)item).getFieldName().split("\\.");
            listFilterFieldNames.add(split[0]);
        }
        return listFilterFieldNames;
    }

    private void buildNlFieldSearchBos(EntityMetadata nlMetadata, String nlFieldNumber, String fullFieldName, List<HisFieldF7SearchTypeBo> fieldF7SearchTypeBos, HisEntityF7SearchTypeBo hisEntityF7SearchTypeBo, String entityNumber) {
        long l1 = System.currentTimeMillis();
        boolean isMultiEntity = hisEntityF7SearchTypeBo.isMultiEntity();
        String mainEntity = hisEntityF7SearchTypeBo.getMainEntity();
        List entityItems = nlMetadata.getItems();
        for (EntityItem entityItem : entityItems) {
            HisFieldF7SearchTypeBo fieldF7SearchTypeBo;
            if (!HRStringUtils.equals((String)entityItem.getKey(), (String)nlFieldNumber)) continue;
            String finalFullName = fullFieldName + "." + nlFieldNumber;
            boolean anyMatch = fieldF7SearchTypeBos.stream().anyMatch(bo -> HRStringUtils.equals((String)bo.getFullFieldName(), (String)finalFullName));
            if (anyMatch) {
                return;
            }
            if (!(entityItem instanceof HisModelBasedataField)) {
                return;
            }
            String selData = ((HisModelBasedataField)entityItem).getSelData();
            if (HRStringUtils.isEmpty((String)selData) || HRStringUtils.equals((String)selData, (String)"bd")) {
                return;
            }
            String listFilterType = ((HisModelBasedataField)entityItem).getListFilterType();
            if (HRStringUtils.isEmpty((String)listFilterType)) {
                listFilterType = EnumHisF7SearchType.BY_BO.getType();
            }
            String nlEntityNumber = ((HisModelBasedataField)entityItem).getRefBaseEntityMeta().getKey();
            boolean isEntryField = false;
            String entryNumber = "";
            List parentFieldF7SearchTypeBos = fieldF7SearchTypeBos.stream().filter(bo -> HRStringUtils.equals((String)bo.getFullFieldName(), (String)fullFieldName)).collect(Collectors.toList());
            if (parentFieldF7SearchTypeBos.size() > 0 && (isEntryField = (fieldF7SearchTypeBo = (HisFieldF7SearchTypeBo)parentFieldF7SearchTypeBos.get(0)).isEntryField()) && fieldF7SearchTypeBo.getEntryNumber() != null) {
                entryNumber = fieldF7SearchTypeBo.getEntryNumber();
            }
            fieldF7SearchTypeBo = new HisFieldF7SearchTypeBo();
            fieldF7SearchTypeBo.setFullFieldName(finalFullName);
            fieldF7SearchTypeBo.setFieldName(nlFieldNumber);
            fieldF7SearchTypeBo.setRefEntity(nlEntityNumber);
            fieldF7SearchTypeBo.setMultiMainEntity(HRStringUtils.equals((String)mainEntity, (String)entityNumber));
            fieldF7SearchTypeBo.setMultiEntity(isMultiEntity);
            fieldF7SearchTypeBo.setSearchType(listFilterType);
            fieldF7SearchTypeBo.setSelData(selData);
            fieldF7SearchTypeBo.setHisVersionField("bdversion".equals(selData));
            fieldF7SearchTypeBo.setEntryField(isEntryField);
            fieldF7SearchTypeBo.setEntryNumber(entryNumber);
            fieldF7SearchTypeBos.add(fieldF7SearchTypeBo);
        }
        long l2 = System.currentTimeMillis();
        LOGGER.info("HisCommonFilterService.buildNlFieldSearchBos excute time " + (l2 - l1));
    }

    private void buildFieldSearchBos(DataEntityPropertyCollection propertyCollection, List<HisFieldF7SearchTypeBo> fieldF7SearchTypeBos, boolean isEntryField, String entryNumber, HisEntityF7SearchTypeBo hisEntityF7SearchTypeBo, String entityNumber, Set<String> listFilterFieldNames) {
        long l1 = System.currentTimeMillis();
        boolean isMultiEntity = hisEntityF7SearchTypeBo.isMultiEntity();
        String mainEntity = hisEntityF7SearchTypeBo.getMainEntity();
        for (IDataEntityProperty property : propertyCollection) {
            String baseDataEntityNumber;
            String fieldName;
            if (property instanceof BasedataProp) {
                BasedataProp basedataProp = (BasedataProp)property;
                fieldName = basedataProp.getName();
                baseDataEntityNumber = basedataProp.getBaseEntityId();
            } else {
                if (property instanceof AttachmentProp || !(property instanceof MulBasedataProp)) continue;
                MulBasedataProp mulBasedataProp = (MulBasedataProp)property;
                fieldName = mulBasedataProp.getName();
                baseDataEntityNumber = mulBasedataProp.getBaseEntityId();
            }
            if (!listFilterFieldNames.contains(fieldName) || HRStringUtils.equalsIgnoreCase((String)fieldName, (String)"creator") || HRStringUtils.equalsIgnoreCase((String)fieldName, (String)"modifier") || HRStringUtils.equalsIgnoreCase((String)fieldName, (String)"createorg") || HRStringUtils.equalsIgnoreCase((String)fieldName, (String)"org") || HRStringUtils.equalsIgnoreCase((String)fieldName, (String)"useorg") || HRStringUtils.equalsIgnoreCase((String)fieldName, (String)"disabler")) continue;
            HisFieldF7SearchTypeBo fieldF7SearchTypeBo = new HisFieldF7SearchTypeBo();
            if (isEntryField) {
                fieldF7SearchTypeBo.setEntryField(true);
                fieldF7SearchTypeBo.setFullFieldName(entryNumber + "." + fieldName);
                fieldF7SearchTypeBo.setEntryNumber(entryNumber);
            } else {
                fieldF7SearchTypeBo.setFullFieldName(fieldName);
            }
            if (isMultiEntity && !HRStringUtils.equals((String)entityNumber, (String)mainEntity)) {
                fieldF7SearchTypeBo.setFullFieldName(entityNumber + "." + fieldF7SearchTypeBo.getFullFieldName());
            }
            fieldF7SearchTypeBo.setFieldName(fieldName);
            fieldF7SearchTypeBo.setRefEntity(baseDataEntityNumber);
            fieldF7SearchTypeBo.setMultiEntity(isMultiEntity);
            fieldF7SearchTypeBo.setMultiMainEntity(HRStringUtils.equals((String)entityNumber, (String)mainEntity));
            if (property instanceof HisModelBasedataProp) {
                String listFilterType;
                HisModelBasedataProp hisModelBasedataProp = (HisModelBasedataProp)property;
                String selData = hisModelBasedataProp.getSelData();
                if (HRStringUtils.isEmpty((String)selData)) {
                    selData = "bd";
                }
                if (HRStringUtils.isEmpty((String)(listFilterType = hisModelBasedataProp.getListFilterType()))) {
                    listFilterType = EnumHisF7SearchType.BY_BO.getType();
                }
                fieldF7SearchTypeBo.setSelData(selData);
                fieldF7SearchTypeBo.setSearchType(listFilterType);
                fieldF7SearchTypeBo.setHisVersionField("bdversion".equals(selData));
            }
            fieldF7SearchTypeBos.add(fieldF7SearchTypeBo);
        }
        long l2 = System.currentTimeMillis();
        LOGGER.info("HisCommonFilterService.buildFieldSearchBos excute time " + (l2 - l1));
    }
}

