/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.newhismodel.pluginservice.impl;

import java.util.List;
import java.util.Objects;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.application.impl.common.HrEntityCommonService;
import kd.hr.hbp.business.domain.repository.HisCommonEntityRepository;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.newhismodel.pluginservice.IHisChangeTitleService;
import kd.hr.hbp.formplugin.web.newhismodel.pluginservice.impl.HisCommonEditPluginService;
import kd.hr.hbp.formplugin.web.util.HRBaseDataUtils;

public class HisNoLineTimeChangeTitleService
implements IHisChangeTitleService {
    private static final Log LOGGER = LogFactory.getLog(HisNoLineTimeChangeTitleService.class);
    private static volatile HisNoLineTimeChangeTitleService service = null;

    private HisNoLineTimeChangeTitleService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HisNoLineTimeChangeTitleService getInstance() {
        if (service != null) return service;
        Class<HisNoLineTimeChangeTitleService> clazz = HisNoLineTimeChangeTitleService.class;
        synchronized (HisNoLineTimeChangeTitleService.class) {
            if (service != null) return service;
            service = new HisNoLineTimeChangeTitleService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return service;
        }
    }

    @Override
    public void setCaptionForPreOpenForm(FormShowParameter showParameter) {
        if (HRBaseDataUtils.skipHisControlPageLabel(showParameter)) {
            return;
        }
        String entityNumber = showParameter.getFormId();
        LOGGER.info("HisNoLineTimeChangeTitleService handleUE formId:" + entityNumber);
        if (HRStringUtils.isEmpty((String)entityNumber) || !(showParameter instanceof BillShowParameter)) {
            return;
        }
        List parentEntity = HrEntityCommonService.getInstance().getParentEntity(entityNumber);
        boolean isOriTimeSeqTpl = HisCommonEditPluginService.getInstance().isOriTimeSeqTpl(entityNumber, parentEntity);
        if (isOriTimeSeqTpl) {
            this.setOriCaptionForPreOpenForm(showParameter);
        } else {
            this.setCommonTplCaptionForPreOpenForm(showParameter);
        }
    }

    private void setOriCaptionForPreOpenForm(FormShowParameter showParameter) {
        LocaleString caption = showParameter.getFormConfig().getCaption();
        String hisAction = (String)showParameter.getCustomParams().get("his_action");
        if (showParameter.getStatus() == OperationStatus.ADDNEW && hisAction == null) {
            String tittle = String.format(ResManager.loadKDString((String)"\u65b0\u589e%s", (String)"HRBaseDataTplEdit_0", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), caption);
            showParameter.setCaption(tittle);
        }
    }

    private void setCommonTplCaptionForPreOpenForm(FormShowParameter showParameter) {
        LocaleString caption = showParameter.getFormConfig().getCaption();
        if (showParameter.getStatus() == OperationStatus.ADDNEW) {
            String tittle = String.format(ResManager.loadKDString((String)"\u65b0\u589e%s", (String)"HRBaseDataTplEdit_0", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), caption);
            showParameter.setCaption(tittle);
        } else {
            Object pkId = ((BillShowParameter)showParameter).getPkId();
            if (!Objects.isNull(pkId)) {
                String formId = showParameter.getFormId();
                HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(formId);
                MetadataReader metadataReader = new MetadataReader();
                String formIdStr = metadataReader.loadIdByNumber(formId, MetaCategory.Entity);
                if (HRStringUtils.isEmpty((String)formIdStr)) {
                    return;
                }
                DynamicObject dynamicObject = null;
                if (pkId instanceof String) {
                    String idStr = (String)pkId;
                    long id = Long.parseLong(idStr);
                    DynamicObject[] names = hrBaseServiceHelper.query("name", new QFilter[]{new QFilter("id", "=", (Object)id)});
                    if (names.length > 0) {
                        dynamicObject = names[0];
                    }
                } else {
                    DynamicObject[] names = hrBaseServiceHelper.query("name", new QFilter[]{new QFilter("id", "=", pkId)});
                    if (names.length > 0) {
                        dynamicObject = names[0];
                    }
                }
                if (dynamicObject == null) {
                    return;
                }
                try {
                    String name = dynamicObject.getString("name");
                    LOGGER.info("HisNoLineTimeChangeTitleService handleUE tittle:" + name);
                    if (HRStringUtils.isNotEmpty((String)name)) {
                        String tittle = String.format(ResManager.loadKDString((String)"%1$s-%2$s", (String)"HisNoLineTimeChangeTitleService_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), caption, name);
                        showParameter.setCaption(tittle);
                        return;
                    }
                }
                catch (Exception exception) {
                    LOGGER.error("HisNoLineTimeChangeTitleService handleUE:" + exception);
                }
            }
        }
    }

    @Override
    public void setHisModelTitle(IFormView formView, String operateKey, IDataModel dataModel, boolean isNew) {
        String inheritPath = dataModel.getDataEntityType().getInheritPath();
        String entityNumber = formView.getEntityId();
        boolean isOriTimeSeqTpl = HisCommonEditPluginService.getInstance().isOriTimeSeqTpl(entityNumber, inheritPath);
        if (isOriTimeSeqTpl) {
            this.setOriTitleForAfterDo(formView);
            return;
        }
        this.setCommonTitleForAfterDo(formView, dataModel, isNew);
    }

    private void setOriTitleForAfterDo(IFormView formView) {
        FormShowParameter showParameter = formView.getFormShowParameter();
        LocaleString caption = showParameter.getFormConfig().getCaption();
        String fromPage = (String)showParameter.getCustomParams().get("fromPage");
        if ("revise".equalsIgnoreCase(fromPage)) {
            formView.setFormTitle(caption);
            return;
        }
        if (showParameter.getStatus() == OperationStatus.ADDNEW) {
            String tittle = String.format(ResManager.loadKDString((String)"\u65b0\u589e%s", (String)"HisCommonChangeTitleService_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), caption);
            formView.setFormTitle(new LocaleString(tittle));
        }
    }

    private void setCommonTitleForAfterDo(IFormView formView, IDataModel dataModel, boolean isNew) {
        ILocaleString name;
        FormShowParameter showParameter = formView.getFormShowParameter();
        LocaleString caption = showParameter.getFormConfig().getCaption();
        if (isNew) {
            String tittle = String.format(ResManager.loadKDString((String)"\u65b0\u589e%s", (String)"HisCommonChangeTitleService_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), caption);
            formView.setFormTitle(new LocaleString(tittle));
            return;
        }
        String entityNumber = formView.getEntityId();
        if (!dataModel.getDataEntityType().getProperties().containsKey((Object)"name")) {
            return;
        }
        Object objName = dataModel.getDataEntity().get("name");
        if (!(objName instanceof ILocaleString)) {
            return;
        }
        if (objName == null || HRStringUtils.isEmpty((String)((ILocaleString)objName).getLocaleValue())) {
            Long boId = dataModel.getDataEntity().getLong("boid");
            if (StringUtils.isEmpty((String)entityNumber) || boId == null || boId == 0L) {
                return;
            }
            DynamicObject dynamicObject = HisCommonEntityRepository.getCurrentDyName((HRBaseServiceHelper)new HRBaseServiceHelper(entityNumber), (Long)boId);
            if (dynamicObject == null) {
                return;
            }
            objName = dynamicObject.get("name");
            if (objName == null) {
                return;
            }
        }
        if (HRStringUtils.isNotEmpty((String)(name = (ILocaleString)objName).toString())) {
            String tittle = String.format(ResManager.loadKDString((String)"%1$s-%2$s", (String)"HisCommonChangeTitleService_2", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), caption, name);
            formView.setFormTitle(new LocaleString(tittle));
        }
    }
}

