/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.org.structproject.imp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.AppIdServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.business.servicehelper.QueryEntityServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.constants.org.TreeTemplateConstants;
import kd.hr.hbp.common.model.AuthorizedStructResult;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.org.structproject.StructProjectCapable;
import kd.hr.hbp.formplugin.web.util.perm.HRPermUtil;

@ExcludeFromJacocoGeneratedReport
public class DefaultStructProjectProcessor
implements StructProjectCapable {
    private static final String STRUCT_PROJECT_INIT_FINISH = "struct_project_init_finish";
    private static final String CACHE_PERM_STRUCT_PROJECT = "perm_struct_project";
    private static final String CACHE_PERM_STRUCT_PROJECT_CONFIG = "perm_struct_project_config";
    private static final Log LOGGER = LogFactory.getLog(DefaultStructProjectProcessor.class);
    private IFormView formView;
    private Supplier<String> propKeySupplier;
    private Supplier<AuthorizedStructResult> structProjectPermSupplier;
    private DynamicObject structProject;
    private DynamicObject noControlTempStructProject;

    public DefaultStructProjectProcessor(IFormView formView) {
        this.formView = formView;
    }

    public DefaultStructProjectProcessor() {
    }

    @Override
    public StructProjectCapable wrapView(IFormView formView) {
        this.formView = formView;
        return this;
    }

    @Override
    public void registerListener(EventObject eventObject) {
        BasedataEdit structProjectBdEdit = (BasedataEdit)this.getControl("structproject");
        if (structProjectBdEdit != null) {
            structProjectBdEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        if (this.enableStructProjectCode()) {
            this.setDefaultStructProject();
            this.markStructProjectInitFinish();
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        if (this.enableStructProjectCode()) {
            this.setStructProjectVisible();
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"structproject"});
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String properName = beforeF7SelectEvent.getProperty().getName();
        if (this.enableStructProjectCode() && "structproject".equals(properName)) {
            List<QFilter> structProjectControlFilterList = this.getStructProjectAllFilter();
            structProjectControlFilterList.forEach(arg_0 -> ((BeforeF7SelectEvent)beforeF7SelectEvent).addCustomQFilter(arg_0));
            ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter().setOrderBy("issyspreset desc, number asc");
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs changedArgs) {
        String propertyName = changedArgs.getProperty().getName();
        if ("structproject".equals(propertyName)) {
            this.cacheStructProject4perm();
        }
    }

    @Override
    public long getStructProjectRootOrgId() {
        return this.getStructProject().getLong("rootorg.id");
    }

    @Override
    public long getDefaultFirstStructProjectId() {
        return 1010L;
    }

    @Override
    public boolean enableStructProjectCode() {
        return true;
    }

    @Override
    public Set<Long> getStructProjectIdSet() {
        HashSet<Long> structProjectIdSet = new HashSet<Long>();
        structProjectIdSet.add(1010L);
        return structProjectIdSet;
    }

    @Override
    public DynamicObject getStructProject() {
        if (this.hasStructProjectControl()) {
            if (this.isStructProjectInitFinish()) {
                DynamicObject dynamicObject;
                try {
                    dynamicObject = this.getModel().getDataEntity().getDynamicObject("structproject");
                }
                catch (KDException ex) {
                    dynamicObject = this.getValidStructProject4Init();
                    LOGGER.error((Throwable)ex);
                }
                return dynamicObject;
            }
            return this.getValidStructProject4Init();
        }
        return this.getNoControlTempStructProject();
    }

    @Override
    public List<QFilter> getStructProjectAllFilter() {
        if (!this.enableStructProjectCode()) {
            return Collections.emptyList();
        }
        QFilter structProjectIdFilter = this.getStructProjectIdFilter();
        if (structProjectIdFilter != null) {
            return Stream.of(structProjectIdFilter, this.getStructProjectFilterFromConfigFilter()).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return Stream.of(this.getEnableStructProjectControlFilter(), this.getIsToAllAreasFilter(), this.getOtClassifyStructProjectFilter(), this.getStructProjectFilterFromConfigFilter()).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public QFilter getStructProjectFilterFromConfigFilter() {
        AuthorizedStructResult permStructProject;
        AuthorizedStructResult getPermConfig = this.getGetStructProjectPerm();
        if (getPermConfig != null) {
            permStructProject = getPermConfig;
        } else {
            permStructProject = this.getPermStructProject();
            if (permStructProject == null) {
                permStructProject = new AuthorizedStructResult();
            }
        }
        if (permStructProject.isHasAllStruct()) {
            return new QFilter("id", "in", this.getConfigStructProject());
        }
        return new QFilter("id", "in", (Object)permStructProject.getAuthorizedStructs());
    }

    private Set<Long> getConfigStructProject() {
        List<Map<String, Object>> structProjectConfigList = this.getStructProjectConfig();
        if (structProjectConfigList == null || structProjectConfigList.size() == 0) {
            return Collections.emptySet();
        }
        HashSet<Long> structFromHaos = new HashSet<Long>();
        Map<String, Object> structProjectConfig = structProjectConfigList.get(0);
        List structProjectList = (List)structProjectConfig.get("structproject");
        if (structProjectList != null) {
            for (Map structProjectMap : structProjectList) {
                Object structProjectId = structProjectMap.get("id");
                if (structProjectId == null) continue;
                structFromHaos.add(Long.valueOf(structProjectId.toString()));
            }
        }
        return structFromHaos;
    }

    private List<Map<String, Object>> getStructProjectConfig() {
        String structProjectConfigResultString = this.getPageCache().get(CACHE_PERM_STRUCT_PROJECT_CONFIG);
        if (!HRStringUtils.isEmpty((String)structProjectConfigResultString)) {
            LOGGER.info(String.format("getStructProjectConfig\uff1a %s ", structProjectConfigResultString));
            return (List)SerializationUtils.fromJsonString((String)structProjectConfigResultString, List.class);
        }
        if (this.getView().getFormShowParameter() instanceof ListShowParameter) {
            ListShowParameter listParameter = (ListShowParameter)this.getView().getFormShowParameter();
            Boolean isF7 = listParameter.isLookUp();
            String permEntityId = listParameter.getBillFormId();
            String propKey = this.getPermPropKey(isF7);
            if (isF7.booleanValue()) {
                permEntityId = this.getPermEntity();
            }
            permEntityId = QueryEntityServiceHelper.getDataEntityNumber((String)permEntityId);
            String baseDataType = this.getBaseDataType4ListView(permEntityId, propKey);
            long otClassify = this.getOtClassify();
            LOGGER.info(String.format("getStructProjectConfig param: {permEntityId: %1$s, propKey: %2$s, otClassifyId: %3$s, baseDataType: %4$s}", permEntityId, propKey, otClassify, baseDataType));
            List result = (List)HRMServiceHelper.invokeHRMPService((String)"haos", (String)"IHAOSStructProjectService", (String)"queryStructProConfig", (Object[])new Object[]{permEntityId, propKey, otClassify, baseDataType});
            this.getPageCache().put(CACHE_PERM_STRUCT_PROJECT_CONFIG, SerializationUtils.toJsonString((Object)result));
            return result;
        }
        if (this.getView().getFormShowParameter() instanceof ReportShowParameter) {
            ReportShowParameter formShowParameter = (ReportShowParameter)this.getView().getFormShowParameter();
            String permEntityId = null;
            String propKey = this.getPropKeySupplier().get();
            permEntityId = "haos_adminorgdetail";
            Map permParams = (Map)formShowParameter.getCustomParam("permParams");
            permEntityId = QueryEntityServiceHelper.getDataEntityNumber((String)permEntityId);
            if (permParams != null) {
                permEntityId = (String)permParams.get("permEntityId");
                propKey = (String)permParams.get("propKey");
            }
            String baseDataType = this.getBaseDataType4ReportView(permEntityId, propKey);
            long otClassify = this.getOtClassify();
            LOGGER.info(String.format("getStructProjectConfig param: {permEntityId: %1$s, propKey: %2$s, otClassifyId: %3$s, baseDataType: %4$s}", permEntityId, propKey, otClassify, baseDataType));
            List result = (List)HRMServiceHelper.invokeHRMPService((String)"haos", (String)"IHAOSStructProjectService", (String)"queryStructProConfig", (Object[])new Object[]{permEntityId, propKey, otClassify, baseDataType});
            this.getPageCache().put(CACHE_PERM_STRUCT_PROJECT_CONFIG, SerializationUtils.toJsonString((Object)result));
            return result;
        }
        return null;
    }

    private String getBaseDataType4ListView(String permEntityId, String propKey) {
        if (permEntityId != null && propKey != null) {
            ListShowParameter listParameter = (ListShowParameter)this.getView().getFormShowParameter();
            boolean isF7 = listParameter.isLookUp();
            String baseDataType = this.getBaseDataEntityFromCache(permEntityId, propKey);
            LOGGER.info(String.format("getBaseDataType4ListView find baseDataType: %1$s: ", baseDataType));
            if (baseDataType == null) {
                IDataEntityProperty property = isF7 ? (IDataEntityProperty)this.getView().getParentView().getModel().getDataEntityType().getAllFields().get(propKey) : (IDataEntityProperty)this.getView().getModel().getDataEntityType().getAllFields().get(propKey);
                if (property instanceof BasedataProp) {
                    baseDataType = ((BasedataProp)property).getBaseEntityId();
                } else if (property instanceof MulBasedataProp) {
                    baseDataType = ((MulBasedataProp)property).getBaseEntityId();
                }
            }
            return baseDataType;
        }
        return null;
    }

    private String getBaseDataType4ReportView(String permEntityId, String propKey) {
        if (permEntityId != null && propKey != null) {
            String baseDataType = this.getBaseDataEntityFromCache(permEntityId, propKey);
            if (baseDataType == null) {
                DynamicProperty property = this.getView().getParentView().getModel().getDataEntityType().getProperty(propKey);
                if (property instanceof BasedataProp) {
                    baseDataType = ((BasedataProp)property).getBaseEntityId();
                } else if (property instanceof MulBasedataProp) {
                    baseDataType = ((MulBasedataProp)property).getBaseEntityId();
                }
            }
            return baseDataType;
        }
        return null;
    }

    private AuthorizedStructResult getPermStructProject() {
        String structProjectResultString = this.getPageCache().get(CACHE_PERM_STRUCT_PROJECT);
        if (!HRStringUtils.isEmpty((String)structProjectResultString)) {
            LOGGER.info(String.format("getPermStructProject\uff1a %s ", structProjectResultString));
            return (AuthorizedStructResult)SerializationUtils.fromJsonString((String)structProjectResultString, AuthorizedStructResult.class);
        }
        Long userId = RequestContext.get().getCurrUserId();
        if (this.getView().getFormShowParameter() instanceof ListShowParameter) {
            ListShowParameter listParameter = (ListShowParameter)this.getView().getFormShowParameter();
            Boolean isF7 = listParameter.isLookUp();
            String permEntityId = listParameter.getBillFormId();
            String permItemId = "47150e89000000ac";
            if (isF7.booleanValue()) {
                permEntityId = this.getPermEntity();
                permItemId = this.getPermItem();
            }
            permEntityId = QueryEntityServiceHelper.getDataEntityNumber((String)permEntityId);
            String appId = this.getAppIdWithDealThirdApp((FormShowParameter)listParameter, permEntityId);
            String propByEntity = (String)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getOrgTreePermPropCfg", (Object[])new Object[]{permEntityId});
            LOGGER.info("getPropByEntity entityNumber:{},propKey:{}", (Object)permEntityId, (Object)propByEntity);
            String propKey = HRStringUtils.isNotEmpty((String)propByEntity) ? propByEntity : this.getPermPropKey(isF7);
            HashMap<String, Object> inParam = new HashMap<String, Object>();
            this.setIsToAllAreasParam(inParam);
            AuthorizedStructResult permResult = isF7 != false ? (AuthorizedStructResult)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getUserStructProjectsF7", (Object[])new Object[]{userId, appId, permEntityId, permItemId, propKey, inParam}) : (AuthorizedStructResult)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getUserStructProjects", (Object[])new Object[]{userId, appId, permEntityId, permItemId, propKey, inParam});
            String permResultStr = SerializationUtils.toJsonString((Object)permResult);
            this.getPageCache().put(CACHE_PERM_STRUCT_PROJECT, permResultStr);
            LOGGER.info(String.format("getPermStructProject\uff1a %s ", permResultStr));
            return permResult;
        }
        if (this.getView().getFormShowParameter() instanceof ReportShowParameter) {
            ReportShowParameter formShowParameter = (ReportShowParameter)this.getView().getFormShowParameter();
            String permEntityId = null;
            String permItemId = "47150e89000000ac";
            String propKey = this.getPropKeySupplier().get();
            permEntityId = "haos_adminorgdetail";
            String appId = this.getAppIdWithDealThirdApp((FormShowParameter)formShowParameter, permEntityId);
            Map permParams = (Map)formShowParameter.getCustomParam("permParams");
            permEntityId = QueryEntityServiceHelper.getDataEntityNumber((String)permEntityId);
            if (permParams != null) {
                permEntityId = (String)permParams.get("permEntityId");
                permItemId = (String)permParams.get("permItemId");
                appId = (String)permParams.get("appId");
                propKey = (String)permParams.get("propKey");
            }
            AuthorizedStructResult permResult = (AuthorizedStructResult)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getUserStructProjects", (Object[])new Object[]{userId, appId, permEntityId, permItemId, propKey, null});
            String permResultStr = SerializationUtils.toJsonString((Object)permResult);
            this.getPageCache().put(CACHE_PERM_STRUCT_PROJECT, permResultStr);
            LOGGER.info(String.format("getPermStructProject\uff1a %s ", permResultStr));
            return permResult;
        }
        return null;
    }

    private void setIsToAllAreasParam(Map<String, Object> inParam) {
        boolean flag = this.getBooleanCustomParam("struct_project_is_to_all_areas", false);
        if (flag) {
            inParam.put("needToAllAreasStructProject", Boolean.TRUE);
        }
    }

    @Override
    public QFilter getOtClassifyStructProjectFilter() {
        return new QFilter("otclassify.id", "=", (Object)1010L);
    }

    @Override
    public QFilter getEnableStructProjectControlFilter() {
        boolean flag = this.getBooleanCustomParam("struct_project_enable", false);
        QFilter customFilter = flag ? new QFilter("enable", "=", (Object)"1") : new QFilter("enable", "in", (Object)new String[]{"1", "0"});
        return customFilter;
    }

    @Override
    public QFilter getIsToAllAreasFilter() {
        boolean flag = this.getBooleanCustomParam("struct_project_is_to_all_areas", false);
        QFilter customFilter = flag ? null : new QFilter("istoallareas", "=", (Object)Character.valueOf('1'));
        return customFilter;
    }

    @Override
    public QFilter getStructProjectIdFilter() {
        String customParam = (String)this.getView().getFormShowParameter().getCustomParam("struct_project_ids");
        if (customParam != null) {
            LOGGER.info(String.format("getCustomStructProjectControlFilter custom param: %s", customParam));
            QFilter customFilter = null;
            try {
                List value = SerializationUtils.fromJsonStringToList((String)customParam, Long.class);
                if (value.size() != 0) {
                    customFilter = new QFilter("id", "in", (Object)value);
                }
            }
            catch (Exception ex) {
                LOGGER.error((Throwable)ex);
                LOGGER.error(String.format("getCustomStructProjectControlFilter error with param: %s", customParam));
                return null;
            }
            return customFilter;
        }
        return null;
    }

    @Override
    public Supplier<String> getPropKeySupplier() {
        return this.propKeySupplier;
    }

    @Override
    public void setPropKeySupplier(Supplier<String> propKeySupplier) {
        this.propKeySupplier = propKeySupplier;
    }

    @Override
    public void setGetStructProjectPerm(Supplier<AuthorizedStructResult> structProjectPermSupplier) {
        this.structProjectPermSupplier = structProjectPermSupplier;
    }

    @Override
    public AuthorizedStructResult getGetStructProjectPerm() {
        return this.structProjectPermSupplier.get();
    }

    private void setStructProjectVisible() {
        this.getView().setVisible(Boolean.valueOf(this.isStructProjectVisible()), new String[]{"flexstructproject"});
    }

    protected boolean isStructProjectVisible() {
        String customParam = (String)this.getView().getFormShowParameter().getCustomParam("struct_project_visible");
        if (HRStringUtils.isEmpty((String)customParam)) {
            List<Long> list = this.getStructProjectUsableList();
            Optional<Long> otherStructProjectOpt = list.stream().filter(structProjectId -> structProjectId != 0L).filter(structProjectId -> !TreeTemplateConstants.SYSTEM_STRUCT_PROJECT.contains(structProjectId)).findAny();
            return otherStructProjectOpt.isPresent();
        }
        return this.getBooleanCustomParam("struct_project_visible", false);
    }

    private List<Long> getStructProjectUsableList() {
        HRBaseServiceHelper structProjectHelper = new HRBaseServiceHelper("haos_structproject");
        DynamicObject[] structProjects = structProjectHelper.query("id", new QFilter[]{new QFilter("enable", "in", (Object)new String[]{"1", "0"})});
        return Arrays.stream(structProjects).map(structProject -> structProject.getLong("id")).collect(Collectors.toList());
    }

    private void setDefaultStructProject() {
        if (this.hasStructProjectControl()) {
            this.getModel().setValue("structproject", (Object)this.getStructProject());
            this.cacheStructProject4perm();
        }
    }

    private DynamicObject getNoControlTempStructProject() {
        if (this.noControlTempStructProject == null) {
            DynamicObject idDy = BusinessDataServiceHelper.loadSingle((String)"haos_structproject", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.getDefaultFirstStructProjectId())});
            DynamicObjectType dyType = (DynamicObjectType)((BasedataProp)EntityMetadataCache.getDataEntityType((String)"hbp_orgtreelist").getProperty("structproject")).getComplexType();
            this.noControlTempStructProject = BusinessDataServiceHelper.loadSingle((Object)idDy.get("id"), (DynamicObjectType)dyType);
        }
        this.cacheStructProject4perm(this.noControlTempStructProject.getString("id"));
        return this.noControlTempStructProject;
    }

    private DynamicObject getValidStructProject4Init() {
        if (this.structProject == null) {
            long defaultFirstStructProjectId = this.getDefaultFirstStructProjectId();
            List<QFilter> structProjectControlFilter = this.getStructProjectAllFilter();
            DynamicObject[] validStructProjects = BusinessDataServiceHelper.load((String)"haos_structproject", (String)"id", (QFilter[])structProjectControlFilter.toArray(new QFilter[0]), (String)"number");
            DynamicObjectType dyType = (DynamicObjectType)((BasedataProp)this.getModel().getProperty("structproject")).getComplexType();
            if (validStructProjects.length != 0) {
                Optional<DynamicObject> validDataHasDefaultOpt = Arrays.stream(validStructProjects).filter(dy -> dy.getLong("id") == defaultFirstStructProjectId).findAny();
                DynamicObject idDy = validDataHasDefaultOpt.orElseGet(() -> validStructProjects[0]);
                this.structProject = BusinessDataServiceHelper.loadSingle((Object)idDy.get("id"), (DynamicObjectType)dyType);
            } else {
                this.structProject = BusinessDataServiceHelper.loadSingle((Object)defaultFirstStructProjectId, (DynamicObjectType)dyType);
                LOGGER.info(String.format("getValidStructProject4Init has not been gotten valid struct, struct project id: %s", defaultFirstStructProjectId));
            }
            this.cacheStructProject4perm(this.structProject.getString("id"));
        }
        return this.structProject;
    }

    public final boolean hasStructProjectControl() {
        return this.getModel().getProperty("structproject") != null;
    }

    private void markStructProjectInitFinish() {
        this.getPageCache().put(STRUCT_PROJECT_INIT_FINISH, "true");
    }

    public final boolean isStructProjectInitFinish() {
        String structProjectInitFinish = this.getPageCache().get(STRUCT_PROJECT_INIT_FINISH);
        return structProjectInitFinish != null && Boolean.parseBoolean(structProjectInitFinish.toString());
    }

    public final boolean getBooleanCustomParam(String paramKey, boolean defaultVal) {
        boolean flag = defaultVal;
        String customParam = (String)this.getView().getFormShowParameter().getCustomParam(paramKey);
        if (customParam != null) {
            LOGGER.info(String.format("%s custom param: %s", paramKey, customParam));
            try {
                flag = Boolean.parseBoolean(customParam);
            }
            catch (Exception ex) {
                LOGGER.error((Throwable)ex);
                LOGGER.error(String.format("%s custom param error with param: %s", paramKey, customParam));
            }
        }
        return flag;
    }

    private void cacheStructProject4perm() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.getStructProject().getString("id"));
        this.getView().getPageCache().put("tree_perm_structprojectids", SerializationUtils.toJsonString(list));
    }

    private void cacheStructProject4perm(String id) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(id);
        this.getView().getPageCache().put("tree_perm_structprojectids", SerializationUtils.toJsonString(list));
    }

    private String getAppIdWithDealThirdApp(FormShowParameter showParameter, String entityNumber) {
        String entryAppId = HRPermUtil.getAppIdFromShowParam(showParameter);
        return AppIdServiceHelper.getPermAppId((String)entryAppId, (String)entityNumber);
    }

    @Override
    public IFormView getView() {
        if (this.formView == null) {
            throw new KDBizException("form view is null, please check your code.");
        }
        return this.formView;
    }

    private String getPermEntity() {
        String customEntityNumber = (String)this.getView().getFormShowParameter().getCustomParam("customHREntityNumber");
        if (HRStringUtils.isNotEmpty((String)customEntityNumber)) {
            return customEntityNumber;
        }
        return HRPermUtil.getF7ParentEntityId(this.getView());
    }

    private String getPermPropKey(Boolean isF7) {
        String propKey = (String)this.getView().getFormShowParameter().getCustomParam("custom_parent_f7_prop");
        if (isF7.booleanValue() && HRStringUtils.isNotEmpty((String)propKey)) {
            return propKey;
        }
        return this.getPropKeySupplier().get();
    }

    private String getPermItem() {
        String customPermItemId = (String)this.getView().getFormShowParameter().getCustomParam("customHRPermItemId");
        if (HRStringUtils.isNotEmpty((String)customPermItemId)) {
            return customPermItemId;
        }
        return HRPermUtil.getF7ParentPermItemId(this.getView());
    }

    protected long getOtClassify() {
        return 1010L;
    }

    private String getBaseDataEntityFromCache(String entityName, String propKey) {
        MainEntityType dataEntityType = null;
        try {
            dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityName);
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            LOGGER.error(String.format("getBaseDataEntityFromCache not found valid entity: %s", entityName));
            return null;
        }
        IDataEntityProperty property = (IDataEntityProperty)dataEntityType.getAllFields().get(propKey);
        if (property instanceof BasedataProp) {
            return ((BasedataProp)property).getBaseEntityId();
        }
        if (property instanceof MulBasedataProp) {
            return ((MulBasedataProp)property).getBaseEntityId();
        }
        return null;
    }
}

