/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.org.template;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.base.utils.msg.BaseMessage;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FloatingDirection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.IListView;
import kd.bos.list.ITreeListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.dao.IHRBaseDao;
import kd.hr.hbp.business.dao.factory.HRBaseDaoFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.org.TreeTemplateHelper;
import kd.hr.hbp.business.servicehelper.org.util.OrgTreeUtils;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.business.util.OrgServiceUtil;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.constants.org.OrgTreeSearchParam;
import kd.hr.hbp.common.constants.org.TreeTemplateConstants;
import kd.hr.hbp.common.model.AuthorizedOrgResultWithSub;
import kd.hr.hbp.common.model.AuthorizedStructResult;
import kd.hr.hbp.common.model.OrgSubInfo;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.common.util.PermCustomParamUtil;
import kd.hr.hbp.common.util.org.model.OrgTreeModel;
import kd.hr.hbp.formplugin.web.HRStandardTreeList;
import kd.hr.hbp.formplugin.web.org.structproject.StructProjectCapable;
import kd.hr.hbp.formplugin.web.org.structproject.imp.DefaultStructProjectProcessor;
import kd.hr.hbp.formplugin.web.util.perm.HRPermUtil;

@ExcludeFromJacocoGeneratedReport
public abstract class TreeListTemplateBase
extends HRStandardTreeList
implements BeforeF7SelectListener {
    protected static final Log logger = LogFactory.getLog(TreeListTemplateBase.class);
    private static final String ORG_SEARCH_NODE = "org_searchNode";
    private static final String ORG_OLD_SEARCH_TEXT = "org_oldSearchText";
    protected OrgTreeModel orgTreeModel;
    protected AuthorizedOrgResultWithSub permOrgResultWithSub;
    protected String currentVersionVal;
    protected String orgStructNumberProperty;
    protected int queryHisTreeDateCount;
    protected StringBuilder hisSubFiledFromSql = new StringBuilder();
    protected StringBuilder hisSubWhereCommonSql = new StringBuilder();
    protected StringBuilder hisSubWhereBizSql = new StringBuilder();
    String orgType;
    String rootNodeLongNumber;
    String subTreeOrderBys = "structlongnumber";
    private QFilter dataStatusAndBSedFilter;
    private QFilter orgEnableFilter;
    private Boolean isShowDisable = null;
    private Map<String, Boolean> orgSubStructLongNumberPermMap;
    String dynParentProperty;
    private String orgIdProperty;
    private QFilter curTreeBizQFilter;
    private List<String> allPermLongNumberList;
    private StructProjectCapable structProjectCapable;
    private String originallyF7ProKey;
    private Boolean conditionalOrgAndCacheResult;
    AuthorizedOrgResultWithSub dateChgPermResult;
    DynamicObject rootNodeDynamicObj;
    protected QFilter hisListDataStatusBSedFilter;

    public TreeListTemplateBase(OrgTreeModel orgTreeModel, String orgType, String dynParentProperty, String orgIdProperty) {
        super(orgTreeModel.getEntityName(), orgTreeModel.isIncludeChild());
        this.orgTreeModel = orgTreeModel;
        this.orgType = orgType;
        this.dynParentProperty = dynParentProperty;
        this.orgIdProperty = orgIdProperty;
        orgTreeModel.setOrgType(this.orgType);
        this.setRootId("100000");
        orgTreeModel.setInitStatus("2");
        this.structProjectCapable = new DefaultStructProjectProcessor();
    }

    private static void orgTreeNodeClick(OrgTreeSearchParam searchParam) {
        TreeView treeView = searchParam.getTreeView();
        TreeNode rootNode = searchParam.getRootNode();
        if (!rootNode.getId().equals(treeView.getTreeState().getFocusNodeId())) {
            treeView.uncheckNodes(treeView.getTreeState().getSelectedNodeId());
            treeView.treeNodeClick(rootNode.getParentid(), rootNode.getId());
            TreeListTemplateBase.focusNodeAfterSearch(searchParam, rootNode);
        }
    }

    public static void focusNodeAfterSearch(OrgTreeSearchParam searchParam, TreeNode node) {
        searchParam.getTreeView().focusNode(node);
        IFormView formView = searchParam.getFormView();
        if (formView instanceof ListView) {
            ITreeListView treeListView = ((ListView)formView).getTreeListView();
            treeListView.getTreeModel().setCurrentNodeId((Object)node.getId());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if ("kd.bos.form.operate.formop.Refresh".equals(args.getSource().getClass().getName())) {
            AuthorizedOrgResultWithSub oldPermOrgResult = null;
            if ("adminOrg".equals(this.orgTreeModel.getOrgType())) {
                oldPermOrgResult = this.getPermOrgResultWithSub();
            }
            TreeTemplateHelper.removeRootAndStructLongNumberCache((IPageCache)this.getPageCache());
            this.permOrgResultWithSub = null;
            if ("adminOrg".equals(this.orgTreeModel.getOrgType()) && oldPermOrgResult != null) {
                this.refreshPerChgRebuildTree(oldPermOrgResult);
            }
            this.queryConditionalOrgAndCache();
            TreeView treeView = this.getTreeListView().getTreeView();
            Object currentNodeId = this.getTreeModel().getCurrentNodeId();
            String focusNodeId = treeView.getTreeState().getFocusNodeId();
            if (!(StringUtils.isEmpty((CharSequence)focusNodeId) || ObjectUtils.isEmpty((Object)currentNodeId) || focusNodeId.equals(currentNodeId.toString()))) {
                TreeNode treeNode = this.getTreeModel().getRoot().getTreeNode(focusNodeId, 20);
                if (treeNode != null) {
                    treeView.treeNodeClick(treeNode.getParentid(), treeNode.getId());
                } else {
                    TreeNode root = this.getTreeModel().getRoot();
                    if (root != null) {
                        treeView.treeNodeClick(root.getParentid(), root.getId());
                    }
                }
            }
            this.getView().getFormShowParameter().setCustomParam("refresh", (Object)"refresh");
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void refreshPerChgRebuildTree(AuthorizedOrgResultWithSub oldPermOrgResult) {
        List permOrgWithSub = oldPermOrgResult.getHasPermOrgsWithSub();
        AuthorizedOrgResultWithSub permOrgResultWithSubNew = this.getPermOrgResultWithSub();
        if (permOrgResultWithSubNew.isHasAllOrgPerm() && oldPermOrgResult.isHasAllOrgPerm()) {
            return;
        }
        if (ObjectUtils.isEmpty((Object)permOrgWithSub)) {
            return;
        }
        HashMap<Long, Boolean> map = new HashMap<Long, Boolean>(permOrgWithSub.size());
        for (OrgSubInfo orgSubInfo : permOrgWithSub) {
            Long orgId = orgSubInfo.getOrgId();
            Boolean isContainSub = (Boolean)map.get(orgId);
            if (isContainSub != null && isContainSub.booleanValue()) continue;
            map.put(orgSubInfo.getOrgId(), orgSubInfo.isContainsSub());
        }
        List permOrgWithSubNew = permOrgResultWithSubNew.getHasPermOrgsWithSub();
        if (ObjectUtils.isEmpty(map) && ObjectUtils.isEmpty((Object)permOrgWithSubNew)) {
            return;
        }
        if (ObjectUtils.isEmpty(map) || ObjectUtils.isEmpty((Object)permOrgWithSubNew) || map.size() != permOrgWithSubNew.size()) {
            this.rebuildTreeNode();
        } else {
            for (OrgSubInfo orgSubInfo : permOrgWithSubNew) {
                if (null == map.get(orgSubInfo.getOrgId())) {
                    this.rebuildTreeNode();
                    break;
                }
                if (orgSubInfo.isContainsSub() == ((Boolean)map.get(orgSubInfo.getOrgId())).booleanValue()) continue;
                this.rebuildTreeNode();
                break;
            }
        }
    }

    public void setView(IFormView formView) {
        super.setView(formView);
        this.getStructProjectCapable().wrapView(this.getView());
        this.getStructProjectCapable().setPropKeySupplier(() -> {
            if (this.isCurrentViewF7()) {
                return this.getParentF7PropWrap((ListShowParameter)this.getView().getFormShowParameter());
            }
            return this.getListPermProKey();
        });
        this.getStructProjectCapable().setGetStructProjectPerm(this::getPermStructProject);
    }

    private boolean isCurrentViewF7() {
        return ((ListShowParameter)this.getView().getFormShowParameter()).isLookUp();
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        this.setStructProjectCache2ParentView();
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        super.listRowDoubleClick(evt);
        this.setStructProjectCache2ParentView();
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{"btntreefilter"});
        this.addClickListeners(new String[]{"chkshowdisable"});
        this.addClickListeners(new String[]{"btnok"});
        this.getStructProjectCapable().registerListener(eventObject);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        this.getStructProjectCapable().beforeF7Select(beforeF7SelectEvent);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getStructProjectCapable().afterBindData(e);
    }

    public void afterCreateNewData(EventObject e) {
        this.getStructProjectCapable().afterCreateNewData(e);
    }

    @Override
    public TreeNode getRootNode() {
        logger.info("getRootNode begin");
        this.getStructProjectCapable().getStructProject();
        this.setStructProjectParam4Perm();
        IPageCache pageCache = this.getPageCache();
        String rootNodeStr = pageCache.get("org_root_node");
        if (!StringUtils.isEmpty((CharSequence)rootNodeStr)) {
            TreeNode rootTreeNode = (TreeNode)SerializationUtils.fromJsonString((String)rootNodeStr, TreeNode.class);
            return rootTreeNode;
        }
        String text = "";
        text = this.getStructProjectCapable().getStructProject().getLong("id") == 1010L ? ResManager.loadKDString((String)"\u672a\u521d\u59cb\u5316\u6839\u7ec4\u7ec7", (String)"TreeListTemplateBase_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7ec4\u7ec7\u8303\u56f4\u672a\u5206\u914d\u3002", (String)"TreeListTemplateBase_4", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]);
        TreeNode rootNode = new TreeNode("", "0", text, (Object)"0");
        DynamicObject rootNodeDynamicObj = this.getRootDynamicObject();
        if (rootNodeDynamicObj != null && this.getDefinedDyVsCustomNode().containsKey(rootNodeDynamicObj.getLong("id"))) {
            return this.getDefinedDyVsCustomNode().get(rootNodeDynamicObj.getLong("id")).get();
        }
        this.encapsulateRootNode(rootNode, rootNodeDynamicObj);
        this.rootNodeLongNumber = rootNode.getLongNumber();
        pageCache.put("org_root_node", SerializationUtils.toJsonString((Object)rootNode));
        logger.info(String.format("getRootNode end with root id: %s", rootNode.getId()));
        return rootNode;
    }

    protected void setStructProjectParam4Perm() {
        String propKey;
        ListShowParameter listParameter = (ListShowParameter)this.getView().getFormShowParameter();
        boolean isF7 = listParameter.isLookUp();
        if (isF7) {
            propKey = this.getParentF7PropWrap(listParameter);
            PermCustomParamUtil.setStructProjectParam((IFormView)this.getView(), (String)this.getParentF7PropWrap(listParameter), this.getStructProjectIdsFromCache());
        } else {
            propKey = this.getListPermProKey();
        }
        logger.info(String.format("setStructProjectParam4Perm propKey: %s", propKey));
        PermCustomParamUtil.setStructProjectParam((IFormView)this.getView(), (String)propKey, this.getStructProjectIdsFromCache());
    }

    protected Map<Long, Supplier<TreeNode>> getDefinedDyVsCustomNode() {
        return Collections.emptyMap();
    }

    protected DynamicObject getRootDynamicObjectByCommonParentSLN(String commonParentStructLongNumber) {
        return null;
    }

    @Override
    public DynamicObject getRootDynamicObject() {
        if (!this.orgTreeModel.isFilterTreePerm()) {
            return this.getRootNodeDyn();
        }
        if ("orgTeam".equals(this.orgTreeModel.getOrgType()) ? this.getPermOrgTeamResult().isHasAllOrgPerm() : this.getPermOrgResultWithSub().isHasAllOrgPerm()) {
            return this.getRootNodeDyn();
        }
        if (!this.orgTreeModel.isHisTree() || this.orgTreeModel.isHisTree() && this.isCurNowDate()) {
            QFilter orgTreeFilter;
            QFilter permFilter = "orgTeam".equals(this.orgTreeModel.getOrgType()) ? new QFilter("orgteam.id", "in", this.getPermOrgTeamIdResult()) : TreeTemplateHelper.getOrgAndSubInPermFilter((AuthorizedOrgResultWithSub)this.getPermOrgResultWithSub(), (String)this.orgIdProperty);
            DynamicObject rootNodeDynamicObj = this.getCurVerTreeNodeDynInPerm(permFilter, orgTreeFilter = this.getOrgRootTreeFilter());
            if (null == rootNodeDynamicObj && this.getStructProjectCapable().getStructProject().getLong("id") == 1010L) {
                return this.getRootDynByRootId();
            }
            this.resetHisDynVidBySourceId(rootNodeDynamicObj);
            return rootNodeDynamicObj;
        }
        QFilter structLongNumberAndSubFilter = TreeTemplateHelper.getOrgAndSubInPermFilter((AuthorizedOrgResultWithSub)this.getPermOrgResultWithSub(), (String)this.orgIdProperty);
        DynamicObject rootNodeDynamicObj = this.getHisTreeRootNodeDynInPerm(structLongNumberAndSubFilter);
        if (null == rootNodeDynamicObj && this.getStructProjectCapable().getStructProject().getLong("id") == 1010L) {
            rootNodeDynamicObj = this.getRootDynByRootId();
        }
        return rootNodeDynamicObj;
    }

    protected void resetHisDynVidBySourceId(DynamicObject orgDynObj) {
        if (this.orgTreeModel.isHisTree() && this.orgTreeModel.isCurNowDate()) {
            this.setOrgDynFiledId(orgDynObj);
        }
    }

    protected void resetHisSubVidBySourceId(DynamicObjectCollection dynCol) {
        if (this.orgTreeModel.isHisTree() && this.isCurNowDate()) {
            dynCol.forEach(this::setOrgDynFiledId);
        }
    }

    private void setOrgDynFiledId(DynamicObject dyn) {
        dyn.set("id", (Object)dyn.getLong("sourcevid"));
        dyn.set("parentorg", (Object)dyn.getLong("psourcevid"));
    }

    protected DynamicObject getCurVerTreeNodeDynInPerm(QFilter permFilter, QFilter commonFilter) {
        return null;
    }

    protected abstract DynamicObject getRootDynByRootId();

    protected DynamicObject getRootNodeDyn() {
        return null;
    }

    public DynamicObject getCurTreeRootNodeDyn(String selectFields) {
        QFilter orgTreeFilter = this.getOrgRootTreeFilter();
        if (orgTreeFilter == null) {
            return this.getRootDynByRootId();
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(this.getEntityName());
        DynamicObject[] dynamicObjects = serviceHelper.queryOriginalArray("structlongnumber", new QFilter[]{orgTreeFilter});
        if (null == dynamicObjects || 1 > dynamicObjects.length) {
            return this.getRootDynByRootId();
        }
        String commonParentStructLongNumber = TreeTemplateHelper.getParentOrgStructLongNumberByOrgArray((DynamicObject[])dynamicObjects);
        QFilter[] filters = new QFilter[]{new QFilter("structlongnumber", "=", (Object)commonParentStructLongNumber), this.getDataStatusAndBSedFilter()};
        return serviceHelper.queryOriginalOne(selectFields, filters);
    }

    protected DynamicObject getHisTreeRootNodeDynInPerm(QFilter structLongNumberFilter) {
        return null;
    }

    @Override
    public void refreshNode(RefreshNodeEvent refreshNodeEvent) {
        String nodeId = refreshNodeEvent.getNodeId().toString();
        Object refreshNodeId = refreshNodeEvent.getNodeId();
        Object currentNodeId = this.getTreeModel().getCurrentNodeId();
        TreeNode rootNode = this.getTreeModel().getRoot();
        if (!refreshNodeId.equals(currentNodeId)) {
            ITreeListView treeListView = this.getTreeListView();
            TreeView treeView = treeListView.getTreeView();
            treeView.uncheckNodes(treeView.getTreeState().getSelectedNodeId());
            TreeNode node = OrgTreeUtils.getNode((TreeNode)rootNode, (Object)refreshNodeId);
            treeView.focusNode(node);
            treeListView.getTreeModel().setCurrentNodeId((Object)node.getId());
        }
        TreeNode node = this.getTreeModel().getRoot().getTreeNode(nodeId, 20);
        List<Object> childNodes = Lists.newArrayListWithCapacity((int)2);
        if (!HRStringUtils.equals((String)nodeId, (String)"-1")) {
            List curNodeChildren = node.getChildren();
            Object refreshObj = this.getView().getFormShowParameter().getCustomParam("refresh");
            childNodes = !ObjectUtils.isEmpty((Object)curNodeChildren) && refreshObj == null ? curNodeChildren : this.getChildNodesWrap(this.getEntityName(), nodeId);
        }
        if (!CollectionUtils.isEmpty((Collection)childNodes)) {
            node.setIsOpened(true);
        }
        if (!HRStringUtils.equals((String)rootNode.getId(), (String)"999999999") && HRStringUtils.equals((String)nodeId, (String)rootNode.getId()) && this.getPageCache().get("do_not_have_parent_org_structlongnumber") != null) {
            childNodes.add(this.parentVirtualNode(nodeId));
        }
        refreshNodeEvent.setChildNodes((List)childNodes);
    }

    @Override
    public List<Map<String, String>> getTreeViewByParentId(String entityName, String currentNodeId) {
        DynamicObjectCollection dyColl = this.getTreeViewCollection(entityName, currentNodeId);
        return this.encapsulationTreeMap(dyColl);
    }

    public List<Map<String, String>> encapsulationTreeMap(DynamicObjectCollection dyColl) {
        ArrayList list = Lists.newArrayList();
        if (CollectionUtils.isEmpty((Collection)dyColl)) {
            return list;
        }
        String parent = "parent";
        if ("adminOrg".equals(this.orgType)) {
            parent = "parentorg";
        } else if ("orgTeam".equals(this.orgType)) {
            parent = "parentorgteam";
        }
        for (DynamicObject dyn : dyColl) {
            HashMap map = Maps.newHashMap();
            map.put("id", dyn.getString("id"));
            map.put("boid", dyn.getString("boid"));
            map.put("name", dyn.getString("name"));
            map.put("enable", dyn.getString("enable"));
            map.put("parent", dyn.getString(parent));
            map.put("isleaf", dyn.getBoolean("isleaf") ? "1" : "0");
            map.put("longnumber", dyn.getString("structlongnumber"));
            map.put("tobedisableflag", dyn.containsProperty("tobedisableflag") ? dyn.getString("tobedisableflag") : "");
            if (dyn.containsProperty("isvirtualorg")) {
                map.put("isvirtualorg", dyn.getBoolean("isvirtualorg") ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
            }
            this.encapsulationOrgTreeOtherFiled(map, dyn);
            list.add(map);
        }
        return list;
    }

    protected void encapsulationOrgTreeOtherFiled(Map<String, String> dataMap, DynamicObject colDyn) {
    }

    @Override
    public DynamicObjectCollection getTreeViewCollection(String entityName, String currentNodeId) {
        DynamicObjectCollection treeViewDynObjColl;
        TreeNode currentNode = OrgTreeUtils.getNode((TreeNode)this.getTreeModel().getRoot(), (Object)currentNodeId);
        long startTime = System.currentTimeMillis();
        logger.info("TreeListTemplateBase.getTreeViewCollection,currentNodeId={}", (Object)currentNodeId);
        if (currentNode == null) {
            logger.info("TreeListTemplateBase.getTreeViewCollection, currentNode is null");
            return null;
        }
        String currentStructLongNumber = currentNode.getLongNumber();
        if (!"999999999".equals(currentNode.getId()) && StringUtils.isEmpty((CharSequence)currentStructLongNumber)) {
            return null;
        }
        if (!this.orgTreeModel.isHisTree() || this.orgTreeModel.isHisTree() && this.isCurNowDate()) {
            QFilter treeViewStructNumberFilter = this.getTreeViewStructNumberFilter(currentStructLongNumber);
            treeViewDynObjColl = this.queryCurTreeViewDynamicCollection(new QFilter[]{this.getCurTreeBizCommonQFilter(), treeViewStructNumberFilter});
            this.resetHisSubVidBySourceId(treeViewDynObjColl);
        } else {
            Date dateParam = this.getDateParam();
            if (null == dateParam) {
                dateParam = new Date();
            }
            ArrayList treeViewStructNumberList = null;
            if (HRStringUtils.equals((String)"-1", (String)currentNodeId)) {
                treeViewDynObjColl = new DynamicObjectCollection();
            } else if (HRStringUtils.equals((String)"0", (String)currentNodeId)) {
                treeViewDynObjColl = new DynamicObjectCollection();
            } else {
                if (HRStringUtils.equals((String)currentNodeId, (String)"999999999")) {
                    String doNotHaveParentOrgStructLongNumbers = this.getPageCache().get("do_not_have_parent_org_structlongnumber");
                    treeViewStructNumberList = Lists.newArrayList((Iterable)((Set)SerializationUtils.fromJsonString((String)doNotHaveParentOrgStructLongNumbers, Set.class)));
                } else {
                    treeViewStructNumberList = this.getHisTreeViewStructNumberFilter(currentStructLongNumber);
                }
                treeViewDynObjColl = this.queryHisTreeViewDynamicCollection(treeViewStructNumberList, dateParam);
            }
        }
        this.setOrgLeaf(treeViewDynObjColl, this.dynParentProperty);
        logger.info("TreeListTemplateBase.getTreeViewCollection,currentNodeId={},cost={}", (Object)currentNodeId, (Object)(System.currentTimeMillis() - startTime));
        return treeViewDynObjColl;
    }

    public void setOrgLeaf(DynamicObjectCollection dynObjCol, String dynParentProperty) {
        if (dynObjCol == null) {
            return;
        }
        HashMap<Long, DynamicObject> notLeafDynMap = new HashMap<Long, DynamicObject>();
        for (DynamicObject dyn2 : dynObjCol) {
            notLeafDynMap.put(dyn2.getLong("boid"), dyn2);
        }
        Map<Long, DynamicObject> queryChildDynMap = this.getNeedQueryToSetLeafDynMap(notLeafDynMap);
        DynamicObjectCollection childDynCol = this.getCurChildDynCol(queryChildDynMap.keySet());
        if (childDynCol == null) {
            for (DynamicObject dyn3 : notLeafDynMap.values()) {
                dyn3.set("isleaf", (Object)Boolean.TRUE);
            }
        } else {
            Map<Long, List<DynamicObject>> curOrgGroupParentCol = childDynCol.stream().collect(Collectors.groupingBy(dyn -> dyn.getLong(dynParentProperty)));
            Set<Map.Entry<Long, DynamicObject>> curOrgColEntry = queryChildDynMap.entrySet();
            for (Map.Entry<Long, DynamicObject> curOrgMap : curOrgColEntry) {
                Long curOrgId = curOrgMap.getKey();
                DynamicObject curOrgDyn = curOrgMap.getValue();
                List<DynamicObject> childDynList = curOrgGroupParentCol.get(curOrgId);
                if (ObjectUtils.isEmpty(childDynList)) {
                    curOrgDyn.set("isleaf", (Object)Boolean.TRUE);
                    continue;
                }
                curOrgDyn.set("isleaf", (Object)Boolean.FALSE);
            }
        }
    }

    @Override
    protected void setLazyNodeLeafChildren(TreeNode node) {
        if (node == null) {
            return;
        }
        if (!node.isLeaf() && node.getChildren() == null) {
            node.addChildren(new ArrayList(0));
        }
    }

    public Map<Long, DynamicObject> getNeedQueryToSetLeafDynMap(Map<Long, DynamicObject> notLeafDynMap) {
        HashMap<Long, DynamicObject> queryChildDynMap = new HashMap<Long, DynamicObject>();
        if (ObjectUtils.isEmpty(notLeafDynMap)) {
            return queryChildDynMap;
        }
        ArrayList<DynamicObject> notIsLeafDynList = new ArrayList<DynamicObject>(notLeafDynMap.values());
        if (this.orgTreeModel.isFilterTreePerm() && !this.isHasAllOrgPerm()) {
            if ("orgTeam".equals(this.orgTreeModel.getOrgType())) {
                queryChildDynMap.putAll(notLeafDynMap);
            } else {
                for (DynamicObject dyn : notIsLeafDynList) {
                    queryChildDynMap.put(dyn.getLong("boid"), dyn);
                }
            }
        } else {
            queryChildDynMap.putAll(notLeafDynMap);
        }
        return queryChildDynMap;
    }

    protected boolean isHasAllOrgPerm() {
        boolean isHasAllOrgPerm = "orgTeam".equals(this.orgTreeModel.getOrgType()) ? this.getPermOrgTeamResult().isHasAllOrgPerm() : this.getPermOrgResultWithSub().isHasAllOrgPerm();
        return isHasAllOrgPerm;
    }

    @ExcludeFromJacocoGeneratedReport
    private boolean isContainWithPermByLongNumberOrBOId(DynamicObject dyn) {
        Set<Map.Entry<String, Boolean>> orgSubStructPerm = this.getOrgSubStructLongNumberPermMap().entrySet();
        for (Map.Entry<String, Boolean> orgStructPermMap : orgSubStructPerm) {
            String orgPermLongNumber = orgStructPermMap.getKey();
            Boolean isContainSubPerm = orgStructPermMap.getValue();
            if (!isContainSubPerm.booleanValue() || !dyn.getString("structlongnumber").startsWith(orgPermLongNumber)) continue;
            return true;
        }
        QFilter permStructLongNumberFilter = TreeTemplateHelper.getPermStructLongNumberFilter((AuthorizedOrgResultWithSub)this.permOrgResultWithSub, (String)this.orgIdProperty);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(this.getEntityName());
        DynamicObjectCollection originalDynColl = serviceHelper.queryOriginalCollection(this.orgIdProperty, permStructLongNumberFilter.toArray());
        Set adminOrgBOIdSet = originalDynColl.stream().map(originalDyn -> originalDyn.getLong(this.orgIdProperty)).collect(Collectors.toSet());
        return adminOrgBOIdSet.contains(dyn.getLong("boid"));
    }

    protected abstract DynamicObjectCollection getCurChildDynCol(Set<Long> var1);

    public void search(SearchEnterEvent evt) {
        if (!StringUtils.isBlank((CharSequence)evt.getText())) {
            OrgTreeSearchParam searchParam = new OrgTreeSearchParam(evt.getText(), (ListView)this.getView());
            searchParam.setClickNode(true);
            this.searchFromLazyOrgTree(searchParam);
        }
    }

    public void propertyChanged(PropertyChangedArgs changedArgs) {
        String propertyName = changedArgs.getProperty().getName();
        if ("chkincludechild".equals(propertyName)) {
            TreeTemplateHelper.removeRootAndStructLongNumberCache((IPageCache)this.getPageCache());
            this.queryConditionalOrgAndCache();
            Object currentNodeId = this.getTreeModel().getCurrentNodeId();
            if (StringUtils.isNotBlank((Object)currentNodeId)) {
                String curNodeIdStr = currentNodeId.toString();
                TreeNode currentTreeNode = this.getTreeModel().getRoot().getTreeNode(curNodeIdStr, 20);
                this.treeListView.getTreeView().treeNodeClick(currentTreeNode.getParentid(), curNodeIdStr);
            }
        } else if ("searchdate".equals(propertyName)) {
            TreeTemplateHelper.removeRootAndStructLongNumberCache((IPageCache)this.getPageCache());
            IListView iListView = (IListView)this.getView();
            ITreeListView adminOrgTreeView = iListView.getTreeListView();
            ITreeModel treeModel = adminOrgTreeView.getTreeModel();
            TreeView treeView = adminOrgTreeView.getTreeView();
            String rootId = adminOrgTreeView.getTreeModel().getRoot().getId();
            TreeNode treeNode = treeModel.refreshNode((Object)rootId);
            if (treeNode != null) {
                treeView.updateNode(treeNode);
                treeView.focusNode(treeNode);
                treeView.treeNodeClick(treeNode.getParentid(), rootId);
            }
        } else if ("structproject".equals(propertyName)) {
            ChangeData changeData = changedArgs.getChangeSet()[0];
            if (changeData.getNewValue() == null) {
                this.getModel().setValue("structproject", changeData.getOldValue());
                return;
            }
            TreeTemplateHelper.removeRootAndStructLongNumberCache((IPageCache)this.getPageCache());
            this.getStructProjectCapable().propertyChanged(changedArgs);
            this.rebuildTreeNode();
            this.getView().updateView();
        }
    }

    protected DynamicObjectCollection queryCurTreeViewDynamicCollection(QFilter[] qFilters) {
        return null;
    }

    protected DynamicObjectCollection queryHisTreeViewDynamicCollection(List<String> treeViewStructNumberList, Date queryDate) {
        return null;
    }

    protected abstract List<String> getAllPermissionStructLongNumbers();

    protected String getOrgParentStructLongNumberQueryFields() {
        return "";
    }

    protected void encapsulateRootNode(TreeNode rootNode, DynamicObject dynamicObject) {
        if (dynamicObject == null) {
            return;
        }
        TreeTemplateHelper.encapsulateRootOrgTeamNode((TreeNode)rootNode, (DynamicObject)dynamicObject, (OrgTreeModel)this.orgTreeModel);
        this.treeNodeIcon(rootNode, dynamicObject);
        this.resetOrgNameByEnableInfo(rootNode, dynamicObject);
    }

    protected void treeNodeIcon(TreeNode treeNode, DynamicObject dynamicObject) {
    }

    protected void treeNodeIcon(TreeNode treeNode, Map<String, String> map) {
    }

    protected abstract void queryTreeNodeChildrenByStructNumbers(OrgTreeSearchParam var1, List<String> var2, TreeNode var3);

    private List<TreeNode> searchTreeNode(OrgTreeSearchParam searchParam) {
        if (!this.orgTreeModel.isHisTree()) {
            return this.searchCurTreeNode(searchParam.getSearchText(), this.getSearchTreeStructFilter());
        }
        return this.searchHisTreeNode(searchParam.getSearchText());
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control control = (Control)evt.getSource();
        if ("btnok".equals(control.getKey().toLowerCase(Locale.ROOT))) {
            this.setStructProjectCache2ParentView();
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if ("btntreefilter".equals(control.getKey().toLowerCase(Locale.ROOT))) {
            if (this.isShowDisableAndSearchDate()) {
                this.showSearchDateAndIsShowDisableFormWindow();
            } else {
                FormShowParameter formShowParameter = this.showAdminOrgTreeFilterDialog();
                if (formShowParameter == null) {
                    return;
                }
                String chkShowDisable = this.getPageCache().get("chkshowdisable");
                formShowParameter.setCustomParam("chkshowdisable", (Object)chkShowDisable);
                this.getView().showForm(formShowParameter);
            }
        }
    }

    private void showSearchDateAndIsShowDisableFormWindow() {
        FormShowParameter formShowParameter = new FormShowParameter();
        OpenStyle openStyle = formShowParameter.getOpenStyle();
        openStyle.setShowType(ShowType.Floating);
        openStyle.setFloatingDirection(FloatingDirection.RightCenter);
        openStyle.setTargetKey("btntreefilter");
        formShowParameter.setFormId("hbp_treequerycriteria");
        String chkShowDisable = this.getPageCache().get("chkshowdisable");
        formShowParameter.setCustomParam("chkshowdisable", (Object)(chkShowDisable == null ? String.valueOf(Boolean.FALSE) : chkShowDisable));
        String cachedSearchDate = this.getView().getPageCache().get("searchdate");
        formShowParameter.setCustomParam("searchdate", (Object)(cachedSearchDate == null ? KDDateUtils.today() : HRDateTimeUtils.localDate2Date((LocalDate)((LocalDate)JSON.parseObject((String)cachedSearchDate, LocalDate.class)))));
        formShowParameter.setCloseCallBack(new CloseCallBack(this.getPluginName(), "btntreefilter"));
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String treeConditionChanged;
        if (closedCallBackEvent.getActionId().equals("btntreefilter") && HRStringUtils.equals((String)(treeConditionChanged = this.getView().getPageCache().get("treeConditionChanged")), (String)"true")) {
            this.getView().getFormShowParameter().getCustomParams().put("searchdate", this.getDateParam());
            this.getView().getPageCache().remove("treeConditionChanged");
            this.rebuildTreeNode();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
    }

    private void setStructProjectCache2ParentView() {
        if (this.isCurrentViewF7()) {
            String parentPageId = this.getView().getFormShowParameter().getParentPageId();
            IFormView parentView = this.getView().getViewNoPlugin(parentPageId);
            if (parentView != null) {
                String controlKey = this.getView().getFormShowParameter().getCloseCallBack().getControlKey();
                parentView.getPageCache().put("current_orgscheme_type_" + controlKey, this.getStructProjectCapable().getStructProject().getString("id"));
            }
        }
    }

    protected boolean isShowDisableAndSearchDate() {
        return false;
    }

    public FormShowParameter showAdminOrgTreeFilterDialog() {
        FormShowParameter formShowParameter = new FormShowParameter();
        OpenStyle openStyle = formShowParameter.getOpenStyle();
        openStyle.setShowType(ShowType.Floating);
        openStyle.setFloatingDirection(FloatingDirection.RightCenter);
        openStyle.setTargetKey("btntreefilter");
        StyleCss cssValue = new StyleCss();
        cssValue.setWidth("140px");
        cssValue.setHeight("50px");
        openStyle.setInlineStyleCss(cssValue);
        formShowParameter.setFormId("hbp_orgtreefiter");
        formShowParameter.setCloseCallBack(new CloseCallBack(this.getPluginName(), "btntreefilter"));
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u663e\u793a\u7981\u7528", (String)"TreeListTemplateBase_0", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
        return formShowParameter;
    }

    protected void resetOrgNameByEnableInfo(TreeNode node, Map<String, String> nodeMap) {
    }

    protected void resetOrgNameByEnableInfo(TreeNode node, DynamicObject dyn) {
    }

    protected abstract QFilter getSearchTreeStructFilter();

    protected abstract List<String> getSearchTreeStructNumberList();

    protected abstract List<TreeNode> searchCurTreeNode(String var1, QFilter var2);

    protected abstract List<TreeNode> searchHisTreeNode(String var1);

    protected List<TreeNode> getSearchNodesBySearchId(Long searchIdVal) {
        return null;
    }

    protected List<TreeNode> getHisTreeSearchDynCol(Long searchIdVal, String parentProperty, int queryDateCount, String orderBys) {
        StringBuilder sqlStr = this.getHisSubTreeQuerySql();
        sqlStr.append(" AND A.fid = ? ");
        List<Object> paramList = this.getHisSubTreeQueryParamList(queryDateCount);
        paramList.add(searchIdVal);
        DynamicObjectCollection retDynCol = TreeTemplateHelper.getHisAdminOrgDynCol((StringBuilder)sqlStr, paramList, (String)"hbp_getAdminOrgHisTreeSearchDynCol");
        OrgTreeUtils.sortDynColsOrderBys((DynamicObjectCollection)retDynCol, (String)orderBys);
        return OrgTreeUtils.buildSearchTreeNodeList((DynamicObjectCollection)retDynCol, (String)parentProperty);
    }

    public void listRowClick(ListRowClickEvent evt) {
        evt.setCancel(true);
        if (evt.getCurrentListSelectedRow() != null) {
            Long curNodeId = this.getCurNodeIdByRowClick(evt);
            if (curNodeId == null || curNodeId == 0L) {
                return;
            }
            String orgId = curNodeId.toString();
            String focusNodeId = this.treeListView.getTreeView().getTreeState().getFocusNodeId();
            OrgTreeSearchParam searchParam = new OrgTreeSearchParam(curNodeId, (ListView)this.getView());
            if (!orgId.equals(focusNodeId)) {
                TreeNode rootNode = this.getTreeModel().getRoot();
                TreeNode treeNode = rootNode.getTreeNode(orgId, 20);
                TreeView treeView = this.getTreeListView().getTreeView();
                if (treeNode != null) {
                    this.focusNode(treeView, rootNode, treeNode);
                    this.treeListView.getTreeModel().setCurrentNodeId((Object)treeNode.getId());
                } else {
                    searchParam.setTreeView(this.getTreeListView().getTreeView());
                    searchParam.setSearchById(true);
                    searchParam.setClickNode(true);
                    List<TreeNode> treeNodes = this.getSearchNodesBySearchId(curNodeId);
                    this.searchFromLazyOrgTree(searchParam, treeNodes, true);
                }
            } else {
                HashSet loopController = Sets.newHashSetWithExpectedSize((int)16);
                ArrayList expendIds = Lists.newArrayListWithCapacity((int)16);
                OrgTreeUtils.expandParentNode((OrgTreeSearchParam)searchParam, (String)focusNodeId, (Set)loopController, (List)expendIds, (int)0);
            }
            String currentFocusNodeId = this.treeListView.getTreeView().getTreeState().getFocusNodeId();
            boolean isFocusRootNode = false;
            TreeNode rootNode = this.getTreeModel().getRoot();
            if (StringUtils.isBlank((Object)currentFocusNodeId)) {
                isFocusRootNode = true;
            } else {
                TreeNode currentNode = OrgTreeUtils.getNode((TreeNode)rootNode, (Object)currentFocusNodeId);
                if (currentNode == null) {
                    isFocusRootNode = true;
                } else {
                    this.treeListView.getTreeView().focusNode(currentNode);
                    this.treeListView.getTreeModel().setCurrentNodeId((Object)currentNode.getId());
                }
            }
            if (isFocusRootNode) {
                this.treeListView.getTreeView().focusNode(rootNode);
                this.treeListView.getTreeModel().setCurrentNodeId((Object)rootNode.getId());
            }
        }
    }

    private void focusNode(TreeView treeView, TreeNode rootNode, TreeNode treeNode) {
        this.expandParents(treeView, rootNode, treeNode);
        treeView.showNode(treeNode.getParentid());
        treeView.focusNode(treeNode);
    }

    private void expandParents(TreeView treeView, TreeNode rootNode, TreeNode node) {
        String parentId = node.getParentid();
        if (StringUtils.isNotBlank((CharSequence)parentId)) {
            TreeNode p = rootNode.getTreeNode(parentId, 20);
            if (p != null) {
                this.expandParents(treeView, rootNode, p);
                treeView.expand(parentId);
                if (p == rootNode) {
                    treeView.updateNode(node);
                }
            } else {
                treeView.updateNode(node);
            }
        } else {
            treeView.updateNode(node);
        }
    }

    protected Long getCurNodeIdByRowClick(ListRowClickEvent evt) {
        Long pkId;
        IHRBaseDao bizDao;
        DynamicObject dyn;
        String listPermProKey = this.getListPermProKey();
        if (!StringUtils.isEmpty((CharSequence)listPermProKey) && (dyn = (bizDao = HRBaseDaoFactory.getInstance((String)this.getListEntityNumber())).queryOne(listPermProKey, (Object)(pkId = Long.valueOf(evt.getCurrentListSelectedRow().getPrimaryKeyValue().toString())))) != null) {
            return dyn.getLong(listPermProKey + ".id");
        }
        return null;
    }

    protected Date getDateParam() {
        return null;
    }

    protected QFilter getOrgEnableFilter() {
        this.orgEnableFilter = new QFilter("enable", "=", (Object)"1");
        if (this.isShowDisable()) {
            QFilter disableFilter = new QFilter("enable", "=", (Object)"0");
            this.orgEnableFilter.or(disableFilter);
        }
        return this.orgEnableFilter;
    }

    protected QFilter getOrgTreeEnableFilter() {
        return this.getOrgEnableFilter();
    }

    protected QFilter getDataStatusAndBSedFilter() {
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)this.orgTreeModel.getDataStatusList());
        if (StringUtils.isNotBlank((CharSequence)this.orgTreeModel.getInitStatus())) {
            dataStatusFilter.and(new QFilter("initstatus", "=", (Object)this.orgTreeModel.getInitStatus()));
        }
        if (this.orgTreeModel.isHisTree() && !this.isCurNowDate()) {
            Date dateParam = this.getDateParam();
            if (null == dateParam) {
                dateParam = new Date();
            }
            this.currentVersionVal = "0";
            QFilter bsedFilter = new QFilter("bsed", "<=", (Object)dateParam);
            QFilter bsledFilter = new QFilter("bsled", ">=", (Object)dateParam);
            dataStatusFilter.and(new QFilter("iscurrentversion", "=", (Object)this.getCurrentVersionVal()));
            this.dataStatusAndBSedFilter = bsedFilter.and(bsledFilter).and(dataStatusFilter);
            return this.dataStatusAndBSedFilter;
        }
        this.dataStatusAndBSedFilter = new QFilter("iscurrentversion", "=", (Object)this.getCurrentVersionVal());
        this.dataStatusAndBSedFilter.and(dataStatusFilter);
        return this.dataStatusAndBSedFilter;
    }

    public QFilter getTreeStructProjectFilter() {
        QFilter result = new QFilter("structproject", "in", this.getStructProjectCapable().getStructProjectIdSet());
        if (!TreeTemplateConstants.SYSTEM_STRUCT_PROJECT.contains(this.getStructProjectCapable().getStructProject().getLong("id"))) {
            result.and(new QFilter("enable", "=", (Object)"1"));
        } else {
            result.and(new QFilter("enable", "in", (Object)new String[]{"1", "0"}));
        }
        return result;
    }

    protected QFilter getHisListDataStatusBSedFilter() {
        QFilter qFilter;
        if (this.hisListDataStatusBSedFilter != null) {
            return this.hisListDataStatusBSedFilter;
        }
        Date dateParam = this.getDateParam();
        if (null == dateParam) {
            dateParam = new Date();
        }
        this.hisListDataStatusBSedFilter = qFilter = new QFilter("bsed", "<=", (Object)dateParam).and("bsled", ">=", (Object)dateParam).and("datastatus", "in", (Object)new String[]{EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()}).and("iscurrentversion", "=", (Object)Character.valueOf('0'));
        return qFilter;
    }

    public QFilter getOrgTreeFilter() {
        QFilter orgTreeFilter = this.getOrgCommonFilter();
        if (this.getStructProjectCapable().enableStructProjectCode()) {
            orgTreeFilter.and(this.getTreeStructProjectFilter());
        }
        return orgTreeFilter;
    }

    public QFilter getOrgFilter() {
        return this.getOrgCommonFilter();
    }

    private QFilter getOrgCommonFilter() {
        QFilter dataStatusAndBSedFilter = this.getDataStatusAndBSedFilter();
        dataStatusAndBSedFilter.and(this.getOrgEnableFilter());
        return dataStatusAndBSedFilter;
    }

    public QFilter getOrgRootTreeFilter() {
        QFilter treeFilter = this.getOrgCommonFilter();
        QFilter bizRootTreeFilter = this.getBizRootTreeFilter();
        if (bizRootTreeFilter != null) {
            treeFilter.and(bizRootTreeFilter);
        }
        if (this.getStructProjectCapable().enableStructProjectCode()) {
            treeFilter.and(this.getTreeStructProjectFilter());
        }
        return treeFilter;
    }

    protected QFilter getBizRootTreeFilter() {
        return null;
    }

    protected QFilter getCurTreeBizQFilter() {
        return this.getTreeCustomFilter();
    }

    private QFilter getTreeCustomFilter() {
        String qFilterStr;
        String curTreeBizFilterStr = this.getPageCache().get("cur_tree_biz_filter");
        if (HRStringUtils.isNotEmpty((String)curTreeBizFilterStr)) {
            this.curTreeBizQFilter = QFilter.fromSerializedString((String)curTreeBizFilterStr);
            return this.curTreeBizQFilter;
        }
        if (this.curTreeBizQFilter == null && !HRStringUtils.isEmpty((String)(qFilterStr = (String)this.getView().getFormShowParameter().getCustomParam("bizQFilterKey")))) {
            this.curTreeBizQFilter = QFilter.fromSerializedString((String)qFilterStr);
            this.getPageCache().put("cur_tree_biz_filter", qFilterStr);
        }
        return this.curTreeBizQFilter;
    }

    protected QFilter getCurTreeBizCommonQFilter() {
        QFilter commonTreeFilter = this.getDataStatusAndBSedFilter().and(this.getOrgTreeEnableFilter());
        if (this.getStructProjectCapable().enableStructProjectCode()) {
            commonTreeFilter.and(this.getTreeStructProjectFilter());
        }
        return commonTreeFilter;
    }

    protected boolean isShowDisable() {
        String cacheStrShowDisable;
        if (this.isShowDisable != null) {
            return this.isShowDisable;
        }
        Boolean isShowDisableParam = (Boolean)this.getView().getFormShowParameter().getCustomParam("chkshowdisable");
        this.isShowDisable = isShowDisableParam == null ? (HRStringUtils.isEmpty((String)(cacheStrShowDisable = this.getPageCache().get("chkshowdisable"))) ? Boolean.valueOf(this.getDefaultShowDisableValFromMeta()) : Boolean.valueOf(Boolean.parseBoolean(cacheStrShowDisable))) : isShowDisableParam;
        this.getPageCache().put("chkshowdisable", String.valueOf(this.isShowDisable));
        return this.isShowDisable;
    }

    protected boolean getDefaultShowDisableValFromMeta() {
        FormShowParameter formShowParameter = this.showAdminOrgTreeFilterDialog();
        String formId = formShowParameter.getFormId();
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)formId);
        DynamicProperty chkShowDisableProperty = dataEntityType.getProperty("chkshowdisable");
        return chkShowDisableProperty != null && (Boolean)chkShowDisableProperty.getDefaultValue() != false;
    }

    @Override
    protected AuthorizedOrgResultWithSub getPermOrgResultWithSub() {
        if (this.permOrgResultWithSub == null) {
            String orgResultString = this.getPageCache().get("perm_org_result_withsub");
            if (!HRStringUtils.isEmpty((String)orgResultString)) {
                return (AuthorizedOrgResultWithSub)SerializationUtils.fromJsonString((String)orgResultString, AuthorizedOrgResultWithSub.class);
            }
            ListShowParameter listParameter = (ListShowParameter)this.getView().getFormShowParameter();
            logger.info(String.format("TreeListTemplateBase.getPermOrgResultWithSub billFormId=:%s", listParameter.getBillFormId()));
            this.permOrgResultWithSub = super.getPermOrgResultWithSub();
            logger.info(String.format("TreeListTemplateBase.getPermOrgResultWithSub permOrgResultWithSub=:%s", SerializationUtils.toJsonString((Object)this.permOrgResultWithSub)));
            if (this.getTreeCustomFilter() != null) {
                this.permOrgResultWithSub = this.resetPermOrgResultWithSubWithCustomFilter(this.permOrgResultWithSub, this.getCurTreeBizQFilter());
                logger.info(String.format("TreeListTemplateBase.resetPermOrgResultWithSubWithCustomFilter permOrgResultWithSub=:%s", SerializationUtils.toJsonString((Object)this.permOrgResultWithSub)));
            }
            this.resetPermOrgResultWitchSub(this.permOrgResultWithSub);
            this.getPageCache().put("perm_org_result_withsub", SerializationUtils.toJsonString((Object)this.permOrgResultWithSub));
        }
        if (this.permOrgResultWithSub == null) {
            this.permOrgResultWithSub = AuthorizedOrgResultWithSub.allOrg();
        }
        return this.permOrgResultWithSub;
    }

    private AuthorizedOrgResultWithSub resetPermOrgResultWithSubWithCustomFilter(AuthorizedOrgResultWithSub authorizedOrgResultWithSub, QFilter curTreeBizQFilter) {
        QFilter orgAndSubInPermFilter = authorizedOrgResultWithSub.isHasAllOrgPerm() ? new QFilter("1", "=", (Object)1) : TreeTemplateHelper.getOrgAndSubInPermFilter((AuthorizedOrgResultWithSub)authorizedOrgResultWithSub, (String)this.orgIdProperty);
        DynamicObjectCollection bizCustomFilterOrgCol = HRBaseDaoFactory.getInstance((String)this.orgTreeModel.getEntityName()).queryColl("id, boid, structlongnumber, " + this.orgIdProperty, new QFilter[]{this.getOrgTreeFilter(), curTreeBizQFilter, orgAndSubInPermFilter}, null);
        long structProjectId = this.getStructProjectCapable().getStructProject().getLong("id");
        AuthorizedOrgResultWithSub newResult = new AuthorizedOrgResultWithSub();
        List orgSubInfoList = bizCustomFilterOrgCol.stream().map(bizCustomFilterOrg -> {
            OrgSubInfo orgSubInfo = new OrgSubInfo();
            orgSubInfo.setOrgId(Long.valueOf(bizCustomFilterOrg.getLong(this.orgIdProperty)));
            orgSubInfo.setContainsSub(false);
            orgSubInfo.setLongStructNumber(bizCustomFilterOrg.getString("structlongnumber"));
            String SLN = orgSubInfo.getLongStructNumber();
            orgSubInfo.setStructNumber(SLN.substring(SLN.length() - 12));
            orgSubInfo.setStructProjectId(Long.valueOf(structProjectId));
            return orgSubInfo;
        }).collect(Collectors.toList());
        newResult.setHasAllOrgPerm(false);
        newResult.setHasPermOrgsWithSub(orgSubInfoList);
        return newResult;
    }

    protected void resetPermOrgResultWitchSub(AuthorizedOrgResultWithSub permOrgResultWithSub) {
        if (permOrgResultWithSub.isHasAllOrgPerm()) {
            return;
        }
        for (OrgSubInfo orgSubInfo : permOrgResultWithSub.getHasPermOrgsWithSub()) {
            if (OrgServiceUtil.getAdminRootOrgId() != orgSubInfo.getOrgId() || !orgSubInfo.isContainsSub()) continue;
            permOrgResultWithSub.setHasAllOrgPerm(true);
            break;
        }
    }

    public Map<String, Boolean> getOrgSubStructLongNumberPermMap() {
        if (this.orgSubStructLongNumberPermMap == null && "adminOrg".equals(this.orgType)) {
            this.permOrgResultWithSub = this.getPermOrgResultWithSub();
            List permOrgWithSub = this.permOrgResultWithSub.getHasPermOrgsWithSub();
            if (ObjectUtils.isEmpty((Object)permOrgWithSub) || this.permOrgResultWithSub.isHasAllOrgPerm()) {
                return null;
            }
            this.orgSubStructLongNumberPermMap = permOrgWithSub.stream().collect(Collectors.toMap(OrgSubInfo::getLongStructNumber, OrgSubInfo::isContainsSub, (k1, k2) -> k1));
        }
        if (this.orgSubStructLongNumberPermMap == null) {
            this.orgSubStructLongNumberPermMap = new HashMap<String, Boolean>();
        }
        return this.orgSubStructLongNumberPermMap;
    }

    private List<String> getHisTreeViewStructNumberFilter(String currentStructLongNumber) {
        List<String> structNumberList = new ArrayList<String>(16);
        if (!this.orgTreeModel.isFilterTreePerm()) {
            return this.getAllPermissionStructNumbers(currentStructLongNumber);
        }
        if ("adminOrg".equals(this.orgType)) {
            structNumberList = this.getPermOrgResultWithSub().isHasAllOrgPerm() ? this.getAllPermissionStructNumbers(currentStructLongNumber) : this.getHisPermissionTreeViewStructNumbers(this.getPermOrgResultWithSub(), currentStructLongNumber);
        } else if (this.getPermOrgTeamResult().isHasAllOrgPerm()) {
            structNumberList = this.getAllPermissionStructNumbers(currentStructLongNumber);
        }
        return structNumberList;
    }

    @ExcludeFromJacocoGeneratedReport
    public QFilter getTreeViewStructNumberFilter(String currentStructLongNumber) {
        QFilter structNumberFilter = null;
        if (!this.orgTreeModel.isFilterTreePerm()) {
            return new QFilter(this.orgStructNumberProperty, "in", this.getAllPermissionStructNumbers(currentStructLongNumber));
        }
        if ("adminOrg".equals(this.orgType)) {
            structNumberFilter = this.getPermOrgResultWithSub().isHasAllOrgPerm() ? new QFilter(this.orgStructNumberProperty, "in", this.getAllPermissionStructNumbers(currentStructLongNumber)) : this.getPermissionTreeViewStructNumbers(this.getPermOrgResultWithSub(), currentStructLongNumber);
        } else if (this.isHasAllOrgPerm()) {
            structNumberFilter = new QFilter(this.orgStructNumberProperty, "in", this.getAllPermissionStructNumbers(currentStructLongNumber));
        } else {
            QFilter orgTeamIdFilter = new QFilter("orgteam.id", "in", this.getPermOrgTeamIdResult());
            Integer layerCount = (Integer)this.getView().getFormShowParameter().getCustomParam("layerCount");
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(this.getEntityName());
            QFilter longNumberFilter = new QFilter("structlongnumber", "like", (Object)(currentStructLongNumber + "%"));
            DynamicObjectCollection dynCol = serviceHelper.queryOriginalCollection("structlongnumber", new QFilter[]{orgTeamIdFilter, this.getOrgTreeFilter(), longNumberFilter});
            if (dynCol != null) {
                ArrayList structLongNumbers = new ArrayList(16);
                dynCol.forEach(dyn -> structLongNumbers.add(dyn.getString("structlongnumber")));
                List subStructNumbers = OrgTreeUtils.getMultiLayerSubStructNumber((String)currentStructLongNumber, structLongNumbers, (boolean)false, (Integer)layerCount);
                structNumberFilter = new QFilter(this.orgStructNumberProperty, "in", (Object)subStructNumbers);
            }
        }
        return structNumberFilter;
    }

    private List<String> getAllPermissionStructNumbers(String currentStructLongNumber) {
        logger.info("getAllPermissionStructNumbers, currentStructLongNumber={}", (Object)currentStructLongNumber);
        long starTime = System.currentTimeMillis();
        IPageCache pageCache = this.getPageCache();
        if (ObjectUtils.isEmpty(this.allPermLongNumberList)) {
            String structLongNumberStr = pageCache.get("all_struct_long_number");
            if (!StringUtils.isEmpty((CharSequence)structLongNumberStr)) {
                this.allPermLongNumberList = SerializationUtils.fromJsonStringToList((String)structLongNumberStr, String.class);
                logger.info("getAllPermissionStructNumbers.Serialization,allPermLongNumberList.size={},cost={}", (Object)(this.allPermLongNumberList == null ? 0 : this.allPermLongNumberList.size()), (Object)(System.currentTimeMillis() - starTime));
            } else {
                this.allPermLongNumberList = this.getAllPermissionStructLongNumbers();
                pageCache.put("all_struct_long_number", SerializationUtils.toJsonString(this.allPermLongNumberList));
                logger.info("getAllPermissionStructNumbers,allPermLongNumberList.size={},cost={}", (Object)this.allPermLongNumberList.size(), (Object)(System.currentTimeMillis() - starTime));
            }
        }
        Integer layerCount = (Integer)this.getView().getFormShowParameter().getCustomParam("layerCount");
        List subStructNumbers = OrgTreeUtils.getMultiLayerSubStructNumber((String)currentStructLongNumber, this.allPermLongNumberList, (boolean)false, (Integer)layerCount);
        logger.info("getAllPermissionStructNumbers, subStructNumbers.size={},cost={}", (Object)subStructNumbers.size(), (Object)(System.currentTimeMillis() - starTime));
        return subStructNumbers;
    }

    private QFilter getPermissionTreeViewStructNumbers(AuthorizedOrgResultWithSub permissionModel, String currentStructLongNumber) {
        List<String> structLongNumbers = this.getStructLongNumberInPermCache(permissionModel);
        Integer layerCount = (Integer)this.getView().getFormShowParameter().getCustomParam("layerCount");
        List subStructNumbers = OrgTreeUtils.getMultiLayerSubStructNumber((String)currentStructLongNumber, structLongNumbers, (boolean)false, (Integer)layerCount);
        return new QFilter(this.orgStructNumberProperty, "in", (Object)subStructNumbers);
    }

    protected List<String> getStructLongNumberInPermCache(AuthorizedOrgResultWithSub permissionModel) {
        List structLongNumbers;
        IPageCache pageCache = this.getPageCache();
        String structLongNumberInPermStr = pageCache.get("all_struct_long_number_in_perm");
        if (!StringUtils.isEmpty((CharSequence)structLongNumberInPermStr)) {
            structLongNumbers = SerializationUtils.fromJsonStringToList((String)structLongNumberInPermStr, String.class);
        } else {
            structLongNumbers = TreeTemplateHelper.getPermissionStructLongNumbersWithSub((AuthorizedOrgResultWithSub)permissionModel, (String)this.getEntityName(), (QFilter)this.getOrgTreeFilter(), (String)this.orgIdProperty, null);
            pageCache.put("all_struct_long_number_in_perm", SerializationUtils.toJsonString((Object)structLongNumbers));
        }
        return structLongNumbers;
    }

    private List<String> getHisPermissionTreeViewStructNumbers(AuthorizedOrgResultWithSub permissionModel, String currentStructLongNumber) {
        List<String> structLongNumbers = this.getStructLongNumberInPermCache(permissionModel);
        Integer layerCount = (Integer)this.getView().getFormShowParameter().getCustomParam("layerCount");
        String doNotHaveParentCache = this.getPageCache().get("do_not_have_parent_org_structlongnumber");
        List subStructNumbers = doNotHaveParentCache != null ? OrgTreeUtils.getMultiLayerSubStructNumberForHis((String)currentStructLongNumber, (AuthorizedOrgResultWithSub)permissionModel, (boolean)false, (Integer)layerCount, (String)this.getEntityName(), (QFilter)this.getOrgTreeFilter()) : OrgTreeUtils.getMultiLayerSubStructNumber((String)currentStructLongNumber, structLongNumbers, (boolean)false, (Integer)layerCount);
        return subStructNumbers;
    }

    protected void searchFromLazyOrgTree(OrgTreeSearchParam searchParam) {
        if (searchParam != null) {
            String searchText = searchParam.getSearchText();
            boolean isFirstSearch = false;
            if (!StringUtils.isBlank((CharSequence)searchText)) {
                List<Object> treeNodes = Lists.newArrayListWithCapacity((int)16);
                IPageCache pageCache = searchParam.getPageCache();
                String oldSearchText = pageCache.get(ORG_OLD_SEARCH_TEXT);
                if (StringUtils.isEmpty((CharSequence)oldSearchText)) {
                    isFirstSearch = true;
                }
                pageCache.put(ORG_OLD_SEARCH_TEXT, searchText);
                if (searchText.equals(oldSearchText)) {
                    String searchNodesCache = pageCache.get(ORG_SEARCH_NODE);
                    if (StringUtils.isNotBlank((CharSequence)searchNodesCache)) {
                        treeNodes = SerializationUtils.fromJsonStringToList((String)searchNodesCache, TreeNode.class);
                    }
                } else {
                    pageCache.remove(ORG_SEARCH_NODE);
                    treeNodes = this.searchTreeNode(searchParam);
                    if (this.finishSearch(searchParam, treeNodes, true)) {
                        return;
                    }
                }
                if (CollectionUtils.isEmpty((Collection)treeNodes)) {
                    this.finishSearch(searchParam, treeNodes, false);
                } else {
                    this.searchFromLazyOrgTree(searchParam, treeNodes, isFirstSearch);
                }
            }
        }
    }

    private void searchFromLazyOrgTree(OrgTreeSearchParam searchParam, List<TreeNode> treeNodes, boolean isFirstSearch) {
        IPageCache pageCache = searchParam.getPageCache();
        TreeView treeView = this.getTreeListView().getTreeView();
        treeView.uncheckNodes(treeView.getTreeState().getSelectedNodeId());
        TreeNode node = this.searchExistsNodeFromLazyOrgTree(searchParam, treeNodes, 0);
        if (node == null) {
            this.finishSearch(searchParam, treeNodes, isFirstSearch);
        } else {
            treeView.expand(searchParam.getRootNode().getId());
            if (searchParam.isClickNode() && !searchParam.isSearchById()) {
                treeView.treeNodeClick(node.getParentid(), node.getId());
            }
            searchParam.getCheckNodeIds().add(node.getId());
            treeView.uncheckNodes(treeView.getTreeState().getSelectedNodeId());
            treeView.checkNode(node);
            TreeListTemplateBase.focusNodeAfterSearch(searchParam, node);
            if (!searchParam.isSearchById() && treeNodes != null && !treeNodes.isEmpty()) {
                treeNodes.remove(0);
            }
        }
        if (ObjectUtils.isEmpty(treeNodes) && !searchParam.isSearchById()) {
            pageCache.put(ORG_SEARCH_NODE, null);
            return;
        }
        if (searchParam.isSearchById()) {
            return;
        }
        pageCache.put(ORG_SEARCH_NODE, SerializationUtils.toJsonString(treeNodes));
    }

    public boolean finishSearch(OrgTreeSearchParam searchParam, List<TreeNode> treeNodes, boolean noResult) {
        if (!CollectionUtils.isEmpty(treeNodes)) {
            return false;
        }
        searchParam.getPageCache().put(ORG_SEARCH_NODE, "");
        searchParam.getPageCache().remove(ORG_OLD_SEARCH_TEXT);
        if (searchParam.isSearchById()) {
            if (treeNodes.size() == 0) {
                return true;
            }
            TreeListTemplateBase.orgTreeNodeClick(searchParam);
            if (null != treeNodes.get(0)) {
                searchParam.getTreeView().checkNode(treeNodes.get(0));
            }
            return true;
        }
        if (noResult) {
            searchParam.getFormView().showTipNotification(BaseMessage.getMessage((String)"M00030"));
        } else {
            searchParam.getFormView().showSuccessNotification(BaseMessage.getMessage((String)"M00029"));
        }
        TreeListTemplateBase.orgTreeNodeClick(searchParam);
        return true;
    }

    @Override
    public void treeNodeClick(TreeNodeEvent treeNodeEvent) {
        String currentNodeId = treeNodeEvent.getNodeId().toString();
        TreeNode currentNode = this.getTreeModel().getRoot().getTreeNode(currentNodeId, 20);
        String treeConditionChanged = this.getView().getPageCache().get("treeConditionChanged");
        if (HRStringUtils.equals((String)treeConditionChanged, (String)"true")) {
            this.getView().getPageCache().remove("treeConditionChanged");
            this.rebuildTreeNode();
            return;
        }
        if (null != currentNode) {
            List children = currentNode.getChildren();
            if (CollectionUtils.isEmpty((Collection)children)) {
                if (null == children) {
                    children = Lists.newArrayListWithCapacity((int)0);
                }
                this.addChildNodeWrap(currentNodeId, children);
            }
        } else {
            this.getTreeModel().setCurrentNodeId((Object)this.getTreeModel().getRoot().getId());
        }
    }

    @Override
    protected List<TreeNode> getChildNodesWrap(String entityName, String parentId) {
        List<Map<String, String>> treeView = this.getTreeViewByParentId(entityName, parentId);
        return this.buildTreeChildNodes(treeView);
    }

    private TreeNode searchExistsNodeFromLazyOrgTree(OrgTreeSearchParam searchParam, List<TreeNode> treeNodes, int recursionCount) {
        if (CollectionUtils.isEmpty(treeNodes) || recursionCount > 20) {
            return null;
        }
        TreeNode node = treeNodes.get(0);
        if (node == null) {
            return null;
        }
        String parentId = node.getParentid();
        TreeNode parentNode = OrgTreeUtils.getNode((TreeNode)searchParam.getRootNode(), (Object)parentId);
        if (OrgTreeUtils.isChildNode((TreeNode)parentNode, (TreeNode)node)) {
            HashSet loopController = Sets.newHashSetWithExpectedSize((int)16);
            ArrayList expendIds = Lists.newArrayListWithCapacity((int)16);
            OrgTreeUtils.expandParentNode((OrgTreeSearchParam)searchParam, (String)parentId, (Set)loopController, (List)expendIds, (int)0);
            for (int i = expendIds.size() - 1; i >= 0; --i) {
                searchParam.getTreeView().expand((String)expendIds.get(i));
            }
        } else {
            this.queryTreeNodeWithParent(searchParam, node);
        }
        node = OrgTreeUtils.getNode((TreeNode)searchParam.getRootNode(), (Object)node.getId());
        if (node == null) {
            TreeNode removeNode = treeNodes.remove(0);
            String subNodeLongNumber = removeNode.getLongNumber() + "!";
            ArrayList removeSubNodes = Lists.newArrayList();
            for (TreeNode subNode : treeNodes) {
                if (subNode.getLongNumber() == null || !subNode.getLongNumber().startsWith(subNodeLongNumber)) continue;
                removeSubNodes.add(subNode);
            }
            treeNodes.removeAll(removeSubNodes);
            return this.searchExistsNodeFromLazyOrgTree(searchParam, treeNodes, recursionCount);
        }
        return node;
    }

    private void queryTreeNodeWithParent(OrgTreeSearchParam searchParam, TreeNode node) {
        String notLoadParentLongNumber;
        int layerCount;
        Object currentNodeId = this.getTreeModel().getCurrentNodeId();
        TreeNode curTreeNode = OrgTreeUtils.getNode((TreeNode)this.getTreeModel().getRoot(), (Object)currentNodeId.toString());
        String structLongNumber = node.getLongNumber();
        if (StringUtils.equals((CharSequence)"999999999", (CharSequence)currentNodeId.toString())) {
            String[] splitedStructLongNumber = structLongNumber.split("!");
            layerCount = splitedStructLongNumber.length - 1;
            notLoadParentLongNumber = splitedStructLongNumber[0];
        } else {
            if (curTreeNode == null || HRStringUtils.isEmpty((String)curTreeNode.getLongNumber())) {
                return;
            }
            int nextLongNumberLength = curTreeNode.getLongNumber().length() + TreeTemplateConstants.LONG_NUMBER_AND_SPLIT_LENGTH;
            if (structLongNumber.length() < nextLongNumberLength) {
                return;
            }
            String newParentStructLongNumber = structLongNumber.substring(0, nextLongNumberLength);
            notLoadParentLongNumber = newParentStructLongNumber.substring(newParentStructLongNumber.lastIndexOf(33) + 1);
            layerCount = (structLongNumber.length() - newParentStructLongNumber.length()) / TreeTemplateConstants.LONG_NUMBER_AND_SPLIT_LENGTH;
        }
        ArrayList<String> structNumbers = new ArrayList<String>();
        structNumbers.add(notLoadParentLongNumber);
        this.getView().getFormShowParameter().setCustomParam("layerCount", (Object)layerCount);
        this.queryTreeNodeChildrenByStructNumbers(searchParam, structNumbers, node);
    }

    public String getCurrentVersionVal() {
        if (this.currentVersionVal != null) {
            return this.currentVersionVal;
        }
        this.currentVersionVal = this.orgTreeModel.isHisTree() && !this.isCurNowDate() ? "0" : "1";
        return this.currentVersionVal;
    }

    @Override
    protected TreeNode genTreeNodeWrap(Map<String, String> map) {
        TreeNode node = new TreeNode();
        node.setParentid(map.get("parent"));
        String nodeId = map.get("id");
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            return node;
        }
        node.setId(nodeId);
        this.treeNodeIcon(node, map);
        node.setText(map.get("name"));
        this.resetOrgNameByEnableInfo(node, map);
        node.setLongNumber(map.get("longnumber"));
        boolean isLeaf = "1".equals(map.get("isleaf"));
        node.setLeaf(isLeaf);
        node.setData((Object)map.get("boid"));
        return node;
    }

    protected List<Long> getAllOrgBoIdList() {
        return null;
    }

    protected boolean isDefDirectlySubOrg() {
        return false;
    }

    protected Long getCurOrgIdByBoId(Long boId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(this.orgTreeModel.getMainEntityName());
        QFilter boIdFilter = new QFilter("boid", "=", (Object)boId);
        DynamicObject dynamicObject = serviceHelper.queryOne("id", new QFilter[]{boIdFilter, this.getDataStatusAndBSedFilter(), this.getOrgEnableFilter()});
        if (dynamicObject == null) {
            return null;
        }
        return dynamicObject.getLong("id");
    }

    public StringBuilder getHisSubTreeQuerySql() {
        StringBuilder sqlSb = new StringBuilder(this.hisSubFiledFromSql);
        sqlSb.append((CharSequence)this.hisSubWhereCommonSql);
        StringBuilder hisOtherWhereSql = this.getHisOtherWhereSql();
        if (null != hisOtherWhereSql) {
            sqlSb.append((CharSequence)hisOtherWhereSql);
        }
        sqlSb.append((CharSequence)this.hisSubWhereBizSql);
        this.buildCustomSql(sqlSb);
        if (!this.isShowDisable()) {
            sqlSb.append(" AND A.FENABLE = '1' ");
        }
        return sqlSb;
    }

    private void buildCustomSql(StringBuilder sqlSb) {
        String sqlStr = (String)this.getView().getFormShowParameter().getCustomParam("hisBizQFilterKey");
        logger.info(String.format("TreeListTemplateBase_hisBizQFilterKey: param is %s", sqlStr));
        if (!HRStringUtils.isEmpty((String)sqlStr)) {
            sqlSb.append(" AND ( ").append(sqlStr).append(") ");
        }
    }

    public List<Object> getHisSubTreeQueryParamList(int queryDateCount) {
        Date dateParam = this.getDateParam();
        if (dateParam == null) {
            dateParam = new Date();
        }
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add(RequestContext.get().getLang().toString());
        this.setOtherWhereParams(paramList);
        OrgTreeUtils.setParamQueryDate((Date)dateParam, paramList, (int)queryDateCount);
        return paramList;
    }

    protected void setOtherWhereParams(List<Object> paramList) {
    }

    protected void setStructProjectSqlParam(List<Object> paramList) {
    }

    protected StringBuilder getHisOtherWhereSql() {
        return null;
    }

    public String getSubTreeOrderBys() {
        String treeOrderBys = this.getTreeOrderBys();
        if (!StringUtils.isEmpty((CharSequence)treeOrderBys)) {
            this.subTreeOrderBys = treeOrderBys;
        }
        return this.subTreeOrderBys;
    }

    public void setSubTreeOrderBys(String subTreeOrderBys) {
        this.subTreeOrderBys = subTreeOrderBys;
    }

    protected String getTreeOrderBys() {
        return null;
    }

    protected TreeNode parentVirtualNode(String parentNodeId) {
        TreeNode treeNode = new TreeNode();
        treeNode.setId("999999999");
        treeNode.setText(ResManager.loadKDString((String)"\u5f53\u524d\u65e5\u671f\u65e0\u7236\u8282\u70b9\u3002", (String)"TreeListTemplateBase_3", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
        treeNode.setParentid(parentNodeId);
        treeNode.setLeaf(Boolean.FALSE.booleanValue());
        treeNode.setChildren(new ArrayList());
        return treeNode;
    }

    protected TreeNode noDataVirtualNode() {
        TreeNode treeNode = new TreeNode();
        treeNode.setId("-1");
        treeNode.setText(ResManager.loadKDString((String)"\u5f53\u524d\u65e5\u671f\u65e0\u6570\u636e\u3002", (String)"TreeListTemplateBase_2", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
        treeNode.setParentid("");
        treeNode.setLeaf(Boolean.TRUE.booleanValue());
        return treeNode;
    }

    protected TreeNode noPermDataVirtualNode() {
        TreeNode treeNode = new TreeNode();
        treeNode.setId("-3");
        treeNode.setText(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e", (String)"TreeListTemplateBase_5", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
        treeNode.setParentid("");
        treeNode.setLeaf(Boolean.TRUE.booleanValue());
        return treeNode;
    }

    protected boolean isAllOrgDoNotHaveParentAtSearchDate() {
        if (this.conditionalOrgAndCacheResult != null) {
            return this.conditionalOrgAndCacheResult;
        }
        this.conditionalOrgAndCacheResult = this.queryConditionalOrgAndCache();
        return this.conditionalOrgAndCacheResult;
    }

    private boolean parseDoNotHaveParentOrgAndCache(DynamicObject[] dynamicObjects) {
        HashSet doNotHaveParentOrgStructLongNumbers = Sets.newHashSetWithExpectedSize((int)4);
        ArrayList haveParentOrgStructLongNumbers = Lists.newArrayListWithExpectedSize((int)dynamicObjects.length);
        ArrayList allConditionalOrgIds = Lists.newArrayListWithExpectedSize((int)dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            long orgId = dynamicObject.getLong("id");
            allConditionalOrgIds.add(orgId);
            String structLongNumber2 = dynamicObject.getString("structlongnumber");
            long parentId = dynamicObject.getLong("parent");
            if (parentId == 0L && !dynamicObject.getBoolean("isroot")) {
                doNotHaveParentOrgStructLongNumbers.add(structLongNumber2);
                continue;
            }
            haveParentOrgStructLongNumbers.add(structLongNumber2);
        }
        boolean flag = true;
        if (!CollectionUtils.isEmpty((Collection)haveParentOrgStructLongNumbers)) {
            Iterator iterator = haveParentOrgStructLongNumbers.iterator();
            while (iterator.hasNext()) {
                String structLongNumber3 = (String)iterator.next();
                if (!doNotHaveParentOrgStructLongNumbers.contains(structLongNumber3.split("!")[0])) {
                    flag = false;
                    continue;
                }
                iterator.remove();
            }
            if (!flag && !CollectionUtils.isEmpty((Collection)haveParentOrgStructLongNumbers)) {
                String commonPrefixStructLongNumber = OrgTreeUtils.getCommonPrefixStructLongNumber((List)haveParentOrgStructLongNumbers);
                if (StringUtils.isEmpty((CharSequence)commonPrefixStructLongNumber)) {
                    haveParentOrgStructLongNumbers.forEach(structLongNumber -> doNotHaveParentOrgStructLongNumbers.add(structLongNumber.split("!")[0]));
                    commonPrefixStructLongNumber = "no_common_parent";
                }
                this.getPageCache().put("common_prefix_struct_long_number", commonPrefixStructLongNumber);
            }
        }
        IPageCache pageCache = this.getView().getPageCache();
        if (doNotHaveParentOrgStructLongNumbers.size() > 0) {
            pageCache.put("do_not_have_parent_org_structlongnumber", SerializationUtils.toJsonString((Object)doNotHaveParentOrgStructLongNumbers));
            logger.info(String.format("do_not_have_parent_org_structlongnumber: %s", doNotHaveParentOrgStructLongNumbers));
        }
        pageCache.put("all_conditional_org", SerializationUtils.toJsonString((Object)allConditionalOrgIds));
        logger.info(String.format("all_conditional_org: %s", allConditionalOrgIds));
        return flag;
    }

    protected DynamicObject[] queryConditionalOrgAtSearchDate() {
        QFilter hisPermFilter = null;
        if ("adminOrg".equals(this.orgTreeModel.getOrgType())) {
            if (this.dateChgPermResult == null) {
                this.dateChgPermResult = this.getPermOrgResultWithSub();
            }
            if (this.permOrgResultWithSub == null) {
                this.permOrgResultWithSub = this.getPermOrgResultWithSub();
            }
            hisPermFilter = TreeTemplateHelper.getPermStructLongNumberFilter((AuthorizedOrgResultWithSub)this.permOrgResultWithSub, (String)"adminorg.boid");
        }
        QFilter treeFilter = this.getOrgTreeFilter();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(this.getEntityName());
        return serviceHelper.queryOriginalArray(this.getOrgParentStructLongNumberQueryFields(), new QFilter[]{hisPermFilter, treeFilter});
    }

    @ExcludeFromJacocoGeneratedReport
    private QFilter getPermFilterForHisTree(AuthorizedOrgResultWithSub permissionModel) {
        if (permissionModel.isHasAllOrgPerm()) {
            return null;
        }
        List hasPermOrgWithSub = permissionModel.getHasPermOrgsWithSub();
        HashSet<Long> orgBoIdSet = new HashSet<Long>(hasPermOrgWithSub.size());
        QFilter structLongNumberFilter = null;
        for (OrgSubInfo subInfo : hasPermOrgWithSub) {
            if (subInfo.isContainsSub()) {
                if (structLongNumberFilter == null) {
                    structLongNumberFilter = new QFilter("structlongnumber", "like", (Object)(subInfo.getLongStructNumber() + "%"));
                    continue;
                }
                structLongNumberFilter.or("structlongnumber", "like", (Object)(subInfo.getLongStructNumber() + "%"));
                continue;
            }
            orgBoIdSet.add(subInfo.getOrgId());
        }
        if (structLongNumberFilter == null && orgBoIdSet.isEmpty()) {
            return new QFilter("1", "!=", (Object)1);
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(this.getEntityName());
        if (structLongNumberFilter != null) {
            DynamicObjectCollection dynObjColl = serviceHelper.queryOriginalCollection("adminorg.boid", structLongNumberFilter.toArray());
            orgBoIdSet.addAll(dynObjColl.stream().map(dynObj -> dynObj.getLong("adminorg.boid")).collect(Collectors.toSet()));
        }
        return new QFilter("adminorg.boid", "in", orgBoIdSet);
    }

    protected void rebuildTreeNode() {
        if (StringUtils.isEmpty((CharSequence)this.getTreeModel().getRoot().getId())) {
            return;
        }
        TreeNode rootNode = this.getRootNode();
        IListView iListView = (IListView)this.getView();
        ITreeListView adminOrgTreeView = iListView.getTreeListView();
        ITreeModel treeModel = adminOrgTreeView.getTreeModel();
        TreeView treeView = adminOrgTreeView.getTreeView();
        treeView.deleteAllNodes();
        treeView.addNode(rootNode);
        treeModel.setRoot(rootNode);
        TreeNode node = treeModel.refreshNode((Object)rootNode.getId());
        if (node != null) {
            treeView.updateNode(node);
            treeView.focusNode(node);
            treeView.treeNodeClick(node.getParentid(), rootNode.getId());
        }
    }

    private boolean queryConditionalOrgAndCache() {
        if (this.orgTreeModel.isHisTree()) {
            Object[] dynamicObjects = this.queryConditionalOrgAtSearchDate();
            if (ObjectUtils.isEmpty((Object[])dynamicObjects)) {
                return false;
            }
            return this.parseDoNotHaveParentOrgAndCache((DynamicObject[])dynamicObjects);
        }
        return false;
    }

    protected Set<Long> getPermOrgTeamIdResult() {
        return null;
    }

    Set<Long> getOrgTeamTreeClassify() {
        return null;
    }

    public List<Long> getOTTreeFocus() {
        return null;
    }

    @Override
    protected String getParentF7PropWrap(ListShowParameter listParameter) {
        String controlKey = listParameter.getCloseCallBack().getControlKey();
        IFormView parentView = HRPermUtil.getParentNoPlugin(this.getView());
        String parentF7Prop = (String)parentView.getFormShowParameter().getCustomParam("custom_parent_f7_prop");
        Control control = this.getControl(controlKey);
        if (!StringUtils.isEmpty((CharSequence)parentF7Prop)) {
            return parentF7Prop;
        }
        if (control instanceof FilterContainer) {
            String f7ControlKey = this.getFilterContainerF7Key(listParameter);
            String filterContainerCustomPermProp = this.getFilterContainerCustomPermProp(f7ControlKey);
            if (filterContainerCustomPermProp != null) {
                return filterContainerCustomPermProp;
            }
            return f7ControlKey;
        }
        return listParameter.getCloseCallBack().getControlKey();
    }

    private String getFilterContainerF7Key(ListShowParameter listParameter) {
        String actionId = listParameter.getCloseCallBack().getActionId();
        int indexOf = actionId.lastIndexOf("$");
        int endIdx = actionId.lastIndexOf(".");
        String f7ControlKey = actionId.substring(indexOf + 1, endIdx == -1 ? actionId.length() : endIdx);
        logger.info("TreeListTemplateBase.getParentF7PropWrap, f7ControlKey={}", (Object)f7ControlKey);
        return f7ControlKey;
    }

    protected String getFilterContainerCustomPermProp(String prop) {
        return null;
    }

    public String getOriginallyF7ProKey() {
        if (HRStringUtils.isEmpty((String)this.originallyF7ProKey)) {
            ListShowParameter listParameter = (ListShowParameter)this.getView().getFormShowParameter();
            if (!listParameter.isLookUp()) {
                return this.originallyF7ProKey;
            }
            String controlKey = listParameter.getCloseCallBack().getControlKey();
            Control control = this.getControl(controlKey);
            String filterContainerF7Key = null;
            if (control instanceof FilterContainer) {
                filterContainerF7Key = this.getFilterContainerF7Key(listParameter);
            }
            this.originallyF7ProKey = HRStringUtils.isEmpty(filterContainerF7Key) ? controlKey : filterContainerF7Key;
        }
        return this.originallyF7ProKey;
    }

    public boolean isCurNowDate() {
        Date dateParam = this.getDateParam();
        if (dateParam == null) {
            return true;
        }
        boolean isHisCurNowDate = HRDateTimeUtils.truncateDate((Date)new Date()).equals(HRDateTimeUtils.truncateDate((Date)dateParam));
        this.orgTreeModel.setCurNowDate(isHisCurNowDate);
        return isHisCurNowDate;
    }

    protected AuthorizedStructResult getPermStructProject() {
        return null;
    }

    public void setStructProjectCapable(StructProjectCapable structProjectCapable) {
        this.structProjectCapable = structProjectCapable;
    }

    public StructProjectCapable getStructProjectCapable() {
        return this.structProjectCapable;
    }

    public Map<String, Object> getStructProjectCustomInParam(String prop) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("hr_dataperm_structprojectid_prop_" + prop, Collections.singletonList(this.getStructProjectCapable().getStructProject().getLong("id")));
        return map;
    }

    public Map<String, Object> getStructProjectCustomInParamWithDate(String prop) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("hr_dataperm_structprojectid_prop_" + prop, Collections.singletonList(this.getStructProjectCapable().getStructProject().getLong("id")));
        map.put("hr_dataperm_bsedtime", this.getDateParam());
        map.put("hr_dataperm_bsledtime", this.getDateParam());
        return map;
    }
}

