/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.org.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.util.HRDateTimeUtils;

public class TreeNodeNameSetter {
    Set<Long> ADMIN_ORG_TYPE_COMPANY_AND_AREA = new HashSet<Long>(Arrays.asList(1030L, 1040L));
    String ADMIN_ORG_TYPE_ADMIN_ORG_TYPE_STD_ID = "adminorgtype.adminorgtypestd.id";
    String BELONG_COMPANY_ID = "belongcompany.id";
    Set<Long> ADMIN_ORG_TYPE_COMPANY_AND_GROUP = new HashSet<Long>(Arrays.asList(1010L, 1020L));
    HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
    Map<Long, String> idVsCompanyName = new HashMap<Long, String>();
    Map<Long, Boolean> idVsShowCompany = new HashMap<Long, Boolean>();
    Predicate<Long> filterSHowOrgType = this.ADMIN_ORG_TYPE_COMPANY_AND_AREA::contains;

    public void beforeEncapsulationTreeMap(DynamicObjectCollection dyColl, Date queryDate) {
        if (dyColl != null) {
            Set<Long> idSet = dyColl.stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet());
            this.packageData(idSet, queryDate);
        }
    }

    public void beforeEncapsulationNode(DynamicObject dy, Date queryDate) {
        if (dy != null) {
            this.packageData(new HashSet<Long>(Collections.singletonList(dy.getLong("id"))), queryDate);
        }
    }

    public String createCompanySuffix(DynamicObject rootDy) {
        long id = rootDy.getLong("id");
        return this.getCompanySuffix(id);
    }

    public String createCompanySuffix(Map<String, String> nodeMap) {
        long id = Long.parseLong(nodeMap.getOrDefault("id", "0"));
        return this.getCompanySuffix(id);
    }

    private void packageData(Set<Long> idSet, Date queryDate) {
        DynamicObject[] adminOrgDys = this.queryOriginalByPks("id, belongcompany.id, adminorgtype.adminorgtypestd.id", idSet);
        Map<Long, Long> filteredIdVsCompanyBo = Arrays.stream(adminOrgDys).filter(adminOrg -> this.filterSHowOrgType.test(adminOrg.getLong(this.ADMIN_ORG_TYPE_ADMIN_ORG_TYPE_STD_ID))).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong(this.BELONG_COMPANY_ID)));
        if (filteredIdVsCompanyBo.size() == 0) {
            return;
        }
        DynamicObject[] belongAdminOrgs = this.isHis(queryDate) ? this.queryOriginalByBoAndEffDate("boid, name", filteredIdVsCompanyBo.values(), queryDate) : this.queryOrgInfoByBoId("boid, name", new ArrayList<Long>(filteredIdVsCompanyBo.values()));
        Map<Long, String> companyIdVsName = Arrays.stream(belongAdminOrgs).collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> dy.getString("name")));
        this.idVsCompanyName = filteredIdVsCompanyBo.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> companyIdVsName.getOrDefault(entry.getValue(), "")));
        this.idVsShowCompany = Arrays.stream(adminOrgDys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> !this.ADMIN_ORG_TYPE_COMPANY_AND_GROUP.contains(dy.getLong(this.ADMIN_ORG_TYPE_ADMIN_ORG_TYPE_STD_ID))));
    }

    private String getCompanySuffix(long id) {
        if (this.idVsShowCompany.getOrDefault(id, false).booleanValue()) {
            return this.idVsCompanyName.getOrDefault(id, "");
        }
        return "";
    }

    private boolean isHis(Date queryDate) {
        return queryDate != null;
    }

    public DynamicObject[] queryOriginalByPks(String selectFields, Collection<Long> pks) {
        QFilter idFilter = new QFilter("id", "in", pks);
        return this.serviceHelper.queryOriginalArray(selectFields, new QFilter[]{idFilter});
    }

    public DynamicObject[] queryOriginalByBoAndEffDate(String fields, Collection<Long> boCollection, Date effDate) {
        QFilter boFilter = new QFilter("boid", "in", boCollection);
        QFilter hisFilter = TreeNodeNameSetter.createValidHisVersionFilterByOnePoint(effDate);
        return this.serviceHelper.queryOriginalArray(fields, new QFilter[]{boFilter, hisFilter});
    }

    public DynamicObject[] queryOrgInfoByBoId(String selectFields, List<Long> boIds) {
        QFilter filter = new QFilter("iscurrentversion", "=", (Object)"1");
        filter.and("boid", "in", boIds);
        return this.serviceHelper.query(selectFields, new QFilter[]{filter});
    }

    public static QFilter createValidHisVersionFilterByOnePoint(Date bsed) {
        Date date = HRDateTimeUtils.truncateDate((Date)bsed);
        return TreeNodeNameSetter.createValidHisVersionFilter().and(new QFilter("bsed", "<=", (Object)date)).and(new QFilter("bsled", ">=", (Object)date));
    }

    public static QFilter createValidHisVersionFilter() {
        return new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0')).and(new QFilter("datastatus", "in", (Object)new String[]{EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()}));
    }
}

