/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.query;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.query.ksql.KsqlConfig;
import kd.hr.hbp.business.servicehelper.EntityReleaseInfoService;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.query.QueryListDataFactory;
import kd.sdk.annotation.SdkPlugin;

@SdkPlugin(name="HR\u9886\u57df\u591a\u5b9e\u4f53\u67e5\u8be2\u5217\u8868\u63d2\u4ef6")
public class QueryListPlugin
extends AbstractListPlugin {
    private static final Log LOGGER = LogFactory.getLog(QueryListPlugin.class);

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        String entityId = ((BillList)args.getSource()).getEntityId();
        args.setListDataProvider((IListDataProvider)this.listDataProvider(entityId));
    }

    private ListDataProvider listDataProvider(String entityNum) {
        DynamicObject entityReleaseInfo = EntityReleaseInfoService.getEntityReleaseInfoByName((String)entityNum);
        if (Objects.isNull(entityReleaseInfo)) {
            return null;
        }
        String dataSourceTypeStr = entityReleaseInfo.getString("datasourcetype");
        String ksqlQueryType = entityReleaseInfo.getString("ksqlquerytype");
        boolean ksqlUseUnion = entityReleaseInfo.getBoolean("ksqluseunion");
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("HR QueryListPlugin dataSourceTypeStr:" + dataSourceTypeStr + ", ksqlQueryType:" + ksqlQueryType + ", ksqlUseUnion:" + ksqlUseUnion);
        }
        return QueryListDataFactory.getListDataProvider(this.getView(), dataSourceTypeStr, this.setCustomKSqlConfig(), ksqlQueryType, ksqlUseUnion);
    }

    protected KsqlConfig setCustomKSqlConfig() {
        String customSelectedFields;
        KsqlConfig ksqlConfig = new KsqlConfig();
        Map relationMap = (Map)this.getView().getFormShowParameter().getCustomParam("MultEntity_JoinOnRelationMap");
        if (!CollectionUtils.isEmpty((Map)relationMap)) {
            ksqlConfig.setJoinOnRelationMap(relationMap);
        }
        if (!HRStringUtils.isEmpty((String)(customSelectedFields = (String)this.getView().getFormShowParameter().getCustomParam("MultEntity_CustomSelectedFields")))) {
            ksqlConfig.setCustomSelectedFields(customSelectedFields);
        }
        return ksqlConfig;
    }

    public void afterBindData(EventObject e) {
        HashMap<String, Boolean> mapBillListAp = new HashMap<String, Boolean>();
        mapBillListAp.put("enabledChangePage", true);
        mapBillListAp.put("suppressSelectAllRows", true);
        this.getView().updateControlMetadata("billlistap", mapBillListAp);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        Map parameter = operate.getParameter();
        parameter.put("byList", true);
        operate.setParameter(parameter);
    }
}

