/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.rp;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.ImageAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.mvc.cache.PageCache;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.rp.HRRelatePanelSetFactory;
import kd.hr.hbp.business.service.rp.RelatePageInfo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.control.HRImageAp;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;

public class HRRelatePageLeftDynamicPlugin
extends HRDynamicFormBasePlugin {
    private static final String FLEX_START = "flex-start";
    private static final String MAINPAGEPANEL = "mainpagepanel";
    private static final String PANEL = "panel";
    private static final Log logger = LogFactory.getLog(HRRelatePageLeftDynamicPlugin.class);
    private static final String CACHE_RELATEPAGELDFT = "cache_RelatePageLeft";

    public void initialize() {
        super.initialize();
        this.hidePartTwoPanel();
    }

    public void registerListener(EventObject eventObject) {
        this.addClickListeners(new String[]{"imgdown", "imgup"});
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs loadCustomControlMetasArgs) {
        super.loadCustomControlMetas(loadCustomControlMetasArgs);
        FormShowParameter showParameter = (FormShowParameter)loadCustomControlMetasArgs.getSource();
        String relateEntityTypeId = (String)showParameter.getCustomParam("hbss_entitytype_id");
        String pageId = showParameter.getPageId();
        FlexPanelAp headFlexPanelAp = this.createRelatePageInfoPanelAp(relateEntityTypeId, pageId);
        HashMap<String, String> mapHead = new HashMap<String, String>();
        mapHead.put("id", "flexpanelrelateinfo");
        mapHead.put("items", (String)headFlexPanelAp.createControl().get("items"));
        loadCustomControlMetasArgs.getItems().add(mapHead);
    }

    private FlexPanelAp createRelatePageInfoPanelAp(String relateEntityTypeId, String pageId) {
        FlexPanelAp relatePanelAp = this.assembleRelatePanelAp("relatePageflexpanellistap");
        List<RelatePageInfo> pageInfoList = this.getPageInfoList(relateEntityTypeId, pageId);
        this.addAllPageLabelForRelatePanel(relatePanelAp, pageInfoList);
        return relatePanelAp;
    }

    public void beforeBindData(EventObject eventObj) {
        super.beforeBindData(eventObj);
        FormView fView = (FormView)eventObj.getSource();
        String relateEntityTypeId = (String)fView.getFormShowParameter().getCustomParam("hbss_entitytype_id");
        FlexPanelAp headPanelAp = this.createRelatePageInfoPanelAp(relateEntityTypeId, this.getView().getPageId());
        Container relatePanel = (Container)this.getView().getControl("flexpanelrelateinfo");
        relatePanel.getItems().addAll(((Container)headPanelAp.buildRuntimeControl()).getItems());
        this.getView().createControlIndex(relatePanel.getItems());
    }

    public void onGetControl(OnGetControlArgs onGetControlArgs) {
        FormView formView = (FormView)onGetControlArgs.getSource();
        String relateEntityTypeId = (String)formView.getFormShowParameter().getCustomParam("hbss_entitytype_id");
        List<RelatePageInfo> pageInfoList = this.getPageInfoList(relateEntityTypeId, this.getView().getPageId());
        RelatePageInfo relatePage = null;
        Label relateLabel = null;
        int size = pageInfoList.size();
        for (int i = 0; i < size; ++i) {
            relatePage = pageInfoList.get(i);
            String pageKey = relatePage.getNumber().toLowerCase(Locale.ROOT);
            if (!HRStringUtils.equals((String)pageKey, (String)onGetControlArgs.getKey())) continue;
            relateLabel = new Label();
            relateLabel.setKey(pageKey);
            relateLabel.setView(this.getView());
            relateLabel.addClickListener((ClickListener)this);
            onGetControlArgs.setControl((Control)relateLabel);
        }
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        String curRelatedPageKey = (String)this.getView().getFormShowParameter().getCustomParam("currentRelatePage");
        Map pageIconMap = (Map)this.getView().getFormShowParameter().getCustomParam("pageIcons");
        this.setSelectRelatePageLabelStyle(curRelatedPageKey, pageIconMap);
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (evt.getSource() instanceof Label) {
            Label curClickLabel = (Label)evt.getSource();
            String labelName = curClickLabel.getKey();
            this.hidePartTwoPanel();
            Map pageIconMap = (Map)this.getView().getFormShowParameter().getCustomParam("pageIcons");
            this.setSelectRelatePageLabelStyle(curClickLabel.getKey(), pageIconMap);
            this.showRelatedPageInContainer(labelName);
            this.getPageCache().put("currentRelatePage", labelName);
        } else if (evt.getSource() instanceof Vector) {
            Vector clickImg = (Vector)evt.getSource();
            if (clickImg.getKey().equals("imgup")) {
                this.hidePartTwoPanel();
            } else if (clickImg.getKey().equals("imgdown")) {
                this.showPartTwoPanel();
            }
        }
    }

    private void setSelectRelatePageLabelStyle(String labelNumber, Map<String, String> pageIconMap) {
        String relateEntityTypeId = (String)this.getView().getFormShowParameter().getCustomParam("hbss_entitytype_id");
        RelatePageInfo relatePageInfo = null;
        List<RelatePageInfo> pageInfoList = this.getPageInfoList(relateEntityTypeId, this.getView().getPageId());
        boolean isPerm = false;
        int size = pageInfoList.size();
        for (int i = 0; i < size; ++i) {
            relatePageInfo = pageInfoList.get(i);
            if (!labelNumber.equalsIgnoreCase(relatePageInfo.getNumber())) continue;
            isPerm = true;
            break;
        }
        if (!isPerm) {
            if (logger.isInfoEnabled()) {
                logger.info("labelNumber:" + labelNumber + "isPerm:" + isPerm);
            }
            if (pageInfoList.size() == 0) {
                return;
            }
            labelNumber = pageInfoList.get(0).getNumber();
            if (logger.isInfoEnabled()) {
                logger.info("pageInfoList.get(0).getNumber():" + pageInfoList.get(0).getNumber());
            }
        }
        this.showRelatedPageInContainer(labelNumber);
        this.setPageInfoList(labelNumber, pageIconMap, pageInfoList);
        if (logger.isInfoEnabled()) {
            logger.info("labelNumber:" + labelNumber);
        }
        if (Objects.isNull(relatePageInfo = HRRelatePanelSetFactory.getRelatePageInfo((String)relateEntityTypeId, (String)labelNumber.toUpperCase(Locale.ROOT)))) {
            return;
        }
        if (logger.isInfoEnabled()) {
            logger.info("relatePageInfo:" + relatePageInfo);
        }
        this.setSelectPage(pageIconMap, relatePageInfo);
    }

    private void setSelectPage(Map<String, String> pageIconMap, RelatePageInfo relatePageInfo) {
        LabelAp selectLabelAp = this.assembleSelectRelatePageLabelAp(relatePageInfo);
        this.getView().updateControlMetadata(selectLabelAp.getKey(), selectLabelAp.createControl());
        FlexPanelAp selectFlexPanelAp = this.assembleSelectRelatePanelAp(relatePageInfo.getNumber() + PANEL);
        selectFlexPanelAp.getItems().add(selectLabelAp);
        String number = relatePageInfo.getNumber().toLowerCase(Locale.ROOT);
        if (pageIconMap != null && !pageIconMap.isEmpty() && pageIconMap.containsKey(number)) {
            ImageAp pageIconAp = this.assembleImageAp(number, pageIconMap);
            selectFlexPanelAp.getItems().add(pageIconAp);
        }
        this.getView().updateControlMetadata(selectFlexPanelAp.getKey(), selectFlexPanelAp.createControl());
    }

    private void setPageInfoList(String labelNumber, Map<String, String> pageIconMap, List<RelatePageInfo> pageInfoList) {
        int size = pageInfoList.size();
        for (int i = 0; i < size; ++i) {
            RelatePageInfo relatePageInfo = pageInfoList.get(i);
            if (labelNumber.equals(relatePageInfo.getNumber().toLowerCase(Locale.ROOT))) continue;
            LabelAp relateLabelPanelAp = this.assembleRelatePageLabelAp(relatePageInfo);
            this.getView().updateControlMetadata(relateLabelPanelAp.getKey(), relateLabelPanelAp.createControl());
            FlexPanelAp relatePanelAp = this.assembleRelatePanelAp(relatePageInfo.getNumber() + PANEL);
            relatePanelAp.getItems().add(relateLabelPanelAp);
            if (pageIconMap != null && !pageIconMap.isEmpty() && pageIconMap.containsKey(relatePageInfo.getNumber())) {
                ImageAp pageIconAp = this.assembleImageAp(relatePageInfo.getNumber(), pageIconMap);
                relatePanelAp.getItems().add(pageIconAp);
            }
            this.getView().updateControlMetadata(relatePanelAp.getKey(), relatePanelAp.createControl());
        }
    }

    private void showRelatedPageInContainer(String relatedNumber) {
        String relateEntityTypeId = (String)this.getView().getFormShowParameter().getCustomParam("hbss_entitytype_id");
        RelatePageInfo relatePageInfo = HRRelatePanelSetFactory.getRelatePageInfo((String)relateEntityTypeId, (String)relatedNumber.toUpperCase(Locale.ROOT));
        if (Objects.isNull(relatePageInfo)) {
            return;
        }
        String relatedPageName = relatePageInfo.getPageNumber();
        if (relatePageInfo.getPageType().equals("1")) {
            this.setPageEdit(relatePageInfo, relatedPageName);
        } else if (relatePageInfo.getPageType().equals("2")) {
            this.setPageList(relatePageInfo, relatedPageName);
        } else if (relatePageInfo.getPageType().equals("4")) {
            ListShowParameter formShowParameter = new ListShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
            formShowParameter.getOpenStyle().setTargetKey(MAINPAGEPANEL);
            formShowParameter.setFormId("hbp_cardviewtpl");
            formShowParameter.setBillFormId(relatedPageName);
            formShowParameter.setLookUp(false);
            formShowParameter.setCustomParam("type", (Object)"list");
            formShowParameter.setCustomParams(this.getView().getFormShowParameter().getCustomParams());
            this.getView().showForm((FormShowParameter)formShowParameter);
        } else if (relatePageInfo.getPageType().equals("3")) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
            formShowParameter.getOpenStyle().setTargetKey(MAINPAGEPANEL);
            formShowParameter.setFormId(relatedPageName);
            formShowParameter.setCustomParams(this.getView().getFormShowParameter().getCustomParams());
            this.getView().showForm(formShowParameter);
        }
    }

    private void setPageList(RelatePageInfo relatePageInfo, String relatedPageName) {
        ListShowParameter formShowParameter = new ListShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey(MAINPAGEPANEL);
        formShowParameter.setFormId("hr_list");
        formShowParameter.setBillFormId(relatedPageName);
        formShowParameter.setLookUp(false);
        formShowParameter.setCustomParam("type", (Object)"list");
        formShowParameter.setCustomParams(this.getView().getFormShowParameter().getCustomParams());
        if (HRStringUtils.isNotEmpty((String)relatePageInfo.getFilterCondition())) {
            QFilter qFilter = QFilter.of((String)relatePageInfo.getFilterCondition(), (Object[])new Object[0]);
            formShowParameter.getListFilterParameter().setFilter(qFilter);
        }
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    public void setPageEdit(RelatePageInfo relatePageInfo, String relatedPageName) {
        QFilter[] objFilterArray;
        DynamicObject[] relatePageObjArray;
        String customPKFilterMapValue;
        BaseShowParameter formShowParameter = new BaseShowParameter();
        formShowParameter.setFormId(relatedPageName);
        formShowParameter.setCustomParams(this.getView().getFormShowParameter().getCustomParams());
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(relatedPageName);
        String currentObjId = (String)this.getView().getFormShowParameter().getCustomParam("currentObjectPKId");
        QFilter mainObjFilter = new QFilter(relatePageInfo.getMainPropName(), "=", (Object)Long.valueOf(currentObjId));
        Map customPKFilterMap = (Map)this.getView().getFormShowParameter().getCustomParam("customPKFilter");
        if (customPKFilterMap != null && (customPKFilterMapValue = (String)customPKFilterMap.get(relatedPageName)) != null) {
            String customPKFilterStr = customPKFilterMapValue;
            QFilter customPKFilter = QFilter.fromSerializedString((String)customPKFilterStr);
            mainObjFilter.and(customPKFilter);
        }
        if ((relatePageObjArray = serviceHelper.query("id", objFilterArray = new QFilter[]{mainObjFilter})) != null && relatePageObjArray.length > 0) {
            formShowParameter.setPkId(relatePageObjArray[0].get("id"));
            formShowParameter.setBillStatus(BillOperationStatus.VIEW);
            formShowParameter.setStatus(OperationStatus.VIEW);
        } else {
            formShowParameter.setBillStatus(BillOperationStatus.ADDNEW);
            formShowParameter.setStatus(OperationStatus.ADDNEW);
        }
        formShowParameter.getOpenStyle().setTargetKey(MAINPAGEPANEL);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private List<RelatePageInfo> getPageInfoList(String relateEntityTypeId, String pageId) {
        if (logger.isInfoEnabled()) {
            logger.info("relateEntityTypeId:" + relateEntityTypeId + "pageId:" + pageId);
        }
        PageCache pageCache = new PageCache(pageId);
        String chacheStr = pageCache.get(CACHE_RELATEPAGELDFT);
        List pageInfoList = null;
        if (Objects.isNull(chacheStr)) {
            pageInfoList = HRRelatePanelSetFactory.getRelatePageInfoList((String)relateEntityTypeId);
            pageCache.put(CACHE_RELATEPAGELDFT, SerializationUtils.toJsonString((Object)pageInfoList));
        } else {
            pageInfoList = SerializationUtils.fromJsonStringToList((String)chacheStr, RelatePageInfo.class);
        }
        if (logger.isInfoEnabled()) {
            logger.info("pageInfoList:" + pageInfoList.size() + "," + pageInfoList);
        }
        return pageInfoList;
    }

    private void addAllPageLabelForRelatePanel(FlexPanelAp relatePanelAp, List<RelatePageInfo> pageInfoList) {
        RelatePageInfo pageInfo = null;
        LabelAp lblRelatePageAp = null;
        FlexPanelAp relateLabelPanelAp = null;
        int size = pageInfoList.size();
        for (int i = 0; i < size; ++i) {
            pageInfo = pageInfoList.get(i);
            lblRelatePageAp = this.assembleRelatePageLabelAp(pageInfo);
            relateLabelPanelAp = this.assembleRelatePanelAp(pageInfo.getNumber() + PANEL);
            relateLabelPanelAp.getItems().add(lblRelatePageAp);
            relatePanelAp.getItems().add(relateLabelPanelAp);
        }
    }

    private ImageAp assembleImageAp(String numberStr, Map<String, String> pageIconMap) {
        String imageKeyNumStr = pageIconMap.get(numberStr);
        ImageAp pageIconAp = ((HRImageAp.Builder)new HRImageAp.Builder("pageIcon" + numberStr).setHeight("5px").setWidth("5px").setGrow(0).setShrink(1).setRadius("30px").setImageKey(imageKeyNumStr).setMarginTop("10px")).setClickable(true).build();
        return pageIconAp;
    }

    private FlexPanelAp assembleRelatePanelAp(String relatePanelName) {
        FlexPanelAp relatePanelAp = new FlexPanelAp();
        relatePanelAp.setKey(relatePanelName);
        relatePanelAp.setWrap(true);
        relatePanelAp.setDirection("row");
        relatePanelAp.setAlignItems(FLEX_START);
        relatePanelAp.setJustifyContent(FLEX_START);
        relatePanelAp.setHeight(new LocaleString("40px"));
        relatePanelAp.setWidth(new LocaleString("100%"));
        Style style = new Style();
        Border border = new Border();
        String borderStyle = "4px_solid_#ffffff";
        border.setLeft(borderStyle);
        style.setBorder(border);
        relatePanelAp.setStyle(style);
        String hoverCss = "eyJ0eXBlIjowLCJjb250ZW50IjoiwqAvKiogXG4qIOagt+S+i1xuKiDmlK/mjIHljp/nlJ9jc3PmoLflvI/lhpnms5Vcbiog5b2T5YmN5YWD57Sg55qEY2xhc3NOYW1l5L2/55SoIFwiJFwiIOS7o+abv++8jOS4jeaUr+aMgeiHquWumuS5ieWFg+e0oGNsYXNzTmFtZVxuKiDnm67liY3mj5DkvpvkuInkuKrmoLfmnb/vvIzmiZPlvIDms6jph4rljbPlj6/kvb/nlKhcbiog5rOo6YeK5YaF5a655Lya6KKr6L+H5ruk5LiN5bGV56S6XG4qIOWmgumcgOS9v+eUqOW5s+WPsOS4u+mimOiJsu+8jOWPr+S7peS9v+eUqCd0aGVtZUNvbG9yJ+adpeS7o+aMh1xuICovXG4vKipcbiog5b2T5YmN5YWD57Sg6IOM5pmv6aKc6Imy6Lef6ZqP5Li76aKY6ImyXG4qL1xuLyoqXG4kIHtcbsKgwqBiYWNrZ3JvdW5kOid0aGVtZUNvbG9yJztcbsKgfVxuKi9cbsKgLyoqXG4qIOS/ruaUueW9k+WJjeWFg+e0oOiDjOaZr+minOiJslxuKi9cbi8qKlxuJCB7XG7CoMKgYmFja2dyb3VuZDpyZWQ7XG7CoH1cbiovXG7CoC8qKlxuKiDkv67mlLnlvZPliY3lhYPntKBob3ZlcuaViOaenFxuwqAgKi9cbi8qKlxuJDpob3ZlciB7XG7CoMKgYmFja2dyb3VuZDpyZWQ7XG7CoH1cbiovXG4vKipcbiAqIOS/ruaUueW9k+WJjeWFg+e0oOS4umRpduagh+etvuWtkOWFg+e0oFxuKi9cbi8qKlxuJCA+IGRpdiB7XG7CoGJhY2tncm91bmQ6cmVkO1xuwqB9XG4gKi9cbiQgPiBkaXYgOmhvdmVye1xuICBcdGNvbG9yOid0aGVtZUNvbG9yJyFpbXBvcnRhbnQ7XG59In0=";
        relatePanelAp.setCustomeStyles(hoverCss);
        return relatePanelAp;
    }

    private FlexPanelAp assembleSelectRelatePanelAp(String relatePanelName) {
        FlexPanelAp relatePanelAp = new FlexPanelAp();
        relatePanelAp.setKey(relatePanelName);
        relatePanelAp.setWrap(true);
        relatePanelAp.setDirection("row");
        relatePanelAp.setAlignItems(FLEX_START);
        relatePanelAp.setJustifyContent(FLEX_START);
        relatePanelAp.setHeight(new LocaleString("40px"));
        Style style = new Style();
        Border border = new Border();
        String borderStyle = "4px_solid_themeColor";
        border.setLeft(borderStyle);
        style.setBorder(border);
        relatePanelAp.setStyle(style);
        return relatePanelAp;
    }

    private LabelAp assembleRelatePageLabelAp(RelatePageInfo relatePageInfo) {
        LabelAp lblRelatePageAp = this.assembleBaseLabelAp(relatePageInfo);
        lblRelatePageAp.setForeColor("#333333");
        Style style = new Style();
        Border border = new Border();
        style.setBorder(border);
        Padding padding = new Padding();
        padding.setLeft("16px");
        style.setPadding(padding);
        Margin margin = new Margin();
        margin.setTop("10px");
        style.setMargin(margin);
        lblRelatePageAp.setStyle(style);
        return lblRelatePageAp;
    }

    private LabelAp assembleSelectRelatePageLabelAp(RelatePageInfo relatePageInfo) {
        LabelAp lblRelatePageAp = this.assembleBaseLabelAp(relatePageInfo);
        lblRelatePageAp.setForeColor("themeColor");
        lblRelatePageAp.setBackColor("var(--theme-color-level1)");
        lblRelatePageAp.setHeight(new LocaleString("100%"));
        lblRelatePageAp.setWidth(new LocaleString("100%"));
        Style style = new Style();
        Padding padding = new Padding();
        padding.setLeft("16px");
        padding.setTop("10px");
        style.setPadding(padding);
        lblRelatePageAp.setStyle(style);
        return lblRelatePageAp;
    }

    private LabelAp assembleBaseLabelAp(RelatePageInfo relatePageInfo) {
        LabelAp lblRelatePageAp = new LabelAp();
        lblRelatePageAp.setId(relatePageInfo.getNumber());
        lblRelatePageAp.setKey(relatePageInfo.getNumber());
        lblRelatePageAp.setName(new LocaleString(relatePageInfo.getPageName()));
        lblRelatePageAp.setFontSize(14);
        lblRelatePageAp.setClickable(true);
        return lblRelatePageAp;
    }

    private void showPartTwoPanel() {
        this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelparttwo"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpaneldownarrow"});
    }

    private void hidePartTwoPanel() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelparttwo"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"flexpaneldownarrow"});
    }
}

