/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.template;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.orm.query.QFilter;
import kd.bos.script.annotations.KSMethod;
import kd.hr.hbp.business.application.impl.common.HrEntityCommonService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisCommonService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.HRBaseDataConfigUtil;
import kd.hr.hbp.bussiness.cert.HRCertCheckServiceHelper;
import kd.hr.hbp.common.constants.HRBaseConstants;
import kd.hr.hbp.common.constants.newhismodel.EnumEntityTpl;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hbp.formplugin.web.util.HRBaseDataUtils;
import kd.sdk.annotation.SdkPlugin;
import org.apache.commons.lang3.StringUtils;

@SdkPlugin(name="HR\u57fa\u7840\u8d44\u6599\u6a21\u677f\u8868\u5355\u63d2\u4ef6")
public class HRBaseDataTplEdit
extends HRDataBaseEdit {
    public static final String SET_TITTLE_AFTER_DELETE = "setTittleAfterDelete";
    private static Log LOGGER = LogFactory.getLog(HRBaseDataTplEdit.class);
    private Map<String, Object> params;

    public void afterBindData(EventObject e) {
        LOGGER.info("HRBaseDataTplEdit afterBindData start:");
        super.afterBindData(e);
        this.setBillStatus();
        this.setButtonStatus();
        if (HRStringUtils.equals((String)this.getPageCache().get(SET_TITTLE_AFTER_DELETE), (String)Boolean.TRUE.toString())) {
            this.getPageCache().remove(SET_TITTLE_AFTER_DELETE);
            Object objName = this.getView().getModel().getValue("name");
            if (objName == null || !(objName instanceof ILocaleString)) {
                return;
            }
            LocaleString caption = this.getView().getFormShowParameter().getFormConfig().getCaption();
            ILocaleString name = (ILocaleString)objName;
            if (HRStringUtils.isNotEmpty((String)name.toString())) {
                String tittle = String.format(ResManager.loadKDString((String)"%1$s-%2$s", (String)"HRBaseDataTplEdit_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), caption, name);
                this.getView().setFormTitle(new LocaleString(tittle));
            }
        }
    }

    public void afterLoadData(EventObject e) {
        this.setBillStatus();
    }

    public void initImportData(InitImportDataEventArgs e) {
        super.initImportData(e);
        IDataEntityProperty property = this.getModel().getProperty("status");
        BillStatusProp billStatusProp = (BillStatusProp)property;
        String formId = this.getView().getModel().getDataEntityType().getName();
        boolean needAudit = this.isNeedAudit(formId);
        if (!needAudit) {
            billStatusProp.setDefValue((Object)"C");
        }
    }

    private boolean isNeedAudit(String formId) {
        if (Objects.isNull(this.params) || this.params.size() == 0) {
            this.params = HRBaseDataConfigUtil.getStatus((String)formId);
        }
        return (Boolean)this.params.get("auditcheck");
    }

    private boolean getHisModelCondition(String billFormId) {
        String entityType = HisCommonService.getInstance().entityInhRelation(billFormId);
        return EnumEntityTpl.LINETIMESEQ_TPL.getNumber().equals(entityType) || EnumEntityTpl.NONLINETIMESEQ_TPL.getNumber().equals(entityType);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String formId = this.getView().getModel().getDataEntityType().getName();
        boolean audit = this.isNeedAudit(formId);
        if (((BillShowParameter)this.getView().getFormShowParameter()).getBillStatus().equals((Object)BillOperationStatus.EDIT) && audit) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_disable", "bar_enable"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_disable", "bar_enable"});
        }
        this.setFormTitleAfterDoOperation(formId, afterDoOperationEventArgs);
        LOGGER.info("HRBaseDataTplEdit afterDoOperationEventArgs audit:" + audit);
        if (audit) {
            return;
        }
        if (this.isCommonType() && (StringUtils.equals((CharSequence)afterDoOperationEventArgs.getOperateKey(), (CharSequence)"modify") || StringUtils.equals((CharSequence)afterDoOperationEventArgs.getOperateKey(), (CharSequence)"save") || StringUtils.equals((CharSequence)afterDoOperationEventArgs.getOperateKey(), (CharSequence)"next") || StringUtils.equals((CharSequence)afterDoOperationEventArgs.getOperateKey(), (CharSequence)"first") || StringUtils.equals((CharSequence)afterDoOperationEventArgs.getOperateKey(), (CharSequence)"previous") || StringUtils.equals((CharSequence)afterDoOperationEventArgs.getOperateKey(), (CharSequence)"last"))) {
            OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
            LOGGER.info("HRBaseDataTplEdit operationResult:" + operationResult.isSuccess());
            if (operationResult.isSuccess()) {
                this.getModel().setValue("status", (Object)"A");
                this.getModel().setDataChanged(false);
            }
        }
    }

    private void setFormTitleAfterDoOperation(String formId, AfterDoOperationEventArgs args) {
        List parentEntity = HrEntityCommonService.getInstance().getParentEntity(formId);
        List templateDlgList = Arrays.stream(HRBaseConstants.templateDlg).collect(Collectors.toList());
        for (String templateDlgStr : templateDlgList) {
            if (!parentEntity.contains(templateDlgStr)) continue;
            return;
        }
        MetadataReader metadataReader = new MetadataReader();
        String formIdStr = metadataReader.loadIdByNumber(formId, MetaCategory.Entity);
        if (HRStringUtils.isEmpty((String)formIdStr)) {
            return;
        }
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        if (HRBaseDataUtils.skipControlPageLabelForHis(showParameter)) {
            return;
        }
        LocaleString caption = showParameter.getFormConfig().getCaption();
        switch (args.getOperateKey()) {
            case "save": 
            case "submit": {
                if (args.getOperationResult() == null || !args.getOperationResult().isSuccess()) {
                    return;
                }
                Object objName = this.getView().getModel().getValue("name");
                if (objName == null || !(objName instanceof ILocaleString)) {
                    return;
                }
                ILocaleString name = (ILocaleString)objName;
                if (!HRStringUtils.isNotEmpty((String)name.toString())) break;
                String tittle = String.format(ResManager.loadKDString((String)"%1$s-%2$s", (String)"HRBaseDataTplEdit_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), caption, name);
                this.getView().setFormTitle(new LocaleString(tittle));
                break;
            }
            case "new": {
                String tittle = String.format(ResManager.loadKDString((String)"\u65b0\u589e%s", (String)"HRBaseDataTplEdit_0", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), caption);
                this.getView().setFormTitle(new LocaleString(tittle));
                break;
            }
            case "delete": {
                this.getPageCache().put(SET_TITTLE_AFTER_DELETE, "true");
                break;
            }
        }
    }

    private boolean isCommonType() {
        String entityType = HisCommonService.getInstance().entityInhRelation(this.getModel().getDataEntity().getDataEntityType().getName());
        if (EnumEntityTpl.COMMON_TPL.getNumber().equals(entityType)) {
            return true;
        }
        Boolean isCurrentVersion = (Boolean)this.getModel().getValue("iscurrentversion");
        String dataStatus = (String)this.getModel().getValue("datastatus");
        return isCurrentVersion != false && (HRStringUtils.equals((String)dataStatus, (String)EnumHisDataVersionStatus.TEMP.getStatus()) || HRStringUtils.isEmpty((String)dataStatus));
    }

    private void setButtonStatus() {
        String formId = this.getView().getModel().getDataEntityType().getName();
        if (this.isNeedAudit(formId)) {
            if (((BillShowParameter)this.getView().getFormShowParameter()).getBillStatus().equals((Object)BillOperationStatus.EDIT)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_disable", "bar_enable"});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_disable", "bar_enable"});
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_submit", "bar_unsubmit", "bar_audit", "bar_unaudit"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_submit", "bar_unsubmit", "bar_audit", "bar_unaudit"});
        }
    }

    @KSMethod
    private void setBillStatus() {
        IDataEntityProperty property;
        String formId = this.getView().getModel().getDataEntityType().getName();
        String customParam = (String)this.getView().getFormShowParameter().getCustomParam("bill@#$status");
        if (HRStringUtils.equals((String)customParam, (String)String.valueOf(BillOperationStatus.VIEW.getValue()))) {
            ((IBillView)this.getView()).setBillStatus(BillOperationStatus.VIEW);
            return;
        }
        if (this.getView().getFormShowParameter().getStatus() == OperationStatus.VIEW) {
            ((IBillView)this.getView()).setBillStatus(BillOperationStatus.VIEW);
            return;
        }
        if (this.getView().getFormShowParameter().getStatus() == OperationStatus.ADDNEW) {
            this.getModel().setValue("status", (Object)"A");
            List iDataEntityProperties = this.getModel().getDataEntity().getDataEntityState().GetDirtyProperties();
            for (IDataEntityProperty property2 : iDataEntityProperties) {
                if (!HRStringUtils.equals((String)property2.getName(), (String)"status")) continue;
                int ordinal = property2.getOrdinal();
                this.getModel().getDataEntity().getDataEntityState().setBizChanged(ordinal, false);
                break;
            }
        }
        if ((property = this.getModel().getProperty("status")) != null) {
            LOGGER.info("HRBaseDataTplEdit getStatus:" + this.getView().getFormShowParameter().getStatus());
            LOGGER.info("HRBaseDataTplEdit getValue:" + this.getModel().getValue("status"));
            BillStatusProp billStatusProp = (BillStatusProp)property;
            billStatusProp.setDefValue((Object)"A");
            boolean bFromDb = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
            if (!bFromDb) {
                ((IBillView)this.getView()).setBillStatus(BillOperationStatus.ADDNEW);
                return;
            }
            if (this.isNeedAudit(formId)) {
                String value = (String)this.getModel().getValue("status");
                if ("B".equals(value)) {
                    ((IBillView)this.getView()).setBillStatus(BillOperationStatus.SUBMIT);
                    ((BillShowParameter)this.getView().getFormShowParameter()).setBillStatus(BillOperationStatus.SUBMIT);
                } else if ("C".equals(value)) {
                    ((IBillView)this.getView()).setBillStatus(BillOperationStatus.AUDIT);
                    ((BillShowParameter)this.getView().getFormShowParameter()).setBillStatus(BillOperationStatus.AUDIT);
                } else {
                    ((IBillView)this.getView()).setBillStatus(BillOperationStatus.EDIT);
                    ((BillShowParameter)this.getView().getFormShowParameter()).setBillStatus(BillOperationStatus.EDIT);
                }
            } else {
                LOGGER.info("HRBaseDataTplEdit getAudit false:");
                ((IBillView)this.getView()).setBillStatus(BillOperationStatus.EDIT);
                ((BillShowParameter)this.getView().getFormShowParameter()).setBillStatus(BillOperationStatus.EDIT);
            }
            this.getView().cacheFormShowParameter();
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        HRCertCheckServiceHelper.check((FormShowParameter)e.getFormShowParameter(), (PreOpenFormEventArgs)e);
        FormShowParameter showParameter = e.getFormShowParameter();
        if (HRBaseDataUtils.skipControlPageLabel(showParameter)) {
            return;
        }
        String formId = showParameter.getFormId();
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(formId);
        MetadataReader metadataReader = new MetadataReader();
        String formIdStr = metadataReader.loadIdByNumber(formId, MetaCategory.Entity);
        if (HRStringUtils.isEmpty((String)formIdStr)) {
            return;
        }
        LOGGER.info("HRBaseDataTplEdit handleUE formId:" + formId);
        if (HRStringUtils.isNotEmpty((String)formId) && showParameter instanceof BillShowParameter) {
            List parentEntity = HrEntityCommonService.getInstance().getParentEntity(formId);
            List templateDlgList = Arrays.stream(HRBaseConstants.templateDlg).collect(Collectors.toList());
            for (String templateDlgStr : templateDlgList) {
                if (!parentEntity.contains(templateDlgStr)) continue;
                return;
            }
            LocaleString caption = showParameter.getFormConfig().getCaption();
            if (showParameter.getStatus() == OperationStatus.ADDNEW) {
                String tittle = String.format(ResManager.loadKDString((String)"\u65b0\u589e%s", (String)"HRBaseDataTplEdit_0", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), caption);
                showParameter.setCaption(tittle);
            } else {
                List templateTplList = Arrays.stream(HRBaseConstants.templateTpl).collect(Collectors.toList());
                Object pkId = ((BillShowParameter)showParameter).getPkId();
                if (!Objects.isNull(pkId)) {
                    DynamicObject dynamicObject = null;
                    if (pkId instanceof String) {
                        String idStr = (String)pkId;
                        long id = Long.parseLong(idStr);
                        DynamicObject[] names = hrBaseServiceHelper.query("name", new QFilter[]{new QFilter("id", "=", (Object)id)});
                        if (names.length > 0) {
                            dynamicObject = names[0];
                        }
                    } else {
                        DynamicObject[] names = hrBaseServiceHelper.query("name", new QFilter[]{new QFilter("id", "=", pkId)});
                        if (names.length > 0) {
                            dynamicObject = names[0];
                        }
                    }
                    if (dynamicObject == null) {
                        return;
                    }
                    for (String templateTplStr : templateTplList) {
                        if (!parentEntity.contains(templateTplStr)) continue;
                        try {
                            String name = dynamicObject.getString("name");
                            LOGGER.info("HRBaseDataTplEdit handleUE tittle:" + name);
                            if (!HRStringUtils.isNotEmpty((String)name)) continue;
                            String tittle = String.format(ResManager.loadKDString((String)"%1$s-%2$s", (String)"HRBaseDataTplEdit_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), caption, name);
                            showParameter.setCaption(tittle);
                            return;
                        }
                        catch (Exception exception) {
                            LOGGER.error("HRBaseDataTplEdit handleUE:" + exception);
                        }
                    }
                }
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String formId = this.getView().getModel().getDataEntityType().getName();
        if (!this.isNeedAudit(formId)) {
            this.getModel().setValue("status", (Object)"C");
            List iDataEntityProperties = this.getModel().getDataEntity().getDataEntityState().GetDirtyProperties();
            for (IDataEntityProperty property : iDataEntityProperties) {
                if (!HRStringUtils.equals((String)property.getName(), (String)"status")) continue;
                int ordinal = property.getOrdinal();
                this.getModel().getDataEntity().getDataEntityState().setBizChanged(ordinal, false);
                break;
            }
        }
    }
}

