/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.template;

import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.util.HRBaseDataConfigUtil;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import org.apache.commons.lang3.StringUtils;

public class HRBasedataLogList
extends HRDataBaseList {
    private static final String BTN_LOG = "log";
    private static final String VIEW_LOG_AP = "viewlogap";
    private Map<String, Object> params;

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setButtonStatus();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operKey = formOperate.getOperateKey();
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (StringUtils.equals((CharSequence)"logview", (CharSequence)operKey)) {
            this.viewLog(listShowParameter.getBillFormId(), 0L);
        } else if (StringUtils.equals((CharSequence)"viewonelog", (CharSequence)operKey)) {
            ListSelectedRowCollection listSelectedData = args.getListSelectedData();
            ListSelectedRow listSelectedRow = listSelectedData.get(0);
            long primaryKeyValue = (Long)listSelectedRow.getPrimaryKeyValue();
            this.viewLog(listShowParameter.getBillFormId(), primaryKeyValue);
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        List columns = args.getListColumns();
        if (!this.getRecordChanged()) {
            Iterator it = columns.iterator();
            while (it.hasNext()) {
                IListColumn column = (IListColumn)it.next();
                if (!StringUtils.equals((CharSequence)column.getListFieldKey(), (CharSequence)VIEW_LOG_AP)) continue;
                it.remove();
            }
        }
    }

    private void viewLog(String billFormId, long primaryKeyValue) {
        ListShowParameter lsp = new ListShowParameter();
        lsp.setFormId("bos_list");
        lsp.setBillFormId("hbss_history_logview");
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        QFilter bizobj = new QFilter("bizobj", "=", (Object)billFormId);
        if (primaryKeyValue != 0L) {
            bizobj.and(new QFilter("modifybillid", "like", (Object)(String.valueOf(primaryKeyValue) + "%")));
        }
        listFilterParameter.setFilter(bizobj);
        lsp.setListFilterParameter(listFilterParameter);
        FormShowParameter listShowParameter = this.getView().getFormShowParameter();
        lsp.setCustomParam("caption", (Object)listShowParameter.getCaption());
        lsp.setCustomParam("appId", (Object)listShowParameter.getAppId());
        lsp.setCustomParam("formId", (Object)((ListShowParameter)listShowParameter).getBillFormId());
        lsp.setCustomParam("tab", (Object)"1");
        lsp.setCustomParam("pkid", (Object)primaryKeyValue);
        lsp.setHasRight(true);
        String pageId = this.getView().getPageId() + "_" + primaryKeyValue;
        lsp.setPageId(pageId);
        lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)lsp);
    }

    private boolean getRecordChanged() {
        String formId = ((BillList)this.getControl("billlistap")).getListModel().getDataEntityType().getName();
        if (Objects.isNull(this.params) || this.params.size() == 0) {
            this.params = HRBaseDataConfigUtil.getStatus((String)formId);
        }
        return (Boolean)this.params.get("changecheck");
    }

    private void setButtonStatus() {
        if (this.getRecordChanged()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_LOG});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_LOG});
        }
    }
}

