/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.template;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.commonfield.DropdownItem;
import kd.bos.metadata.form.BasedataFormAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.BarItemAp;
import kd.bos.mvc.bill.BillView;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRQFilterHelper;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class HRHiesButtonSwitchPlugin
extends AbstractFormPlugin {
    private static Log LOGGER = LogFactory.getLog(HRHiesButtonSwitchPlugin.class);

    public void afterBindData(EventObject arg) {
        Object[] switchRegistryDyns;
        IFormView view = this.getView();
        if (!(view instanceof ListView) && !(view instanceof BillView)) {
            LOGGER.warn("\u4e0d\u652f\u6301\u6b64\u79cd\u7c7b\u578b\u9875\u9762");
            return;
        }
        String billFormId = view instanceof ListView ? ((IListView)view).getBillFormId() : view.getEntityId();
        try {
            String id = MetadataDao.getIdByNumber((String)billFormId, (MetaCategory)MetaCategory.Form);
            HRBaseServiceHelper switchRegistryService = new HRBaseServiceHelper("hies_switchregistry");
            switchRegistryDyns = switchRegistryService.queryOriginalArray("optype,oldop,newop,permitem,enablestatus", new QFilter[]{HRQFilterHelper.buildEql((String)"entity", (Object)id)});
            if (ArrayUtils.isEmpty((Object[])switchRegistryDyns)) {
                return;
            }
        }
        catch (Exception ex) {
            LOGGER.warn("\u67e5\u8be2hr\u5bfc\u5165\u5bfc\u51fa\u5207\u6362\u65b9\u6848\u5931\u8d25 errmsg:{}", (Object)ex.getMessage(), (Object)ex);
            return;
        }
        boolean enableNoPermBtnHide = PermCommonUtil.isEnableNoPermBtnHide();
        LOGGER.info("billFormId:{} enableNoPermBtnHide:{}", (Object)billFormId, (Object)enableNoPermBtnHide);
        for (Object switchRegistryDyn : switchRegistryDyns) {
            String opType = switchRegistryDyn.getString("optype");
            String oldOp = switchRegistryDyn.getString("oldop");
            String newOp = switchRegistryDyn.getString("newop");
            String permItem = switchRegistryDyn.getString("permitem");
            if (StringUtils.isBlank((CharSequence)permItem)) {
                if ("expt".equals(opType)) {
                    permItem = "4730fc9f000004ae";
                } else if ("impt".equals(opType)) {
                    permItem = "4730fc9f000003ae";
                }
            }
            if (enableNoPermBtnHide) {
                String queryFormId = MetadataDao.getIdByNumber((String)billFormId, (MetaCategory)MetaCategory.Form);
                AbstractMetadata abstractMetadata = MetadataDao.readMeta((String)queryFormId, (MetaCategory)MetaCategory.Form);
                String appId = AppMetadataCache.getAppNumberById((String)abstractMetadata.getBizappId());
                long currUserId = RequestContext.get().getCurrUserId();
                boolean isPerm = PermissionServiceHelper.checkPermission((Long)currUserId, (String)appId, (String)billFormId, (String)permItem);
                LOGGER.info("currUserId:{} appId:{} billFormId:{} permItem:{}", new Object[]{currUserId, appId, billFormId, permItem});
                if (isPerm) {
                    this.switchButton(view, billFormId, (DynamicObject)switchRegistryDyn, oldOp, newOp);
                    continue;
                }
                view.setVisible(Boolean.FALSE, new String[]{oldOp});
                view.setVisible(Boolean.FALSE, new String[]{newOp});
                continue;
            }
            this.switchButton(view, billFormId, (DynamicObject)switchRegistryDyn, oldOp, newOp);
        }
    }

    private void switchButton(IFormView view, String billFormId, DynamicObject switchRegistryDyn, String oldOp, String newOp) {
        String enableStatus = switchRegistryDyn.getString("enablestatus");
        if ("1".equals(enableStatus)) {
            view.setVisible(Boolean.TRUE, new String[]{oldOp});
            view.setVisible(Boolean.FALSE, new String[]{newOp});
            view.updateControlMetadata(newOp, Collections.singletonMap("vi", 0));
            view.updateControlMetadata(oldOp, Collections.singletonMap("vi", 63));
        } else {
            view.setVisible(Boolean.FALSE, new String[]{oldOp});
            view.setVisible(Boolean.TRUE, new String[]{newOp});
            view.updateControlMetadata(oldOp, Collections.singletonMap("vi", 0));
            view.updateControlMetadata(newOp, Collections.singletonMap("vi", 63));
        }
    }

    private void setVisible(String billFormId, String buttonKey) {
        String entityId = MetadataDao.getIdByNumber((String)billFormId, (MetaCategory)MetaCategory.Form);
        FormMetadata metadata = (FormMetadata)MetadataDao.readMeta((String)entityId, (MetaCategory)MetaCategory.Form);
        HashMap btnMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap btnMap2 = Maps.newHashMapWithExpectedSize((int)16);
        metadata.getItems().forEach(item -> {
            if (item instanceof BasedataFormAp) {
                BasedataFormAp basedataFormAp = (BasedataFormAp)item;
                if (basedataFormAp.getListMeta() == null) {
                    return;
                }
                basedataFormAp.getListMeta().getItems().forEach(listItem -> {
                    if (listItem instanceof BarItemAp) {
                        this.addButton((ControlAp)listItem, btnMap, btnMap2);
                    }
                });
            } else if (item instanceof BarItemAp) {
                this.addButton((ControlAp)item, btnMap, btnMap2);
            }
        });
        BarItemAp barItemAp = (BarItemAp)btnMap.get(buttonKey);
        if (ObjectUtils.isNotEmpty((Object)barItemAp)) {
            barItemAp.setVisible("init,new,edit,view,submit,audit");
        } else {
            DropdownItem dropdownItem = (DropdownItem)btnMap2.get(buttonKey);
            dropdownItem.setVisible("init,new,edit,view,submit,audit,default");
        }
    }

    private void addButton(ControlAp item, Map<String, BarItemAp> btnMap, Map<String, DropdownItem> btnMap2) {
        BarItemAp barItemAp = (BarItemAp)item;
        if (StringUtils.isNotEmpty((CharSequence)barItemAp.getOperationKey())) {
            btnMap.put(barItemAp.getKey(), barItemAp);
        }
        barItemAp.getDropdownItems().forEach(dropdownItem -> {
            if (StringUtils.isNotEmpty((CharSequence)dropdownItem.getOperationKey())) {
                btnMap2.put(dropdownItem.getKey(), (DropdownItem)dropdownItem);
            }
        });
    }
}

