/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.model.AdminOrgPermModel;
import kd.hr.hbp.common.model.HRFilterFieldInfo;
import kd.hr.hbp.common.model.HRFilterFieldItemInfo;
import kd.hr.hbp.common.util.HRStringUtils;

public class HRCommonFilterTool {
    private static final String IHBSS_SERVICE = "IHBSSService";

    public static QFilter assembleQFilterInfo(HRFilterFieldInfo hrFilterFieldInfo) {
        if (hrFilterFieldInfo == null) {
            return null;
        }
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        List hrFilterFieldItemInfos = hrFilterFieldInfo.getFilterFieldItemInfoList();
        QFilter qFilter = null;
        for (HRFilterFieldItemInfo hrFilterFieldItemInfo : hrFilterFieldItemInfos) {
            QFilter filter;
            String filterPropName = hrFilterFieldItemInfo.getFilterPropName();
            String filterType = hrFilterFieldItemInfo.getFilterType();
            String operationType = hrFilterFieldItemInfo.getOperationType();
            if (HRStringUtils.equals((String)filterType, (String)"adminorg")) {
                filter = HRCommonFilterTool.getEnabledAdminPermFilter(userId, operationType, filterPropName);
                qFilter = HRCommonFilterTool.setQFilter(qFilter, filter);
                continue;
            }
            if (HRStringUtils.equals((String)filterType, (String)"hrbu")) {
                filter = hrFilterFieldItemInfo.getQFilter();
                qFilter = HRCommonFilterTool.setQFilter(qFilter, filter);
                continue;
            }
            if (!HRStringUtils.equals((String)filterType, (String)"custom")) continue;
            filter = hrFilterFieldItemInfo.getQFilter();
            qFilter = HRCommonFilterTool.setQFilter(qFilter, filter);
        }
        return qFilter;
    }

    private static QFilter setQFilter(QFilter qFilter, QFilter filter) {
        if (qFilter == null) {
            qFilter = filter;
        } else {
            qFilter.and(filter);
        }
        return qFilter;
    }

    private static QFilter getEnabledAdminPermFilter(Long userId, String operationType, String filterPropName) {
        List orgIds = (List)HRMServiceHelper.invokeHRMPService((String)"hbss", (String)IHBSS_SERVICE, (String)"getOrgListFromPermFiles", (Object[])new Object[]{userId});
        QFilter filter = new QFilter(filterPropName, operationType, (Object)orgIds);
        return filter;
    }

    public static QFilter getAllAdminPermFilter(Long userId, String operationType, String filterPropName) {
        List orgIds = (List)HRMServiceHelper.invokeHRMPService((String)"hbss", (String)IHBSS_SERVICE, (String)"getAllOrgListFromPermFiles", (Object[])new Object[]{userId});
        QFilter filter = new QFilter(filterPropName, operationType, (Object)orgIds);
        return filter;
    }

    @Deprecated
    public static void setFiledByAdminPerm(IDataModel model, String key) {
        Long orgId;
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        List orgIds = (List)HRMServiceHelper.invokeHRMPService((String)"hbss", (String)IHBSS_SERVICE, (String)"getOrgListFromPermFiles", (Object[])new Object[]{userId});
        DynamicObject org = (DynamicObject)model.getValue(key);
        if (org != null && !orgIds.contains(orgId = Long.valueOf(org.getLong("id")))) {
            model.setValue(key, null);
        }
    }

    public static void setFieldByAdminPerm(AdminOrgPermModel model) {
        Long orgId;
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        Set orgIds = (Set)HRMServiceHelper.invokeHRMPService((String)"hbss", (String)"IHBSSPermService", (String)"getAdminOrgSetByPermItem", (Object[])new Object[]{userId, model.getAppId(), model.getPermEntityId(), model.getPermItemId(), model.isAdminOrgFilterEnable()});
        IDataModel dataModel = model.getModel();
        DynamicObject org = (DynamicObject)dataModel.getValue(model.getFieldKey());
        if (org != null && !orgIds.contains(orgId = Long.valueOf(org.getLong("id")))) {
            dataModel.setValue(model.getFieldKey(), null);
        }
    }

    public static void setSchemefilterF7FiledRange(List<FilterColumn> filterColumnList, String filterField, DynamicObject[] dys) {
        for (FilterColumn filterColumn : filterColumnList) {
            if (!HRStringUtils.equals((String)(filterField + ".number"), (String)filterColumn.getFieldName()) && !HRStringUtils.equals((String)(filterField + ".name"), (String)filterColumn.getFieldName())) continue;
            HRCommonFilterTool.setComboItems((CommonFilterColumn)filterColumn, dys);
        }
    }

    private static void setComboItems(CommonFilterColumn commonFilterColumn, DynamicObject[] dys) {
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>();
        int cunt = 0;
        for (DynamicObject dy : dys) {
            ++cunt;
            if (dy == null) continue;
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(dy.getString("name")));
            item.setValue(String.valueOf(dy.get("id")));
            combos.add(item);
            if (cunt > 20) break;
        }
        commonFilterColumn.setComboItems(combos);
    }
}

