/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.util;

import com.google.common.collect.Lists;
import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.hr.hbp.common.util.HRStringUtils;

public class TreeViewSearchTool {
    private static final String KEY_PARAM_SEARCH_TEXT = "searchText";
    private static final String KEY_PARAM_SEARCH_NODE = "searchNode";
    private static final String KEY_PARAM_SEARCH_NODE_INDEX = "searchNodeIndex";

    private TreeViewSearchTool() {
    }

    public static void search(String searchText, TreeView tv, IPageCache pageCache) {
        TreeViewSearchTool.search(searchText, tv, pageCache, tv.getKey());
    }

    public static void search(String searchText, TreeView tv, IPageCache pageCache, String treeFlag) {
        String paramSearchNodes;
        TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)pageCache.get(tv.getKey()), TreeNode.class);
        if (!StringUtils.equals((CharSequence)searchText, (CharSequence)pageCache.get(treeFlag + KEY_PARAM_SEARCH_TEXT))) {
            pageCache.put(treeFlag + KEY_PARAM_SEARCH_TEXT, searchText);
            pageCache.put(treeFlag + KEY_PARAM_SEARCH_NODE, "");
            pageCache.remove(treeFlag + KEY_PARAM_SEARCH_NODE_INDEX);
            TreeViewSearchTool.searchParamByText(searchText, rootNode, pageCache, treeFlag);
        }
        if (HRStringUtils.isEmpty((String)(paramSearchNodes = pageCache.get(treeFlag + KEY_PARAM_SEARCH_NODE)))) {
            return;
        }
        List searchNodeList = (List)SerializationUtils.fromJsonString((String)paramSearchNodes, List.class);
        String index = pageCache.get(treeFlag + KEY_PARAM_SEARCH_NODE_INDEX);
        int nodeIndex = HRStringUtils.isEmpty((String)index) ? 0 : Integer.parseInt(index);
        String currentSearchNodeId = (String)searchNodeList.get(nodeIndex);
        TreeNode currentSearchNode = rootNode.getTreeNode(currentSearchNodeId, 4);
        tv.showNode(currentSearchNodeId);
        tv.focusNode(currentSearchNode);
        nodeIndex = nodeIndex + 1 >= searchNodeList.size() ? 0 : nodeIndex + 1;
        pageCache.put(treeFlag + KEY_PARAM_SEARCH_NODE_INDEX, String.valueOf(nodeIndex));
    }

    private static void searchParamByText(String text, TreeNode node, IPageCache pageCache, String treeFlag) {
        List children;
        if (node.getText().contains(text)) {
            String paramSearchNodes = pageCache.get(treeFlag + KEY_PARAM_SEARCH_NODE);
            List searchNodeList = HRStringUtils.isEmpty((String)paramSearchNodes) ? Lists.newArrayListWithCapacity((int)16) : (List)SerializationUtils.fromJsonString((String)paramSearchNodes, List.class);
            searchNodeList.add(node.getId());
            pageCache.put(treeFlag + KEY_PARAM_SEARCH_NODE, SerializationUtils.toJsonString((Object)searchNodeList));
        }
        if ((children = node.getChildren()) == null) {
            return;
        }
        for (TreeNode child : children) {
            TreeViewSearchTool.searchParamByText(text, child, pageCache, treeFlag);
        }
    }
}

