/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.util.newhismodel;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.CollectionUtils;
import kd.bos.web.actions.utils.FilePathUtil;
import kd.bos.web.actions.utils.FilePremissionUtil;
import kd.hr.hbp.business.domain.service.attachment.HisAttachmentService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisCommonService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class HisAttachmentTool {
    private static final Log LOGGER = LogFactory.getLog(HisAttachmentTool.class);

    public static void registerAttachments(IFormView view, UploadListener listener) {
        List attachments = (List)view.getFormShowParameter().getCustomParam("attachments");
        if (attachments == null) {
            HashSet attachment = Sets.newHashSetWithExpectedSize((int)16);
            HisCommonService.getInstance().findAttachments(view.getRootControl(), (Set)attachment);
            if (attachment.isEmpty()) {
                return;
            }
            attachment.forEach(attachKey -> {
                AttachmentPanel attachmentpanel = (AttachmentPanel)view.getControl(attachKey);
                attachmentpanel.addUploadListener(listener);
            });
            return;
        }
        attachments.stream().map(attach -> (String)attach.get("fattachmentpanel")).distinct().forEach(attachKey -> {
            AttachmentPanel attachmentpanel = (AttachmentPanel)view.getControl(attachKey);
            attachmentpanel.addUploadListener(listener);
        });
    }

    public static void hideAttachmentsBtn(IFormView view) {
        HashSet attachment = Sets.newHashSetWithExpectedSize((int)16);
        HisCommonService.getInstance().findAttachments(view.getRootControl(), (Set)attachment);
        if (attachment.isEmpty()) {
            return;
        }
        attachment.forEach(attachKey -> view.setEnable(Boolean.FALSE, new String[]{attachKey}));
    }

    public static void saveAttachmentInfoToOp(BeforeDoOperationEventArgs args, IFormView view) {
        HashSet attachKeys = Sets.newHashSetWithExpectedSize((int)16);
        HisCommonService.getInstance().findAttachments(view.getRootControl(), (Set)attachKeys);
        if (attachKeys.isEmpty()) {
            return;
        }
        long userId = RequestContext.get().getCurrUserId();
        String entityNumber = view.getEntityId();
        IClientViewProxy clientViewProxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        HashMap attachmentInfo = new HashMap();
        attachKeys.forEach(attachKey -> {
            List<Map> attachs;
            AttachmentPanel attachmentPanel = (AttachmentPanel)view.getControl(attachKey);
            FilePremissionUtil.allPermissionQuery((IPageCache)view.getPageCache(), (String)attachKey, (Long)userId, (String)entityNumber, (IClientViewProxy)clientViewProxy, (IFormView)view);
            boolean hasPermission = FilePremissionUtil.hasAttachmentOpPermission((String)entityNumber, (String)"2NJ6+I0X0CJ8", (IFormView)view, (boolean)false, (String)attachKey, (IClientViewProxy)clientViewProxy);
            if (hasPermission) {
                attachs = attachmentPanel.getAttachmentData();
                HashSet uidSet = Sets.newHashSetWithExpectedSize((int)16);
                attachs.removeIf(data -> {
                    String uid = (String)data.get("uid");
                    if (uidSet.contains(uid)) {
                        return true;
                    }
                    uidSet.add(uid);
                    return false;
                });
            } else {
                String changeAttachmentStr = view.getPageCache().get("changeAttachments");
                if (HRStringUtils.isEmpty((String)changeAttachmentStr)) {
                    return;
                }
                Map attachmentsMap = (Map)SerializationUtils.fromJsonString((String)changeAttachmentStr, Map.class);
                attachs = attachmentsMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            }
            attachs.forEach(attach -> {
                try {
                    String url = (String)attach.get("url");
                    if (!url.contains("tempfile/download.do?configKey") && !url.startsWith("/")) {
                        attach.put("url", HisAttachmentTool.getPathFromDownloadUrl(URLDecoder.decode(String.valueOf(attach.get("url")), "UTF-8")));
                    } else if (attach.containsKey("originUrl")) {
                        attach.put("url", attach.remove("originUrl"));
                    }
                    attach.remove("lastModified");
                }
                catch (IOException ex) {
                    LOGGER.error((Throwable)ex);
                }
            });
            attachmentInfo.put(attachKey, attachs);
        });
        if (attachmentInfo.isEmpty()) {
            return;
        }
        FormOperate operate = (FormOperate)args.getSource();
        String attachDeleteFlagStr = view.getPageCache().get("attachDeleteFlag");
        if (HRStringUtils.isNotEmpty((String)attachDeleteFlagStr)) {
            operate.getOption().setVariableValue("attachDeleteFlag", attachDeleteFlagStr);
        }
        operate.getOption().setVariableValue("opHisTempAttachments", SerializationUtils.toJsonString(attachmentInfo));
    }

    public static void putAttachmentsIntoCustomParam(IFormView view, FormShowParameter formShowParameter) {
        HashSet attachment = Sets.newHashSetWithExpectedSize((int)16);
        HisCommonService.getInstance().findAttachments(view.getRootControl(), (Set)attachment);
        if (attachment.isEmpty()) {
            return;
        }
        ArrayList attachments = Lists.newArrayListWithCapacity((int)16);
        Map mapDisAttachParam = (Map)view.getFormShowParameter().getCustomParam("load_attachment_from_db");
        if (mapDisAttachParam != null && !mapDisAttachParam.isEmpty()) {
            for (String attachKey : attachment) {
                attachments.addAll((Collection)mapDisAttachParam.get(attachKey));
            }
            view.getFormShowParameter().getCustomParams().remove("load_attachment_from_db");
        } else {
            for (String attachKey : attachment) {
                AttachmentPanel attachmentPanel = (AttachmentPanel)view.getControl(attachKey);
                attachments.addAll(attachmentPanel.getAttachmentData());
            }
        }
        HisAttachmentTool.removeRepeatAttachmentsForList(attachments);
        formShowParameter.setCustomParam("attachments", (Object)attachments);
    }

    public static void putAttachmentsIntoCustomParam(String formId, Object pkId, FormShowParameter formShowParameter) {
        List attachments = AttachmentServiceHelper.getAttachmentsByExport((String)formId, (Object)pkId);
        if (attachments != null && attachments.size() > 0) {
            formShowParameter.setCustomParam("attachments", (Object)attachments);
        }
    }

    public static void newPageProcessAttachments(IFormView view) {
        String his_is_disable = (String)view.getFormShowParameter().getCustomParam("his_is_disable");
        if ("true".equals(his_is_disable)) {
            view.getFormShowParameter().setCustomParam("his_is_disable", null);
            return;
        }
        String his_action = (String)view.getFormShowParameter().getCustomParam("his_action");
        if ("open_insert_data_page".equals(his_action) || "open_copy_his_data_page".equals(his_action)) {
            Map<String, List<Map<String, Object>>> attachmentMap = HisAttachmentTool.getAttachmentsFromParams(view);
            HisAttachmentTool.setAttachments(view, attachmentMap);
        }
    }

    public static void setAttachments(IFormView view, Map<String, List<Map<String, Object>>> attachmentMap) {
        if (attachmentMap == null) {
            return;
        }
        long userId = RequestContext.get().getCurrUserId();
        String entityNumber = view.getEntityId();
        IClientViewProxy clientViewProxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        attachmentMap.forEach((attachKey, attachmentMaps) -> {
            attachmentMaps.forEach(map -> {
                String originUid = (String)map.get("uid");
                String uid = "rc-upload-" + UUID.randomUUID().toString() + originUid.substring(originUid.lastIndexOf("-"));
                map.put("uid", uid);
                map.remove("attPkId");
                map.remove("lastModified");
            });
            AttachmentPanel attachmentpanel = (AttachmentPanel)view.getControl(attachKey);
            FilePremissionUtil.allPermissionQuery((IPageCache)view.getPageCache(), (String)attachKey, (Long)userId, (String)entityNumber, (IClientViewProxy)clientViewProxy, (IFormView)view);
            boolean hasPermission = FilePremissionUtil.hasAttachmentOpPermission((String)entityNumber, (String)"2NJ6+I0X0CJ8", (IFormView)view, (boolean)false, (String)attachKey, (IClientViewProxy)clientViewProxy);
            attachmentpanel.bindData(attachmentMaps);
            attachmentpanel.upload(attachmentMaps);
            if (!hasPermission) {
                attachmentpanel.bindData((List)Lists.newArrayList());
            }
        });
        view.getPageCache().put("changeAttachments", SerializationUtils.toJsonString(attachmentMap));
    }

    public static void setAttachmentsForNonTime(IFormView view) {
        Map<String, List<Map<String, Object>>> attachmentMap = HisAttachmentTool.getAttachmentsFromParams(view);
        if (attachmentMap == null) {
            return;
        }
        long userId = RequestContext.get().getCurrUserId();
        String entityNumber = view.getEntityId();
        IClientViewProxy clientViewProxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        attachmentMap.forEach((attachKey, attachmentMaps) -> {
            attachmentMaps.forEach(map -> {
                String originUid = (String)map.get("uid");
                String uid = "rc-upload-" + UUID.randomUUID().toString() + originUid.substring(originUid.lastIndexOf("-"));
                map.put("uid", uid);
                String originUrl = (String)map.get("url");
                map.put("originUrl", originUrl);
                map.put("url", UrlService.getAttachmentFullUrl((String)originUrl));
                map.put("previewurl", UrlService.getAttachmentPreviewUrl((String)originUrl));
                map.remove("attPkId");
                map.remove("lastModified");
            });
            AttachmentPanel attachmentpanel = (AttachmentPanel)view.getControl(attachKey);
            FilePremissionUtil.allPermissionQuery((IPageCache)view.getPageCache(), (String)attachKey, (Long)userId, (String)entityNumber, (IClientViewProxy)clientViewProxy, (IFormView)view);
            boolean hasPermission = FilePremissionUtil.hasAttachmentOpPermission((String)entityNumber, (String)"2NJ6+I0X0CJ8", (IFormView)view, (boolean)false, (String)attachKey, (IClientViewProxy)clientViewProxy);
            attachmentpanel.bindData(attachmentMaps);
            attachmentpanel.upload(attachmentMaps);
            if (!hasPermission) {
                attachmentpanel.bindData((List)Lists.newArrayList());
            }
        });
        view.getPageCache().put("changeAttachments", SerializationUtils.toJsonString(attachmentMap));
    }

    private static Map<String, List<Map<String, Object>>> getAttachmentsFromParams(IFormView view) {
        List attachments = (List)view.getFormShowParameter().getCustomParam("attachments");
        if (attachments == null) {
            return null;
        }
        return attachments.stream().collect(Collectors.groupingBy(attachment -> (String)attachment.get("fattachmentpanel")));
    }

    public static void remove(UploadEvent evt, IFormView view, IDataModel model) {
        String changeAttachmentStr = view.getPageCache().get("changeAttachments");
        if (HRStringUtils.isEmpty((String)changeAttachmentStr)) {
            return;
        }
        Map attachmentsMap = (Map)SerializationUtils.fromJsonString((String)changeAttachmentStr, Map.class);
        List attachments = attachmentsMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        Map attach = (Map)evt.getUrls()[0];
        if (attachments.stream().noneMatch(attachment -> HRStringUtils.equals((String)((String)attach.get("uid")), (String)((String)attachment.get("uid"))))) {
            return;
        }
        evt.setCancel(true);
        AttachmentPanel attachmentpanel = (AttachmentPanel)view.getControl(evt.getCallbackKey());
        List<Map<String, Object>> tempAtts = HisAttachmentTool.getAttPageCache(attachmentpanel.getKey(), view);
        if (!tempAtts.isEmpty()) {
            for (Map<String, Object> tempAtt : tempAtts) {
                if (!attach.get("uid").equals(tempAtt.get("uid"))) continue;
                tempAtts.remove(tempAtt);
                break;
            }
            HisAttachmentTool.setAttPageCache(attachmentpanel.getKey(), tempAtts, view);
            if (StringUtils.isNotBlank((CharSequence)attachmentpanel.getAttachmentCountField())) {
                model.setValue(attachmentpanel.getAttachmentCountField(), (Object)tempAtts.size());
            }
            IClientViewProxy clientViewProxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
            HashMap<String, Boolean> removeResult = new HashMap<String, Boolean>();
            removeResult.put("remove", true);
            removeResult.put("uid", (Boolean)attach.get("uid"));
            clientViewProxy.invokeControlMethod(attachmentpanel.getKey(), "removeAttachment", new Object[]{removeResult});
        }
    }

    public static void removeRepeatAttachmentsForList(List<Map<String, Object>> attachmentData) {
        HashSet uidSet = Sets.newHashSetWithExpectedSize((int)16);
        Iterator<Map<String, Object>> it = attachmentData.iterator();
        while (it.hasNext()) {
            Map<String, Object> mapData = it.next();
            String uid = (String)mapData.get("uid");
            if (uidSet.contains(uid)) {
                it.remove();
                continue;
            }
            uidSet.add(uid);
        }
    }

    public static void reloadAttachments(IFormView view, Object pkId) {
        if (view == null) {
            return;
        }
        String entityNumber = view.getEntityId();
        if (StringUtils.isEmpty((CharSequence)entityNumber)) {
            return;
        }
        if (pkId == null) {
            return;
        }
        if (pkId instanceof Long) {
            Long lPkId = (Long)pkId;
            if (lPkId == 0L) {
                return;
            }
        } else {
            return;
        }
        HashSet attachment = Sets.newHashSetWithExpectedSize((int)16);
        HisCommonService.getInstance().findAttachments(view.getRootControl(), (Set)attachment);
        if (attachment.isEmpty()) {
            return;
        }
        LinkedHashMap mapAttachParam = Maps.newLinkedHashMapWithExpectedSize((int)16);
        long userId = RequestContext.get().getCurrUserId();
        IClientViewProxy clientViewProxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        attachment.forEach(attachKey -> {
            List attachmentDataFromDB = AttachmentServiceHelper.getAttachments((String)entityNumber, (Object)pkId, (String)attachKey);
            if (CollectionUtils.isEmpty((Collection)attachmentDataFromDB)) {
                return;
            }
            AttachmentPanel attachmentpanel = (AttachmentPanel)view.getControl(attachKey);
            FilePremissionUtil.allPermissionQuery((IPageCache)view.getPageCache(), (String)attachKey, (Long)userId, (String)entityNumber, (IClientViewProxy)clientViewProxy, (IFormView)view);
            boolean hasPermission = FilePremissionUtil.hasAttachmentOpPermission((String)entityNumber, (String)"2NJ6+I0X0CJ8", (IFormView)view, (boolean)false, (String)attachKey, (IClientViewProxy)clientViewProxy);
            attachmentpanel.bindData(attachmentDataFromDB);
            mapAttachParam.put(attachKey, attachmentDataFromDB);
            if (!hasPermission) {
                attachmentpanel.bindData((List)Lists.newArrayList());
            }
        });
        view.getFormShowParameter().setCustomParam("load_attachment_from_db", (Object)mapAttachParam);
    }

    public static void removeRepeatAttachments(IFormView view, boolean disabledAttach) {
        HashSet attachment = Sets.newHashSetWithExpectedSize((int)16);
        HisCommonService.getInstance().findAttachments(view.getRootControl(), (Set)attachment);
        if (attachment.isEmpty()) {
            return;
        }
        long userId = RequestContext.get().getCurrUserId();
        String entityNumber = view.getEntityId();
        IClientViewProxy clientViewProxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        attachment.forEach(attachKey -> {
            FilePremissionUtil.allPermissionQuery((IPageCache)view.getPageCache(), (String)attachKey, (Long)userId, (String)entityNumber, (IClientViewProxy)clientViewProxy, (IFormView)view);
            boolean hasPermission = FilePremissionUtil.hasAttachmentOpPermission((String)entityNumber, (String)"2NJ6+I0X0CJ8", (IFormView)view, (boolean)false, (String)attachKey, (IClientViewProxy)clientViewProxy);
            AttachmentPanel attachmentpanel = (AttachmentPanel)view.getControl(attachKey);
            List attachmentData = attachmentpanel.getAttachmentData();
            HisAttachmentTool.removeRepeatAttachmentsForList(attachmentData);
            attachmentpanel.bindData(attachmentData);
            if (!hasPermission) {
                attachmentpanel.bindData((List)Lists.newArrayList());
            }
            if (disabledAttach) {
                view.setEnable(Boolean.FALSE, new String[]{attachKey});
            }
        });
    }

    private static void setAttPageCache(String key, List<Map<String, Object>> tempAtts, IFormView view) {
        IPageCache cache = (IPageCache)view.getService(IPageCache.class);
        String cacheJsonString = cache.get("TampAttCache" + view.getPageId());
        Map<String, List<Map<String, Object>>> attachmentInfo = new HashMap<String, List<Map<String, Object>>>();
        if (!StringUtils.isEmpty((CharSequence)cacheJsonString)) {
            attachmentInfo = (Map)SerializationUtils.fromJsonString((String)cacheJsonString, Map.class);
        }
        attachmentInfo.put(key, tempAtts);
        cacheJsonString = SerializationUtils.toJsonString(attachmentInfo);
        cache.put("TampAttCache" + view.getPageId(), cacheJsonString);
    }

    private static List<Map<String, Object>> getAttPageCache(String key, IFormView view) {
        Map attachmentInfo;
        List tempAtts;
        IPageCache cache = (IPageCache)view.getService(IPageCache.class);
        String cacheJsonString = cache.get("TampAttCache" + view.getPageId());
        if (!StringUtils.isEmpty((CharSequence)cacheJsonString) && (tempAtts = (List)(attachmentInfo = (Map)SerializationUtils.fromJsonString((String)cacheJsonString, Map.class)).get(key)) != null) {
            return tempAtts;
        }
        return new ArrayList<Map<String, Object>>(10);
    }

    private static String getPathFromDownloadUrl(String url) throws IOException {
        String path = StringUtils.substringAfter((String)url, (String)"path=");
        path = URLDecoder.decode(path, "UTF-8");
        return FilePathUtil.dealPath((String)path, (String)"attach");
    }

    public static void removeFromRevise(UploadEvent evt, IFormView view, IDataModel model) {
        String fromPage = (String)view.getFormShowParameter().getCustomParam("fromPage");
        if (HRStringUtils.equals((String)fromPage, (String)"revise")) {
            String uid;
            QFilter qFilter;
            Object pkValue = ((BillModel)model).getPKValue();
            Object boid = model.getValue("boid");
            HRBaseServiceHelper helper = new HRBaseServiceHelper(model.getDataEntityType().getName());
            DynamicObject dynamicObject = helper.queryOriginalOne("sourcevid", (qFilter = new QFilter("id", "=", boid)).toArray());
            if (dynamicObject == null) {
                return;
            }
            Object sourceId = dynamicObject.get("sourcevid");
            if (!pkValue.equals(sourceId) && !pkValue.equals(boid)) {
                return;
            }
            Object writeBackId = pkValue.equals(sourceId) ? boid : sourceId;
            Set ids = Stream.of(String.valueOf(writeBackId)).collect(Collectors.toSet());
            List attachmentMapList = HisAttachmentService.generateAttachmentMapById(ids, (String)model.getDataEntityType().getName());
            Object[] urls = evt.getUrls();
            HashSet<String> suffixUids = new HashSet<String>(urls.length);
            for (Object url : urls) {
                if (!(url instanceof LinkedHashMap) || !HRStringUtils.isNotEmpty((String)(uid = (String)((LinkedHashMap)url).get("uid"))) || uid.lastIndexOf(45) == -1) continue;
                String suffixUid = uid.substring(uid.lastIndexOf(45));
                suffixUids.add(suffixUid);
            }
            block1: for (String suffixUid : suffixUids) {
                for (Map map : attachmentMapList) {
                    uid = (String)map.get("uid");
                    if (!uid.endsWith(suffixUid)) continue;
                    AttachmentServiceHelper.remove((String)model.getDataEntityType().getName(), (Object)writeBackId, (Object)uid);
                    continue block1;
                }
            }
        }
    }
}

