/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.util.newhismodel;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TimeZone;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.application.impl.common.HRLongValueParseService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisEffDateCommonService;
import kd.hr.hbp.common.constants.newhismodel.EventOperateEnums;
import kd.hr.hbp.common.constants.newhismodel.HisFieldNameConstants;
import kd.hr.hbp.common.constants.newhismodel.HisLineTimeTplConstants;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.util.newhismodel.HisModelListCommonTool;

public class HisLineF7FilterHandler
implements HisLineTimeTplConstants,
HisFieldNameConstants {
    private static final Log LOGGER = LogFactory.getLog(HisLineF7FilterHandler.class);
    private static volatile HisLineF7FilterHandler handler = null;

    private HisLineF7FilterHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HisLineF7FilterHandler getInstance() {
        if (handler != null) return handler;
        Class<HisLineF7FilterHandler> clazz = HisLineF7FilterHandler.class;
        synchronized (HisLineF7FilterHandler.class) {
            if (handler != null) return handler;
            handler = new HisLineF7FilterHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return handler;
        }
    }

    public void addBusinessF7QFilters(ListShowParameter listParameter, List<QFilter> qFilters) {
        QFilter currentVersionFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('1'));
        qFilters.add(currentVersionFilter);
        QFilter dataStatusFilter = new QFilter("datastatus", "in", Stream.of(EventOperateEnums.CHANGE_BEFORE_STATUS_EFFECTING.getValue(), EventOperateEnums.CHANGE_BEFORE_STATUS_TOBEEFFECT.getValue()).collect(Collectors.toSet()));
        qFilters.add(dataStatusFilter);
        Date effDate = this.transDate(listParameter.getCustomParam("effectdate"));
        if (effDate != null) {
            QFilter effDateFilter = new QFilter("firstbsed", "<=", (Object)effDate);
            qFilters.add(effDateFilter);
        }
    }

    public void addVersionF7QFilters(ListShowParameter listParameter, List<QFilter> qFilters, IFormView view, Map<String, Date> changeDateMap) {
        QFilter effDateQFilter;
        QFilter currentVersionFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0'));
        qFilters.add(currentVersionFilter);
        QFilter dataStatusFilter = new QFilter("datastatus", "in", Stream.of(EventOperateEnums.CHANGE_BEFORE_STATUS_EFFECTING.getValue(), EventOperateEnums.CHANGE_BEFORE_STATUS_TOBEEFFECT.getValue(), EventOperateEnums.CHANGE_BEFORE_STATUS_INVALIDED.getValue()).collect(Collectors.toSet()));
        qFilters.add(dataStatusFilter);
        Long boId = HRLongValueParseService.getInstance().getLongValueFromMap(listParameter.getCustomParams(), "boid");
        if (boId != null && boId != 0L) {
            QFilter boIdQFilter = new QFilter("boid", "=", (Object)boId);
            qFilters.add(boIdQFilter);
        }
        if ((effDateQFilter = this.getEffDateQFilter(listParameter, view, changeDateMap)) != null) {
            qFilters.add(effDateQFilter);
        }
    }

    private QFilter getEffDateQFilter(ListShowParameter listParameter, IFormView view, Map<String, Date> changeDateMap) {
        QFilter effDateQFilter;
        Object useDefaultDate = listParameter.getCustomParam("useDefaultDate");
        boolean isUseDefaultDate = (Boolean)Optional.ofNullable(useDefaultDate).orElse(true);
        String dateFieldType = (String)listParameter.getCustomParam("effDateFieldType");
        if (HRStringUtils.equals((String)dateFieldType, (String)"effDate")) {
            Date modelEffectDate = (Date)view.getModel().getValue("effectdate");
            modelEffectDate = Optional.ofNullable(changeDateMap.get("changeDate")).orElse(modelEffectDate);
            if (modelEffectDate == null) {
                modelEffectDate = this.transDate(listParameter.getCustomParam("effectdate"));
            }
            if (modelEffectDate == null && !isUseDefaultDate) {
                return null;
            }
            modelEffectDate = Optional.ofNullable(modelEffectDate).orElseGet(Date::new);
            Calendar cal = Calendar.getInstance();
            cal.setTime(modelEffectDate);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            modelEffectDate = cal.getTime();
            view.getModel().setValue("effectdate", (Object)modelEffectDate);
            effDateQFilter = new QFilter("bsed", "<=", (Object)modelEffectDate);
            effDateQFilter.and(new QFilter("bsled", ">=", (Object)modelEffectDate));
        } else {
            Date effDateStart = (Date)view.getModel().getValue("effdatestart");
            Date effDateEnd = (Date)view.getModel().getValue("effdateend");
            effDateStart = Optional.ofNullable(changeDateMap.get("changeDateStart")).orElse(effDateStart);
            effDateEnd = Optional.ofNullable(changeDateMap.get("changeDateEnd")).orElse(effDateEnd);
            if (effDateStart == null || effDateEnd == null) {
                effDateStart = this.transDate(listParameter.getCustomParam("effdatestart"));
                effDateEnd = this.transDate(listParameter.getCustomParam("effdateend"));
            }
            effDateQFilter = this.getVersionDateRangeQFilter(effDateStart, effDateEnd, isUseDefaultDate, view);
        }
        return effDateQFilter;
    }

    private QFilter getVersionDateRangeQFilter(Date effDateStart, Date effDateEnd, boolean isUseDefaultDate, IFormView view) {
        if (effDateStart == null && effDateEnd == null && !isUseDefaultDate) {
            return null;
        }
        if (effDateStart == null) {
            long current = System.currentTimeMillis();
            long dayTime = current - (current + (long)TimeZone.getDefault().getRawOffset()) % 86400000L;
            effDateStart = new Date(dayTime);
        }
        if (effDateEnd == null) {
            effDateEnd = HisEffDateCommonService.getInstance().getDate2999(null);
        }
        if (view != null) {
            view.getModel().setValue("effdatestart", (Object)effDateStart);
            view.getModel().setValue("effdateend", (Object)effDateEnd);
        }
        QFilter effDateQFilter = new QFilter("bsled", ">=", (Object)effDateStart);
        effDateQFilter.and(new QFilter("bsed", "<=", (Object)effDateEnd));
        return effDateQFilter;
    }

    public Date transDate(Object transDate) {
        if (transDate == null) {
            return null;
        }
        if (transDate instanceof Date) {
            return (Date)transDate;
        }
        Date date = null;
        try {
            date = HRDateTimeUtils.parseDate((String)((String)transDate));
        }
        catch (ParseException ex) {
            LOGGER.error((Throwable)ex);
        }
        return date;
    }

    public boolean isBusinessF7(IFormView view) {
        ListShowParameter listParameter = (ListShowParameter)view.getFormShowParameter();
        Object isBdObj = listParameter.getCustomParam("selData");
        if (Objects.isNull(isBdObj)) {
            return true;
        }
        return (Boolean)isBdObj;
    }

    public void addBdQFilter(String formId, FormShowParameter parameter, List<QFilter> qFilters) {
        Date customEffDate = handler.transDate(parameter.getCustomParam("effectdate"));
        if (customEffDate == null) {
            customEffDate = this.getToday();
        }
        if (!HisModelListCommonTool.hasBdQFilter(formId, qFilters)) {
            return;
        }
        qFilters.add(new QFilter("id", "=", (Object)"masterid", true).or(new QFilter("firstbsed", "<=", (Object)customEffDate)));
    }

    private Date getToday() {
        long current = System.currentTimeMillis();
        long dayTime = current - (current + (long)TimeZone.getDefault().getRawOffset()) % 86400000L;
        return new Date(dayTime);
    }
}

