/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.util.perm;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.BeforeDoCheckDataPermissionArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.Modify;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.util.perm.HRPermUtil;
import org.apache.commons.lang3.StringUtils;

@Deprecated
public class HRPermCheckTool {
    private static final Log LOGGER = LogFactory.getLog(HRPermCheckTool.class);
    private static final String KEY_CURR_BIZAPPID = "currbizappid";
    private static final String KEY_SPECIAL_CURR_BIZAPPID = "specialdataperm_currentappid";
    private static final String IHBSS_PERM_SERVICE = "IHBSSPermService";

    public static void checkEditDataPermission(String adminOrgFieldName, String empgrpFieldName, BeforeDoCheckDataPermissionArgs args, IDataModel model, Boolean isAdminOrgEnabled) {
        Set authedEmpGroupSet;
        Set authedOrgSet;
        Boolean isCheckAdminOrg = HRStringUtils.isNotEmpty((String)adminOrgFieldName);
        Boolean isCheckEmpgrp = HRStringUtils.isNotEmpty((String)empgrpFieldName);
        if (!isCheckAdminOrg.booleanValue() && !isCheckEmpgrp.booleanValue()) {
            return;
        }
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        Long adminOrgId = 0L;
        Long empgrpId = 0L;
        if (isCheckAdminOrg.booleanValue()) {
            adminOrgId = HRPermUtil.getDynamicObjectFieldId(model.getDataEntity(), adminOrgFieldName);
        }
        if (isCheckEmpgrp.booleanValue()) {
            empgrpId = HRPermUtil.getDynamicObjectFieldId(model.getDataEntity(), empgrpFieldName);
        }
        if (Objects.equals(adminOrgId, 0L) && Objects.equals(empgrpId, 0L)) {
            return;
        }
        String appId = HRPermCheckTool.getAppIdFromPermArgs(args);
        String entityNumber = HRPermCheckTool.getEntityIdFromPermArgs(args);
        String permItemId = HRPermCheckTool.getPermItemFromPermArgs(args);
        if (HRStringUtils.isEmpty((String)entityNumber) || HRStringUtils.isEmpty((String)appId) || HRStringUtils.isEmpty((String)permItemId)) {
            LOGGER.error(String.format(Locale.ROOT, "Can't Attach entityNumber,appId or permItemId,entityNumber[%s],appId[%s],permItemId[%s]", entityNumber, appId, permItemId));
            return;
        }
        if (!Objects.equals(adminOrgId, 0L) && !(authedOrgSet = (Set)HRMServiceHelper.invokeHRMPService((String)"hbss", (String)IHBSS_PERM_SERVICE, (String)"getAdminOrgSetByPermItem", (Object[])new Object[]{userId, appId, entityNumber, permItemId, isAdminOrgEnabled})).contains(adminOrgId)) {
            HRPermCheckTool.setErrorMessage(args);
        }
        if (!Objects.equals(empgrpId, 0L) && !(authedEmpGroupSet = (Set)HRMServiceHelper.invokeHRMPService((String)"hbss", (String)IHBSS_PERM_SERVICE, (String)"getEmpgrpSetByPermItem", (Object[])new Object[]{userId, appId, entityNumber, permItemId})).contains(empgrpId)) {
            HRPermCheckTool.setErrorMessage(args);
        }
    }

    public static void checkListDataPermission(String adminOrgFieldName, String empgrpFieldName, BeforeDoCheckDataPermissionArgs args, Boolean isAdminOrgEnabled) {
        Set authedEmpGroupSet;
        Set<Long> selectedEmpGroup;
        Sets.SetView nonAuthedEmpGroup;
        Set authedOrgSet;
        Set<Long> selectedOrg;
        Sets.SetView nonAuthedOrg;
        String permItemId;
        String entityNumber;
        String appId;
        Boolean isCheckAdminOrg = HRStringUtils.isNotEmpty((String)adminOrgFieldName);
        Boolean isCheckEmpgrp = HRStringUtils.isNotEmpty((String)empgrpFieldName);
        if (!isCheckAdminOrg.booleanValue() && !isCheckEmpgrp.booleanValue()) {
            return;
        }
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        ListSelectedRowCollection listSelectedData = new ListSelectedRowCollection();
        if (HRPermCheckTool.paramIsEmpty(listSelectedData = HRPermCheckTool.getListSelectedRows(args, listSelectedData), appId = HRPermCheckTool.getAppIdFromPermArgs(args), entityNumber = HRPermCheckTool.getEntityIdFromPermArgs(args), permItemId = HRPermCheckTool.getPermItemFromPermArgs(args))) {
            return;
        }
        ArrayList selectedIdList = Lists.newArrayListWithExpectedSize((int)listSelectedData.size());
        HRPermCheckTool.addSelectedIdList(listSelectedData, selectedIdList);
        if (selectedIdList.isEmpty()) {
            return;
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityNumber);
        ArrayList<String> selectPropertyList = new ArrayList<String>(2);
        HRPermCheckTool.addpropertyList(adminOrgFieldName, empgrpFieldName, isCheckAdminOrg, isCheckEmpgrp, selectPropertyList);
        String selectPropertyStr = StringUtils.join(selectPropertyList, (String)",");
        DynamicObject[] items = helper.queryOriginalArray(selectPropertyStr, new QFilter("id", "in", (Object)selectedIdList).toArray());
        if (isCheckAdminOrg.booleanValue() && !(nonAuthedOrg = Sets.difference(selectedOrg = HRPermCheckTool.getSelectedIds(items, adminOrgFieldName), (Set)(authedOrgSet = (Set)HRMServiceHelper.invokeHRMPService((String)"hbss", (String)IHBSS_PERM_SERVICE, (String)"getAdminOrgSetByPermItem", (Object[])new Object[]{userId, appId, entityNumber, permItemId, isAdminOrgEnabled})))).isEmpty()) {
            HRPermCheckTool.setErrorMessage(args);
            return;
        }
        if (isCheckEmpgrp.booleanValue() && !(nonAuthedEmpGroup = Sets.difference(selectedEmpGroup = HRPermCheckTool.getSelectedIds(items, empgrpFieldName), (Set)(authedEmpGroupSet = (Set)HRMServiceHelper.invokeHRMPService((String)"hbss", (String)IHBSS_PERM_SERVICE, (String)"getEmpgrpSetByPermItem", (Object[])new Object[]{userId, appId, entityNumber, permItemId})))).isEmpty()) {
            HRPermCheckTool.setErrorMessage(args);
        }
    }

    private static Set<Long> getSelectedIds(DynamicObject[] items, String fieldName) {
        HashSet selectedOrg = Sets.newHashSetWithExpectedSize((int)items.length);
        for (DynamicObject dyno : items) {
            selectedOrg.add(dyno.getLong(fieldName));
        }
        return selectedOrg;
    }

    private static void addpropertyList(String adminOrgFieldName, String empgrpFieldName, Boolean isCheckAdminOrg, Boolean isCheckEmpgrp, List<String> selectPropertyList) {
        if (isCheckAdminOrg.booleanValue()) {
            selectPropertyList.add(adminOrgFieldName);
        }
        if (isCheckEmpgrp.booleanValue()) {
            selectPropertyList.add(empgrpFieldName);
        }
    }

    private static ListSelectedRowCollection getListSelectedRows(BeforeDoCheckDataPermissionArgs args, ListSelectedRowCollection listSelectedData) {
        if (args.getSource() instanceof Modify) {
            Modify oper = (Modify)args.getSource();
            listSelectedData.add((Object)oper.getListFocusRow());
        } else {
            listSelectedData = args.getListSelectedData();
        }
        return listSelectedData;
    }

    private static void addSelectedIdList(ListSelectedRowCollection listSelectedData, List<Object> selectedIdList) {
        for (ListSelectedRow row : listSelectedData) {
            Object primaryKeyValue = row.getPrimaryKeyValue();
            if (!Objects.nonNull(primaryKeyValue)) continue;
            selectedIdList.add(primaryKeyValue);
        }
    }

    private static void setErrorMessage(BeforeDoCheckDataPermissionArgs args) {
        args.setSkipCheckDataPermission(false);
        args.setCancel(true);
        String noAuthTip = HRPermCheckTool.getNoDataPermTip(args);
        args.setCancelMessage(noAuthTip);
    }

    private static boolean paramIsEmpty(ListSelectedRowCollection listSelectedData, String appId, String entityNumber, String permItemId) {
        return Objects.isNull(listSelectedData) || listSelectedData.size() == 0 || HRStringUtils.isEmpty((String)entityNumber) || HRStringUtils.isEmpty((String)appId) || HRStringUtils.isEmpty((String)permItemId);
    }

    private static String getAppIdFromPermArgs(BeforeDoCheckDataPermissionArgs args) {
        String appId = null;
        OperateOption option = null;
        Object source = args.getSource();
        if (!(source instanceof FormOperate)) {
            return null;
        }
        FormOperate operate = (FormOperate)args.getSource();
        option = operate.getOption();
        if (option.containsVariable(KEY_CURR_BIZAPPID)) {
            appId = option.getVariableValue(KEY_CURR_BIZAPPID);
        } else if (option.containsVariable(KEY_SPECIAL_CURR_BIZAPPID)) {
            String appNumber = option.getVariableValue(KEY_SPECIAL_CURR_BIZAPPID);
            if (HRStringUtils.isEmpty((String)appNumber)) {
                return null;
            }
            AppInfo appInfo = AppMetadataCache.getAppInfo((String)appNumber);
            if (appInfo != null) {
                appId = appInfo.getId();
            }
        }
        return appId;
    }

    private static String getEntityIdFromPermArgs(BeforeDoCheckDataPermissionArgs args) {
        Object source = args.getSource();
        if (source instanceof FormOperate) {
            FormOperate operate = (FormOperate)source;
            String permissionEntityId = operate.getPermissionEntityId();
            if (HRStringUtils.isEmpty((String)permissionEntityId)) {
                permissionEntityId = operate.getEntityId();
            }
            return permissionEntityId;
        }
        return null;
    }

    public static String getPermItemFromPermArgs(BeforeDoCheckDataPermissionArgs args) {
        Object source = args.getSource();
        if (source instanceof FormOperate) {
            FormOperate operate = (FormOperate)source;
            return operate.getPermissionItemId();
        }
        return null;
    }

    private static String getLocaleOperateName(BeforeDoCheckDataPermissionArgs args) {
        Object source = args.getSource();
        if (source instanceof FormOperate) {
            FormOperate operate = (FormOperate)source;
            return operate.getOperateName().toString();
        }
        return "";
    }

    private static String getFormName(BeforeDoCheckDataPermissionArgs args) {
        Object source = args.getSource();
        if (source instanceof FormOperate) {
            FormOperate operate = (FormOperate)source;
            FormShowParameter showParameter = operate.getView().getFormShowParameter();
            String formId = showParameter.getFormId();
            if (showParameter instanceof ListShowParameter) {
                ListShowParameter listParameter = (ListShowParameter)showParameter;
                formId = listParameter.getBillFormId();
            }
            LocaleString formName = FormMetadataCache.getFormConfig((String)formId).getCaption();
            return formName.toString();
        }
        return "";
    }

    private static String getNoDataPermTip(BeforeDoCheckDataPermissionArgs args) {
        String operateName = HRPermCheckTool.getLocaleOperateName(args);
        String formName = HRPermCheckTool.getFormName(args);
        String noAuthTipFormat = ResManager.loadKDString((String)"\u62b1\u6b49\uff0c\u60a8\u6ca1\u6709\u201c%1$s\u201d\u201c%2$s\u201d\u7684\u6570\u636e\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"HRPermCheckTool_0", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]);
        return String.format(Locale.ROOT, noAuthTipFormat, operateName, formName);
    }
}

