/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.util.perm;

import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.model.HRFilterFieldInfo;
import kd.hr.hbp.common.model.HRFilterFieldItemInfo;

public class HRPermFilterTool {
    public static QFilter assembleQFilterInfo(HRFilterFieldInfo hrFilterFieldInfo, String appId, String entityId, String permItemId, Boolean isAdminOrgEnabled, Boolean isF7) {
        if (hrFilterFieldInfo == null) {
            return null;
        }
        List hrFilterFieldItemInfos = hrFilterFieldInfo.getFilterFieldItemInfoList();
        QFilter resultQFilter = null;
        for (HRFilterFieldItemInfo hrFilterFieldItemInfo : hrFilterFieldItemInfos) {
            String filterPropName = hrFilterFieldItemInfo.getFilterPropName();
            String filterType = hrFilterFieldItemInfo.getFilterType();
            String operationType = hrFilterFieldItemInfo.getOperationType();
            QFilter toAddQFilter = HRPermFilterTool.buildQFilter(hrFilterFieldItemInfo, filterPropName, filterType, operationType, appId, entityId, permItemId, isAdminOrgEnabled, isF7);
            if (resultQFilter == null) {
                resultQFilter = toAddQFilter;
                continue;
            }
            resultQFilter.and(toAddQFilter);
        }
        return resultQFilter;
    }

    public static QFilter buildQFilter(HRFilterFieldItemInfo hrFilterFieldItemInfo, String filterPropName, String filterType, String operationType, String appId, String entityId, String permItemId, Boolean isAdminOrgEnabled, Boolean isF7) {
        QFilter qFilter = null;
        switch (filterType) {
            case "adminorg": {
                qFilter = HRPermFilterTool.buildRoleOrgFilter(operationType, filterPropName, appId, entityId, permItemId, isAdminOrgEnabled, isF7);
                break;
            }
            case "empgrp": {
                qFilter = HRPermFilterTool.buildRoleEmpGroupFilter(operationType, filterPropName, appId, entityId, permItemId, isF7);
                break;
            }
            case "hrbu": {
                qFilter = hrFilterFieldItemInfo.getQFilter();
                break;
            }
            case "custom": {
                qFilter = hrFilterFieldItemInfo.getQFilter();
                break;
            }
        }
        return qFilter;
    }

    public static QFilter buildRoleOrgFilter(String operationType, String filterPropName, String appId, String entityId, String permItemId, Boolean isAdminOrgEnabled, Boolean isF7) {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        Set userOrgSet = (Set)HRMServiceHelper.invokeHRMPService((String)"hbss", (String)"IHBSSPermService", (String)"getAdminOrgSetByPermItem", (Object[])new Object[]{userId, appId, entityId, permItemId, isAdminOrgEnabled, isF7});
        return new QFilter(filterPropName, operationType, (Object)userOrgSet);
    }

    public static QFilter buildRoleEmpGroupFilter(String operationType, String filterPropName, String appId, String entityId, String permItemId, Boolean isF7) {
        Long userId = Long.parseLong(RequestContext.get().getUserId());
        Set userEmpgrpSet = (Set)HRMServiceHelper.invokeHRMPService((String)"hbss", (String)"IHBSSPermService", (String)"getEmpgrpSetByPermItem", (Object[])new Object[]{userId, appId, entityId, permItemId, isF7});
        return new QFilter(filterPropName, operationType, (Object)userEmpgrpSet);
    }
}

