/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.bussiness.cert;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DBServiceHelper;
import kd.hr.hbp.bussiness.cert.HRCertCacheManager;
import kd.hr.hbp.bussiness.cert.HRCertConstant;
import kd.hr.hbp.bussiness.cert.HRCertUtils;
import kd.hr.hbp.bussiness.cert.biz.HRCertCalculatorFactory;
import kd.hr.hbp.bussiness.cert.model.HRCertInfo;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;

public final class HRCertDBUtils {
    private static final Log logger = LogFactory.getLog(HRCertDBUtils.class);
    private static final Set<String> allowedClassNameSet = Sets.newHashSet((Object[])new String[]{"kd.hr.hbp.bussiness.cert.HRCertCommonHelper", "kd.hr.hbp.bussiness.cert.HRCertManager", "kd.hr.hbp.bussiness.cert.HRCertCacheManager", "kd.hr.hbp.bussiness.cert.HRCertCalClassLoader"});

    static int getGroupUsedCountFromDB(String groupId) {
        String selectSql = "select fgroupid,fusedcountstring from t_hbss_certinfo where fgroupid =" + groupId;
        DataSet dataSet = HRDBUtil.queryDataSet((String)"hrcertgroupquery", (DBRoute)DBRoute.of((String)"hmp"), (String)selectSql, null);
        int usedcount = -1;
        for (Row row : dataSet) {
            String usedCoutStr = HRCertUtils.decode4Cache(row.getString("fusedcountstring"));
            if (HRStringUtils.isEmpty((String)usedCoutStr)) continue;
            usedcount = Integer.parseInt(usedCoutStr);
        }
        dataSet.close();
        return usedcount;
    }

    static Map<String, String> updateCertCountToCertInfoTable() {
        HRCertUtils.isAllowedClassName(allowedClassNameSet);
        ArrayList<Object[]> groupDataList = new ArrayList<Object[]>(16);
        HashMap<String, String> currentGroupMap = new HashMap<String, String>(16);
        HRCertConstant.GROUP_ID_SET.forEach(groupId -> {
            try {
                int usedCertCount = HRCertCalculatorFactory.getInstance(groupId).calculateUsedCertCount((String)groupId);
                String decodeUsedCertCount = HRCertUtils.encode4Cache(String.valueOf(usedCertCount));
                HRCertCacheManager.updateUsedCertCount(groupId, usedCertCount);
                Object[] groupDataArray = new Object[]{usedCertCount, decodeUsedCertCount, new Date(), Long.valueOf(groupId)};
                groupDataList.add(groupDataArray);
                currentGroupMap.put((String)groupId, decodeUsedCertCount);
            }
            catch (Exception e) {
                logger.error("kd.hr.hbp.bussiness.cert.HRCertDBUtils.updateCertCountToCertInfoTable groupId : {}, get cert calculator error!", groupId);
                logger.error((Throwable)e);
            }
        });
        if (groupDataList.size() > 0) {
            String updateSql = "update t_hbss_certinfo set fusedcount=? , fusedcountstring=? ,fmodifytime=?  where fgroupid=?";
            HRDBUtil.executeBatch((DBRoute)DBRoute.of((String)"hmp"), (String)updateSql, groupDataList);
            try {
                HRCertDBUtils.saveCertHistoryInfo(groupDataList);
            }
            catch (Exception e) {
                logger.error("kd.hr.hbp.bussiness.cert.HRCertDBUtils.saveCertHistoryInfo error!");
                logger.error((Throwable)e);
            }
        }
        return currentGroupMap;
    }

    private static void saveCertHistoryInfo(List<Object[]> groupDataList) {
        ArrayList<Object[]> groupInsertHistoryDataList = new ArrayList<Object[]>(16);
        ArrayList<Object[]> groupUpdateHistoryDataList = new ArrayList<Object[]>(16);
        RequestContext requestContext = RequestContext.get();
        Map<Long, HRCertInfo> groupUsedCount = HRCertDBUtils.getTodayMaxUsedCountFromDB();
        for (Object[] obj : groupDataList) {
            Object[] groupHistoryDataArray;
            if (obj[3] instanceof Long && groupUsedCount.containsKey(obj[3])) {
                if (groupUsedCount.get(obj[3]).getUsedCount() >= (long)((Integer)obj[0]).intValue()) continue;
                groupHistoryDataArray = new Object[]{obj[0], obj[1], obj[2], requestContext.getCurrUserId(), groupUsedCount.get(obj[3]).getId()};
                groupUpdateHistoryDataList.add(groupHistoryDataArray);
                continue;
            }
            groupHistoryDataArray = new Object[]{DBServiceHelper.genGlobalLongId(), requestContext.getCurrUserId(), obj[2], requestContext.getCurrUserId(), obj[2], obj[3], obj[0], obj[1]};
            groupInsertHistoryDataList.add(groupHistoryDataArray);
        }
        if (groupInsertHistoryDataList.size() > 0) {
            String insertSql = "insert into t_hbss_certhistoryinfo(fid, fcreatorid, fcreatetime, fmodifierid, fmodifytime, fgroupid, fusedcount, fusedcountstring) values (?,?,?,?,?,?,?,?)";
            HRDBUtil.executeBatch((DBRoute)DBRoute.of((String)"hmp"), (String)insertSql, groupInsertHistoryDataList);
        }
        if (groupUpdateHistoryDataList.size() > 0) {
            String updateSql = "update t_hbss_certhistoryinfo  set fusedcount = ?,fusedcountstring = ?, fmodifytime =?, fmodifierid =? where fid = ? ";
            HRDBUtil.executeBatch((DBRoute)DBRoute.of((String)"hmp"), (String)updateSql, groupUpdateHistoryDataList);
        }
    }

    static Map<String, String> getCurrentCertCountFromDB() {
        String selectSql = "select fgroupid,fusedcountstring from t_hbss_certinfo where fgroupid in (" + String.join((CharSequence)",", HRCertConstant.GROUP_ID_SET) + ")";
        DataSet dataSet = HRDBUtil.queryDataSet((String)"hrCertGroupUsedCountQuery", (DBRoute)DBRoute.of((String)"hmp"), (String)selectSql, null);
        HashMap<String, String> groupDbResMap = new HashMap<String, String>(16);
        for (Row row : dataSet) {
            groupDbResMap.put(row.getString("fgroupid"), row.getString("fusedcountstring"));
        }
        dataSet.close();
        return groupDbResMap;
    }

    static Map<String, String> getGroupCertPctStringFromDB() {
        String selectSql = "select fgroupid,fpctstring from t_hbss_certinfo where fgroupid in (" + String.join((CharSequence)",", HRCertConstant.GROUP_ID_SET) + ") and fpctstring is not null";
        DataSet dataSet = HRDBUtil.queryDataSet((String)"hrCertGroupPCTQuery", (DBRoute)DBRoute.of((String)"hmp"), (String)selectSql, null);
        HashMap<String, String> groupDbResMap = new HashMap<String, String>(16);
        for (Row row : dataSet) {
            groupDbResMap.put(row.getString("fgroupid"), row.getString("fpctstring"));
        }
        dataSet.close();
        return groupDbResMap;
    }

    private static Map<Long, HRCertInfo> getTodayMaxUsedCountFromDB() {
        String selectSql = "select thc.fgroupid,thc.fid,thc.fusedcount from t_hbss_certhistoryinfo thc where thc.fgroupid in (" + String.join((CharSequence)",", HRCertConstant.GROUP_ID_SET) + ") and  thc.fcreatetime > curdate()";
        DataSet dataSet = HRDBUtil.queryDataSet((String)"hrcertgrouphistoryquery", (DBRoute)DBRoute.of((String)"hmp"), (String)selectSql, null);
        HashMap<Long, HRCertInfo> groupDbResMap = new HashMap<Long, HRCertInfo>(16);
        for (Row row : dataSet) {
            HRCertInfo certInfo = new HRCertInfo();
            certInfo.setId(row.getLong("fid"));
            certInfo.setUsedCount(row.getLong("fusedcount"));
            groupDbResMap.put(row.getLong("fgroupid"), certInfo);
        }
        dataSet.close();
        return groupDbResMap;
    }

    static Map<String, String> getGroupUsedCalClass() {
        String selectSql = "select fgroupid,fcalclass from t_hbss_certinfo";
        DataSet dataSet = HRDBUtil.queryDataSet((String)"hrcertgroupquery", (DBRoute)DBRoute.of((String)"hmp"), (String)selectSql, null);
        HashMap<String, String> groupCalClassMap = new HashMap<String, String>(16);
        for (Row row : dataSet) {
            groupCalClassMap.put(row.getString("fgroupid"), row.getString("fcalclass"));
        }
        dataSet.close();
        return groupCalClassMap;
    }
}

