/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.bussiness.cert;

import com.google.common.collect.Sets;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import javax.crypto.spec.SecretKeySpec;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.license.bean.LicenseGroupCtrl;
import kd.bos.license.service.cache.LicenseCache;
import kd.bos.license.util.LicenseGroupUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.hr.hbp.bussiness.cert.HRCertConstant;
import kd.hr.hbp.common.util.HRStringUtils;

final class HRCertUtils {
    private static final Log logger = LogFactory.getLog(HRCertUtils.class);
    private static final String KEY_CERT = "abJbVXGG+aRYu3OnbMm6ZA==";
    private static final String KEY_CODE_TYPE = "AES";
    private static final int GCM_IV_LENGTH = 12;
    private static final int GCM_TAG_LENGTH = 16;
    private static final String KEY_INSTANCE_TYPE = "AES/GCM/NoPadding";
    private static final String SIGN_ALGORITHMS = "SHA256WithRSA";
    private static final String KEY_SIGN_PUBLIC = "";
    private static final String KEY_PRIVATE = "MIICeAIBADANBgkqhkiG9w0BAQEFAASCAmIwggJeAgEAAoGBALkxYP+j9CIZ7RrqU92meHIPJRXWuQ9+n+2gN+uWJSWhZCjERLXFDuBW3WD7RvZ4/lMDyXI8VHXRmL4g96kut4Ywok3Bt4HSjUnu30jDUZKKnkoD5eJbTzW68ENK6YBPCJKhXSeCNwHBDXA5wbveGKt+mkQp4D31OC5GHQ9HWdvRAgMBAAECgYEAtIzVuqaH369TIMiQFyqzhtAJIe+D4P1cwnlPy5lIghWE5tHjAywpwsItdt3EY4u2uAybG4qB9ZPwzHyrt//Z34qAvW0finyI6xZuDitIF1cs3odluqbw37g7KC6yrA7S9YvuqS4TNlN4PxogyU3AzHMRBUAxZaxqYl3O0XtxiJkCQQDpI0dlHLjqBdh8AHtZGCD1yfRRzkDIfg8gQdzBMG0k8e/KEkXaWRCiUbAUe4fJwKP3qRelT0o7nehJX1i3QSeXAkEAy1p8D6xgIGA+ZhWmngmDiLZoB2qmAI1536wI85lQs0mfgP8q6P0/hOiI0gpzY+IY5oKvhZ8SbLLzfWfKJ37E1wJAXAOqiAPAD81i1f4ysMVPLPMaVLc85mSqf6a/BBii2zQJ2g1AOJ9yaz4mas8elshLbtH0HTCgMctvBJZ3I0y53QJBALPm4hiPnB8oZiuz/cqUihxZmyDsld2pS+e4b9bqjP2AJa9ejxy+ZwJzIhAIFNuJvBO6DAQ/nXIywrzwJGTaftMCQQC8WR1K6UJp3kQxmjuCZSQF0Q9DJC2ZZfe0xEzFlhjzHFJCyr3LuB+z9L/G7GGnu2yxfaIqd7d9Dlzx0I4YQjj0";
    private static final Set<String> allowedClassNameSet = Sets.newHashSet((Object[])new String[]{"kd.hr.hbp.bussiness.cert.HRCertManager", "kd.hr.hbp.bussiness.cert.HRCertCommonHelper", "kd.hr.hbp.bussiness.cert.HRUsedCertNumWarnDataSource", "kd.hr.hbp.bussiness.cert.HRBizCertSignHelper", "kd.hr.hbp.bussiness.cert.HRCertCalClassLoader"});

    HRCertUtils() {
    }

    static String encode(String data, String publicKey, String salt) {
        try {
            byte[] decoded = Base64.getDecoder().decode(publicKey);
            RSAPublicKey pubKey = (RSAPublicKey)KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(decoded));
            Cipher cipher = HRCertUtils.getRSACipher();
            if (cipher == null) {
                return null;
            }
            OAEPParameterSpec oaepParams = new OAEPParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, PSource.PSpecified.DEFAULT);
            cipher.init(1, (Key)pubKey, oaepParams);
            byte[] byteData = cipher.doFinal(data.getBytes(StandardCharsets.UTF_8));
            return Base64.getEncoder().encodeToString(HRCertUtils.process(byteData, salt));
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Cipher getRSACipher() {
        Cipher rsa = null;
        try {
            rsa = Cipher.getInstance("RSA/ECB/OAEPWITHSHA-256ANDMGF1PADDING");
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            logger.error("this should never happen", (Throwable)e);
        }
        return rsa;
    }

    static String decode(String content, String tenant) {
        HRCertUtils.isAllowedClassName(allowedClassNameSet);
        return HRCertUtils.decode(content, tenant, KEY_PRIVATE);
    }

    static String decode(String content, String tenant, String privateKey) {
        HRCertUtils.isAllowedClassName(allowedClassNameSet);
        try {
            byte[] inputByte = Base64.getDecoder().decode(content.getBytes(StandardCharsets.UTF_8));
            inputByte = HRCertUtils.process(inputByte, tenant);
            byte[] decoded = Base64.getDecoder().decode(privateKey);
            RSAPrivateKey priKey = (RSAPrivateKey)KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(decoded));
            Cipher cipher = HRCertUtils.getRSACipher();
            if (cipher == null) {
                return null;
            }
            OAEPParameterSpec oaepParams = new OAEPParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, PSource.PSpecified.DEFAULT);
            cipher.init(2, (Key)priKey, oaepParams);
            return new String(cipher.doFinal(inputByte));
        }
        catch (Exception e) {
            return null;
        }
    }

    static boolean checkSign(String content, String sign) {
        if (null == content || null == sign || KEY_SIGN_PUBLIC.equals(content) || KEY_SIGN_PUBLIC.equals(sign)) {
            return false;
        }
        try {
            byte[] decoded = Base64.getDecoder().decode(KEY_SIGN_PUBLIC);
            RSAPublicKey pubKey = (RSAPublicKey)KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(decoded));
            byte[] signed = Base64.getDecoder().decode(sign);
            Signature signatureChecker = Signature.getInstance(SIGN_ALGORITHMS);
            signatureChecker.initVerify(pubKey);
            signatureChecker.update(content.getBytes());
            return signatureChecker.verify(signed);
        }
        catch (Exception e) {
            return false;
        }
    }

    static String getGroupName(String groupId) {
        Map licenseGroupMap = LicenseGroupUtil.getLicenseGroup(null);
        Map licenseGroupMapV4 = LicenseGroupUtil.getLicenseGroupV4(null);
        String groupName = (String)licenseGroupMap.get(groupId);
        String string = groupName = HRStringUtils.isEmpty((String)groupName) ? (String)licenseGroupMapV4.get(groupId) : groupName;
        if (HRStringUtils.isEmpty((String)groupName)) {
            DynamicObject group = LicenseCache.getGroupByID((Long)Long.valueOf(groupId));
            groupName = group.getString("name");
        }
        return groupName;
    }

    static String encode4Cache(String data) {
        if (data == null || KEY_SIGN_PUBLIC.equals(data)) {
            return KEY_SIGN_PUBLIC;
        }
        String encodeString = Base64.getEncoder().encodeToString(HRCertUtils.encode(data.getBytes(StandardCharsets.UTF_8)));
        return HRStringUtils.isEmpty((String)encodeString) ? KEY_SIGN_PUBLIC : encodeString;
    }

    static String convertStringToHex(String str) {
        char[] charArray;
        StringBuilder stringBuilder = new StringBuilder();
        for (char chr : charArray = str.toCharArray()) {
            String charToHex = Integer.toHexString(chr);
            stringBuilder.append(charToHex);
        }
        return stringBuilder.toString();
    }

    static String decode4Cache(String data) {
        if (HRStringUtils.isEmpty((String)data)) {
            return null;
        }
        byte[] bytes = HRCertUtils.decrypt(Base64.getMimeDecoder().decode(data));
        String json = null;
        if (bytes != null) {
            Charset charset = Charset.forName(StandardCharsets.UTF_8.name());
            ByteBuffer byteBuffer = ByteBuffer.allocate(bytes.length);
            byteBuffer.put(bytes).flip();
            CharBuffer charBuffer = charset.decode(byteBuffer);
            json = new String(charBuffer.array());
            Arrays.fill(bytes, (byte)32);
        }
        return json;
    }

    private static byte[] encode(byte[] bytes) {
        HRCertUtils.isAllowedClassName(allowedClassNameSet);
        try {
            byte[] ivs = new byte[12];
            new SecureRandom().nextBytes(ivs);
            Cipher cipher = Cipher.getInstance(KEY_INSTANCE_TYPE);
            GCMParameterSpec ivSpec = new GCMParameterSpec(128, ivs);
            cipher.init(1, (Key)HRCertUtils.getPrivateKey(), ivSpec);
            byte[] ciphertext = cipher.doFinal(bytes);
            byte[] encrypted = new byte[ivs.length + ciphertext.length];
            System.arraycopy(ivs, 0, encrypted, 0, ivs.length);
            System.arraycopy(ciphertext, 0, encrypted, ivs.length, ciphertext.length);
            return encrypted;
        }
        catch (Exception var4) {
            return null;
        }
    }

    private static byte[] decrypt(byte[] bytes) {
        HRCertUtils.isAllowedClassName(allowedClassNameSet);
        try {
            byte[] ivs = Arrays.copyOfRange(bytes, 0, 12);
            Cipher cipher = Cipher.getInstance(KEY_INSTANCE_TYPE);
            GCMParameterSpec ivSpec = new GCMParameterSpec(128, ivs);
            cipher.init(2, (Key)HRCertUtils.getPrivateKey(), ivSpec);
            return cipher.doFinal(bytes, 12, bytes.length - 12);
        }
        catch (Exception var4) {
            logger.error("kd.hr.hbp.bussiness.cert.HRCertManager.decrypt error! may be the data is invalid.");
            return null;
        }
    }

    private static SecretKeySpec getPrivateKey() {
        return new SecretKeySpec(Base64.getDecoder().decode(KEY_CERT), KEY_CODE_TYPE);
    }

    private static byte[] process(byte[] inputByte, String tenant) {
        if (tenant == null || KEY_SIGN_PUBLIC.equals(tenant.trim())) {
            return inputByte;
        }
        int dataLength = inputByte.length;
        byte[] result = new byte[dataLength];
        byte[] tenantByte = tenant.getBytes(StandardCharsets.UTF_8);
        for (int idx = 0; idx < dataLength; ++idx) {
            result[idx] = idx < tenantByte.length ? (byte)(inputByte[idx] ^ tenantByte[idx]) : inputByte[idx];
        }
        return result;
    }

    static void isAllowedClassName(Set<String> allowedClassNameSet) {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        boolean isAllowedClass = Arrays.stream(stackTraceElements).limit(20L).anyMatch(stackTraceElement -> allowedClassNameSet.contains(stackTraceElement.getClassName()));
        if (!isAllowedClass) {
            throw new KDBizException("HRLicenseManage error: current call is not allowed.");
        }
    }

    static String getGroupIdByBizObjID(String bizAppID, String bizObjID) {
        if (bizAppID == null || bizObjID == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4e1a\u52a1\u5bf9\u8c61%s\u6ca1\u6709\u5339\u914d\u7684\u8bb8\u53ef\u5206\u7ec4\u3002", (String)"HRCertUtils_0", (String)"hrmp-hbp-certmanager", (Object[])new Object[0]), bizObjID));
        }
        Set<Long> groupIdSet = HRCertUtils.getGroupIdSetByBizObjID(bizAppID, bizObjID);
        logger.info("HRCertUtils.getGroupIdByBizObjID:bizAppID:{},bizObjID:{}", (Object)bizAppID, (Object)bizObjID);
        if (groupIdSet.size() > 0) {
            Long groupId = groupIdSet.iterator().next();
            logger.info("HRCertUtils.getGroupIdByBizObjID,groupIdSet.size:{},bizAppID:{},bizObjID:{},groupId:{}", new Object[]{groupIdSet.size(), bizAppID, bizObjID, groupId});
            return String.valueOf(groupId);
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4e1a\u52a1\u5bf9\u8c61%s\u6ca1\u6709\u5339\u914d\u7684\u8bb8\u53ef\u5206\u7ec4\u3002", (String)"HRCertUtils_0", (String)"hrmp-hbp-certmanager", (Object[])new Object[0]), bizObjID));
    }

    static String getSignData(String data, String salt) throws KDBizException {
        String signData = data + salt;
        try {
            MessageDigest mdTemp = MessageDigest.getInstance("SHA-256");
            mdTemp.update(signData.getBytes(StandardCharsets.UTF_8));
            signData = new BigInteger(1, mdTemp.digest()).toString(16);
        }
        catch (Exception ex) {
            logger.error(signData);
            logger.error(ex.getMessage());
            throw new KDBizException("create sign data error:" + ex.getMessage());
        }
        return signData;
    }

    static Set<Long> getGroupIdSetByBizObjID(String bizAppID, String bizObjID) {
        if (bizAppID == null || bizObjID == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4e1a\u52a1\u5bf9\u8c61%s\u6ca1\u6709\u5339\u914d\u7684\u8bb8\u53ef\u5206\u7ec4\u3002", (String)"HRCertUtils_0", (String)"hrmp-hbp-certmanager", (Object[])new Object[0]), bizObjID));
        }
        logger.info("HRCertUtils.getGroupIdSetByBizObjID:bizAppID:{},bizObjID:{}", (Object)bizAppID, (Object)bizObjID);
        HashSet<Long> groups = new HashSet<Long>(16);
        try (TXHandle h = TX.notSupported((String)"hrmp_query_licensegroup");){
            try {
                LicenseGroupCtrl licenseGroupCtrl;
                groups.addAll(LicenseCache.getGroups((String)bizAppID, (String)bizObjID));
                if (groups.size() == 0 && (licenseGroupCtrl = LicenseCache.getLicenseGroupCtrl((String)bizAppID, (String)bizObjID)) != null) {
                    groups.addAll(licenseGroupCtrl.getCurVersionGroups());
                    groups.addAll(licenseGroupCtrl.getLatestVersionGroups());
                }
            }
            catch (Exception e) {
                logger.info(e.getMessage());
            }
        }
        return groups;
    }

    protected static boolean isHRTenant() {
        boolean isHRTenant = false;
        for (String groupNumber : HRCertConstant.GROUP_NUMBER_SET) {
            if (!LicenseServiceHelper.checkGroup((String)groupNumber).getHasLicense().booleanValue()) continue;
            isHRTenant = true;
            break;
        }
        return isHRTenant;
    }
}

