/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.bussiness.cert.biz;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.bussiness.cert.HRCertCalClassLoader;
import kd.hr.hbp.bussiness.cert.biz.IHRCertCalculator;

public final class HRCertCalculatorFactory {
    private static final Log logger = LogFactory.getLog(HRCertCalculatorFactory.class);
    private static final Map<String, String> groupCalClassMap = new ConcurrentHashMap<String, String>(16);
    private static final Set<String> allowedClassNameSet = Sets.newHashSet((Object[])new String[]{"kd.hr.hbp.bussiness.cert.HRCertManager", "kd.hr.hbp.bussiness.cert.HRCertCacheManager", "kd.hr.hbp.bussiness.cert.HRCertCommonHelper", "kd.hr.hbp.bussiness.cert.HRCertDBUtils"});

    public static IHRCertCalculator getInstance(String groupId) {
        HRCertCalculatorFactory.isAllowedClassName();
        String calClassName = groupCalClassMap.get(groupId);
        try {
            if (calClassName != null) {
                return (IHRCertCalculator)TypesContainer.getOrRegister((String)calClassName).newInstance();
            }
            Map<String, String> map = groupCalClassMap;
            synchronized (map) {
                HRCertCalculatorFactory.loadGroupUsedCalClass();
                calClassName = groupCalClassMap.get(groupId);
                if (calClassName != null) {
                    return (IHRCertCalculator)TypesContainer.getOrRegister((String)calClassName).newInstance();
                }
                String errorMessage = String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u8ba1\u7b97\u5904\u7406\u7c7b\u51fa\u73b0\u5f02\u5e38\uff0c\u5206\u7ec4ID\u4e3a %s\u3002", (String)"HRCertCalculatorFactory_0", (String)"hrmp-hbp-certmanager", (Object[])new Object[0]), groupId);
                throw new KDBizException(errorMessage);
            }
        }
        catch (Exception exception) {
            String errorMessage = String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u8ba1\u7b97\u5904\u7406\u7c7b\u51fa\u73b0\u5f02\u5e38\uff0c\u5206\u7ec4ID\u4e3a %s\u3002", (String)"HRCertCalculatorFactory_0", (String)"hrmp-hbp-certmanager", (Object[])new Object[0]), groupId);
            logger.error((Throwable)exception);
            ErrorCode errorCode = new ErrorCode("kd.hr.hbp.bussiness.cert.biz.HRCertCalculatorFactory.getInstance", errorMessage);
            throw new KDBizException((Throwable)exception, errorCode, new Object[0]);
        }
    }

    static void isAllowedClassName() {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        boolean isAllowedClass = Arrays.stream(stackTraceElements).limit(10L).anyMatch(stackTraceElement -> allowedClassNameSet.contains(stackTraceElement.getClassName()));
        if (!isAllowedClass) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u8c03\u7528\u7c7b\u4e0d\u5728\u767d\u540d\u5355\u8303\u56f4\u5185\u3002\u8bf7\u68c0\u67e5\u5e76\u4fee\u6539\u3002", (String)"HRCertManager_5", (String)"hrmp-hbp-certmanager", (Object[])new Object[0]));
        }
    }

    static void loadGroupUsedCalClass() {
        Map<String, String> groupCalClassSrcMap = HRCertCalClassLoader.getGroupUsedCalClass();
        groupCalClassSrcMap.forEach((groupId, calClassName) -> {
            if (calClassName.contains("kd.hr.hbp.bussiness.cert.biz")) {
                groupCalClassMap.put((String)groupId, (String)calClassName);
            } else {
                logger.error(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u8ba1\u7b97\u5904\u7406\u7c7b\u51fa\u73b0\u5f02\u5e38\uff0c\u5206\u7ec4ID:%1$s\uff0c\u7c7b\u540d:%2$s\u3002", (String)"HRCertCalculatorFactory_1", (String)"hrmp-hbp-certmanager", (Object[])new Object[0]), groupId, calClassName));
            }
        });
    }
}

