/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.bussiness.cert.biz;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.bussiness.cert.HRCertCommonHelper;
import kd.hr.hbp.bussiness.cert.HRCertPromptInfoTypeEnum;
import kd.hr.hbp.bussiness.cert.biz.HRCertCalculatorFactory;
import kd.hr.hbp.bussiness.cert.biz.IHRCertCalculator;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRObjectUtils;

final class HREMPCertCalculator
implements IHRCertCalculator {
    private static final String ENTITYNAME = "hrpi_empposorgrel";
    private static final String KEY_ENTITYNAME_CERRGROUPMEMBER = "hbss_certmember";
    private static final HRBaseServiceHelper SERVICE_HELPER = new HRBaseServiceHelper("hrpi_empposorgrel");
    private static final String KEY_PERSON_PREFIX = "person.";
    private static final String KEY_SEQNUMBER = "seqnumber";

    HREMPCertCalculator() {
    }

    @Override
    public int calculateUsedCertCount(String groupId) {
        HRCertCalculatorFactory.isAllowedClassName();
        return SERVICE_HELPER.count(ENTITYNAME, this.getFilters());
    }

    @Override
    public DynamicObjectCollection getData(String groupId, List<QFilter> filter, int start, int limit) {
        DynamicObjectCollection doc = new DynamicObjectCollection();
        Object[] primaryPersonArray = BusinessDataServiceHelper.load((String)ENTITYNAME, (String)"person", (QFilter[])this.getFilters(filter), (String)"number", (int)(start / limit), (int)limit);
        if (HRArrayUtils.isEmpty((Object[])primaryPersonArray)) {
            return new DynamicObjectCollection(new DynamicObjectType(KEY_ENTITYNAME_CERRGROUPMEMBER), null);
        }
        AtomicInteger idx = new AtomicInteger(start);
        Arrays.stream(primaryPersonArray).forEach(emporgRel -> {
            DynamicObject personDy = emporgRel.getDynamicObject("person");
            if (!HRObjectUtils.isEmpty((Object)personDy)) {
                DynamicObject dObject = BusinessDataServiceHelper.newDynamicObject((String)KEY_ENTITYNAME_CERRGROUPMEMBER);
                dObject.set("name", (Object)personDy.getString("name"));
                dObject.set("number", (Object)personDy.getString("number"));
                dObject.set(KEY_SEQNUMBER, (Object)idx.incrementAndGet());
                doc.add((Object)dObject);
            }
        });
        return doc;
    }

    @Override
    public int getRealCount(String groupId, List<QFilter> filter) {
        return SERVICE_HELPER.count(ENTITYNAME, this.getFilters(filter));
    }

    private QFilter[] getFilters() {
        return this.getFilters(null);
    }

    private QFilter[] getFilters(List<QFilter> custFilters) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("iscurrentversion", "=", (Object)"1"));
        filters.add(new QFilter("businessstatus", "=", (Object)"1"));
        filters.add(new QFilter("isprimary", "=", (Object)"1"));
        filters.add(new QFilter("initstatus", "=", (Object)"2"));
        filters.add(new QFilter("postype.postcategory", "=", (Object)1010L));
        filters.add(new QFilter("employee.laborrelstatus.labrelstatusprd", "in", (Object)1010L));
        filters.add(new QFilter("datastatus", "=", (Object)"1"));
        if (null != custFilters && !custFilters.isEmpty()) {
            custFilters.forEach(qft -> {
                String value = KEY_PERSON_PREFIX + qft.getValue();
                value = value.replace(",", ",person.");
                filters.add(new QFilter(qft.getProperty(), "ftlike", (Object)value));
            });
        }
        return filters.toArray(new QFilter[0]);
    }

    @Override
    public Map<String, Object> updateBizAssignData(String groupId) {
        Map<String, String> map = HRCertCommonHelper.verifyCertCount(groupId);
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)4);
        if (HRCertPromptInfoTypeEnum.FORBIDDEN.getName().equals(map.get("infoType"))) {
            resultMap.put("exeFlag", false);
            resultMap.put("msg", "verifyCertCount return FORBIDDEN");
            return resultMap;
        }
        resultMap.put("exeFlag", true);
        resultMap.put("msg", "excute corehr licenseService");
        HRMServiceHelper.invokeHRService((String)"hpfs", (String)"IHPFSLicenseService", (String)"updateLicenseSign", (Object[])new Object[]{groupId});
        return resultMap;
    }
}

