/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.bussiness.cert.biz;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.bussiness.cert.HRCertCommonHelper;
import kd.hr.hbp.bussiness.cert.HRCertPromptInfoTypeEnum;
import kd.hr.hbp.bussiness.cert.biz.HRCertCalculatorFactory;
import kd.hr.hbp.bussiness.cert.biz.IHRCertCalculator;

public class HRTSCCertCalculator
implements IHRCertCalculator {
    private static final Log logger = LogFactory.getLog(HRTSCCertCalculator.class);
    private static final String KEY_CERT_ENTITY = "tsirm_certdetail";
    private static final String KEY_ENTITY_CERTGROUPMEMBER = "hbss_certmember";
    private static final String KEY_SEQNUMBER = "seqnumber";

    @Override
    public int calculateUsedCertCount(String groupId) {
        logger.info("calculateUsedCertCount. groupId={}", (Object)groupId);
        HRCertCalculatorFactory.isAllowedClassName();
        return this.getRealCount(groupId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DynamicObjectCollection getData(String groupId, List<QFilter> qFilters, int start, int limit) {
        logger.info("getData. groupId={} start={} limit={}", new Object[]{groupId, start, limit});
        DynamicObjectCollection dyoc = new DynamicObjectCollection();
        DataSet pidDataSet = null;
        DataSet personDataSet = null;
        DataSet finish = null;
        try {
            QFilter groupFilter = QFilter.of((String)"groupid=?", (Object[])new Object[]{groupId});
            pidDataSet = QueryServiceHelper.queryDataSet((String)"kd.hr.hbp.bussiness.cert.biz.HRTSCCertCalculator1", (String)KEY_CERT_ENTITY, (String)"pid", (QFilter[])new QFilter[]{groupFilter}, null);
            if (pidDataSet.isEmpty()) {
                DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection(new DynamicObjectType(KEY_ENTITY_CERTGROUPMEMBER), null);
                return dynamicObjectCollection;
            }
            qFilters.add(new QFilter("iscurrentversion", "=", (Object)"1"));
            personDataSet = QueryServiceHelper.queryDataSet((String)"kd.hr.hbp.bussiness.cert.biz.HRTSCCertCalculator2", (String)"hrpi_person", (String)"personindexid,name,number ", (QFilter[])qFilters.toArray(new QFilter[0]), null);
            finish = pidDataSet.join(personDataSet).on("pid", "personindexid").select(new String[0], new String[]{"name", "number"}).finish().limit(start, limit);
            AtomicInteger idx = new AtomicInteger(start);
            while (finish.hasNext()) {
                Row row = finish.next();
                DynamicObject dObject = BusinessDataServiceHelper.newDynamicObject((String)KEY_ENTITY_CERTGROUPMEMBER);
                dObject.set("name", (Object)row.getString("name"));
                dObject.set("number", (Object)row.getString("number"));
                dObject.set(KEY_SEQNUMBER, (Object)idx.incrementAndGet());
                dyoc.add((Object)dObject);
            }
        }
        finally {
            if (finish != null) {
                finish.close();
            }
            if (personDataSet != null) {
                personDataSet.close();
            }
            if (pidDataSet != null) {
                pidDataSet.close();
            }
        }
        if (dyoc.size() < 1) {
            return new DynamicObjectCollection(new DynamicObjectType(KEY_ENTITY_CERTGROUPMEMBER), null);
        }
        return dyoc;
    }

    @Override
    public int getRealCount(String groupId, List<QFilter> qFilters) {
        logger.info("getRealCount.");
        QFilter groupFilter = QFilter.of((String)"groupid=?", (Object[])new Object[]{groupId});
        if (qFilters != null && qFilters.size() > 0) {
            Object[] objects = BusinessDataServiceHelper.load((String)KEY_CERT_ENTITY, (String)"pid", (QFilter[])new QFilter[]{groupFilter});
            if (ArrayUtils.isEmpty((Object[])objects)) {
                return 0;
            }
            Set pidSet = Arrays.stream(objects).map(row -> row.getLong("pid")).collect(Collectors.toSet());
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            filters.add(new QFilter("personindexid", "in", pidSet));
            filters.add(new QFilter("iscurrentversion", "=", (Object)"1"));
            filters.addAll(qFilters);
            return ORM.create().count("BusinessDataServiceHelper_count", "hrpi_person", filters.toArray(new QFilter[filters.size()]));
        }
        return ORM.create().count("BusinessDataServiceHelper_count", KEY_CERT_ENTITY, new QFilter[]{groupFilter});
    }

    @Override
    public Map<String, Object> updateBizAssignData(String groupId) {
        logger.info("updateBizAssignData. groupId={}", (Object)groupId);
        Map<String, String> map = HRCertCommonHelper.verifyCertCount(groupId);
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)4);
        if (null == map || HRCertPromptInfoTypeEnum.FORBIDDEN.getName().equals(map.get("infoType"))) {
            resultMap.put("exeFlag", false);
            resultMap.put("msg", "verifyCertCount return FORBIDDEN");
            return resultMap;
        }
        resultMap.put("exeFlag", true);
        resultMap.put("msg", "excute tsrbd licenseService");
        HRMServiceHelper.invokeBizService((String)"tsc", (String)"tsirm", (String)"ITSIRMLicenseService", (String)"updateCertDetail", (Object[])new Object[]{groupId});
        return resultMap;
    }
}

