/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.bussiness.cert.biz;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.bussiness.cert.HRCertCommonHelper;
import kd.hr.hbp.bussiness.cert.HRCertPromptInfoTypeEnum;
import kd.hr.hbp.bussiness.cert.biz.HRCertCalculatorFactory;
import kd.hr.hbp.bussiness.cert.biz.IHRCertCalculator;

final class HRWTCCertCalculator
implements IHRCertCalculator {
    public static final String WORKHOUR_CERTENTITY = "wtbs_certdetail";
    private static final String KEY_ENTITYNAME_CERRGROUPMEMBER = "hbss_certmember";
    private static final String KEY_SEQNUMBER = "seqnumber";

    HRWTCCertCalculator() {
    }

    @Override
    public int calculateUsedCertCount(String groupId) {
        HRCertCalculatorFactory.isAllowedClassName();
        return this.getRealCount(groupId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DynamicObjectCollection getData(String groupId, List<QFilter> qFilters, int start, int limit) {
        DynamicObjectCollection doc = new DynamicObjectCollection();
        DataSet dataSet1 = null;
        DataSet dataSet2 = null;
        DataSet finish = null;
        try {
            QFilter groupFilter = QFilter.of((String)"groupid=?", (Object[])new Object[]{groupId});
            dataSet1 = QueryServiceHelper.queryDataSet((String)"algokey1", (String)WORKHOUR_CERTENTITY, (String)"pid", (QFilter[])new QFilter[]{groupFilter}, null);
            qFilters.add(new QFilter("iscurrentversion", "=", (Object)"1"));
            dataSet2 = QueryServiceHelper.queryDataSet((String)"algokey2", (String)"hrpi_person", (String)"personindexid,name,number ", (QFilter[])qFilters.toArray(new QFilter[0]), null);
            finish = dataSet1.join(dataSet2).on("pid", "personindexid").select(new String[0], new String[]{"name", "number"}).finish().limit(start, limit);
            AtomicInteger idx = new AtomicInteger(start);
            while (finish.hasNext()) {
                Row row = finish.next();
                DynamicObject dObject = BusinessDataServiceHelper.newDynamicObject((String)KEY_ENTITYNAME_CERRGROUPMEMBER);
                dObject.set("name", (Object)row.getString("name"));
                dObject.set("number", (Object)row.getString("number"));
                dObject.set(KEY_SEQNUMBER, (Object)idx.incrementAndGet());
                doc.add((Object)dObject);
            }
        }
        finally {
            if (finish != null) {
                finish.close();
            }
            if (dataSet2 != null) {
                dataSet2.close();
            }
            if (dataSet1 != null) {
                dataSet1.close();
            }
        }
        if (doc.size() < 1) {
            return new DynamicObjectCollection(new DynamicObjectType(KEY_ENTITYNAME_CERRGROUPMEMBER), null);
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRealCount(String groupId, List<QFilter> filter) {
        QFilter groupFilter = QFilter.of((String)"groupid=?", (Object[])new Object[]{groupId});
        if (filter != null && filter.size() > 0) {
            int count;
            DataSet dataSet1 = null;
            DataSet dataSet2 = null;
            try {
                dataSet1 = QueryServiceHelper.queryDataSet((String)"algokey1", (String)WORKHOUR_CERTENTITY, (String)"pid", (QFilter[])new QFilter[]{groupFilter}, null);
                filter.add(new QFilter("iscurrentversion", "=", (Object)"1"));
                dataSet2 = QueryServiceHelper.queryDataSet((String)"algokey2", (String)"hrpi_person", (String)"personindexid,name,number ", (QFilter[])filter.toArray(new QFilter[0]), null);
                count = dataSet1.join(dataSet2).on("pid", "personindexid").select(new String[0], new String[]{"name", "number", "personindexid"}).finish().count("personindexid", true);
            }
            finally {
                if (dataSet2 != null) {
                    dataSet2.close();
                }
                if (dataSet1 != null) {
                    dataSet1.close();
                }
            }
            return count;
        }
        return ORM.create().count("BusinessDataServiceHelper_count", WORKHOUR_CERTENTITY, new QFilter[]{groupFilter});
    }

    @Override
    public Map<String, Object> updateBizAssignData(String groupId) {
        Map<String, String> map = HRCertCommonHelper.verifyCertCount(groupId);
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)4);
        if (null == map || HRCertPromptInfoTypeEnum.FORBIDDEN.getName().equals(map.get("infoType"))) {
            resultMap.put("exeFlag", false);
            resultMap.put("msg", "verifyCertCount return FORBIDDEN");
            return resultMap;
        }
        resultMap.put("exeFlag", true);
        resultMap.put("msg", "excute wtc licenseService");
        HRMServiceHelper.invokeBizService((String)"wtc", (String)"wtbs", (String)"ILicenseService", (String)"updateCertDetail", (Object[])new Object[]{groupId});
        return resultMap;
    }
}

