/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.opplugin.validator.flow;

import java.text.MessageFormat;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import org.apache.commons.lang3.StringUtils;

public class JobSettingValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] data = this.getDataEntities();
        String operationKey = this.getOperateKey();
        if (StringUtils.isBlank((CharSequence)operationKey)) {
            return;
        }
        switch (operationKey) {
            case "save": 
            case "submit": 
            case "confirmchange": 
            case "confirmchangenoaudit": {
                for (ExtendedDataEntity dataEntity : data) {
                    this.checkOpType(dataEntity);
                }
                break;
            }
        }
    }

    private void checkOpType(ExtendedDataEntity dataEntity) {
        String exeDisplayName;
        DynamicObject dy = dataEntity.getDataEntity();
        DynamicObjectCollection opEntries = dy.getDynamicObjectCollection("jobaction");
        if (opEntries.isEmpty()) {
            String actionControlApDisplayName = this.getActionControlApDisplayName(dy.getDataEntityType().getName());
            this.addFatalErrorMessage(dataEntity, MessageFormat.format(ResManager.loadKDString((String)"[{0}]\u4e0d\u80fd\u4e3a\u7a7a", (String)"JobSettingValidator_0", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]), actionControlApDisplayName));
            return;
        }
        int executeNum = 0;
        int resetNum = 0;
        ComboProp actionTypeProp = (ComboProp)opEntries.getDynamicObjectType().getProperty("actiontype");
        for (DynamicObject entry : opEntries) {
            String opType = entry.getString((IDataEntityProperty)actionTypeProp);
            if ("execute".equals(opType)) {
                ++executeNum;
                continue;
            }
            if (!"reset".equals(opType)) continue;
            ++resetNum;
        }
        if (executeNum == 0) {
            exeDisplayName = actionTypeProp.getItemByName("execute");
            this.addFatalErrorMessage(dataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u5fc5\u987b\u6709\u4e00\u4e2a[{0}]\u4e3a[{1}]\u7684\u8282\u70b9", (String)"JobSettingValidator_1", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]), actionTypeProp.getDisplayName().getLocaleValue(), exeDisplayName));
        } else if (executeNum > 1) {
            exeDisplayName = actionTypeProp.getItemByName("execute");
            this.addFatalErrorMessage(dataEntity, MessageFormat.format(ResManager.loadKDString((String)"[{0}]\u4e3a[{1}]\u7684\u8282\u70b9\u53ea\u80fd\u5b58\u5728\u4e00\u4e2a", (String)"JobSettingValidator_2", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]), actionTypeProp.getDisplayName().getLocaleValue(), exeDisplayName));
        }
        if (resetNum > 1) {
            String resetDisplayName = actionTypeProp.getItemByName("reset");
            this.addFatalErrorMessage(dataEntity, MessageFormat.format(ResManager.loadKDString((String)"[{0}]\u4e3a[{1}]\u7684\u8282\u70b9\u53ea\u80fd\u5b58\u5728\u4e00\u4e2a", (String)"JobSettingValidator_2", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]), actionTypeProp.getDisplayName().getLocaleValue(), resetDisplayName));
        }
    }

    private String getActionControlApDisplayName(String entityNumber) {
        String jobActionControlDisplayName = "";
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        Optional<ControlAp> jobActionControlApOp = formMetadata.getItems().stream().filter(controlAp -> "jobactionap".equals(controlAp.getKey())).findFirst();
        if (jobActionControlApOp.isPresent()) {
            jobActionControlDisplayName = jobActionControlApOp.get().getName().getLocaleValue();
        }
        return jobActionControlDisplayName;
    }
}

