/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.opplugin.web.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.ORM;
import kd.hr.hbp.opplugin.validator.HRAPISourceSaveValidator;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;

public class HRAPISourceSaveOp
extends HRDataBaseOp {
    private static final String ENTITYKEY_APISOURCE = "hbp_apisourcetpl";
    private static final String API_FIELDS = "apiFields";
    private static final String ENTITY = "entity";
    private static final String ENTITY_KEY = "entityKey";
    private static final String ENABLE = "enable";
    private static final String STR = "\t\t\t\t\t";
    private static final String STR1 = "\t\t\t";

    public void beginOperationTransaction(BeginOperationTransactionArgs beginOperationTransactionArgs) {
        super.beginOperationTransaction(beginOperationTransactionArgs);
        DynamicObject[] dys = beginOperationTransactionArgs.getDataEntities();
        if (dys == null || dys.length < 1) {
            return;
        }
        String opKey = beginOperationTransactionArgs.getOperationKey();
        if (!"save".equals(opKey)) {
            return;
        }
        String id = dys[0].getString("id");
        this.setAPIXML(dys[0]);
    }

    public void onAddValidators(AddValidatorsEventArgs addValidatorsEventArgs) {
        addValidatorsEventArgs.addValidator((AbstractValidator)new HRAPISourceSaveValidator());
    }

    private void setAPISourceId(DynamicObject dy) {
        long id = ORM.create().genLongId(ENTITYKEY_APISOURCE);
        dy.set("id", (Object)id);
    }

    private void setAPIXML(DynamicObject dy) {
        String apiXML = this.genAPISourceXML(dy);
        dy.set("apixml", (Object)apiXML);
    }

    private String genAPISourceXML(DynamicObject dy) {
        String bizCloudId = dy.getString("bizcloud.id");
        String bizAppId = dy.getString("bizapp.id");
        long id = dy.getLong("id");
        long version = System.currentTimeMillis();
        String number = dy.getString("number");
        String key = dy.getString("key");
        String name = dy.getLocaleString("name").getLocaleValue();
        String description = dy.getLocaleString("description").getLocaleValue();
        String enable = dy.getString(ENABLE);
        String service = dy.getString("service");
        String method = dy.getString("method");
        String param = dy.getString("param");
        StringBuilder apiSource = new StringBuilder();
        apiSource.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append('\n').append('\n');
        apiSource.append("<APIMetadata>").append('\n');
        apiSource.append("\t").append("<BizCloudId>").append(bizCloudId).append("</BizCloudId>").append('\n');
        apiSource.append("\t").append("<BizAppId>").append(bizAppId).append("</BizAppId>").append('\n');
        apiSource.append("\t").append("<Id>").append(id).append("</Id>").append('\n');
        apiSource.append("\t").append("<Version>").append(version).append("</Version>").append('\n');
        apiSource.append("\t").append("<Number>").append(number).append("</Number>").append('\n');
        apiSource.append("\t").append("<Key>").append(key).append("</Key>").append('\n');
        apiSource.append("\t").append("<Name>").append(name).append("</Name>").append('\n');
        apiSource.append("\t").append("<Description>").append(description).append("</Description>").append('\n');
        apiSource.append("\t").append("<Service>").append(service).append("</Service>").append('\n');
        apiSource.append("\t").append("<Method>").append(method).append("</Method>").append('\n');
        apiSource.append("\t").append("<Param>").append(param).append("</Param>").append('\n');
        apiSource.append("\t").append("<Enable>").append(enable).append("</Enable>").append('\n');
        apiSource.append("\t").append("<APIDataXml>").append('\n');
        apiSource.append(this.genAPIDataXml(dy));
        apiSource.append("\t").append("</APIDataXml>").append('\n');
        apiSource.append("</APIMetadata>");
        return apiSource.toString();
    }

    private String genAPIDataXml(DynamicObject dy) {
        StringBuilder apiDataSource = new StringBuilder();
        List<Map<String, Object>> apiEntitySource = this.getAPIEntitySource(dy);
        for (Map<String, Object> apiEntity : apiEntitySource) {
            apiDataSource.append("\t\t").append("<APIEntity>").append('\n');
            apiDataSource.append(STR1).append("<Entity>").append(apiEntity.get(ENTITY_KEY)).append("</Entity>").append('\n');
            apiDataSource.append(STR1).append("<Description>").append(apiEntity.get(ENTITY)).append("</Description>").append('\n');
            apiDataSource.append(STR1).append("<APIFields>").append('\n');
            List apiFieldsSource = (List)apiEntity.get(API_FIELDS);
            if (apiFieldsSource != null) {
                for (Map apiField : apiFieldsSource) {
                    this.appendApiData(apiDataSource, apiField);
                }
            }
            apiDataSource.append(STR1).append("</APIFields>").append('\n');
            apiDataSource.append("\t\t").append("</APIEntity>").append('\n');
        }
        return apiDataSource.toString();
    }

    private void appendApiData(StringBuilder apiDataSource, Map<String, Object> apiField) {
        apiDataSource.append("\t\t\t\t").append("<APIField>").append('\n');
        apiDataSource.append(STR).append("<Key>").append(apiField.get("apiFieldKey")).append("</Key>").append('\n').append(STR).append("<Name>").append(apiField.get("apiFieldName")).append("</Name>").append('\n').append(STR).append("<Type>").append(apiField.get("apiFieldType")).append("</Type>").append('\n').append(STR).append("<QueryField>").append(apiField.get("queryField")).append("</QueryField>").append('\n').append(STR).append("<QueryFieldName>").append(apiField.get("queryFieldName")).append("</QueryFieldName>").append('\n').append(STR).append("<QueryFieldRelEntity>").append(apiField.get("queryFieldEntity")).append("</QueryFieldRelEntity>").append('\n').append(STR).append("<BaseEntityName>").append(apiField.get("baseEntityName")).append("</BaseEntityName>").append('\n').append(STR).append("<Enable>").append(apiField.get(ENABLE)).append("</Enable>").append('\n');
        apiDataSource.append("\t\t\t\t").append("</APIField>").append('\n');
    }

    private List<Map<String, Object>> getAPIEntitySource(DynamicObject dy) {
        DynamicObjectCollection entityEntryColl = dy.getDynamicObjectCollection("entryentity1");
        Map<String, List<Map<String, Object>>> apiFieldsSource = this.getAPIFieldsSource(dy);
        ArrayList<Map<String, Object>> entitySourceList = new ArrayList<Map<String, Object>>(entityEntryColl.size() + 1);
        Map<String, Object> mainEntitySource = this.getMainEntitySource(dy, apiFieldsSource);
        entitySourceList.add(mainEntitySource);
        for (DynamicObject entityDy : entityEntryColl) {
            HashMap<String, Object> entityInfo = new HashMap<String, Object>(6);
            String entityKey = entityDy.getString("entitykey1");
            String entity = entityDy.getLocaleString("entity1").getLocaleValue();
            entityInfo.put(ENTITY_KEY, entityKey);
            entityInfo.put(ENTITY, entity);
            entityInfo.put(API_FIELDS, apiFieldsSource.get(entityKey));
            entitySourceList.add(entityInfo);
        }
        return entitySourceList;
    }

    private Map<String, Object> getMainEntitySource(DynamicObject dy, Map<String, List<Map<String, Object>>> apiFieldsSource) {
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        DynamicObject queryEntityDy = dy.getDynamicObject("mainentity");
        String queryEntity = queryEntityDy.getString("number");
        QueryEntityType queryEntityTpe = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)queryEntity);
        String mainEntityKey = queryEntityTpe.getMainEntityType().getName();
        String mainEntity = queryEntityTpe.getMainEntityType().getDisplayName().getLocaleValue();
        map.put(ENTITY_KEY, mainEntityKey);
        map.put(ENTITY, mainEntity);
        map.put(API_FIELDS, apiFieldsSource.get(mainEntityKey));
        return map;
    }

    private Map<String, List<Map<String, Object>>> getAPIFieldsSource(DynamicObject dy) {
        HashMap<String, List<Map<String, Object>>> map = new HashMap<String, List<Map<String, Object>>>();
        DynamicObjectCollection fieldEntryColl = dy.getDynamicObjectCollection("entryfield1");
        for (DynamicObject fieldDy : fieldEntryColl) {
            HashMap<String, String> fieldInfo = new HashMap<String, String>(6);
            String queryField = fieldDy.getString("queryfield1");
            String queryFieldName = fieldDy.getString("queryfieldname1");
            String queryFieldEntity = fieldDy.getString("queryfieldentity1");
            String apiFieldKey = fieldDy.getString("apifieldkey1");
            String apiFieldName = fieldDy.getString("apifieldname1");
            String apiFieldType = fieldDy.getString("apifieldtype1");
            String enable = fieldDy.getString("enablefield1");
            String baseEntityName = fieldDy.getString("baseentityname");
            fieldInfo.put("queryField", queryField);
            fieldInfo.put("queryFieldName", queryFieldName);
            fieldInfo.put("queryFieldEntity", queryFieldEntity);
            fieldInfo.put("apiFieldKey", apiFieldKey);
            fieldInfo.put("apiFieldName", apiFieldName);
            fieldInfo.put("apiFieldType", apiFieldType);
            fieldInfo.put(ENABLE, enable);
            fieldInfo.put("baseEntityName", baseEntityName);
            if (map.containsKey(queryFieldEntity)) {
                ((List)map.get(queryFieldEntity)).add(fieldInfo);
                continue;
            }
            ArrayList<HashMap<String, String>> fieldInfoList = new ArrayList<HashMap<String, String>>();
            fieldInfoList.add(fieldInfo);
            map.put(queryFieldEntity, fieldInfoList);
        }
        return map;
    }
}

