/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.opplugin.web.hismodel;

import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.domain.model.newhismodel.HisBaseBo;
import kd.hr.hbp.business.domain.model.newhismodel.enable.HisEnableParamBo;
import kd.hr.hbp.business.domain.service.attachment.HisAttachmentService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisDisabledService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.constants.newhismodel.HisFieldNameConstants;
import kd.hr.hbp.common.constants.newhismodel.HisLineTimeTplConstants;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;

@ExcludeFromJacocoGeneratedReport
public class HisConfirmDisableOp
extends HRDataBaseOp
implements HisFieldNameConstants,
HisLineTimeTplConstants {
    private static final Log LOGGER = LogFactory.getLog(HisConfirmDisableOp.class);

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        String hisDisableDate = this.operateOption.getVariableValue("hisDisableDate", "");
        Date disableDate = null;
        try {
            disableDate = HRDateTimeUtils.parseDate((String)hisDisableDate);
        }
        catch (ParseException ex) {
            LOGGER.error((Throwable)ex);
        }
        String selectRowPks = this.operateOption.getVariableValue("selectRowPks");
        String billFormId = this.operateOption.getVariableValue("billFormId");
        Object[] pks = (Object[])SerializationUtils.fromJsonString((String)selectRowPks, Object[].class);
        HRBaseServiceHelper helper = new HRBaseServiceHelper(billFormId);
        DynamicObject[] dys = helper.loadDynamicObjectArray(pks);
        List disableIds = Arrays.stream(dys).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        HisBaseBo hisBo = new HisBaseBo();
        hisBo.setEntityNumber(billFormId);
        hisBo.setBoIdList(disableIds);
        HisEnableParamBo hisEnableParamBo = new HisEnableParamBo();
        hisEnableParamBo.setDisabled(true);
        hisEnableParamBo.setHisBaseBo(hisBo);
        hisEnableParamBo.setEffectDate(disableDate);
        HisDisabledService hisDisabledService = new HisDisabledService();
        hisDisabledService.disableOrEnableBo(hisEnableParamBo);
        Map mapHisAttachmentBos = hisEnableParamBo.getMapHisAttachmentBos();
        if (mapHisAttachmentBos != null) {
            this.operateOption.setVariableValue("opHisAttachments", SerializationUtils.toJsonString((Object)mapHisAttachmentBos));
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        HisAttachmentService.afterOpHandleAttachment((String)this.billEntityType.getName(), (OperateOption)this.operateOption);
    }
}

