/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.opplugin.web.hismodel;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.operate.IOperationResult;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ValidatePriority;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.application.impl.common.DynamicObjectCommonService;
import kd.hr.hbp.business.domain.model.newhismodel.HisBaseBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionReviseParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionReviseReturnDataBo;
import kd.hr.hbp.business.domain.model.newhismodel.enable.HisEnableParamBo;
import kd.hr.hbp.business.domain.repository.HisCommonEntityRepository;
import kd.hr.hbp.business.domain.service.attachment.HisAttachmentService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisCommonService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisDeleteService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisDisabledService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisEffDateCommonService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisValidateService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisVersionChangeService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.hisversion.HisVersionNumberService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.hisversion.HisVersionReviseService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.timezone.HisTimeZoneService;
import kd.hr.hbp.business.domain.util.HisLineOpUtil;
import kd.hr.hbp.business.domain.util.HisModelEditAuditTool;
import kd.hr.hbp.business.domain.util.HisModelImportUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.constants.newhismodel.EventOperateEnums;
import kd.hr.hbp.common.constants.newhismodel.HisFieldNameConstants;
import kd.hr.hbp.common.constants.newhismodel.HisLineTimeTplConstants;
import kd.hr.hbp.common.model.hismodel.HisAttachmentBo;
import kd.hr.hbp.common.model.hismodel.HisModelOperationBo;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRHisEntryObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.hbp.opplugin.web.hismodel.validator.HisDeleteDataBaseValidator;
import kd.hr.hbp.opplugin.web.hismodel.validator.HisLineImportValidator;
import kd.hr.hbp.opplugin.web.hismodel.validator.HisLineTimeTplValidator;
import kd.hr.hbp.opplugin.web.hismodel.validator.HisReviseSaveValidator;
import kd.hr.hbp.opplugin.web.hismodel.validator.HisSaveValidator;

public class HisLineTimeTplOp
extends HRDataBaseOp
implements HisFieldNameConstants,
HisLineTimeTplConstants {
    private static final Log LOGGER = LogFactory.getLog(HisLineTimeTplOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        args.getFieldKeys().clear();
        ArrayList fieldsNameList = Lists.newArrayListWithExpectedSize((int)this.billEntityType.getFields().size());
        this.billEntityType.getAllFields().forEach((propertyName, entityProperty) -> {
            if (!HRStringUtils.equals((String)propertyName, (String)"multilanguagetext") && !propertyName.endsWith("_id")) {
                fieldsNameList.add(propertyName);
            }
        });
        args.getFieldKeys().addAll(fieldsNameList);
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        String extParam = this.getOption().getVariableValue("extParam", "");
        HisLineImportValidator hisLineImportValidator = new HisLineImportValidator(extParam);
        hisLineImportValidator.setValidatePriority(ValidatePriority.First);
        args.addValidator((AbstractValidator)hisLineImportValidator);
        args.addValidator((AbstractValidator)new HisLineTimeTplValidator());
        args.addValidator((AbstractValidator)new HisSaveValidator());
        args.addValidator((AbstractValidator)new HisReviseSaveValidator());
        if (this.billEntityType instanceof BasedataEntityType) {
            String entityKey = this.billEntityType.getName();
            HisDeleteDataBaseValidator hisDeleteDataBaseValidator = new HisDeleteDataBaseValidator();
            hisDeleteDataBaseValidator.setValidatePriority(ValidatePriority.Last);
            hisDeleteDataBaseValidator.setOption(this.getOption());
            hisDeleteDataBaseValidator.setEntityType((BasedataEntityType)this.billEntityType);
            hisDeleteDataBaseValidator.setEntityKey(entityKey);
            args.addValidator((AbstractValidator)hisDeleteDataBaseValidator);
        }
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs args) {
        super.beforeExecuteOperationTransaction(args);
        DynamicObject[] dataCol = args.getDataEntities();
        if (this.getOption().containsVariable("importtype")) {
            List pks = Arrays.stream(args.getDataEntities()).map(data -> data.get("id")).collect(Collectors.toList());
            this.getOption().setVariableValue("hisImportPKs", SerializationUtils.toJsonString(pks));
        }
        String fromFormEdit = this.getOption().getVariableValue("opFromFormEdit", "false");
        switch (args.getOperationKey()) {
            case "save": 
            case "confirmchange": 
            case "confirmchangenoaudit": {
                this.clearPkForUpdateImport(dataCol);
                this.setEnableForHis(dataCol);
                if (!HRStringUtils.equals((String)fromFormEdit, (String)"false")) {
                    DynamicObject dy2 = dataCol[0];
                    if (dy2.getPkValue() == null || dy2.getLong("id") == 0L) {
                        dy2.set("id", (Object)ORM.create().genLongId(dy2.getDataEntityType().getName()));
                    }
                    HisAttachmentService.saveHisLineAttachmentsForOp((DynamicObject)dy2, (OperateOption)this.operateOption);
                    break;
                }
                HisAttachmentService.getAttachmentsInfo((DynamicObject[])dataCol, (OperateOption)this.operateOption);
                break;
            }
            case "enable": {
                if (!args.getDataEntities()[0].getDataEntityType().getProperties().containsKey((Object)"enable")) break;
                Set enablingIds = Arrays.stream(args.getDataEntities()).filter(dy -> HRStringUtils.equals((String)dy.getString("enable"), (String)"10")).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
                this.getOption().setVariableValue("enablingIds", SerializationUtils.toJsonString(enablingIds));
                break;
            }
        }
    }

    private void setEnableForHis(DynamicObject[] dataCol) {
        String enable = this.operateOption.getVariableValue("hisPageEnable", null);
        if (HRStringUtils.isNotEmpty((String)enable)) {
            Arrays.stream(dataCol).forEach(data -> data.set("enable", (Object)enable));
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        DynamicObject[] dataCol = args.getDataEntities();
        String fromFormEdit = this.getOption().getVariableValue("opFromFormEdit", "false");
        switch (args.getOperationKey()) {
            case "save": {
                String fromPage;
                if (this.getOption().containsVariable("fromPage") && "revise".equals(fromPage = this.getOption().getVariableValue("fromPage"))) {
                    this.doReviseOperate(dataCol);
                    return;
                }
                String operateSrc = this.operateOption.getVariableValue("OPERATE_SRC", null);
                if (HRStringUtils.equals((String)operateSrc, (String)"INIT")) break;
                long startTime = System.currentTimeMillis();
                this.save(args, dataCol);
                LOGGER.info("hisImport_HisSaveOp, time: {}, dataCount: {}", (Object)(System.currentTimeMillis() - startTime), (Object)dataCol.length);
                break;
            }
            case "audit": {
                HisAttachmentService.getAttachmentsInfo((DynamicObject[])dataCol, (OperateOption)this.operateOption);
                dataCol = this.reBuildDynamicObjects(fromFormEdit, args, dataCol);
                this.confirmChangeForAudit(args, dataCol);
                break;
            }
            case "confirmchange": 
            case "confirmchangenoaudit": {
                dataCol = this.reBuildDynamicObjects(fromFormEdit, args, dataCol);
                this.doConfirmChange(args, dataCol);
                break;
            }
            case "his_delete": {
                this.deleteData(dataCol);
                break;
            }
            case "delete": {
                this.deleteAllHisData(args, dataCol);
                break;
            }
            case "submit": {
                if (dataCol[0].getDataEntityState().getFromDatabase()) {
                    String objFromList = this.getOption().getVariableValue("hisFromListSubmit", null);
                    if (!"true".equals(objFromList)) {
                        HisTimeZoneService.getInstance().initPlanBsedByArray(dataCol);
                    }
                    return;
                }
                this.doSaveHis(dataCol);
                break;
            }
            case "his_disable": {
                this.doDisable(args);
                break;
            }
            case "enable": {
                try {
                    boolean customDefineInvoke;
                    HisAttachmentService.getAttachmentsInfo((DynamicObject[])dataCol, (OperateOption)this.operateOption);
                    dataCol = this.reBuildDynamicObjects(fromFormEdit, args, dataCol);
                    boolean bl = customDefineInvoke = this.getOption().containsVariable("HisModelBusinessClassName") && this.getOption().containsVariable("HisModelBusinessMethodName");
                    if (customDefineInvoke) {
                        args.setDataEntities(dataCol);
                        this.callBusinessMethod(args, dataCol);
                    }
                    this.doEnable(args, dataCol);
                    break;
                }
                catch (Exception ex) {
                    LOGGER.info("enable bo fail! error message.", (Object)ex.getMessage());
                    throw new KDBizException((Throwable)ex, new ErrorCode("500", String.format(Locale.ROOT, ResManager.loadKDString((String)"\u542f\u7528\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"HisLineTimeTplOp_05", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]), ex.getMessage())), new Object[0]);
                }
            }
        }
    }

    private void doReviseOperate(DynamicObject[] dataEntities) {
        String attachments;
        String entityNumber = dataEntities[0].getDataEntityType().getName();
        HisValidateService.getInstance().saveValidate(dataEntities);
        Map<Long, List<HisAttachmentBo>> preAttachmentInfoMap = null;
        if (this.getOption().containsVariable("preAttachments") && !"null".equals(attachments = this.getOption().getVariableValue("preAttachments"))) {
            List attachmentMapList = SerializationUtils.fromJsonStringToList((String)attachments, Map.class);
            Map hisAttachBoMap = HisAttachmentService.transAttachmentsInfo((List)attachmentMapList, (String)entityNumber);
            preAttachmentInfoMap = hisAttachBoMap.values().stream().collect(Collectors.groupingBy(HisAttachmentBo::getId));
        }
        List attachMapList = HisAttachmentService.generateAttachmentMap((DynamicObject[])dataEntities);
        Map hisAttachBoMap = HisAttachmentService.transAttachmentsInfo((List)attachMapList, (String)entityNumber);
        Map<Long, List<HisAttachmentBo>> boMap = hisAttachBoMap.values().stream().collect(Collectors.groupingBy(HisAttachmentBo::getId));
        HisVersionReviseParamBo bo = new HisVersionReviseParamBo();
        bo.setReviseDys(dataEntities);
        bo.setEntityNumber(entityNumber);
        bo.setMapHisAttachmentBos(boMap);
        bo.setPreHisAttachmentBos(preAttachmentInfoMap);
        bo.setPersonalDataSyn(true);
        HisVersionReviseService reviseService = HisVersionReviseService.getInstance();
        this.invokeReviseServise(bo, entityNumber, reviseService);
    }

    private void invokeReviseServise(HisVersionReviseParamBo bo, String entityNumber, HisVersionReviseService service) {
        HisVersionReviseReturnDataBo returnDataBo = service.reviseVersion(bo);
        Map attachmentMap = returnDataBo.getAttachmentMap();
        String attachmentInfo = SerializationUtils.toJsonString((Object)attachmentMap);
        this.operateOption.setVariableValue("revise_attachmentInfo", attachmentInfo);
        this.operateOption.setVariableValue("entityNumber", entityNumber);
        DynamicObject[] returnData = returnDataBo.getReturnData();
        if (returnData != null && returnData.length > 0) {
            HRBaseServiceHelper helper = new HRBaseServiceHelper(entityNumber);
            helper.save(returnData);
        }
    }

    private void callBusinessMethod(BeginOperationTransactionArgs args, DynamicObject[] dataCol) {
        String className = this.getOption().getVariableValue("HisModelBusinessClassName");
        String methodName = this.getOption().getVariableValue("HisModelBusinessMethodName");
        String customParamStr = this.getOption().getVariableValue("HisModelBusinessCustomParams", "");
        try {
            Class<?> aClass = Class.forName(className);
            Object instance = aClass.newInstance();
            HisModelOperationBo bo = new HisModelOperationBo();
            bo.setOperationKey(args.getOperationKey());
            bo.setDataEntities(dataCol);
            if (HRStringUtils.isNotEmpty((String)customParamStr)) {
                Map customParams = (Map)SerializationUtils.fromJsonString((String)customParamStr, Map.class);
                bo.setCustomParams(customParams);
            }
            Method method = aClass.getDeclaredMethod(methodName, HisModelOperationBo.class);
            method.invoke(instance, bo);
            args.setDataEntities(bo.getDataEntities());
        }
        catch (Exception ex) {
            LOGGER.error((Throwable)ex);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        super.afterExecuteOperationTransaction(args);
        HisAttachmentService.afterOpHandleAttachment((String)this.billEntityType.getName(), (OperateOption)this.operateOption);
        HisAttachmentService.uploadReviseAttachment((OperateOption)this.operateOption);
    }

    public void onReturnOperation(ReturnOperationArgs args) {
        super.onReturnOperation(args);
        IOperationResult operationResult = args.getOperationResult();
        if (!this.getOption().containsVariable("importtype")) {
            return;
        }
        String importType = this.getOption().getVariableValue("importtype");
        if (!HRStringUtils.equals((String)importType, (String)"new") && operationResult.getSuccessPkIds() != null && !operationResult.getSuccessPkIds().isEmpty()) {
            String currentPkStr = this.getOption().getVariableValue("hisImportPKs", null);
            if (HRStringUtils.isEmpty((String)currentPkStr)) {
                return;
            }
            List currentPks = (List)SerializationUtils.fromJsonString((String)currentPkStr, List.class);
            operationResult.getSuccessPkIds().addAll(currentPks);
        }
    }

    private void clearPkForUpdateImport(DynamicObject[] dataCol) {
        if (!this.getOption().containsVariable("importtype")) {
            return;
        }
        String importType = this.getOption().getVariableValue("importtype");
        if (HRStringUtils.equals((String)importType, (String)"new")) {
            return;
        }
        for (DynamicObject data : dataCol) {
            if (data.getBoolean("iscurrentversion")) continue;
            data.set("id", (Object)0L);
        }
    }

    private DynamicObject[] reBuildDynamicObjects(String fromFormEdit, BeginOperationTransactionArgs args, DynamicObject[] dataCol) {
        HRBaseServiceHelper helper;
        if (HRStringUtils.equals((String)fromFormEdit, (String)"false") && !this.getOption().containsVariable("importtype") && (dataCol = (helper = new HRBaseServiceHelper(dataCol[0].getDataEntityType().getName())).loadDynamicObjectArray((Object[])Arrays.stream(dataCol).map(entity -> entity.get("id")).toArray(Object[]::new))).length == 0) {
            dataCol = args.getDataEntities();
        }
        if (this.getOption().containsVariable("importtype")) {
            HisTimeZoneService.getInstance().initPlanBsedByArray(dataCol);
        }
        return dataCol;
    }

    private void save(BeginOperationTransactionArgs args, DynamicObject[] dataCol) {
        if (HisModelEditAuditTool.getNeedAuditForOp((IDataEntityType)dataCol[0].getDataEntityType())) {
            this.doSaveHis(dataCol);
        } else {
            this.doSaveHisEffect(args, dataCol);
        }
    }

    private void doSaveHis(DynamicObject[] dataCol) {
        HisVersionParamBo hisVersionParamBo = new HisVersionParamBo();
        if (this.getOption().containsVariable("importtype")) {
            hisVersionParamBo.setNeedProcessAttachment(false);
        }
        hisVersionParamBo.setEntityNumber(dataCol[0].getDataEntityType().getName());
        hisVersionParamBo.setHisDyns(dataCol);
        hisVersionParamBo.setNeedValidateDate(false);
        try {
            long startTime = System.currentTimeMillis();
            HisVersionChangeService.getInstance().saveTempVersion(hisVersionParamBo);
            LOGGER.info("hisImport_HisSaveOp_saveTempVersion, time: {}, dataCount: {}", (Object)(System.currentTimeMillis() - startTime), (Object)dataCol.length);
        }
        catch (Exception ex) {
            LOGGER.error("save his error:", (Throwable)ex);
            throw new KDBizException((Throwable)ex, new ErrorCode("500", String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a%s", (String)"HisLineTimeTplOp_01", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]), ex.getMessage())), new Object[0]);
        }
    }

    private void doSaveHisEffect(BeginOperationTransactionArgs args, DynamicObject[] dataCol) {
        ArrayList notEnablingDys = Lists.newArrayListWithCapacity((int)10);
        ArrayList enablingDys = Lists.newArrayListWithCapacity((int)10);
        this.apartEnablingData(dataCol, notEnablingDys, enablingDys);
        if (notEnablingDys.size() > 0) {
            try {
                dataCol = this.callEffectService(notEnablingDys.toArray(new DynamicObject[0]));
            }
            catch (Exception ex) {
                LOGGER.error("save for effect error:", (Throwable)ex);
                throw new KDBizException((Throwable)ex, new ErrorCode("500", String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a%s", (String)"HisLineTimeTplOp_01", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]), ex.getMessage())), new Object[0]);
            }
        }
        if (HRStringUtils.equals((String)args.getOperationKey(), (String)"enable")) {
            Set enablingIds = Arrays.stream(dataCol).map(data -> data.getLong("id")).collect(Collectors.toSet());
            Object[] notEnablings = (DynamicObject[])Arrays.stream(dataCol).filter(data -> !enablingIds.contains(data.getLong("id"))).toArray(DynamicObject[]::new);
            DynamicObject[] allDataCol = (DynamicObject[])ArrayUtils.addAll((Object[])notEnablings, (Object[])dataCol);
            if (dataCol != null && dataCol.length != 0) {
                DynamicObject[] dyOriginals;
                boolean isCopyOk;
                DynamicObject[] isCurrentDataCol = (DynamicObject[])Arrays.stream(allDataCol).filter(data -> data.getBoolean("iscurrentversion")).toArray(DynamicObject[]::new);
                DynamicObject[] isNotCurrentDataCol = (DynamicObject[])Arrays.stream(allDataCol).filter(data -> !data.getBoolean("iscurrentversion")).toArray(DynamicObject[]::new);
                String entityNum = dataCol[0].getDataEntityType().getName();
                HRBaseServiceHelper helper = new HRBaseServiceHelper(entityNum);
                if (isNotCurrentDataCol != null && isNotCurrentDataCol.length > 0) {
                    helper.save(isNotCurrentDataCol);
                }
                if (isCurrentDataCol != null && isCurrentDataCol.length > 0 && !(isCopyOk = this.copyFirstCurrentVersion(dyOriginals = args.getDataEntities(), isCurrentDataCol))) {
                    args.setDataEntities(isCurrentDataCol);
                }
            }
            return;
        }
        if (notEnablingDys.size() > 0 && enablingDys.size() > 0) {
            DynamicObject[] allDataCol = (DynamicObject[])ArrayUtils.addAll((Object[])enablingDys.toArray(new DynamicObject[0]), (Object[])dataCol);
            args.setDataEntities(allDataCol);
        } else {
            if (enablingDys.size() > 0) {
                HRHisEntryObjectUtils.initEntryBoId((DynamicObject[])enablingDys.toArray(new DynamicObject[enablingDys.size()]), (String)((DynamicObject)enablingDys.get(0)).getDataEntityType().getName());
            }
            if (dataCol.length > 0) {
                HisTimeZoneService.getInstance().initPlanBsedByArray(dataCol);
                args.setDataEntities(dataCol);
            }
        }
    }

    private boolean copyFirstCurrentVersion(DynamicObject[] dyOriginals, DynamicObject[] isCurrentDataCol) {
        if (dyOriginals == null || dyOriginals.length == 0 || isCurrentDataCol == null || isCurrentDataCol.length == 0) {
            return false;
        }
        HashMap mapIsCurrentDataCol = Maps.newHashMapWithExpectedSize((int)isCurrentDataCol.length);
        for (DynamicObject dynamicObject : isCurrentDataCol) {
            Long id = dynamicObject.getLong("id");
            if (id == null || id == 0L) {
                return false;
            }
            mapIsCurrentDataCol.put(id, dynamicObject);
        }
        Date dateNow = new Date();
        for (DynamicObject dyOriginal : dyOriginals) {
            Long id = dyOriginal.getLong("id");
            if (id == null || id == 0L) {
                return false;
            }
            DynamicObject currentDataCol = (DynamicObject)mapIsCurrentDataCol.get(id);
            if (currentDataCol == null) continue;
            this.copyFirstCurrentVersion(dyOriginal, currentDataCol, dateNow);
            DynamicObjectCommonService.getInstance().setSimpleModifyInfo(dyOriginal);
        }
        return true;
    }

    public void copyFirstCurrentVersion(DynamicObject dynamicObjectCurrent, DynamicObject currentDataCol, Date dateNow) {
        dynamicObjectCurrent.set("iscurrentversion", (Object)Character.valueOf('1'));
        dynamicObjectCurrent.set("sourcevid", (Object)currentDataCol.getLong("sourcevid"));
        dynamicObjectCurrent.set("firstbsed", (Object)currentDataCol.getDate("bsed"));
        boolean hasPlanBsedField = dynamicObjectCurrent.getDynamicObjectType().getProperties().containsKey((Object)"changebsed");
        if (hasPlanBsedField) {
            dynamicObjectCurrent.set("changebsed", (Object)currentDataCol.getDate("changebsed"));
        }
        DynamicObjectCommonService.getInstance().setSimpleNewInfo(dynamicObjectCurrent);
        DynamicObjectCommonService.getInstance().setMastId(dynamicObjectCurrent);
        String dataStatus = currentDataCol.getString("datastatus");
        dynamicObjectCurrent.set("datastatus", (Object)dataStatus);
        if (EnumHisDataVersionStatus.EFFECTING.getStatus().equals(dataStatus)) {
            dynamicObjectCurrent.set("bred", (Object)dateNow);
            currentDataCol.set("bred", (Object)dateNow);
        }
    }

    private void apartEnablingData(DynamicObject[] dataCol, List<DynamicObject> notEnablingDys, List<DynamicObject> enablingDys) {
        if (dataCol.length == 0) {
            return;
        }
        boolean hasEnable = HisModelImportUtil.hasEnable((DataEntityPropertyCollection)dataCol[0].getDataEntityType().getProperties());
        for (DynamicObject data : dataCol) {
            if (hasEnable) {
                if (HRStringUtils.equals((String)data.getString("enable"), (String)"10")) {
                    enablingDys.add(data);
                    continue;
                }
                notEnablingDys.add(data);
                continue;
            }
            notEnablingDys.add(data);
        }
        if (enablingDys.size() > 0) {
            this.setHisFieldsForEnablingData(enablingDys.toArray(new DynamicObject[0]));
        }
    }

    private void setHisFieldsForEnablingData(DynamicObject[] enablingDys) {
        long modifyDyCount = Arrays.stream(enablingDys).filter(dy -> !dy.getDataEntityState().getFromDatabase()).count();
        long[] ids = ORM.create().genLongIds(enablingDys[0].getDataEntityType().getName(), (int)modifyDyCount);
        Date effDate = HisEffDateCommonService.getInstance().getDate2999(null);
        int index = 0;
        for (DynamicObject enablingDy : enablingDys) {
            enablingDy.set("iscurrentversion", (Object)Character.valueOf('1'));
            if (enablingDy.get("bsled") == null) {
                enablingDy.set("bsled", (Object)effDate);
            }
            enablingDy.set("firstbsed", enablingDy.get("bsed"));
            if (enablingDy.getLong("id") == 0L) {
                enablingDy.set("id", (Object)ids[index++]);
            }
            enablingDy.set("boid", enablingDy.get("id"));
            enablingDy.set("datastatus", (Object)EnumHisDataVersionStatus.TEMP.getStatus());
        }
    }

    private void confirmChangeForAudit(BeginOperationTransactionArgs args, DynamicObject[] dataCol) {
        ArrayList notEnablingDys = Lists.newArrayListWithCapacity((int)10);
        ArrayList enablingDys = Lists.newArrayListWithCapacity((int)10);
        this.apartEnablingData(dataCol, notEnablingDys, enablingDys);
        if (notEnablingDys.size() > 0) {
            Set currentIds = Arrays.stream(dataCol).map(data -> data.get("id")).collect(Collectors.toSet());
            dataCol = this.audit(args, dataCol);
            DynamicObject[] hisDataCol = (DynamicObject[])Arrays.stream(dataCol).filter(data -> !currentIds.contains(data.get("id"))).toArray(DynamicObject[]::new);
            String entityNum = dataCol[0].getDataEntityType().getName();
            HRBaseServiceHelper helper = new HRBaseServiceHelper(entityNum);
            helper.save(hisDataCol);
            Object[] currentDataCol = (DynamicObject[])Arrays.stream(dataCol).filter(data -> currentIds.contains(data.get("id"))).toArray(DynamicObject[]::new);
            if (enablingDys.size() > 0) {
                DynamicObject[] allDataCol = (DynamicObject[])ArrayUtils.addAll((Object[])enablingDys.toArray(new DynamicObject[0]), (Object[])currentDataCol);
                args.setDataEntities(allDataCol);
            } else if (dataCol.length > 0) {
                args.setDataEntities((DynamicObject[])currentDataCol);
            }
        }
    }

    private void doConfirmChange(BeginOperationTransactionArgs args, DynamicObject[] dataCol) {
        String saveHisFlag = this.getOption().getVariableValue("saveHisFlag", "true");
        if (HRStringUtils.equals((String)saveHisFlag, (String)"false")) {
            return;
        }
        String entityNum = dataCol[0].getDataEntityType().getName();
        dataCol = this.confirmChange(args, dataCol);
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityNum);
        try {
            Object[] pkIds = helper.save(dataCol);
            if (this.getOption().containsVariable("importtype")) {
                this.getOption().setVariableValue("hisChangeSuccessPks", SerializationUtils.toJsonString((Object)pkIds));
            }
        }
        catch (Exception ex) {
            LOGGER.error("confirm change error:", (Throwable)ex);
            throw new KDBizException((Throwable)ex, new ErrorCode("500", String.format(Locale.ROOT, ResManager.loadKDString((String)"\u786e\u8ba4\u53d8\u66f4\u5931\u8d25\uff1a%s", (String)"HisLineTimeTplOp_02", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]), ex.getMessage())), new Object[0]);
        }
    }

    private DynamicObject[] confirmChange(BeginOperationTransactionArgs args, DynamicObject[] dataCol) {
        try {
            dataCol = this.callEffectService(dataCol);
        }
        catch (Exception ex) {
            LOGGER.error("confirm change error:", (Throwable)ex);
            args.setCancelOperation(true);
            throw new KDBizException((Throwable)ex, new ErrorCode("500", String.format(Locale.ROOT, ResManager.loadKDString((String)"\u786e\u8ba4\u53d8\u66f4\u5931\u8d25\uff1a%s", (String)"HisLineTimeTplOp_02", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]), ex.getMessage())), new Object[0]);
        }
        return dataCol;
    }

    private DynamicObject[] audit(BeginOperationTransactionArgs args, DynamicObject[] dataCol) {
        for (DynamicObject dynamicObject : dataCol) {
            dynamicObject.set("status", (Object)"C");
        }
        try {
            dataCol = this.callEffectService(dataCol);
        }
        catch (Exception ex) {
            LOGGER.error("audit error:", (Throwable)ex);
            args.setCancelOperation(true);
            throw new KDBizException((Throwable)ex, new ErrorCode("500", String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5ba1\u6838\u5931\u8d25\uff1a%s", (String)"HisLineTimeTplOp_03", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]), ex.getMessage())), new Object[0]);
        }
        return dataCol;
    }

    private DynamicObject[] callEffectService(DynamicObject[] dataCol) {
        HisVersionParamBo hisVersionParamBo = HisLineOpUtil.saveEffect((DynamicObject[])dataCol, (OperateOption)this.operateOption);
        if (this.getOption().containsVariable("importtype")) {
            hisVersionParamBo.setNeedProcessAttachment(false);
        }
        boolean isImport = this.getOption().containsVariable("importtype");
        HisLineOpUtil.handleImportEventBefore((boolean)isImport, (HisVersionParamBo)hisVersionParamBo);
        long startTime = System.currentTimeMillis();
        dataCol = HisVersionChangeService.getInstance().saveEffVersion(hisVersionParamBo);
        LOGGER.info("hisImport_HisSaveOp_callEffectService, time: {}, dataCount: {}", (Object)(System.currentTimeMillis() - startTime), (Object)dataCol.length);
        HisLineOpUtil.handleImportEventAfter((boolean)isImport, (HisVersionParamBo)hisVersionParamBo);
        startTime = System.currentTimeMillis();
        String entityNum = dataCol[0].getDataEntityType().getName();
        HisVersionNumberService.getInstance().calcVersionNumber(entityNum, dataCol);
        LOGGER.info("hisImport_HisSaveOp_calcVersionNumber, time: {}, dataCount: {}", (Object)(System.currentTimeMillis() - startTime), (Object)dataCol.length);
        Map mapHisAttachmentBos = hisVersionParamBo.getMapHisAttachmentBos();
        if (mapHisAttachmentBos != null) {
            this.operateOption.setVariableValue("opHisAttachments", SerializationUtils.toJsonString((Object)mapHisAttachmentBos));
        }
        return dataCol;
    }

    private void deleteData(DynamicObject[] dataCol) {
        String entityNum = dataCol[0].getDataEntityType().getName();
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityNum);
        helper.delete(Arrays.stream(dataCol).map(data -> data.get("id")).toArray());
        Object boId = dataCol[0].get("boid");
        int count = helper.count(entityNum, new QFilter[]{new QFilter("boid", "=", boId), new QFilter("datastatus", "=", (Object)EventOperateEnums.CHANGE_BEFORE_STATUS_TEMP.getValue())});
        if (count == 0) {
            DynamicObject currentData = helper.queryOne("id, ismodify", new QFilter[]{new QFilter("id", "=", boId)});
            currentData.set("ismodify", (Object)"0");
            helper.saveOne(currentData);
        }
    }

    private void deleteAllHisData(BeginOperationTransactionArgs args, DynamicObject[] dataCol) {
        QFilter[] qFilter;
        if (dataCol == null || dataCol.length == 0) {
            return;
        }
        String entityNum = dataCol[0].getDataEntityType().getName();
        HisBaseBo hisBaseBo = new HisBaseBo();
        String entityNumber = dataCol[0].getDataEntityType().getName();
        hisBaseBo.setEntityNumber(entityNumber);
        List boIds = Arrays.stream(dataCol).map(data -> data.getLong("boid")).collect(Collectors.toList());
        hisBaseBo.setBoIdList(boIds);
        HisDeleteService.getInstance().deleteBoEventData(hisBaseBo);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
        if (HisCommonService.getInstance().isBuBaseData(entityNum)) {
            qFilter = new QFilter[]{new QFilter("boid", "in", boIds)};
            DynamicObject[] dynamicObjects = serviceHelper.loadDynamicObjectArray(qFilter);
            ArrayList<DynamicObject> currentDataColList = new ArrayList<DynamicObject>(8);
            for (DynamicObject dynamicObject : dynamicObjects) {
                boolean isCurrentVersion = dynamicObject.getBoolean("iscurrentversion");
                if (!isCurrentVersion) continue;
                currentDataColList.add(dynamicObject);
            }
            args.setDataEntities(currentDataColList.toArray(new DynamicObject[0]));
        } else {
            qFilter = new QFilter[]{new QFilter("id", "in", boIds)};
            DynamicObject[] currentDataCol = serviceHelper.loadDynamicObjectArray(qFilter);
            args.setDataEntities(currentDataCol);
        }
        QFilter[] qFilterDeleteVersion = new QFilter[]{new QFilter("boid", "in", boIds), new QFilter("iscurrentversion", "=", (Object)"0")};
        serviceHelper.deleteByFilter(qFilterDeleteVersion);
    }

    private void doDisable(BeginOperationTransactionArgs args) {
        DynamicObject[] dataCol = args.getDataEntities();
        List ids = Arrays.stream(dataCol).map(data -> data.getLong("boid")).collect(Collectors.toList());
        String hisDisableDate = this.operateOption.getVariableValue("hisDisableDate", null);
        HashSet notConfirmIds = Sets.newHashSetWithExpectedSize((int)16);
        Date disableDate = null;
        HRBaseServiceHelper helper = new HRBaseServiceHelper(dataCol[0].getDataEntityType().getName());
        if (HRStringUtils.isNotEmpty((String)hisDisableDate)) {
            try {
                disableDate = HRDateTimeUtils.parseDate((String)hisDisableDate);
            }
            catch (ParseException ex) {
                LOGGER.error((Throwable)ex);
            }
            notConfirmIds.addAll(HisCommonEntityRepository.getAllToBeEffectBoIdByBoId((HRBaseServiceHelper)helper, ids, (Date)disableDate));
        } else {
            notConfirmIds.addAll(HisCommonEntityRepository.getAllToBeEffectBoIdByBoId((HRBaseServiceHelper)helper, (DynamicObject[])dataCol));
        }
        if (ids.size() > notConfirmIds.size()) {
            HisBaseBo hisBo = new HisBaseBo();
            hisBo.setEntityNumber(dataCol[0].getDataEntityType().getName());
            List confirmIds = ids.stream().filter(id -> !notConfirmIds.contains(id)).collect(Collectors.toList());
            hisBo.setBoIdList(confirmIds);
            HisEnableParamBo hisEnableParamBo = new HisEnableParamBo();
            hisEnableParamBo.setDisabled(true);
            hisEnableParamBo.setHisBaseBo(hisBo);
            hisEnableParamBo.setEffectDate(disableDate);
            HisDisabledService hisDisabledService = new HisDisabledService();
            try {
                hisDisabledService.disableOrEnableBo(hisEnableParamBo);
            }
            catch (Exception ex) {
                throw new KDBizException((Throwable)ex, new ErrorCode("500", String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7981\u7528\u5931\u8d25\uff1a%s", (String)"HisLineTimeTplOp_04", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]), ex.getMessage())), new Object[0]);
            }
            this.getAttachmentsFromEnableOrDisable(hisEnableParamBo);
        }
        args.setDataEntities((DynamicObject[])Arrays.stream(dataCol).filter(data -> !notConfirmIds.contains(data.getLong("id"))).toArray(DynamicObject[]::new));
    }

    private void doEnable(BeginOperationTransactionArgs args, DynamicObject[] dataCol) {
        Arrays.stream(dataCol).forEach(data -> data.set("enable", (Object)"1"));
        String enablingIdStr = this.getOption().getVariableValue("enablingIds", null);
        ArrayList enablingDys = Lists.newArrayListWithCapacity((int)10);
        ArrayList notEnablingDys = Lists.newArrayListWithCapacity((int)10);
        if (HRStringUtils.isNotEmpty((String)enablingIdStr)) {
            Set enablingIds = (Set)SerializationUtils.fromJsonString((String)enablingIdStr, Set.class);
            for (DynamicObject data2 : dataCol) {
                long id = data2.getLong("id");
                if (enablingIds.contains(id)) {
                    enablingDys.add(data2);
                    continue;
                }
                notEnablingDys.add(data2);
            }
        } else {
            notEnablingDys.addAll(Arrays.asList(dataCol));
        }
        if (notEnablingDys.size() > 0) {
            HisBaseBo hisBo = new HisBaseBo();
            hisBo.setEntityNumber(dataCol[0].getDataEntityType().getName());
            hisBo.setDyCurrents(notEnablingDys.toArray(new DynamicObject[0]));
            HisEnableParamBo hisEnableParamBo = new HisEnableParamBo();
            hisEnableParamBo.setDisabled(false);
            hisEnableParamBo.setHisBaseBo(hisBo);
            HisDisabledService hisDisabledService = new HisDisabledService();
            hisDisabledService.disableOrEnableBo(hisEnableParamBo);
            this.getAttachmentsFromEnableOrDisable(hisEnableParamBo);
        }
        if (enablingDys.size() > 0) {
            this.doSaveHisEffect(args, (DynamicObject[])enablingDys.stream().filter(dy -> HRStringUtils.equals((String)dy.getString("status"), (String)"C")).toArray(DynamicObject[]::new));
        }
    }

    private void getAttachmentsFromEnableOrDisable(HisEnableParamBo hisEnableParamBo) {
        Map mapHisAttachmentBos = hisEnableParamBo.getMapHisAttachmentBos();
        if (mapHisAttachmentBos != null) {
            this.operateOption.setVariableValue("opHisAttachments", SerializationUtils.toJsonString((Object)mapHisAttachmentBos));
        }
    }
}

