/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.opplugin.web.hismodel.bd;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisEffDateCommonService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisVersionChangeService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.hisversion.HisVersionNumberService;
import kd.hr.hbp.business.domain.util.HisLineOpUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.constants.newhismodel.HisFieldNameConstants;
import kd.hr.hbp.common.constants.newhismodel.HisLineTimeTplConstants;
import kd.hr.hbp.common.model.hismodel.HisAttachmentBo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.hbp.opplugin.web.hismodel.validator.HisLineTimeBdTplValidator;

public class HisLineTimeBdTplOp
extends HRDataBaseOp
implements HisFieldNameConstants,
HisLineTimeTplConstants {
    private static final Log LOGGER = LogFactory.getLog(HisLineTimeBdTplOp.class);

    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        args.addValidator((AbstractValidator)new HisLineTimeBdTplValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs args) {
        super.beforeExecuteOperationTransaction(args);
        if (!HRStringUtils.equals((String)args.getOperationKey(), (String)"save")) {
            return;
        }
        if (args.isCancel()) {
            return;
        }
        String isPersonalizeData = this.getOption().getVariableValue("ispersonalizedata", null);
        if (HRStringUtils.equals((String)isPersonalizeData, (String)"0")) {
            return;
        }
        DynamicObject[] dataEntities = args.getDataEntities();
        HashSet personDataIds = Sets.newHashSetWithExpectedSize((int)dataEntities.length);
        for (DynamicObject data : dataEntities) {
            boolean isPersonal;
            Long useOrgId = BaseDataCommonService.getLongPropertyFromDynamicObject((DynamicObject)data, (String)"useorg");
            Long createOrgId = BaseDataCommonService.getLongPropertyFromDynamicObject((DynamicObject)data, (String)"createorg");
            boolean bl = isPersonal = data.getLong("masterid") != 0L && data.getPkValue() != null && (Long)data.getPkValue() != 0L && !useOrgId.equals(0L) && !createOrgId.equals(useOrgId);
            if (!isPersonal) continue;
            personDataIds.add(data.getPkValue());
        }
        if (CollectionUtils.isEmpty((Collection)personDataIds)) {
            LOGGER.info("personDataIds: is null ");
            return;
        }
        Date today = HisEffDateCommonService.getInstance().getNowMaskDate(this.billEntityType.getName());
        Date endDate = HisEffDateCommonService.getInstance().getDate2999(null);
        HRBaseServiceHelper helper = new HRBaseServiceHelper(this.billEntityType.getName());
        LOGGER.info("personDataIds:{} ", (Object)personDataIds);
        DynamicObject[] dataCol = helper.loadDynamicObjectArray(personDataIds.toArray(new Object[0]));
        LOGGER.info("dataCol.length:{}", (Object)dataCol.length);
        DynamicObjectCollection copyDys = new DynamicObjectCollection();
        Set ignoreFields = Stream.of("datastatus").collect(Collectors.toSet());
        for (DynamicObject dataEntity : dataCol) {
            dataEntity.set("boid", dataEntity.getPkValue());
            if (HRStringUtils.equals((String)EnumHisDataVersionStatus.EFFECTING.getStatus(), (String)dataEntity.getString("datastatus"))) {
                dataEntity.set("bsed", (Object)today);
                dataEntity.set("firstbsed", (Object)today);
                dataEntity.set("bsled", (Object)endDate);
                dataEntity.set("ismodify", (Object)"0");
            } else if (HRStringUtils.equals((String)EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus(), (String)dataEntity.getString("datastatus"))) {
                dataEntity.set("bsed", dataEntity.get("firstbsed"));
                dataEntity.set("firstbsed", dataEntity.get("firstbsed"));
                dataEntity.set("bsled", (Object)endDate);
                dataEntity.set("ismodify", (Object)"0");
            }
            DynamicObject copyDy = HisLineOpUtil.copyTempVersionDy((String)this.billEntityType.getName(), (DynamicObject)dataEntity, ignoreFields);
            copyDy.set("boid", dataEntity.getPkValue());
            copyDy.set("sourcevid", null);
            copyDy.set("versionsource", (Object)"1");
            copyDys.add((Object)copyDy);
        }
        helper.save(dataCol);
        LOGGER.info("copyDys.size:{}", (Object)copyDys.size());
        DynamicObject[] copyDataCol = (DynamicObject[])copyDys.toArray((Object[])new DynamicObject[0]);
        HisVersionParamBo hisVersionParamBo = HisLineOpUtil.saveEffect((DynamicObject[])copyDataCol, (OperateOption)this.operateOption);
        boolean isImport = this.getOption().containsVariable("importtype");
        if (isImport) {
            hisVersionParamBo.setNeedProcessAttachment(false);
        }
        this.handleAttachments(hisVersionParamBo);
        HisLineOpUtil.handleImportEventBefore((boolean)isImport, (HisVersionParamBo)hisVersionParamBo);
        copyDataCol = HisVersionChangeService.getInstance().saveEffVersion(hisVersionParamBo);
        HisLineOpUtil.handleImportEventAfter((boolean)isImport, (HisVersionParamBo)hisVersionParamBo);
        HisVersionNumberService.getInstance().calcVersionNumber(this.billEntityType.getName(), copyDataCol);
        helper.save(copyDataCol);
    }

    private void handleAttachments(HisVersionParamBo hisVersionParamBo) {
        Map attachmentBoMap = hisVersionParamBo.getMapHisAttachmentBos();
        if (attachmentBoMap == null || attachmentBoMap.isEmpty()) {
            return;
        }
        HashMap newAttachmentBoMap = Maps.newHashMapWithExpectedSize((int)16);
        long versionPk = hisVersionParamBo.getHisDyns()[0].getLong("id");
        attachmentBoMap.forEach((id, bos) -> {
            for (HisAttachmentBo bo : bos) {
                bo.setId(Long.valueOf(versionPk));
                for (Map attachment : bo.getAttachments()) {
                    attachment.put("pk", String.valueOf(versionPk));
                    String uid = (String)attachment.get("uid");
                    uid = "rc-upload-" + UUID.randomUUID() + uid.substring(uid.lastIndexOf("-"));
                    attachment.put("uid", uid);
                }
            }
            newAttachmentBoMap.put(versionPk, bos);
        });
        this.getOption().setVariableValue("opHisAttachments", SerializationUtils.toJsonString((Object)newAttachmentBoMap));
        hisVersionParamBo.setMapHisAttachmentBos(null);
    }
}

