/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.opplugin.web.hismodel.validator;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.basedataref.BaseDataCheckRefrence;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.CreateDateProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.business.domain.repository.HisCommonEntityRepository;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class HisDeleteDataBaseValidator
extends AbstractValidator {
    private static final String ENTITY_NUMBER_ASSISTANT = "bos_assistantdata_detail";
    private static final String KEY_ASSISTANT_GROUP = "group";
    private static final long ONEDAY = 86400000L;
    BasedataEntityType entityType;
    OperateOption option;
    boolean draftValidReference;
    private CreateDateProp createDateProp;

    public OperateOption getOption() {
        return this.option;
    }

    public void setOption(OperateOption option) {
        this.option = option;
    }

    public void setEntityType(BasedataEntityType entityType) {
        this.entityType = entityType;
    }

    public Set<String> preparePropertys() {
        Set fields = super.preparePropertys();
        CreateDateProp prop = this.getCreateDateProp();
        if (prop != null) {
            fields.add(prop.getName());
        }
        if (this.isAssistant()) {
            fields.add(KEY_ASSISTANT_GROUP);
        }
        return fields;
    }

    public void initializeConfiguration() {
        Object obj;
        super.initializeConfiguration();
        HashMap opParameter = (HashMap)this.validateContext.getOperateMetaMap().get("parameter");
        if (opParameter == null) {
            opParameter = new HashMap(16);
        }
        if ((obj = opParameter.get("DraftValidReference")) != null) {
            this.draftValidReference = (Boolean)obj;
        }
    }

    public void validate() {
        String operateKey = this.getOperateKey();
        if (!"delete".equals(operateKey)) {
            return;
        }
        Map<Object, ExtendedDataEntity> objMap = this.getCheckDataEntities();
        if (objMap.isEmpty()) {
            return;
        }
        Object[] boIds = objMap.keySet().toArray();
        if (boIds == null || boIds.length < 1) {
            return;
        }
        String entityNumber = this.entityKey;
        BaseDataCheckRefrence checker = new BaseDataCheckRefrence();
        this.addIgnoreRefEntityIds(checker);
        checker.setDraftValidReference(this.draftValidReference);
        checker.getAsstTypeIds().addAll(this.getAsstTypeIds(objMap));
        checker.setBdCreateTime(this.getCreateDate(objMap));
        Long[] longBoIds = (Long[])Arrays.stream(boIds).toArray(Long[]::new);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
        DynamicObject[] dynamicObjects = HisCommonEntityRepository.getVersionIdsByBoId((HRBaseServiceHelper)serviceHelper, (Long[])longBoIds);
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return;
        }
        Map<Long, Long> mapIdAndBoId = Arrays.stream(dynamicObjects).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("boid")));
        Object[] versionIds = mapIdAndBoId.keySet().toArray(new Long[mapIdAndBoId.size()]);
        Map checkResult = checker.checkRef((BasedataEntityType)this.validateContext.getSubEntityType(), versionIds);
        HashSet<Long> boIdSetNew = new HashSet<Long>(8);
        for (Map.Entry entry : checkResult.entrySet()) {
            Long id = (Long)entry.getKey();
            Long boId = mapIdAndBoId.get(id);
            ExtendedDataEntity dataObj = objMap.get(boId);
            if (dataObj == null) continue;
            if (!boIdSetNew.contains(boId)) {
                BaseDataCheckRefrenceResult referenceResult = (BaseDataCheckRefrenceResult)entry.getValue();
                if (((BaseDataCheckRefrenceResult)entry.getValue()).isRefence()) {
                    String msg = this.buildRefMessage(referenceResult);
                    this.addErrorMessage(dataObj, msg);
                }
            }
            boIdSetNew.add(boId);
        }
    }

    private CreateDateProp getCreateDateProp() {
        if (this.createDateProp == null && this.entityType != null) {
            for (IDataEntityProperty prop : this.entityType.getProperties()) {
                if (!(prop instanceof CreateDateProp)) continue;
                this.createDateProp = (CreateDateProp)prop;
                break;
            }
        }
        return this.createDateProp;
    }

    private Date getCreateDate(Map<Object, ExtendedDataEntity> objMap) {
        Date createDate = null;
        CreateDateProp prop = this.getCreateDateProp();
        if (prop != null) {
            for (Map.Entry<Object, ExtendedDataEntity> entry : objMap.entrySet()) {
                ExtendedDataEntity obj = entry.getValue();
                Date date = obj.getDataEntity().getDate(prop.getName());
                if (createDate == null) {
                    createDate = date;
                    continue;
                }
                if (date == null || createDate.getTime() <= date.getTime()) continue;
                createDate = date;
            }
        }
        if (createDate != null && createDate.getTime() + 86400000L < System.currentTimeMillis()) {
            createDate = null;
        }
        return createDate;
    }

    private boolean isAssistant() {
        return StringUtils.equals((CharSequence)this.getEntityKey(), (CharSequence)ENTITY_NUMBER_ASSISTANT);
    }

    private Set<String> getAsstTypeIds(Map<Object, ExtendedDataEntity> objMap) {
        HashSet<String> set = new HashSet<String>(1);
        if (this.isAssistant()) {
            for (Map.Entry<Object, ExtendedDataEntity> entry : objMap.entrySet()) {
                ExtendedDataEntity obj = entry.getValue();
                DynamicObject asstTypeObj = obj.getDataEntity().getDynamicObject(KEY_ASSISTANT_GROUP);
                String asstTypeId = "";
                if (asstTypeObj != null) {
                    asstTypeId = String.valueOf(asstTypeObj.getPkValue());
                }
                if (!StringUtils.isNotBlank((CharSequence)asstTypeId)) continue;
                set.add(asstTypeId);
            }
        }
        return set;
    }

    private Map<Object, ExtendedDataEntity> getCheckDataEntities() {
        if (this.dataEntities == null || this.dataEntities.length == 0) {
            return new HashMap<Object, ExtendedDataEntity>(0);
        }
        PKFieldProp pkProp = (PKFieldProp)this.getValidateContext().getSubEntityType().getPrimaryKey();
        if (pkProp == null) {
            return new HashMap<Object, ExtendedDataEntity>(0);
        }
        HashMap<Object, ExtendedDataEntity> dataEntityMap = new HashMap<Object, ExtendedDataEntity>(this.dataEntities.length);
        for (ExtendedDataEntity dataObj : this.dataEntities) {
            if (this.validateContext.getValidateResults().getErrorDataIndexs().contains(dataObj.getDataEntityIndex())) continue;
            Object idValue = dataObj.getBillPkId();
            if (pkProp.getValueComparator().compareValue(idValue)) continue;
            dataEntityMap.put(idValue, dataObj);
        }
        return dataEntityMap;
    }

    private void addIgnoreRefEntityIds(BaseDataCheckRefrence checker) {
        String[] entityIds;
        RefObject opValue = new RefObject();
        if (this.option.tryGetVariableValue("ignorerefentityids", opValue) && StringUtils.isNotBlank((CharSequence)((CharSequence)opValue.getValue()))) {
            for (String entityId : entityIds = StringUtils.split((String)((String)opValue.getValue()), (String)",")) {
                if (!StringUtils.isNotBlank((CharSequence)entityId)) continue;
                checker.getIgnoreRefEntityIds().add(entityId);
            }
        }
        if (this.option.tryGetVariableValue("checkrefentityids", opValue = new RefObject()) && StringUtils.isNotBlank((CharSequence)((CharSequence)opValue.getValue()))) {
            for (String entityId : entityIds = StringUtils.split((String)((String)opValue.getValue()), (String)",")) {
                if (!StringUtils.isNotBlank((CharSequence)entityId)) continue;
                checker.getCheckRefEntityIds().add(entityId);
            }
        }
    }

    private String buildRefMessage(BaseDataCheckRefrenceResult refrenceResult) {
        MainEntityType refMainType = EntityMetadataCache.getDataEntityType((String)refrenceResult.getRefenceKey().getRefEntityKey());
        String billName = refMainType.getDisplayName().toString();
        String tableName = refrenceResult.getRefenceKey().getRefTable();
        String fieldName = refrenceResult.getRefenceKey().getRefCol();
        for (IDataEntityProperty property : refMainType.getAllFields().values()) {
            if (this.equalsFieldname(property, tableName, fieldName)) {
                fieldName = property.getDisplayName().toString();
                break;
            }
            if (!this.equalsMulBasedataFieldname(property, tableName, fieldName)) continue;
            fieldName = property.getDisplayName().toString();
            break;
        }
        String msg = String.format(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u5b57\u6bb5\u5f15\u7528\u4e86\u6b64\u6570\u636e\u3002", (String)"HisDeleteDataBaseValidator_1", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]), billName, fieldName);
        return msg;
    }

    private boolean equalsFieldname(IDataEntityProperty property, String tableName, String fieldName) {
        if (!(property instanceof IFieldHandle) || property.getParent() == null || property.getParent().getAlias() == null) {
            return false;
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)property.getAlias(), (CharSequence)fieldName)) {
            return false;
        }
        String propTableName = property.getParent().getAlias();
        if (StringUtils.isNotBlank((CharSequence)property.getTableGroup())) {
            propTableName = propTableName + "_" + property.getTableGroup();
        }
        return StringUtils.equalsIgnoreCase((CharSequence)propTableName, (CharSequence)tableName);
    }

    private boolean equalsMulBasedataFieldname(IDataEntityProperty property, String tableName, String fieldName) {
        if (!(property instanceof MulBasedataProp)) {
            return false;
        }
        MulBasedataProp mulBasedataProp = (MulBasedataProp)property;
        if (mulBasedataProp.getItemType() == null || mulBasedataProp.getItemType().getAlias() == null) {
            return false;
        }
        return StringUtils.equalsIgnoreCase((CharSequence)fieldName, (CharSequence)"fbasedataid") && StringUtils.equalsIgnoreCase((CharSequence)tableName, (CharSequence)mulBasedataProp.getItemType().getAlias());
    }
}

