/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.opplugin.web.hismodel.validator;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.application.impl.common.DynamicObjectCommonService;
import kd.hr.hbp.business.domain.repository.HisCommonEntityRepository;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisCommonService;
import kd.hr.hbp.business.domain.util.HisModelEditAuditTool;
import kd.hr.hbp.business.domain.util.HisModelImportUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class HisNonLineImportValidator
extends AbstractValidator {
    public void validate() {
        Map<Object, Object> boidToOldTempDyMaps;
        String cacheKey;
        String importType = this.getOption().getVariableValue("importtype", null);
        if (!HisModelImportUtil.isImport((OperateOption)this.getOption()) || HisModelImportUtil.isNew((String)importType) || HisModelImportUtil.isDelete((String)importType)) {
            return;
        }
        DataEntityPropertyCollection properties = this.getDataEntities()[0].getDataEntity().getDataEntityType().getProperties();
        boolean hasStatus = HisModelImportUtil.hasStatus((DataEntityPropertyCollection)properties);
        boolean hasEnable = HisModelImportUtil.hasEnable((DataEntityPropertyCollection)properties);
        Pair dataEntities = this.getDataEntities();
        IDataEntityType dataEntityType = dataEntities[0].getDataEntity().getDataEntityType();
        String entityNumber = dataEntityType.getName();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
        IHRAppCache ihrAppCache = HRAppCache.get((String)"hbp");
        Boolean needAudit = (Boolean)ihrAppCache.get(cacheKey = String.format("HisImportNeedAudit_%s_%s", entityNumber, HisModelImportUtil.getImportCacheKeySuffix()), Boolean.class);
        if (needAudit == null) {
            needAudit = HisModelEditAuditTool.getNeedAuditForOp((IDataEntityType)dataEntityType);
        }
        HashSet boidSet = Sets.newHashSetWithExpectedSize((int)16);
        Map enableMap = new HashMap(0);
        Map statusMap = new HashMap(0);
        if (hasEnable || hasStatus) {
            Pair dbEnableAndStatus = HisModelImportUtil.getDbEnableAndStatus((boolean)hasStatus, (boolean)hasEnable, (HRBaseServiceHelper)serviceHelper, () -> HisNonLineImportValidator.lambda$validate$1((ExtendedDataEntity[])dataEntities));
            enableMap = (Map)dbEnableAndStatus.getLeft();
            statusMap = (Map)dbEnableAndStatus.getRight();
        }
        for (Pair extendedDataEntity : dataEntities) {
            boolean nonEnabling;
            boolean isAudited;
            DynamicObject curDyn = extendedDataEntity.getDataEntity();
            boolean isUpd = curDyn.getDataEntityState().getFromDatabase();
            if (isUpd) {
                isAudited = hasStatus && HRStringUtils.equals((String)"C", (String)MapUtils.getString(statusMap, (Object)curDyn.get("id")));
                boolean bl = nonEnabling = hasEnable && !HRStringUtils.equals((String)"10", (String)MapUtils.getString(enableMap, (Object)curDyn.get("id")));
                if (isAudited && nonEnabling) {
                    boolean curNonAudited;
                    boolean bl2 = curNonAudited = StringUtils.equals((CharSequence)curDyn.getString("status"), (CharSequence)"A") || StringUtils.equals((CharSequence)curDyn.getString("status"), (CharSequence)"B");
                    if (needAudit.booleanValue() && curNonAudited) {
                        if (StringUtils.equals((CharSequence)curDyn.getString("enable"), (CharSequence)"10")) {
                            this.addFatalErrorMessage((ExtendedDataEntity)extendedDataEntity, ResManager.loadKDString((String)"\u6570\u636e\u5df2\u8bb0\u5f55\u5386\u53f2\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u6570\u636e\u72b6\u6001\uff0c\u4e5f\u4e0d\u5141\u8bb8\u53d8\u66f4\u4f7f\u7528\u72b6\u6001\u4e3a\u201c\u5f85\u542f\u7528\u201d\u3002", (String)"HisNonLineImportValidator_2", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]));
                            continue;
                        }
                        this.addFatalErrorMessage((ExtendedDataEntity)extendedDataEntity, ResManager.loadKDString((String)"\u6570\u636e\u5df2\u8bb0\u5f55\u5386\u53f2\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u6570\u636e\u72b6\u6001\u3002", (String)"HisNonLineImportValidator_3", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    if (StringUtils.equals((CharSequence)curDyn.getString("enable"), (CharSequence)"10")) {
                        this.addFatalErrorMessage((ExtendedDataEntity)extendedDataEntity, ResManager.loadKDString((String)"\u6570\u636e\u5df2\u8bb0\u5f55\u5386\u53f2\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u4f7f\u7528\u72b6\u6001\u4e3a\u201c\u5f85\u542f\u7528\u201d\u3002", (String)"HisNonLineImportValidator_4", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                }
            } else {
                isAudited = hasStatus && StringUtils.equals((CharSequence)curDyn.getString("status"), (CharSequence)"C");
                boolean bl = nonEnabling = hasEnable && !StringUtils.equals((CharSequence)curDyn.getString("enable"), (CharSequence)"10");
            }
            if (!isAudited || !nonEnabling || !needAudit.booleanValue()) continue;
            boidSet.add(curDyn.getLong("boid"));
        }
        if (CollectionUtils.isNotEmpty((Collection)boidSet)) {
            QFilter boidFilter = new QFilter("boid", "in", (Object)boidSet);
            boidFilter.and(new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0')));
            boidFilter.and(new QFilter("datastatus", "=", (Object)EnumHisDataVersionStatus.TEMP.getStatus()));
            DynamicObject[] oldTempDys = HisCommonEntityRepository.loadDynamicObjectArray((String)entityNumber, (QFilter)boidFilter);
            boidToOldTempDyMaps = Arrays.stream(oldTempDys).collect(Collectors.toMap(dy -> dy.getLong("boid"), Function.identity()));
        } else {
            boidToOldTempDyMaps = new HashMap(0);
        }
        Set excludeFields = Stream.of("masterid", "sourcevid", "datastatus", "iscurrentversion", "status", "ismodify").collect(Collectors.toSet());
        boolean hasCreateOrg = properties.containsKey((Object)"createorg");
        boolean hasUseOrg = properties.containsKey((Object)"useorg");
        long[] ids = ORM.create().genLongIds(entityNumber, ((Pair)dataEntities).length);
        boolean isOriginalTpl = HisCommonService.getInstance().isOriginalTpl(entityNumber);
        for (int i = 0; i < ((Pair)dataEntities).length; ++i) {
            Long boId;
            boolean nonEnabling;
            Pair dataEntity2 = dataEntities[i];
            DynamicObject curDy = dataEntity2.getDataEntity();
            if (hasCreateOrg && hasUseOrg) {
                Long createOrgId = BaseDataCommonService.getLongPropertyFromDynamicObject((DynamicObject)curDy, (String)"createorg");
                Long useOrgId = BaseDataCommonService.getLongPropertyFromDynamicObject((DynamicObject)curDy, (String)"useorg");
                if (curDy.getLong("masterid") != 0L && curDy.getPkValue() != null && (Long)curDy.getPkValue() != 0L && !useOrgId.equals(0L) && !createOrgId.equals(useOrgId)) {
                    curDy.set("boid", (Object)curDy.getLong("id"));
                    continue;
                }
            }
            boolean isAudited = hasStatus && HRStringUtils.equals((String)"C", (String)MapUtils.getString(statusMap, (Object)curDy.get("id")));
            boolean bl = nonEnabling = hasEnable && !HRStringUtils.equals((String)"10", (String)MapUtils.getString(enableMap, (Object)curDy.get("id")));
            if (isAudited && nonEnabling) {
                if (needAudit.booleanValue()) {
                    if (HisModelImportUtil.isOverrideNew((String)importType) && !curDy.getDataEntityState().getFromDatabase()) continue;
                    DynamicObject oldTempDy = (DynamicObject)boidToOldTempDyMaps.get(curDy.getLong("id"));
                    if (HRObjectUtils.isEmpty((Object)oldTempDy)) {
                        DynamicObject tempDy = serviceHelper.generateEmptyDynamicObject();
                        tempDy.set("datastatus", (Object)EnumHisDataVersionStatus.TEMP.getStatus());
                        tempDy.set("iscurrentversion", (Object)Boolean.FALSE);
                        tempDy.set("ismodify", (Object)Boolean.TRUE);
                        tempDy.set("status", (Object)"A");
                        DynamicObjectCommonService.getInstance().setSimpleNewInfo(tempDy);
                        HRDynamicObjectUtils.copy((DynamicObject)curDy, (DynamicObject)tempDy, excludeFields, (boolean)Boolean.TRUE);
                        tempDy.set("id", (Object)curDy.getLong("id"));
                        dataEntity2.setDataEntity(tempDy);
                        continue;
                    }
                    HRDynamicObjectUtils.copy((DynamicObject)curDy, (DynamicObject)oldTempDy, excludeFields, (boolean)Boolean.TRUE);
                    oldTempDy.set("id", (Object)curDy.getLong("id"));
                    DynamicObjectCommonService.getInstance().setSimpleModifyInfo(oldTempDy);
                    dataEntity2.setDataEntity(oldTempDy);
                    continue;
                }
                if (HisModelImportUtil.isOverrideNew((String)importType) && !curDy.getDataEntityState().getFromDatabase()) continue;
                DynamicObject relEffectDy = serviceHelper.generateEmptyDynamicObject();
                relEffectDy.set("status", (Object)"C");
                relEffectDy.set("iscurrentversion", (Object)Boolean.FALSE);
                relEffectDy.set("datastatus", (Object)EnumHisDataVersionStatus.EFFECTING.getStatus());
                HRDynamicObjectUtils.copy((DynamicObject)curDy, (DynamicObject)relEffectDy, excludeFields, (boolean)Boolean.TRUE);
                relEffectDy.set("id", (Object)curDy.getLong("id"));
                dataEntity2.setDataEntity(relEffectDy);
                continue;
            }
            if (!isOriginalTpl || (boId = Long.valueOf(curDy.getLong("boid"))) == null || boId == 0L) continue;
            DynamicObject relEffectDy = serviceHelper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)curDy, (DynamicObject)relEffectDy, excludeFields, (boolean)Boolean.TRUE);
            relEffectDy.set("iscurrentversion", (Object)Boolean.FALSE);
            relEffectDy.set("id", (Object)ids[i]);
            relEffectDy.set("datastatus", (Object)EnumHisDataVersionStatus.EFFECTING.getStatus());
            dataEntity2.setDataEntity(relEffectDy);
        }
        Arrays.stream(dataEntities).forEach(dataEntity -> {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            DynamicObjectCommonService.getInstance().setMastId(dynamicObject);
        });
    }

    private static /* synthetic */ Set lambda$validate$1(ExtendedDataEntity[] dataEntities) {
        return Arrays.stream(dataEntities).map(item -> item.getValue("id")).collect(Collectors.toSet());
    }
}

