/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.opplugin.web.hismodel.validator;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.hr.hbp.business.domain.repository.HisCommonEntityRepository;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.constants.newhismodel.HisFieldNameConstants;
import kd.hr.hbp.common.constants.newhismodel.HisSysConstants;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class HisNonLineTimeTplValidator
extends AbstractValidator
implements HisFieldNameConstants,
HisSysConstants {
    public void validate() {
        ExtendedDataEntity[] datas = this.getDataEntities();
        String operationKey = this.getOperateKey();
        block14: for (ExtendedDataEntity data : datas) {
            switch (operationKey) {
                case "deletehis": {
                    this.checkDelete(data);
                    continue block14;
                }
                case "audithisconfirmchange": {
                    this.checkChange(data);
                    this.checkPersonalData(data);
                    continue block14;
                }
                case "unaudit": {
                    this.validateUnAuditDataOp(data);
                    continue block14;
                }
                case "changesave": 
                case "auditconfirmchange": 
                case "confirmchange": {
                    this.checkPersonalData(data);
                    continue block14;
                }
            }
        }
    }

    private void checkPersonalData(ExtendedDataEntity data) {
        DynamicObject dy = data.getDataEntity();
        String entityNumber = dy.getDataEntityType().getName();
        Boolean isBaseDataCtrl = BaseDataServiceHelper.checkBaseDataCtrl((String)entityNumber);
        if (!isBaseDataCtrl.booleanValue()) {
            return;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
        Long boid = dy.getLong("boid");
        DynamicObject curDy = HisCommonEntityRepository.getNonLineRelCurEffectingDy((HRBaseServiceHelper)serviceHelper, (Long)boid);
        String enable = curDy.getString("enable");
        if (HRStringUtils.equals((String)enable, (String)"1")) {
            return;
        }
        long idValue = curDy.getLong("id");
        long masteridValue = curDy.getLong("masterid");
        if (masteridValue != 0L && idValue == masteridValue) {
            return;
        }
        DynamicObject originalCurDy = HisCommonEntityRepository.getNonLineRelCurEffectingDy((HRBaseServiceHelper)serviceHelper, (Long)curDy.getLong("masterid"));
        if (!HRObjectUtils.isEmpty((Object)originalCurDy) && HRStringUtils.equals((String)originalCurDy.getString("enable"), (String)"0")) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u53d8\u66f4\u5931\u8d25\uff0c\u82e5\u53d8\u66f4\u540e\u6b64\u4e2a\u6027\u5316\u6570\u636e\u5c06\u7f6e\u4e3a\u201c\u53ef\u7528\u201d\u72b6\u6001\uff0c\u4e0e\u539f\u59cb\u6570\u636e\u201c\u7981\u7528\u201d\u72b6\u6001\u51b2\u7a81\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u3002", (String)"HisNonLineTimeTplValidator_2", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]));
        }
    }

    private void checkChange(ExtendedDataEntity data) {
        DynamicObject dy = data.getDataEntity();
        String dataStatus = dy.getString("datastatus");
        if (!HRStringUtils.equals((String)dataStatus, (String)EnumHisDataVersionStatus.TEMP.getStatus())) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u786e\u8ba4\u53d8\u66f4\u5931\u8d25\uff0c\u4ec5\u652f\u6301\u64cd\u4f5c\u201c\u6682\u5b58\u201d\u6570\u636e\u7248\u672c\u3002", (String)"HisNonLineTimeTplValidator_1", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]));
        }
    }

    private void checkDelete(ExtendedDataEntity data) {
        DynamicObject dy = data.getDataEntity();
        String dataStatus = dy.getString("datastatus");
        if (!HRStringUtils.equals((String)dataStatus, (String)EnumHisDataVersionStatus.TEMP.getStatus())) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c\u53ea\u5141\u8bb8\u5220\u9664\u201c\u6682\u5b58\u201d\u6570\u636e\u7248\u672c\u3002", (String)"HisNonLineTimeTplValidator_0", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]));
        }
    }

    private void validateUnAuditDataOp(ExtendedDataEntity data) {
        DataEntityPropertyCollection properties = data.getDataEntity().getDataEntityType().getProperties();
        if (!properties.containsKey((Object)"status") || !properties.containsKey((Object)"enable")) {
            return;
        }
        DynamicObject dynamicObject = data.getDataEntity();
        String status = dynamicObject.getString("status");
        String enable = dynamicObject.getString("enable");
        if (HRStringUtils.equals((String)status, (String)"C") && HRStringUtils.equals((String)enable, (String)"1")) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25\uff0c\u6570\u636e\u5df2\u8bb0\u5f55\u5386\u53f2\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"HisLineTimeTplValidator_06", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]));
        }
    }
}

