/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.opplugin.web.hismodel.validator;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.domain.model.newhismodel.EffStartEndDateBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisValidateRespBo;
import kd.hr.hbp.business.domain.repository.HisCommonEntityRepository;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisEffDateCommonService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisValidateService;
import kd.hr.hbp.business.domain.util.HisModelEditAuditTool;
import kd.hr.hbp.business.domain.util.HisModelImportUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.util.HRStringUtils;

public class HisSaveValidator
extends AbstractValidator {
    private static final Log LOGGER = LogFactory.getLog(HisSaveValidator.class);

    public void validate() {
        String fromPage;
        String importType = this.getOption().getVariableValue("importtype", null);
        boolean needValidateTempVersionDateSection = true;
        if ("confirmchange".equals(this.getOperateKey()) || "confirmchangenoaudit".equals(this.getOperateKey())) {
            needValidateTempVersionDateSection = false;
        }
        if (this.getOption().containsVariable("fromPage") && "revise".equals(fromPage = this.getOption().getVariableValue("fromPage"))) {
            needValidateTempVersionDateSection = false;
        }
        IDataEntityType dataEntityType = this.dataEntities[0].getDataEntity().getDataEntityType();
        if (HisModelImportUtil.isOverride((String)importType) || HisModelImportUtil.isOverrideNew((String)importType)) {
            String cacheKey;
            IHRAppCache cache = HRAppCache.get((String)"hbp");
            Boolean needAudit = (Boolean)cache.get(cacheKey = String.format("HisImportNeedAudit_%s_%s", this.getEntityKey(), HisModelImportUtil.getImportCacheKeySuffix()), Boolean.class);
            if (needAudit == null) {
                needAudit = HisModelEditAuditTool.getNeedAuditForOp((IDataEntityType)dataEntityType);
            }
            needValidateTempVersionDateSection = Boolean.TRUE.equals(needAudit);
        }
        String operateKey = this.getOperateKey();
        String entityNumber = dataEntityType.getName();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
        switch (operateKey) {
            case "save": {
                this.validatePersonalizeData();
                this.validateDate(serviceHelper, true, this.calcNeedValidateTempVersionDateSection(needValidateTempVersionDateSection));
                break;
            }
            case "submit": {
                this.validateDate(serviceHelper, true, this.calcNeedValidateTempVersionDateSection(needValidateTempVersionDateSection));
                break;
            }
            case "confirmchangenoaudit": 
            case "confirmchange": 
            case "audit": {
                Map<Long, List<EffStartEndDateBo>> mapBoIdGroupData = this.validateDate(serviceHelper, false, this.calcNeedValidateTempVersionDateSection(needValidateTempVersionDateSection));
                if (mapBoIdGroupData == null || mapBoIdGroupData.size() == 0) break;
                this.validateDisconnect(mapBoIdGroupData, serviceHelper);
                break;
            }
        }
    }

    private void validatePersonalizeData() {
        String isPersonalizeData = this.getOption().getVariableValue("ispersonalizedata", null);
        if (HRStringUtils.equals((String)isPersonalizeData, (String)"1") && EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus().equals(this.dataEntities[0].getValue("datastatus"))) {
            this.addErrorMessage(this.dataEntities[0], ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u4e2a\u6027\u5316\u5f85\u751f\u6548\u6570\u636e\u3002", (String)"HisSaveValidator_0", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]));
        }
    }

    private Map<Long, List<EffStartEndDateBo>> validateDate(HRBaseServiceHelper serviceHelper, boolean checkOldTempData, boolean needValidateTempVersionDateSection) {
        HashMap<Long, List<EffStartEndDateBo>> mapBoIdGroupData = new HashMap<Long, List<EffStartEndDateBo>>(this.dataEntities.length);
        ArrayList<Long> idList = new ArrayList<Long>(this.dataEntities.length);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            int n = dataEntity.getDataEntityIndex();
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            Date effStartDate = dynamicObject.getDate("bsed");
            Date effEndDate = dynamicObject.getDate("bsled");
            HisValidateRespBo hisValidateRespBo = HisValidateService.getInstance().commonValidate(dynamicObject, effStartDate, effEndDate, true);
            if (hisValidateRespBo == null) {
                return null;
            }
            if (hisValidateRespBo.isError()) {
                this.addErrorMessage(dataEntity, hisValidateRespBo.getMsg());
                continue;
            }
            Long boId = dynamicObject.getLong("boid");
            if (boId == null || boId == 0L) continue;
            Long id = dynamicObject.getLong("id");
            ArrayList<EffStartEndDateBo> effStartEndDateBoList = (ArrayList<EffStartEndDateBo>)mapBoIdGroupData.get(boId);
            if (effStartEndDateBoList == null) {
                effStartEndDateBoList = new ArrayList<EffStartEndDateBo>(8);
            }
            EffStartEndDateBo effStartEndDateBo = hisValidateRespBo.getEffStartEndDateBo();
            effStartEndDateBo.setId(id);
            idList.add(id);
            effStartEndDateBo.setDataEntityIndex(n);
            effStartEndDateBoList.add(effStartEndDateBo);
            mapBoIdGroupData.put(boId, effStartEndDateBoList);
        }
        if (!needValidateTempVersionDateSection) {
            return mapBoIdGroupData;
        }
        List hisValidateRespBoList = HisEffDateCommonService.getInstance().validateTempVersionDateSection(serviceHelper, mapBoIdGroupData, checkOldTempData, idList);
        if (hisValidateRespBoList != null && hisValidateRespBoList.size() > 0) {
            String msg = null;
            HashSet<Object> rowIndexSet = new HashSet<Object>(8);
            for (HisValidateRespBo hisValidateRespBo : hisValidateRespBoList) {
                if (msg == null) {
                    msg = hisValidateRespBo.getMsg();
                }
                rowIndexSet.add(hisValidateRespBo.getRowPair().getKey());
                rowIndexSet.add(hisValidateRespBo.getRowPair().getValue());
                Long boId = hisValidateRespBo.getBoId();
                if (boId == null || boId == 0L) continue;
                mapBoIdGroupData.remove(hisValidateRespBo.getBoId());
            }
            for (Integer n : rowIndexSet) {
                if (n < 0 || n > this.dataEntities.length) continue;
                this.addErrorMessage(this.dataEntities[n], msg);
            }
        }
        return mapBoIdGroupData;
    }

    private void validateDisconnect(Map<Long, List<EffStartEndDateBo>> mapBoIdGroupData, HRBaseServiceHelper serviceHelper) {
        ArrayList<HisValidateRespBo> hisValidateRespBoList = new ArrayList<HisValidateRespBo>(4);
        Set<Long> boIdSet = mapBoIdGroupData.keySet();
        Map oldMapEffStartEndDateBo = HisCommonEntityRepository.getOldEffVersionsByBoId((HRBaseServiceHelper)serviceHelper, boIdSet);
        for (Map.Entry<Long, List<EffStartEndDateBo>> entry : mapBoIdGroupData.entrySet()) {
            Long boId = entry.getKey();
            List<EffStartEndDateBo> effStartEndDateBoList = entry.getValue();
            EffStartEndDateBo[] effStartEndDateBos = effStartEndDateBoList.toArray(new EffStartEndDateBo[effStartEndDateBoList.size()]);
            List oldEffStartEndDateBoList = (List)oldMapEffStartEndDateBo.get(boId);
            HisValidateRespBo hisValidateRespBo = HisEffDateCommonService.getInstance().validateVersionDisconnect(effStartEndDateBos, oldEffStartEndDateBoList, boId);
            if (hisValidateRespBo == null || !hisValidateRespBo.isError()) continue;
            hisValidateRespBoList.add(hisValidateRespBo);
        }
        if (hisValidateRespBoList != null && hisValidateRespBoList.size() > 0) {
            for (HisValidateRespBo hisValidateRespBo : hisValidateRespBoList) {
                Long errorBoId = hisValidateRespBo.getBoId();
                String msg = hisValidateRespBo.getMsg();
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    int dataEntityIndex = dataEntity.getDataEntityIndex();
                    Long boId = (Long)dataEntity.getDataEntity().get("boid");
                    Set dataEntityIndexSet = hisValidateRespBo.getDataEntityIndexSet();
                    if (boId.longValue() != errorBoId.longValue() || !dataEntityIndexSet.contains(dataEntityIndex)) continue;
                    this.addErrorMessage(dataEntity, msg);
                }
            }
        }
    }

    public boolean calcNeedValidateTempVersionDateSection(boolean needValidateTempVersionDateSection) {
        ExtendedDataEntity dataEntity;
        DynamicObject dynamicObject;
        boolean isCurrentVersion;
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities != null && dataEntities.length > 0 && (isCurrentVersion = (dynamicObject = (dataEntity = dataEntities[0]).getDataEntity()).getBoolean("iscurrentversion"))) {
            return false;
        }
        return needValidateTempVersionDateSection;
    }
}

