/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbpm.mservice;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbpm.mservice.api.IDarkPostionService;
import kd.hrmp.hbpm.business.application.impl.position.DarkPositionApplicationImpl;
import kd.hrmp.hbpm.business.application.impl.workrole.DutyWorkRoleServiceApplicationImpl;
import kd.hrmp.hbpm.business.application.impl.workrole.WorkRoleServiceApplicationImpl;
import kd.hrmp.hbpm.business.application.workrole.IDutyWorkRoleServiceApplication;
import kd.hrmp.hbpm.business.application.workrole.IWorkRoleServiceApplication;
import kd.hrmp.hbpm.business.domain.repository.position.PositionQueryRepository;
import kd.hrmp.hbpm.business.domain.service.impl.position.PositionServiceImpl;
import kd.hrmp.hbpm.business.domain.service.position.IPositionService;

public class DarkPostionServiceImpl
implements IDarkPostionService {
    private IDutyWorkRoleServiceApplication dutyWorkRoleServiceApplication = new DutyWorkRoleServiceApplicationImpl();
    private IWorkRoleServiceApplication workRoleServiceApplication = new WorkRoleServiceApplicationImpl();
    private IPositionService positionService = new PositionServiceImpl();
    private static final Log LOGGER = LogFactory.getLog(DarkPostionServiceImpl.class);
    private static final String PARAM_DARKPOSID = "darkposid";
    private static final String PARAM_BSED = "bsed";

    public Map<String, Object> handlePositionIsLeader(Map<Long, Date> darkPositionIdMaps, boolean leader) {
        ArrayList<Long> failedDarkPositionIds;
        ArrayList<Long> successDarkPositionIds;
        DynamicObject[] positionDyns;
        block24: {
            if (CollectionUtils.isEmpty(darkPositionIdMaps)) {
                return DarkPostionServiceImpl.buildSuccessResult(201, "darkPositionIds is empty", null);
            }
            ArrayList<Long> effdtEmpty = new ArrayList<Long>(darkPositionIdMaps.size());
            ArrayList<Long> effdtFuture = new ArrayList<Long>(darkPositionIdMaps.size());
            for (Map.Entry<Long, Date> entry : darkPositionIdMaps.entrySet()) {
                if (entry.getValue() == null) {
                    effdtEmpty.add(entry.getKey());
                }
                if (!entry.getValue().after(new Date())) continue;
                effdtFuture.add(entry.getKey());
            }
            if (!effdtEmpty.isEmpty()) {
                return DarkPostionServiceImpl.buildSuccessResult(201, "effdt is empty", effdtEmpty);
            }
            if (!effdtFuture.isEmpty()) {
                return DarkPostionServiceImpl.buildSuccessResult(201, "effdt can not be a future date", effdtFuture);
            }
            positionDyns = PositionQueryRepository.getInstance().queryDarkPositionById(new ArrayList<Long>(darkPositionIdMaps.keySet()));
            HashMap<Long, DynamicObject> positionDynMap = new HashMap<Long, DynamicObject>(positionDyns.length);
            HashMap<DynamicObject, Date> miandutyPositionMap = new HashMap<DynamicObject, Date>(positionDyns.length);
            HashMap<DynamicObject, Date> ordinaryPositionMap = new HashMap<DynamicObject, Date>(positionDyns.length);
            ArrayList<Long> miandutyPositionIds = new ArrayList<Long>(positionDyns.length);
            ArrayList<Long> ordinaryPositionIds = new ArrayList<Long>(positionDyns.length);
            for (DynamicObject position : positionDyns) {
                positionDynMap.put(position.getLong("id"), position);
                if ("1".equals(position.getString("isleader"))) {
                    miandutyPositionMap.put(position, darkPositionIdMaps.get(position.getLong("id")));
                    miandutyPositionIds.add(position.getLong("id"));
                    continue;
                }
                if (!"2".equals(position.getString("isleader"))) continue;
                ordinaryPositionMap.put(position, darkPositionIdMaps.get(position.getLong("id")));
                ordinaryPositionIds.add(position.getLong("id"));
            }
            successDarkPositionIds = new ArrayList<Long>(darkPositionIdMaps.size());
            failedDarkPositionIds = new ArrayList<Long>(darkPositionIdMaps.size());
            for (Long darkPositionId : darkPositionIdMaps.keySet()) {
                if (positionDynMap.get(darkPositionId) != null) continue;
                failedDarkPositionIds.add(darkPositionId);
            }
            DarkPositionApplicationImpl darkPositionApplication = new DarkPositionApplicationImpl();
            try (TXHandle txHandle = TX.requiresNew();){
                try {
                    if (leader) {
                        darkPositionApplication.cancelMainDutyDarkPosition(miandutyPositionMap);
                        successDarkPositionIds.addAll(miandutyPositionIds);
                        failedDarkPositionIds.addAll(ordinaryPositionIds);
                        break block24;
                    }
                    darkPositionApplication.handleDarkPositionToBeLeader(ordinaryPositionMap);
                    successDarkPositionIds.addAll(ordinaryPositionIds);
                    failedDarkPositionIds.addAll(miandutyPositionIds);
                }
                catch (Exception ex) {
                    txHandle.markRollback();
                    LOGGER.info(ex.getMessage());
                    if (leader) {
                        failedDarkPositionIds.addAll(miandutyPositionIds);
                        break block24;
                    }
                    failedDarkPositionIds.addAll(ordinaryPositionIds);
                }
            }
        }
        HashMap relatedMap = Maps.newHashMapWithExpectedSize((int)positionDyns.length);
        relatedMap.put("success", successDarkPositionIds);
        relatedMap.put("failed", failedDarkPositionIds);
        return DarkPostionServiceImpl.buildSuccessResult(200, "", relatedMap);
    }

    public Map<String, Object> handlePositionIsLeaderV2(Map<Long, Date> darkPositionIdMaps, boolean leader, long adminOrgId) {
        if (CollectionUtils.isEmpty(darkPositionIdMaps)) {
            return DarkPostionServiceImpl.buildSuccessResult(201, "darkPositionIds is empty", null);
        }
        ArrayList<Long> effdtEmpty = new ArrayList<Long>(darkPositionIdMaps.size());
        ArrayList<Long> effdtFuture = new ArrayList<Long>(darkPositionIdMaps.size());
        for (Map.Entry<Long, Date> entry : darkPositionIdMaps.entrySet()) {
            if (entry.getValue() == null) {
                effdtEmpty.add(entry.getKey());
            }
            if (!entry.getValue().after(new Date())) continue;
            effdtFuture.add(entry.getKey());
        }
        if (!effdtEmpty.isEmpty()) {
            return DarkPostionServiceImpl.buildSuccessResult(201, "effdt is empty", effdtEmpty);
        }
        if (!effdtFuture.isEmpty()) {
            return DarkPostionServiceImpl.buildSuccessResult(201, "effdt can not be a future date", effdtFuture);
        }
        DynamicObject[] positionDyns = PositionQueryRepository.getInstance().queryDarkPositionById(new ArrayList<Long>(darkPositionIdMaps.keySet()));
        HashMap<DynamicObject, Date> ordinaryPositionMap = new HashMap<DynamicObject, Date>(positionDyns.length);
        ArrayList<Long> ordinaryPositionIds = new ArrayList<Long>(positionDyns.length);
        for (DynamicObject position : positionDyns) {
            ordinaryPositionMap.put(position, darkPositionIdMaps.get(position.getLong("id")));
            ordinaryPositionIds.add(position.getLong("id"));
        }
        ArrayList<Long> successDarkPositionIds = new ArrayList<Long>(darkPositionIdMaps.size());
        ArrayList<Long> failedDarkPositionIds = new ArrayList<Long>(darkPositionIdMaps.size());
        DarkPositionApplicationImpl darkPositionApplication = new DarkPositionApplicationImpl();
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                if (leader) {
                    LOGGER.info("cancelChargePersonV2#adminOrgId={},ordinaryPositionIds={}", (Object)adminOrgId, (Object)SerializationUtils.toJsonString(ordinaryPositionIds));
                    darkPositionApplication.cancelMainDutyDarkPositionV2(ordinaryPositionMap, adminOrgId);
                } else {
                    LOGGER.info("addChargePersonV2#adminOrgId={},ordinaryPositionIds={}", (Object)adminOrgId, (Object)SerializationUtils.toJsonString(ordinaryPositionIds));
                    darkPositionApplication.handleDarkPositionToBeLeaderV2(ordinaryPositionMap, adminOrgId);
                }
                successDarkPositionIds.addAll(ordinaryPositionIds);
            }
            catch (Exception ex) {
                txHandle.markRollback();
                LOGGER.info(ex.getMessage());
                failedDarkPositionIds.addAll(ordinaryPositionIds);
            }
        }
        HashMap relatedMap = Maps.newHashMapWithExpectedSize((int)positionDyns.length);
        relatedMap.put("success", successDarkPositionIds);
        relatedMap.put("failed", failedDarkPositionIds);
        return DarkPostionServiceImpl.buildSuccessResult(200, "", relatedMap);
    }

    private static Map<String, Object> buildSuccessResult(int code, String ErrMsg, Object data) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)3);
        result.put("code", code);
        result.put("ErrMsg", ErrMsg);
        result.put("data", data);
        return result;
    }

    public Map<String, Object> darkPosFromEmployedDataUpgrade(List<Map<String, Object>> darkPositionIdToBsedMapList) {
        if (CollectionUtils.isEmpty(darkPositionIdToBsedMapList)) {
            LOGGER.info("darkPosFromEmployedDataUpgrade-darkPositionIdToBsedMapList is empty");
            return DarkPostionServiceImpl.buildSuccessResult(200, "", null);
        }
        LOGGER.info("darkPosFromEmployedDataUpgrade-start darkPositionIdToBsedMapListSize={}\uff0c darkPositionIdToBsedMapList={}", (Object)darkPositionIdToBsedMapList.size(), darkPositionIdToBsedMapList);
        Map<Long, List<DynamicObject>> idToVersionsMap = this.getDarkFirstVersion(darkPositionIdToBsedMapList);
        LOGGER.info("darkPosFromEmployedDataUpgrade-step1 executed");
        List<DynamicObject> upgradeDarkPosList = this.getNeedUpgradeData(darkPositionIdToBsedMapList, idToVersionsMap);
        LOGGER.info("darkPosFromEmployedDataUpgrade-step2 executed");
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                this.upgradeData(upgradeDarkPosList);
            }
            catch (Exception ex) {
                txHandle.markRollback();
                LOGGER.info("darkPosFromEmployedDataUpgrade-updatetable error");
                LOGGER.info(ex.getMessage());
                Map<String, Object> map = DarkPostionServiceImpl.buildSuccessResult(201, "darkPosFromEmployedDataUpgrade-updatetable error", null);
                if (txHandle != null) {
                    if (var5_5 != null) {
                        try {
                            txHandle.close();
                        }
                        catch (Throwable throwable) {
                            var5_5.addSuppressed(throwable);
                        }
                    } else {
                        txHandle.close();
                    }
                }
                return map;
            }
        }
        LOGGER.info("darkPosFromEmployedDataUpgrade-step3 executed");
        LOGGER.info("darkPosFromEmployedDataUpgrade-end success");
        return DarkPostionServiceImpl.buildSuccessResult(200, "", null);
    }

    private Map<Long, List<DynamicObject>> getDarkFirstVersion(List<Map<String, Object>> darkPositionIdToBsedMapList) {
        List darkPosIdList = darkPositionIdToBsedMapList.stream().filter(map -> !this.isParamInValid((Map<String, Object>)map)).map(map -> (Long)map.get(PARAM_DARKPOSID)).collect(Collectors.toList());
        DynamicObject[] enableDarkPos = PositionQueryRepository.getInstance().queryEnableDarkPosByBoid(darkPosIdList);
        List enableDarkPosIds = Arrays.stream(enableDarkPos).map(dyn -> dyn.getLong("boid")).collect(Collectors.toList());
        DynamicObject[] darkPos = PositionQueryRepository.getInstance().queryDarkPosFirstVersionByBoid(enableDarkPosIds);
        return Arrays.stream(darkPos).collect(Collectors.groupingBy(dyn -> dyn.getLong("boid")));
    }

    private List<DynamicObject> getNeedUpgradeData(List<Map<String, Object>> darkPositionIdToBsedMapList, Map<Long, List<DynamicObject>> idToVersionsMap) {
        ArrayList<DynamicObject> upgradeDarkPosList = new ArrayList<DynamicObject>(10);
        int index = 0;
        for (Map<String, Object> map : darkPositionIdToBsedMapList) {
            Long darkPosId = (Long)map.get(PARAM_DARKPOSID);
            Date bsed = (Date)map.get(PARAM_BSED);
            LOGGER.info("darkPosFromEmployedDataUpgrade-executing_index={}, darkPosId={}, bsed={}", new Object[]{++index, darkPosId, bsed});
            if (darkPosId == null || darkPosId == 0L || bsed == null) {
                LOGGER.info("darkPosFromEmployedDataUpgrade-executing_index={}, darkPosId={}, bsed={}, param is wrong", new Object[]{index, darkPosId, bsed});
                continue;
            }
            List<DynamicObject> versionList = idToVersionsMap.get(darkPosId);
            if (versionList == null) {
                LOGGER.info("darkPosFromEmployedDataUpgrade-executing index={}, darkPosId={}, darkpos not exist", (Object)index, (Object)darkPosId);
                continue;
            }
            DynamicObject firstVersion = versionList.get(0);
            Date vbsed = firstVersion.getDate(PARAM_BSED);
            Date vfirstbsed = firstVersion.getDate("firstbsed");
            if (!HRDateTimeUtils.dayBefore((Date)HRDateTimeUtils.truncateDate((Date)bsed), (Date)HRDateTimeUtils.truncateDate((Date)vbsed))) {
                LOGGER.info("darkPosFromEmployedDataUpgrade-executing_index={}, darkPosId={}, bsed={}, vbsed={}, day right", new Object[]{index, darkPosId, bsed, vbsed});
                continue;
            }
            if (vfirstbsed != null && !HRDateTimeUtils.dayBefore((Date)HRDateTimeUtils.truncateDate((Date)bsed), (Date)HRDateTimeUtils.truncateDate((Date)vfirstbsed))) {
                LOGGER.info("darkPosFromEmployedDataUpgrade-executing_index={}, darkPosId={}, bsed={}, vfirstbsed={}, already upgrade", new Object[]{index, darkPosId, bsed, vfirstbsed});
                continue;
            }
            String vdatastatus = firstVersion.getString("datastatus");
            if (HRStringUtils.equals((String)vdatastatus, (String)"-2")) {
                firstVersion.set("bsled", (Object)HRDateTimeUtils.addDay((Date)vbsed, (long)-1L));
                firstVersion.set(PARAM_BSED, (Object)bsed);
            } else if (HRStringUtils.equals((String)vdatastatus, (String)"1") || HRStringUtils.equals((String)vdatastatus, (String)"2")) {
                firstVersion.set(PARAM_BSED, (Object)bsed);
            } else {
                LOGGER.info("darkPosFromEmployedDataUpgrade-executing_index={}, darkPosId={}, vdatastatus={}, datastauts wrong", new Object[]{index, darkPosId, vdatastatus});
                continue;
            }
            upgradeDarkPosList.add(firstVersion);
        }
        LOGGER.info("darkPosFromEmployedDataUpgrade-executing_data={}", upgradeDarkPosList);
        return upgradeDarkPosList;
    }

    private void upgradeData(List<DynamicObject> upgradeDarkPosList) {
        if (upgradeDarkPosList.size() > 0) {
            this.workRoleServiceApplication.updateWorkRole(upgradeDarkPosList);
            this.dutyWorkRoleServiceApplication.updateDutyRole(upgradeDarkPosList);
            this.positionService.batchChange(upgradeDarkPosList.toArray(new DynamicObject[0]));
            List upgradeDarkPosBoidList = upgradeDarkPosList.stream().map(dyn -> dyn.getLong("boid")).collect(Collectors.toList());
            DynamicObject[] positions = PositionQueryRepository.getInstance().queryAllHisData(upgradeDarkPosBoidList);
            Map<Long, List<DynamicObject>> idToHisDataMap = Arrays.stream(positions).collect(Collectors.groupingBy(dyn -> dyn.getLong("boid")));
            ArrayList<DynamicObject> allDataList = new ArrayList<DynamicObject>();
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_positionhr");
            for (DynamicObject pos : upgradeDarkPosList) {
                long boid = pos.getLong("boid");
                Date bsed = pos.getDate(PARAM_BSED);
                List<DynamicObject> hisDatas = idToHisDataMap.get(boid);
                if (CollectionUtils.isEmpty(hisDatas)) continue;
                for (DynamicObject his : hisDatas) {
                    his.set("firstbsed", (Object)bsed);
                    his.set("establishmentdate", (Object)bsed);
                }
                allDataList.addAll(hisDatas);
            }
            if (allDataList.size() > 0) {
                serviceHelper.update(allDataList.toArray(new DynamicObject[0]));
            }
        }
    }

    private boolean isParamInValid(Map<String, Object> map) {
        Long darkPosId = (Long)map.get(PARAM_DARKPOSID);
        Date bsed = (Date)map.get(PARAM_BSED);
        return darkPosId == null || darkPosId == 0L || bsed == null;
    }
}

