/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbpm.mservice;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbpm.mservice.api.IHBPMPositionHisVersionQueryService;
import kd.hrmp.hbpm.business.domain.repository.position.PositionQueryRepository;
import kd.hrmp.hbpm.business.domain.repository.position.ReportingrelationQueryRepository;
import kd.hrmp.hbpm.business.domain.service.impl.position.ChangeEventServiceImpl;
import kd.hrmp.hbpm.business.domain.service.impl.position.ReviseLogServiceImpl;
import kd.hrmp.hbpm.business.domain.service.position.ChangeEventService;
import kd.hrmp.hbpm.business.utils.PositionUtils;
import org.apache.commons.lang.ArrayUtils;

public class HBPMPositionHisVersionQueryService
implements IHBPMPositionHisVersionQueryService {
    private static final Log LOGGER = LogFactory.getLog(HBPMPositionHisVersionQueryService.class);
    private ChangeEventService changeEventService = new ChangeEventServiceImpl();

    public Map<String, Object> queryPositionHisVersion(List<Long> eventIds) {
        LOGGER.info(String.format(Locale.ROOT, "queryPositionHisVersion start : params is %s", eventIds));
        if (CollectionUtils.isEmpty(eventIds)) {
            return this.buildResult(201, "params is empty", null);
        }
        Map eventDetailMap = this.changeEventService.getOpdetailByEventIds(eventIds);
        if (CollectionUtils.isEmpty((Map)eventDetailMap)) {
            return this.buildResult(200, "", "");
        }
        List<Long> positionHisVersionIds = this.getPositionHisVersionIds(eventDetailMap, false);
        try {
            Map<Long, Map<String, Object>> positionHisVersionInfoMap = this.queryPositionInfoAndReportRelations(positionHisVersionIds, false);
            if (CollectionUtils.isEmpty(positionHisVersionInfoMap)) {
                return this.buildResult(200, "", "");
            }
            HashMap data = Maps.newHashMapWithExpectedSize((int)eventDetailMap.size());
            eventDetailMap.forEach((eventId, eventInfos) -> {
                ArrayList result = Lists.newArrayListWithExpectedSize((int)eventInfos.size());
                for (DynamicObject eventInfo : eventInfos) {
                    result.add(positionHisVersionInfoMap.get(eventInfo.getLong("afterposition")));
                }
                data.put(eventId, result);
            });
            return this.buildResult(200, "", data);
        }
        catch (Exception exception) {
            LOGGER.error("queryPositionHisVersion error", (Throwable)exception);
            return this.buildResult(500, exception.getMessage(), "");
        }
    }

    public Map<String, Object> queryPositionHisVersionCompare(List<Long> eventIds) {
        LOGGER.info(String.format(Locale.ROOT, "queryPositionHisVersionCompare start : params is %s", eventIds));
        if (CollectionUtils.isEmpty(eventIds)) {
            return this.buildResult(201, "params is empty", null);
        }
        Map eventDetailMap = this.changeEventService.getOpdetailByEventIds(eventIds);
        if (CollectionUtils.isEmpty((Map)eventDetailMap)) {
            return this.buildResult(200, "", "");
        }
        List<Long> positionHisVersionIds = this.getPositionHisVersionIds(eventDetailMap, true);
        try {
            Map<Long, Map<String, Object>> positionHisVersionInfoMap = this.queryPositionInfoAndReportRelations(positionHisVersionIds, false);
            if (CollectionUtils.isEmpty(positionHisVersionInfoMap)) {
                return this.buildResult(200, "", "");
            }
            HashMap data = Maps.newHashMapWithExpectedSize((int)eventDetailMap.size());
            eventDetailMap.forEach((eventId, eventInfos) -> {
                ArrayList result = Lists.newArrayListWithExpectedSize((int)eventInfos.size());
                for (DynamicObject eventInfo : eventInfos) {
                    HashMap response = Maps.newHashMapWithExpectedSize((int)2);
                    response.put("preVersion", positionHisVersionInfoMap.get(eventInfo.getLong("beforeposition")));
                    response.put("currentVersion", positionHisVersionInfoMap.get(eventInfo.getLong("afterposition")));
                    result.add(response);
                }
                data.put(eventId, result);
            });
            return this.buildResult(200, "", data);
        }
        catch (Exception exception) {
            LOGGER.error("queryPositionHisVersion error", (Throwable)exception);
            return this.buildResult(500, exception.getMessage(), "");
        }
    }

    private List<Long> getPositionHisVersionIds(Map<Long, List<DynamicObject>> eventDetailMap, boolean isInCloudBeforeVersion) {
        ArrayList positionHisVersionIds = Lists.newArrayListWithExpectedSize((int)16);
        for (List<DynamicObject> eventInfos : eventDetailMap.values()) {
            if (CollectionUtils.isEmpty(eventInfos)) continue;
            eventInfos.forEach(eventInfo -> {
                positionHisVersionIds.add(eventInfo.getLong("afterposition"));
                long beforePosition = eventInfo.getLong("beforeposition");
                if (isInCloudBeforeVersion && beforePosition != 0L) {
                    positionHisVersionIds.add(beforePosition);
                }
            });
        }
        return positionHisVersionIds;
    }

    private Map<Long, Map<String, Object>> queryPositionInfoAndReportRelations(List<Long> positionHisVersionIds, boolean onlyMainInfo) {
        Object[] positionHisVersionInfo = PositionQueryRepository.getInstance().queryFieldPositionsByIds(positionHisVersionIds);
        if (ArrayUtils.isEmpty((Object[])positionHisVersionInfo)) {
            return new HashMap<Long, Map<String, Object>>();
        }
        Map<Object, Object> workRoleAndRelationMap = Maps.newHashMapWithExpectedSize((int)16);
        if (!onlyMainInfo) {
            workRoleAndRelationMap = this.getWorkRoleAndRelationMap((DynamicObject[])positionHisVersionInfo);
        }
        HashMap positionHisVersionAndReportRelationMap = Maps.newHashMapWithExpectedSize((int)16);
        for (Object positionHisVersion : positionHisVersionInfo) {
            HashMap positionHisVersionInfoMap = Maps.newHashMapWithExpectedSize((int)16);
            positionHisVersionInfoMap.put("hisVersionInfo", PositionUtils.dynamicObjectToMap((DynamicObject)positionHisVersion));
            if (!onlyMainInfo) {
                DynamicObject realReportRelation = this.getRealReportRelation((List)workRoleAndRelationMap.get(positionHisVersion.getLong("workrole.id")), positionHisVersion.getDate("bsed"));
                positionHisVersionInfoMap.put("reportRelation", PositionUtils.dynamicObjectToMap((DynamicObject)realReportRelation));
            }
            positionHisVersionAndReportRelationMap.put(positionHisVersion.getLong("id"), positionHisVersionInfoMap);
        }
        return positionHisVersionAndReportRelationMap;
    }

    private Map<Long, List<DynamicObject>> getWorkRoleAndRelationMap(DynamicObject[] positionHisVersionInfo) {
        List workRoleIds = Arrays.stream(positionHisVersionInfo).map(positionHisVersion -> positionHisVersion.getLong("workrole.id")).collect(Collectors.toList());
        DynamicObject[] reportRelationHisVersions = ReportingrelationQueryRepository.getInstance().queryRelationHisVersions(workRoleIds);
        HashMap workRoleAndRelationMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject reportRelationHisVersion : reportRelationHisVersions) {
            List reportRelations = (List)workRoleAndRelationMap.get(reportRelationHisVersion.getLong("role"));
            if (CollectionUtils.isEmpty((Collection)reportRelations)) {
                reportRelations = Lists.newArrayListWithExpectedSize((int)16);
                workRoleAndRelationMap.put(reportRelationHisVersion.getLong("role"), reportRelations);
            }
            reportRelations.add(reportRelationHisVersion);
        }
        return workRoleAndRelationMap;
    }

    private DynamicObject getRealReportRelation(List<DynamicObject> reportRelations, Date bSed) {
        if (CollectionUtils.isEmpty(reportRelations)) {
            return null;
        }
        for (DynamicObject reportRelation : reportRelations) {
            Date startBSed = reportRelation.getDate("bsed");
            if (bSed.compareTo(startBSed) < 0 || !bSed.before(reportRelation.getDate("bsled"))) continue;
            return reportRelation;
        }
        return null;
    }

    public Map<String, Object> queryPositionReviseVersionCompare(Long reviseLogId) {
        ReviseLogServiceImpl reviseLogService = new ReviseLogServiceImpl();
        DynamicObject entry = reviseLogService.getReviseVersionEntry(reviseLogId.longValue());
        if (entry == null) {
            return this.buildResult(200, "", "");
        }
        Long beforeVid = entry.getLong("revisebefore");
        Long afterVid = entry.getLong("reviseafter");
        ArrayList<Long> vids = new ArrayList<Long>();
        vids.add(beforeVid);
        vids.add(afterVid);
        try {
            Map<Long, Map<String, Object>> positionHisVersionInfoMap = this.queryPositionInfoAndReportRelations(vids, true);
            if (CollectionUtils.isEmpty(positionHisVersionInfoMap)) {
                return this.buildResult(200, "", "");
            }
            HashMap data = Maps.newHashMapWithExpectedSize((int)8);
            data.put("before", ((Map)positionHisVersionInfoMap.getOrDefault(beforeVid, new HashMap())).get("hisVersionInfo"));
            data.put("after", ((Map)positionHisVersionInfoMap.getOrDefault(afterVid, new HashMap())).get("hisVersionInfo"));
            return this.buildResult(200, "", data);
        }
        catch (Exception exception) {
            LOGGER.error("queryPositionHisVersion error", (Throwable)exception);
            return this.buildResult(500, exception.getMessage(), "");
        }
    }

    private Map<String, Object> buildResult(int code, String ErrMsg, Object data) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)4);
        result.put("code", code);
        result.put("ErrMsg", ErrMsg);
        result.put("data", data);
        return result;
    }
}

