/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbpm.mservice;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.service.operation.OperationServiceImpl;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.application.impl.common.CompareDiffController;
import kd.hr.hbp.business.domain.model.newhismodel.api.comparediff.CompareDiffApiInputParam;
import kd.hr.hbp.business.domain.model.newhismodel.api.comparediff.CompareDiffApiOutPutParam;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.api.HrApiResponse;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbpm.mservice.api.IIntegrationPositionService;
import kd.hrmp.hbpm.business.domain.repository.position.PositionQueryRepository;
import kd.hrmp.hbpm.business.utils.PositionJobRangeServiceHelper;
import kd.hrmp.hbpm.business.utils.PositionUtils;
import kd.hrmp.hbpm.common.model.DyMapModel;
import kd.hrmp.hbpm.common.util.Map2Dy;

public class IntegrationPositionServiceImpl
implements IIntegrationPositionService {
    private static final Log logger = LogFactory.getLog(IntegrationPositionServiceImpl.class);
    private static final String ADD_POSITION = "addPosition";
    private static final String CHANGE_POSITION = "changePosition";
    private Map<Long, String> idNumberMap;
    private static final Set<String> FORBID_CHANGE_FIELDS = new HashSet<String>(Arrays.asList("boid", "adminorg", "workrole", "org", "establishmentdate", "initdatasource", "initstatus", "initbatch", "tobedisable", "creator", "createtime", "firstbsed"));
    private static final Set<String> IGNORE_FIELDS = new HashSet<String>(Arrays.asList("issyspreset", "disabler", "disabledate", "initdatasource", "initstatus", "initbatch", "iscurrentversion", "datastatus", "sourcevid", "firstbsed", "changebsed", "bred", "brled", "brfd", "ismodify", "bsed", "bsled", "changedescription", "hisversion", "creator", "modifier", "createtime", "modifytime", "masterid"));

    public Map<String, Object> savePositionTest(List<Map<String, Object>> data) {
        List<DynamicObject> list = this.convertToDynList("hbpm_position_api", data);
        return this.savePosition(new ArrayList<DynamicObject>(list));
    }

    public Map<String, Object> changePositionTest(List<Map<String, Object>> data) {
        List<DynamicObject> list = this.convertToDynList("hbpm_position_api", data);
        return this.changePosition(new ArrayList<DynamicObject>(list));
    }

    private List<DynamicObject> convertToDynList(String entityName, List<Map<String, Object>> data) {
        Map2Dy map2Dy = new Map2Dy();
        DyMapModel dyMapModel = new DyMapModel();
        dyMapModel.setData(data);
        dyMapModel.setMetadata(entityName);
        return map2Dy.map2DynamicObject(dyMapModel);
    }

    public Map<String, Object> savePosition(List<DynamicObject> positions) {
        logger.info("Integration save position params is {}", positions);
        if (positions.size() > 500) {
            return this.buildErroResult("The data volume cannot exceed 500");
        }
        ArrayList<DynamicObject> positionApis = new ArrayList<DynamicObject>(positions.size());
        HashMap<String, List<String>> errorInfoMap = new HashMap<String, List<String>>();
        HashSet<Long> jobScmIds = new HashSet<Long>(16);
        HashSet<Long> jobIds = new HashSet<Long>(16);
        HashSet<Long> jobFamilyIds = new HashSet<Long>(16);
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"hbpm_position_api");
        long[] ids = ORM.create().genLongIds("hbpm_position_api", positions.size());
        ArrayList<Long> parentIds = new ArrayList<Long>(positions.size());
        ArrayList<Long> positionIds = new ArrayList<Long>(positions.size());
        for (int idx = 0; idx < positions.size(); ++idx) {
            if (positions.get(idx).getLong("id") == 0L) {
                positions.get(idx).set("id", (Object)ids[idx]);
            }
            this.handleJobInfo(positions.get(idx), jobScmIds, jobIds, jobFamilyIds);
            DynamicObject parent2 = positions.get(idx).getDynamicObject("parent");
            if (parent2 != null) {
                parentIds.add(parent2.getLong("id"));
            }
            positionIds.add(positions.get(idx).getLong("id"));
        }
        DynamicObject[] parentFromDBs = PositionQueryRepository.getInstance().queryPositionInfo(parentIds);
        Set parentFromDBIds = Arrays.stream(parentFromDBs).map(parent -> parent.getLong("id")).collect(Collectors.toSet());
        PositionJobRangeServiceHelper positionJobRangeServiceHelper = this.initPositionJobRangeServiceHelper(jobScmIds, jobIds, jobFamilyIds);
        for (DynamicObject position : positions) {
            List<String> levelGradeErrors;
            DynamicObject parent3;
            ArrayList<String> errorMsg = new ArrayList<String>(10);
            String paramsError = this.checkPosition(position, null);
            if (!StringUtils.isEmpty((Object)paramsError)) {
                errorMsg.add(paramsError);
            }
            if ((parent3 = position.getDynamicObject("parent")) != null && !parentFromDBIds.contains(parent3.getLong("id")) && !positionIds.contains(parent3.getLong("id"))) {
                errorMsg.add(ResManager.loadKDString((String)"\u4e0a\u7ea7\u5c97\u4f4d\u4e0d\u5b58\u5728\u3002", (String)"IntegrationPositionServiceImpl_10", (String)"hrmp-hbpm-mservice", (Object[])new Object[0]));
                positionIds.remove(position.getLong("id"));
            }
            if (!(levelGradeErrors = this.checkAndTransLevelGradeTextAdd(positionJobRangeServiceHelper, position)).isEmpty()) {
                errorMsg.addAll(levelGradeErrors);
            }
            if (errorMsg.isEmpty()) {
                DynamicObject positionApi = new DynamicObject((DynamicObjectType)dataEntityType);
                HRDynamicObjectUtils.copy((DynamicObject)position, (DynamicObject)positionApi);
                positionApi.set("id", (Object)position.getLong("id"));
                positionApi.set("changetype", (Object)1010L);
                positionApi.set("initstatus", (Object)"2");
                positionApi.set("initdatasource", (Object)"2");
                this.addSystemField(positionApi, ADD_POSITION);
                positionApis.add(positionApi);
                continue;
            }
            this.addErrorMsgListToMap(errorInfoMap, position, errorMsg);
        }
        if (positionApis.size() > 0) {
            DynamicObject[] positionArrays = positionApis.toArray(new DynamicObject[0]);
            this.initIdNumberMap(positionArrays);
            this.changeJobLevelAndGradeScm(positionArrays);
            OperationResult opResult = this.callOp("save_api", positionArrays);
            logger.info("Integration save position callop errorInfoMap is {}", errorInfoMap);
            return this.buildResult(opResult, errorInfoMap);
        }
        logger.info("Integration save position errorInfoMap is {}", errorInfoMap);
        return this.buildResult("fail", errorInfoMap);
    }

    public Map<String, Object> changePosition(List<DynamicObject> positions) {
        logger.info("Integration change position params is {}", positions);
        if (positions.size() > 500) {
            return this.buildErroResult("The data volume cannot exceed 500");
        }
        HashMap<String, List<String>> errorInfoMap = new HashMap<String, List<String>>(positions.size());
        List<DynamicObject> changePositions = this.buildPositions(positions, errorInfoMap);
        this.removeNoChangeData(changePositions);
        List<DynamicObject> positionInits = this.buildPositionInits(changePositions);
        if (positionInits.size() > 0) {
            DynamicObject[] positionArrays = positionInits.toArray(new DynamicObject[0]);
            this.initIdNumberMap(positionArrays);
            this.changeJobLevelAndGradeScm(positionArrays);
            OperationResult opResult = this.callOp("change_api", positionArrays);
            logger.info("Integration change position callop errorInfoMap is {}", errorInfoMap);
            return this.buildResult(opResult, errorInfoMap);
        }
        logger.info("Integration change position errorInfoMap is {}", errorInfoMap);
        return this.buildResult("fail", errorInfoMap);
    }

    private void initIdNumberMap(DynamicObject[] positions) {
        this.idNumberMap = new HashMap<Long, String>(positions.length);
        for (DynamicObject position : positions) {
            this.idNumberMap.put(position.getLong("id"), position.getString("number"));
        }
    }

    private void changeJobLevelAndGradeScm(DynamicObject[] positions) {
        if (PositionUtils.isArrayEmpty((Object[])positions).booleanValue()) {
            return;
        }
        ArrayList<Long> jobLevelScmIds = new ArrayList<Long>();
        ArrayList<Long> jobGradeScmIds = new ArrayList<Long>();
        for (DynamicObject position : positions) {
            long jobLevelScmId = position.getLong("joblevelscm.id");
            long jobGradeScmId = position.getLong("jobgradescm.id");
            if (jobLevelScmId != 0L) {
                jobLevelScmIds.add(jobLevelScmId);
            }
            if (jobGradeScmId == 0L) continue;
            jobGradeScmIds.add(jobGradeScmId);
        }
        Map<Long, DynamicObject> jobLevelScmMap = this.queryJobLevelOrGradeScm(jobLevelScmIds, "hbjm_joblevelscmhr");
        Map<Long, DynamicObject> jobGradeScmMap = this.queryJobLevelOrGradeScm(jobGradeScmIds, "hbjm_jobgradescmhr");
        for (DynamicObject position : positions) {
            long jobLevelScmId = position.getLong("joblevelscm.id");
            long jobGradeScmId = position.getLong("jobgradescm.id");
            if (jobLevelScmId != 0L) {
                position.set("joblevelscm", (Object)jobLevelScmMap.get(jobLevelScmId));
            }
            if (jobGradeScmId == 0L) continue;
            position.set("jobgradescm", (Object)jobGradeScmMap.get(jobGradeScmId));
        }
    }

    private String getPositionNumber(Long positionId) {
        return this.idNumberMap.get(positionId);
    }

    private String checkPosition(DynamicObject position, Map<Long, DynamicObject> posMap) {
        StringBuilder errorMsg = new StringBuilder();
        if (position.getLong("id") == 0L) {
            errorMsg.append(ResManager.loadKDString((String)"\u5c97\u4f4dID\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"IntegrationPositionServiceImpl_1", (String)"hrmp-hbpm-mservice", (Object[])new Object[0]));
        }
        if (position.get("bsed") == null) {
            errorMsg.append(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u751f\u6548\u65e5\u671f\u201d\u3002", (String)"IntegrationPositionServiceImpl_3", (String)"hrmp-hbpm-mservice", (Object[])new Object[0]));
        }
        if (position.get("enable") == null) {
            errorMsg.append(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u4f7f\u7528\u72b6\u6001\u201d\u3002", (String)"IntegrationPositionServiceImpl_8", (String)"hrmp-hbpm-mservice", (Object[])new Object[0]));
        }
        if (posMap != null && posMap.get(position.getLong("id")) == null) {
            errorMsg.append(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u7981\u7528\u3002", (String)"IntegrationPositionServiceImpl_9", (String)"hrmp-hbpm-mservice", (Object[])new Object[0]));
        }
        if (posMap == null && position.get("adminorg") == null) {
            errorMsg.append(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u884c\u653f\u7ec4\u7ec7\u201d\u3002", (String)"IntegrationPositionServiceImpl_2", (String)"hrmp-hbpm-mservice", (Object[])new Object[0]));
        }
        if (posMap == null && position.get("establishmentdate") == null) {
            errorMsg.append(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u8bbe\u7acb\u65e5\u671f\u201d\u3002", (String)"IntegrationPositionServiceImpl_4", (String)"hrmp-hbpm-mservice", (Object[])new Object[0]));
        }
        if (posMap == null && position.get("positiontype") == null) {
            errorMsg.append(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u5c97\u4f4d\u7c7b\u578b\u201d\u3002", (String)"IntegrationPositionServiceImpl_5", (String)"hrmp-hbpm-mservice", (Object[])new Object[0]));
        }
        if (posMap == null && position.get("isleader") == null) {
            errorMsg.append(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u662f\u5426\u4e3b\u8d1f\u8d23\u5c97\u201d\u3002", (String)"IntegrationPositionServiceImpl_6", (String)"hrmp-hbpm-mservice", (Object[])new Object[0]));
        }
        return errorMsg.toString();
    }

    private void addSystemField(DynamicObject position, String type) {
        position.set("org", position.get("adminorg.org"));
        if (position.getDate("establishmentdate") == null) {
            position.set("establishmentdate", (Object)position.getDate("bsed"));
        }
        DynamicObject parent = position.getDynamicObject("parent");
        if (ADD_POSITION.equals(type) && parent != null) {
            if (parent.getDate("establishmentdate") == null) {
                parent.set("establishmentdate", (Object)parent.getDate("bsed"));
            }
            if (parent.getDate("firstbsed") == null) {
                parent.set("firstbsed", (Object)parent.getDate("bsed"));
            }
        }
        if (position.getString("issensitive") == null) {
            position.set("issensitive", (Object)"0");
        }
        this.fillJobLevelOrGradeScm(position);
    }

    private void fillJobLevelOrGradeScm(DynamicObject position) {
        DynamicObject jobScm = position.getDynamicObject("jobscm");
        if (!HRObjectUtils.isEmpty((Object)jobScm)) {
            return;
        }
        DynamicObject highJobLevel = position.getDynamicObject("highjoblevel");
        DynamicObject lowJobLevel = position.getDynamicObject("lowjoblevel");
        DynamicObject highJobGrade = position.getDynamicObject("highjobgrade");
        DynamicObject lowJobGrade = position.getDynamicObject("lowjobgrade");
        if (!HRObjectUtils.isEmpty((Object)highJobLevel) || !HRObjectUtils.isEmpty((Object)lowJobLevel)) {
            DynamicObject jobLevelScm = null;
            jobLevelScm = !HRObjectUtils.isEmpty((Object)highJobLevel) ? highJobLevel.getDynamicObject("joblevelscm") : lowJobLevel.getDynamicObject("joblevelscm");
            position.set("joblevelscm", (Object)jobLevelScm);
        }
        if (!HRObjectUtils.isEmpty((Object)highJobGrade) || !HRObjectUtils.isEmpty((Object)lowJobGrade)) {
            DynamicObject jobGradeScm = null;
            jobGradeScm = !HRObjectUtils.isEmpty((Object)highJobGrade) ? highJobGrade.getDynamicObject("jobgradescm") : lowJobGrade.getDynamicObject("jobgradescm");
            position.set("jobgradescm", (Object)jobGradeScm);
        }
    }

    private Map<Long, DynamicObject> queryJobLevelOrGradeScm(List<Long> ids, String entityNumber) {
        Map<Object, Object> jobLevelOrGradeScmMap = Maps.newHashMapWithExpectedSize((int)ids.size());
        if (CollectionUtils.isEmpty(ids)) {
            return jobLevelOrGradeScmMap;
        }
        HRBaseServiceHelper jobLevelScm = new HRBaseServiceHelper(entityNumber);
        QFilter idFilter = new QFilter("id", "in", ids);
        Object[] jobLevelOrGradeScm = jobLevelScm.loadDynamicObjectArray(new QFilter[]{idFilter});
        if (PositionUtils.isArrayEmpty((Object[])jobLevelOrGradeScm).booleanValue()) {
            return jobLevelOrGradeScmMap;
        }
        jobLevelOrGradeScmMap = Arrays.stream(jobLevelOrGradeScm).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (v1, v2) -> v1));
        return jobLevelOrGradeScmMap;
    }

    private List<DynamicObject> buildPositions(List<DynamicObject> positions, Map<String, List<String>> errorInfoMap) {
        ArrayList<Long> posIds = new ArrayList<Long>(positions.size());
        HashSet<Long> jobScmIds = new HashSet<Long>();
        HashSet<Long> jobIds = new HashSet<Long>();
        HashSet<Long> jobFamilyIds = new HashSet<Long>();
        for (DynamicObject position : positions) {
            posIds.add(position.getLong("id"));
            this.handleJobInfo(position, jobScmIds, jobIds, jobFamilyIds);
        }
        Map<Long, DynamicObject> posMap = this.getPositionById(posIds);
        PositionJobRangeServiceHelper positionJobRangeServiceHelper = this.initPositionJobRangeServiceHelper(jobScmIds, jobIds, jobFamilyIds);
        ArrayList<DynamicObject> changePositions = new ArrayList<DynamicObject>(positions.size());
        for (DynamicObject position : positions) {
            List<String> levelGradeErrors;
            ArrayList<String> errorMsg = new ArrayList<String>(10);
            String paramsError = this.checkPosition(position, posMap);
            if (!StringUtils.isEmpty((Object)paramsError)) {
                errorMsg.add(paramsError);
            }
            if (!(levelGradeErrors = this.checkAndTransLevelGradeTextChange(positionJobRangeServiceHelper, position)).isEmpty()) {
                errorMsg.addAll(levelGradeErrors);
            }
            if (errorMsg.isEmpty()) {
                DynamicObject positionById = posMap.get(position.getLong("id"));
                for (String forbidFiled : FORBID_CHANGE_FIELDS) {
                    position.set(forbidFiled, positionById.get(forbidFiled));
                }
                changePositions.add(position);
                continue;
            }
            this.addErrorMsgListToMap(errorInfoMap, position, errorMsg);
        }
        return changePositions;
    }

    private Map<Long, DynamicObject> getPositionById(List<Long> posIds) {
        HRBaseServiceHelper positionhr = new HRBaseServiceHelper("hbpm_positionhr");
        QFilter idFilter = new QFilter("boid", "in", posIds);
        QFilter versionFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('1'));
        DynamicObject[] positionByIds = positionhr.loadDynamicObjectArray(new QFilter[]{idFilter, versionFilter});
        HashMap<Long, DynamicObject> posMap = new HashMap<Long, DynamicObject>(positionByIds.length);
        for (DynamicObject positionById : positionByIds) {
            posMap.put(positionById.getLong("id"), positionById);
        }
        return posMap;
    }

    private void removeNoChangeData(List<DynamicObject> changePositions) {
        if (CollectionUtils.isEmpty(changePositions)) {
            return;
        }
        CompareDiffApiInputParam param = new CompareDiffApiInputParam();
        param.setEntityNumber("hbpm_positionhr");
        param.setDynamicObjects(changePositions.toArray(new DynamicObject[0]));
        param.setIgnoreFields(IGNORE_FIELDS);
        CompareDiffController diffController = new CompareDiffController();
        HrApiResponse noChangeData = diffController.isNewData(param);
        if (noChangeData.isSuccess()) {
            return;
        }
        List diffApiOutPutParams = (List)noChangeData.getData();
        if (diffApiOutPutParams == null || diffApiOutPutParams.size() == 0) {
            return;
        }
        ArrayList<DynamicObject> noChangePositions = new ArrayList<DynamicObject>(diffApiOutPutParams.size());
        for (CompareDiffApiOutPutParam diffApiOutPutParam : diffApiOutPutParams) {
            noChangePositions.add(diffApiOutPutParam.getDyOriginal());
        }
        changePositions.removeAll(noChangePositions);
    }

    private List<DynamicObject> buildPositionInits(List<DynamicObject> changePositions) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"hbpm_position_api");
        ArrayList<DynamicObject> positionInits = new ArrayList<DynamicObject>(changePositions.size());
        for (DynamicObject position : changePositions) {
            DynamicObject positionInit = new DynamicObject((DynamicObjectType)dataEntityType);
            HRDynamicObjectUtils.copy((DynamicObject)position, (DynamicObject)positionInit);
            positionInit.set("id", (Object)position.getLong("id"));
            positionInit.set("initdatasource", (Object)"2");
            this.addSystemField(positionInit, CHANGE_POSITION);
            positionInits.add(positionInit);
        }
        return positionInits;
    }

    private void handleJobInfo(DynamicObject position, Set<Long> jobScmIds, Set<Long> jobIds, Set<Long> jobFamilyIds) {
        DynamicObject job;
        if (HRObjectUtils.isEmpty((Object)position)) {
            return;
        }
        long jobScmId = position.getLong("jobscm.id");
        if (jobScmId != 0L) {
            jobScmIds.add(jobScmId);
        }
        if (HRObjectUtils.isEmpty((Object)(job = position.getDynamicObject("job")))) {
            return;
        }
        jobIds.add(job.getLong("id"));
        long jobFamilyId = job.getLong("jobfamily.id");
        if (jobFamilyId != 0L) {
            jobFamilyIds.add(jobFamilyId);
        }
    }

    private PositionJobRangeServiceHelper initPositionJobRangeServiceHelper(Set<Long> jobScmIds, Set<Long> jobIds, Set<Long> jobFamilyIds) {
        PositionJobRangeServiceHelper positionJobRangeServiceHelper = new PositionJobRangeServiceHelper();
        positionJobRangeServiceHelper.initData(jobScmIds, jobIds, jobFamilyIds);
        return positionJobRangeServiceHelper;
    }

    private List<String> checkAndTransLevelGradeTextAdd(PositionJobRangeServiceHelper positionJobRangeServiceHelper, DynamicObject position) {
        String highGradeText;
        String lowGradeText;
        String highLevelText;
        String lowLevelText = position.getString("lowjobleveltext");
        if (!positionJobRangeServiceHelper.isFillLevelGradeRange(lowLevelText, highLevelText = position.getString("highjobleveltext"), lowGradeText = position.getString("lowjobgradetext"), highGradeText = position.getString("highjobgradetext"))) {
            return new ArrayList<String>(10);
        }
        Map levelAndGradeRange = positionJobRangeServiceHelper.getLevelAndGradeRange(position.getDynamicObject("joblevelscm"), position.getDynamicObject("jobgradescm"), position.getDynamicObject("job"), position.getDynamicObject("jobscm"));
        return this.buildLevelGradeRange(lowLevelText, highLevelText, lowGradeText, highGradeText, position, levelAndGradeRange);
    }

    private List<String> checkAndTransLevelGradeTextChange(PositionJobRangeServiceHelper positionJobRangeServiceHelper, DynamicObject position) {
        String highGradeText;
        String lowGradeText;
        String highLevelText;
        String lowLevelText = position.getString("lowjobleveltext");
        if (!positionJobRangeServiceHelper.isFillLevelGradeRange(lowLevelText, highLevelText = position.getString("highjobleveltext"), lowGradeText = position.getString("lowjobgradetext"), highGradeText = position.getString("highjobgradetext"))) {
            if (lowLevelText != null || highLevelText != null) {
                position.set("lowjoblevel", null);
                position.set("highjoblevel", null);
            }
            if (lowGradeText != null || highGradeText != null) {
                position.set("lowjobgrade", null);
                position.set("highjobgrade", null);
            }
            return new ArrayList<String>(10);
        }
        Map levelAndGradeRange = positionJobRangeServiceHelper.getLevelAndGradeRange(position.getDynamicObject("joblevelscm"), position.getDynamicObject("jobgradescm"), position.getDynamicObject("job"), position.getDynamicObject("jobscm"));
        return this.buildLevelGradeRange(lowLevelText, highLevelText, lowGradeText, highGradeText, position, levelAndGradeRange);
    }

    private List<String> buildLevelGradeRange(String lowLevelText, String highLevelText, String lowGradeText, String highGradeText, DynamicObject position, Map<String, List<DynamicObject>> levelAndGradeRange) {
        Map<String, DynamicObject> numberToDyMap;
        ArrayList<String> result = new ArrayList<String>(4);
        if (HRStringUtils.isNotEmpty((String)lowLevelText) || HRStringUtils.isNotEmpty((String)highLevelText)) {
            List<DynamicObject> jobLevelScmRanges;
            if (HRStringUtils.isEmpty((String)lowLevelText)) {
                lowLevelText = highLevelText;
            }
            if (HRStringUtils.isEmpty((String)highLevelText)) {
                highLevelText = lowLevelText;
            }
            if (CollectionUtils.isEmpty(jobLevelScmRanges = levelAndGradeRange.get("joblevelscm"))) {
                result.add(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c\u6700\u4f4e\u804c\u7ea7\u201d\u201c\u6700\u9ad8\u804c\u7ea7\u201d\u65e0\u6548\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PositionController_9", (String)"hrmp-hbpm-mservice", (Object[])new Object[0]), new Object[0]));
                logger.info("the validates from PositionController buildLevelGradeRange");
            } else {
                numberToDyMap = jobLevelScmRanges.stream().collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy, (v1, v2) -> v1));
                DynamicObject lowLevel = numberToDyMap.get(lowLevelText);
                DynamicObject highLevel = numberToDyMap.get(highLevelText);
                if (HRObjectUtils.isEmpty((Object)lowLevel)) {
                    result.add(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c\u6700\u4f4e\u804c\u7ea7\u201d\u65e0\u6548\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PositionController_5", (String)"hrmp-hbpm-mservice", (Object[])new Object[0]), new Object[0]));
                    logger.info("the validates from PositionController buildLevelGradeRange");
                } else {
                    position.set("lowjoblevel", (Object)lowLevel);
                }
                if (HRObjectUtils.isEmpty((Object)highLevel)) {
                    result.add(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c\u6700\u9ad8\u804c\u7ea7\u201d\u65e0\u6548\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PositionController_6", (String)"hrmp-hbpm-mservice", (Object[])new Object[0]), new Object[0]));
                    logger.info("the validates from PositionController buildLevelGradeRange");
                } else {
                    position.set("highjoblevel", (Object)highLevel);
                }
            }
        }
        if (HRStringUtils.isNotEmpty((String)lowGradeText) || HRStringUtils.isNotEmpty((String)highGradeText)) {
            List<DynamicObject> jobGradeScmRanges;
            if (HRStringUtils.isEmpty((String)lowGradeText)) {
                lowGradeText = highGradeText;
            }
            if (HRStringUtils.isEmpty((String)highGradeText)) {
                highGradeText = lowGradeText;
            }
            if (CollectionUtils.isEmpty(jobGradeScmRanges = levelAndGradeRange.get("jobgradescm"))) {
                result.add(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c\u6700\u4f4e\u804c\u7b49\u201d\u201c\u6700\u9ad8\u804c\u7b49\u201d\u65e0\u6548\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PositionController_10", (String)"hrmp-hbpm-mservice", (Object[])new Object[0]), new Object[0]));
                logger.info("the validates from PositionController buildLevelGradeRange");
            } else {
                numberToDyMap = jobGradeScmRanges.stream().collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy, (v1, v2) -> v1));
                DynamicObject lowGrade = numberToDyMap.get(lowGradeText);
                DynamicObject highGrade = numberToDyMap.get(highGradeText);
                if (HRObjectUtils.isEmpty((Object)lowGrade)) {
                    result.add(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c\u6700\u4f4e\u804c\u7b49\u201d\u65e0\u6548\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PositionController_7", (String)"hrmp-hbpm-mservice", (Object[])new Object[0]), new Object[0]));
                    logger.info("the validates from PositionController buildLevelGradeRange");
                } else {
                    position.set("lowjobgrade", (Object)lowGrade);
                }
                if (HRObjectUtils.isEmpty((Object)highGrade)) {
                    result.add(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c\u6700\u9ad8\u804c\u7b49\u201d\u65e0\u6548\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PositionController_8", (String)"hrmp-hbpm-mservice", (Object[])new Object[0]), new Object[0]));
                    logger.info("the validates from PositionController buildLevelGradeRange");
                } else {
                    position.set("highjobgrade", (Object)highGrade);
                }
            }
        }
        return result;
    }

    private OperationResult callOp(String opKey, DynamicObject[] positions) {
        OperationServiceImpl opImpl = new OperationServiceImpl();
        OperateOption operateOption = OperateOption.create();
        return opImpl.localInvokeOperation(opKey, positions, operateOption);
    }

    private void addErrorInfoMsg(Map<String, List<String>> errorInfoMap, String number, String errorMsg) {
        List<String> errorInfo = errorInfoMap.get(number);
        if (errorInfo == null) {
            errorInfo = new ArrayList<String>();
        }
        errorInfo.add(errorMsg);
        errorInfoMap.put(number, errorInfo);
    }

    private void addErrorMsgListToMap(Map<String, List<String>> errorInfoMap, DynamicObject position, List<String> errorMsg) {
        List<String> errorInfo = errorInfoMap.get(position.getString("number"));
        if (errorInfo == null) {
            errorInfo = new ArrayList<String>();
        }
        errorInfo.addAll(errorMsg);
        errorInfoMap.put(position.getString("number"), errorInfo);
    }

    private Map<String, Object> buildErroResult(String msg) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("message", msg);
        result.put("data", null);
        result.put("errorCode", "fail");
        return result;
    }

    private Map<String, Object> buildResult(OperationResult opResult, Map<String, List<String>> errorInfoMap) {
        if (errorInfoMap == null) {
            errorInfoMap = new HashMap<String, List<String>>();
        }
        List validateErrors = opResult.getValidateResult().getValidateErrors();
        for (ValidateResult validateError : validateErrors) {
            List allErrorInfo = validateError.getAllErrorInfo();
            for (OperateErrorInfo opErrorInfo : allErrorInfo) {
                Long pkId = (Long)opErrorInfo.getPkValue();
                this.addErrorInfoMsg(errorInfoMap, this.getPositionNumber(pkId), opErrorInfo.getMessage());
            }
        }
        return this.buildResult(opResult.getMessage(), errorInfoMap);
    }

    private Map<String, Object> buildResult(String msg, Map<String, List<String>> errorInfoMap) {
        if (errorInfoMap.size() == 0) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("message", "success");
            result.put("data", "success");
            result.put("errorCode", "success");
            return result;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("message", msg);
        result.put("data", errorInfoMap);
        result.put("errorCode", "fail");
        return result;
    }
}

