/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbpm.mservice;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Map;
import java.util.function.BiConsumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbpm.mservice.api.IJobMessageConsumerService;
import kd.hrmp.hbpm.business.domain.repository.position.StandardPositionRepository;
import kd.hrmp.hbpm.business.service.position.StandardPositionCommonService;
import kd.hrmp.hbpm.business.utils.PositionUtils;

public class JobMessageConsumerServiceImpl
implements IJobMessageConsumerService {
    private static final Log logger = LogFactory.getLog(JobMessageConsumerServiceImpl.class);
    private MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"hbpm_stposition");

    public Map<String, Object> disableJob(DynamicObject tplDy) {
        this.dealStandardPositionSingleFromMsg(tplDy, (job, dyn) -> {
            DynamicObject data = new DynamicObject((DynamicObjectType)this.dataEntityType);
            StandardPositionCommonService.copyValueFromChangeJobToStandardPosition((DynamicObject)job, (DynamicObject)data);
            data.set("positiontype", dyn.get("positiontype"));
            try (TXHandle txHandle = TX.required();){
                try {
                    StandardPositionCommonService.batchHisVersionChange((DynamicObject[])new DynamicObject[]{data});
                }
                catch (Exception e) {
                    txHandle.markRollback();
                    logger.error((Throwable)e);
                    throw e;
                }
            }
        });
        return PositionUtils.buildSuccessResult((int)200, (String)"", null);
    }

    public Map<String, Object> enableJob(DynamicObject tplDy) {
        this.dealStandardPositionSingleFromMsg(tplDy, (job, dyn) -> {
            DynamicObject data = new DynamicObject((DynamicObjectType)this.dataEntityType);
            StandardPositionCommonService.copyValueFromChangeJobToStandardPosition((DynamicObject)job, (DynamicObject)data);
            data.set("positiontype", dyn.get("positiontype"));
            try (TXHandle txHandle = TX.required();){
                try {
                    StandardPositionCommonService.batchHisVersionChange((DynamicObject[])new DynamicObject[]{data});
                }
                catch (Exception e) {
                    txHandle.markRollback();
                    logger.error((Throwable)e);
                    throw e;
                }
            }
        });
        return PositionUtils.buildSuccessResult((int)200, (String)"", null);
    }

    public Map<String, Object> changeJob(DynamicObject tplDy) {
        this.dealStandardPositionSingleFromMsg(tplDy, (job, dyn) -> {
            DynamicObject data = new DynamicObject((DynamicObjectType)this.dataEntityType);
            StandardPositionCommonService.copyValueFromChangeJobToStandardPosition((DynamicObject)job, (DynamicObject)data);
            data.set("positiontype", dyn.get("positiontype"));
            try (TXHandle txHandle = TX.required();){
                try {
                    StandardPositionCommonService.batchHisVersionChange((DynamicObject[])new DynamicObject[]{data});
                }
                catch (Exception e) {
                    txHandle.markRollback();
                    logger.error((Throwable)e);
                    throw e;
                }
            }
        });
        return PositionUtils.buildSuccessResult((int)200, (String)"", null);
    }

    private void dealStandardPositionSingleFromMsg(DynamicObject tplDy, BiConsumer<DynamicObject, DynamicObject> consumer) {
        Object content;
        if (tplDy == null || HRStringUtils.isEmpty((String)tplDy.getString("msgcontent"))) {
            return;
        }
        String contentBase64 = tplDy.getString("msgcontent");
        if (HRStringUtils.isNotEmpty((String)contentBase64) && (content = SerializationUtils.deSerializeFromBase64((String)contentBase64)) instanceof Map) {
            Object[] standardposition;
            Map msgContent = (Map)content;
            Long boid = (Long)msgContent.computeIfAbsent("boid", value -> 0L);
            Long id = (Long)msgContent.computeIfAbsent("id", value -> 0L);
            Object[] jobInfos = null;
            if (id > 0L && boid > 0L && !ObjectUtils.isEmpty((Object[])(standardposition = StandardPositionRepository.getInstance().queryAllDarkStandardPositionByJobIds(Collections.singletonList(boid)))) && standardposition.length > 0) {
                logger.info("JobMessageConsumerServiceImpl dealStandardPositionSingleFromMsg get jobInfos  %s", (Object)id);
                jobInfos = (DynamicObject[])HRMServiceHelper.invokeHRMPService((String)"hbjm", (String)"IHBJMService", (String)"getJobByIds", (Object[])new Object[]{Lists.newArrayList((Object[])new Long[]{id})});
                logger.info("JobMessageConsumerServiceImpl dealStandardPositionSingleFromMsg get jobInfos  %s", jobInfos);
                if (!ObjectUtils.isEmpty((Object[])jobInfos)) {
                    consumer.accept((DynamicObject)jobInfos[0], (DynamicObject)standardposition[0]);
                }
            }
        }
    }
}

